/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.factory.DialectConverter;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.kie.api.fluent.Dialect;
import org.kie.api.fluent.NodeContainerBuilder;
import org.kie.api.fluent.RuleSetNodeBuilder;

public class RuleSetNodeFactory<T extends NodeContainerBuilder<T, ?>>
extends NodeFactory<RuleSetNodeBuilder<T>, T>
implements RuleSetNodeBuilder<T> {
    public RuleSetNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, new RuleSetNode(), id);
    }

    protected RuleSetNode getRuleSetNode() {
        return (RuleSetNode)this.getNode();
    }

    @Override
    public RuleSetNodeFactory<T> name(String name) {
        this.getNode().setName(name);
        return this;
    }

    public RuleSetNodeFactory<T> ruleFlowGroup(String ruleFlowGroup) {
        this.getRuleSetNode().setRuleFlowGroup(ruleFlowGroup);
        return this;
    }

    public RuleSetNodeFactory<T> timer(String delay, String period, String dialect, String action) {
        Timer timer = new Timer();
        timer.setDelay(delay);
        timer.setPeriod(period);
        this.getRuleSetNode().addTimer(timer, new DroolsConsequenceAction(dialect, action));
        return this;
    }

    public RuleSetNodeBuilder<T> timer(String delay, String period, Dialect dialect, String action) {
        return this.timer(delay, period, DialectConverter.fromDialect(dialect), action);
    }
}

