/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.jbpm.process.core.correlation.CorrelationInstance;
import org.jbpm.process.core.correlation.CorrelationManager;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.util.PatternConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTypeFilter
implements EventFilter,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(EventTypeFilter.class);
    private static final long serialVersionUID = 510L;
    protected String type;
    private String messageRef;
    private CorrelationManager correlationManager;

    @Override
    public boolean isCorrelated() {
        return this.messageRef != null;
    }

    public void setCorrelationManager(CorrelationManager correlationManager) {
        this.correlationManager = correlationManager;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean acceptsEvent(String type, Object event) {
        return this.type != null && this.type.equals(type);
    }

    public String toString() {
        return "Event filter: [" + this.type + "]";
    }

    @Override
    public boolean acceptsEvent(String type, Object event, Function<String, Object> resolver) {
        if (this.type != null && this.isAccepted(type, resolver)) {
            if (this.correlationManager != null && this.correlationManager.isSubscribe(this.messageRef)) {
                CorrelationInstance messageCorrelation = this.correlationManager.computeCorrelationInstance(this.messageRef, event);
                CorrelationInstance processCorrelation = this.correlationManager.computeSubscription(this.messageRef, resolver);
                logger.debug("The event type {} is correlated, computing correlations. Message correlation is {}; process correlation is: {} ", new Object[]{type, messageCorrelation, processCorrelation});
                return messageCorrelation.equals(processCorrelation);
            }
            return true;
        }
        return false;
    }

    public boolean isAccepted(String type, Function<String, Object> resolver) {
        return this.resolveVariable(this.type, resolver).contains(type);
    }

    private List<String> resolveVariable(String varExpression, Function<String, Object> resolver) {
        if (varExpression == null) {
            return Collections.emptyList();
        }
        HashMap<String, Object[]> replacements = new HashMap<String, Object[]>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(varExpression);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            Object value = resolver.apply(paramName);
            if (value == null) {
                logger.warn("expression {} in dynamic signal {} not resolved", (Object)paramName, (Object)varExpression);
                continue;
            }
            if (value instanceof Object[]) {
                replacements.put(paramName, (Object[])value);
                continue;
            }
            replacements.put(paramName, new Object[]{value});
        }
        ArrayList<String> acceptedTypes = new ArrayList<String>();
        List<Map<String, String>> data = this.generateCombinations(replacements.keySet(), replacements);
        for (Map<String, String> combination : data) {
            String tmp = varExpression;
            for (Map.Entry<String, String> replacement : combination.entrySet()) {
                tmp = tmp.replace("#{" + replacement.getKey() + "}", replacement.getValue());
            }
            acceptedTypes.add(tmp);
        }
        if (acceptedTypes.isEmpty()) {
            acceptedTypes.add(varExpression);
        }
        return acceptedTypes;
    }

    private List<Map<String, String>> generateCombinations(Set<String> keys, Map<String, Object[]> data) {
        ArrayList<Map<String, String>> combinations = new ArrayList<Map<String, String>>();
        for (String key : keys) {
            HashSet<String> remaining = new HashSet<String>(keys);
            remaining.remove(key);
            List<Map<String, String>> subCombinations = this.generateCombinations(remaining, data);
            if (subCombinations.isEmpty()) {
                for (Object value : data.get(key)) {
                    HashMap<String, String> combination = new HashMap<String, String>();
                    combination.put(key, value.toString());
                    if (combinations.contains(combination)) continue;
                    combinations.add(combination);
                }
                continue;
            }
            for (Map map : subCombinations) {
                for (Object value : data.get(key)) {
                    HashMap<String, String> combination = new HashMap<String, String>();
                    combination.putAll(map);
                    combination.put(key, value.toString());
                    if (combinations.contains(combination)) continue;
                    combinations.add(combination);
                }
            }
        }
        return combinations;
    }

    public void setMessageRef(String messageRef) {
        this.messageRef = messageRef;
    }
}

