/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.osjava.sj.jndi.AbstractContext;
import org.osjava.sj.jndi.DelegatingContext;
import org.osjava.sj.loader.JndiLoader;
import org.osjava.sj.loader.util.Utils;

public class SimpleContext
extends DelegatingContext {
    public static final String SIMPLE_ROOT = "org.osjava.sj.root";
    public static final String SIMPLE_DELEGATE = "org.osjava.sj.factory";
    public static final String SIMPLE_SPACE = "org.osjava.sj.space";

    public SimpleContext(Hashtable env) throws NamingException {
        super(SimpleContext.createContext(env));
        JndiLoader loader = new JndiLoader(env);
        String root = (String)env.get(SIMPLE_ROOT);
        if (root == null) {
            throw new IllegalStateException("Property org.osjava.sj.root is mandatory. ");
        }
        if (root.startsWith("file://")) {
            root = root.substring("file://".length());
        }
        if (!AbstractContext.isSharedAndLoaded()) {
            Context ctxt = this;
            String space = (String)env.get(SIMPLE_SPACE);
            if (space != null) {
                String[] array = Utils.split(space, (String)env.get("org.osjava.sj.delimiter"));
                for (int i = 0; i < array.length; ++i) {
                    ctxt = ctxt.createSubcontext(array[i]);
                }
            }
            try {
                loader.loadDirectory(new File(root), ctxt);
            }
            catch (IOException ioe) {
                throw new NamingException("Unable to load data from directory: " + root + " due to error: " + ioe.getMessage());
            }
        }
    }

    private static InitialContext createContext(Hashtable env) throws NamingException {
        SimpleContext.copyFromSystemProperties(env, "org.osjava.sj.delimiter");
        SimpleContext.copyFromSystemProperties(env, SIMPLE_ROOT);
        SimpleContext.copyFromSystemProperties(env, SIMPLE_SPACE);
        SimpleContext.copyFromSystemProperties(env, "org.osjava.sj.shared");
        SimpleContext.copyFromSystemProperties(env, SIMPLE_DELEGATE);
        env.put("jndi.syntax.direction", "left_to_right");
        if (!env.containsKey("org.osjava.sj.delimiter")) {
            env.put("org.osjava.sj.delimiter", ".");
        }
        env.put("jndi.syntax.separator", env.get("org.osjava.sj.delimiter"));
        if (!env.containsKey(SIMPLE_DELEGATE)) {
            env.put(SIMPLE_DELEGATE, "org.osjava.sj.memory.MemoryContextFactory");
        }
        env.put("java.naming.factory.initial", env.get(SIMPLE_DELEGATE));
        return new InitialContext(env);
    }

    private static void copyFromSystemProperties(Hashtable env, String key) {
        if (System.getProperty(key) != null) {
            env.put(key, System.getProperty(key));
        }
    }
}

