/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;

public class ShouldHaveRootCause
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveRootCauseWithMessage(Throwable actual, Throwable actualCause, String expectedMessage) {
        Preconditions.checkArgument(actual != null, "actual should not be null", new Object[0]);
        Preconditions.checkArgument(expectedMessage != null, "expected root cause message should not be null", new Object[0]);
        if (actualCause == null) {
            return new ShouldHaveRootCause(actual, expectedMessage);
        }
        return new ShouldHaveRootCause(actual, actualCause, expectedMessage);
    }

    public static ErrorMessageFactory shouldHaveRootCause(Throwable actual, Throwable actualCause, Throwable expectedCause) {
        Preconditions.checkArgument(actual != null, "actual should not be null", new Object[0]);
        Preconditions.checkArgument(expectedCause != null, "expected cause should not be null", new Object[0]);
        if (actualCause == null) {
            return new ShouldHaveRootCause(actual, expectedCause);
        }
        if (Objects.areEqual(actualCause.getMessage(), expectedCause.getMessage())) {
            return new ShouldHaveRootCause(actual, actualCause, expectedCause.getClass());
        }
        if (Objects.areEqual(actualCause.getClass(), expectedCause.getClass())) {
            return new ShouldHaveRootCause(actual, actualCause, expectedCause.getMessage());
        }
        return new ShouldHaveRootCause(actual, actualCause, expectedCause);
    }

    private ShouldHaveRootCause(Throwable actual, Throwable actualCause, Throwable expectedCause) {
        super("%nExpecting a root cause with type:%n  <%s>%nand message:%n  <%s>%nbut type was:%n  <%s>%nand message was:%n  <%s>.%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCause.getClass().getName(), expectedCause.getMessage(), actualCause.getClass().getName(), actualCause.getMessage());
    }

    private ShouldHaveRootCause(Throwable actual, Throwable expectedCause) {
        super("%nExpecting a root cause with type:%n  <%s>%nand message:%n  <%s>%nbut actual had no root cause.%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCause.getClass().getName(), expectedCause.getMessage());
    }

    private ShouldHaveRootCause(Throwable actual, Throwable actualCause, Class<? extends Throwable> expectedCauseClass) {
        super("%nExpecting a root cause with type:%n  <%s>%nbut type was:%n  <%s>.%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseClass.getName(), actualCause.getClass().getName());
    }

    private ShouldHaveRootCause(Throwable actual, String expectedMessage) {
        super("%nExpecting a root cause with message:%n  <%s>%nbut actual had no root cause.%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedMessage);
    }

    private ShouldHaveRootCause(Throwable actual, Throwable actualCause, String expectedCauseMessage) {
        super("%nExpecting a root cause with message:%n  <%s>%nbut message was:%n  <%s>.%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseMessage, actualCause.getMessage());
    }
}

