/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceTaskHandler.class);
    private String resultVarName;

    public ServiceTaskHandler() {
        this("Result");
    }

    public ServiceTaskHandler(String resultVarName) {
        this.resultVarName = resultVarName;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String service = (String)workItem.getParameter("Interface");
        String interfaceImplementationRef = (String)workItem.getParameter("interfaceImplementationRef");
        String operation = (String)workItem.getParameter("Operation");
        String parameterType = (String)workItem.getParameter("ParameterType");
        Object parameter = workItem.getParameter("Parameter");
        String[] services = new String[]{service, interfaceImplementationRef};
        Class<?> c = null;
        for (String serv : services) {
            try {
                c = Class.forName(serv);
                break;
            }
            catch (ClassNotFoundException cnfe) {
                if (serv.compareTo(services[services.length - 1]) != 0) continue;
                this.handleException(cnfe, service, interfaceImplementationRef, operation, parameterType, parameter);
            }
        }
        try {
            Object instance = c.newInstance();
            Class[] classes = null;
            Object[] params = null;
            if (parameterType != null) {
                classes = new Class[]{Class.forName(parameterType)};
                params = new Object[]{parameter};
            }
            Method method = c.getMethod(operation, classes);
            Object result = method.invoke(instance, params);
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put(this.resultVarName, result);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (ClassNotFoundException cnfe) {
            this.handleException(cnfe, service, interfaceImplementationRef, operation, parameterType, parameter);
        }
        catch (InstantiationException ie) {
            this.handleException(ie, service, interfaceImplementationRef, operation, parameterType, parameter);
        }
        catch (IllegalAccessException iae) {
            this.handleException(iae, service, interfaceImplementationRef, operation, parameterType, parameter);
        }
        catch (NoSuchMethodException nsme) {
            this.handleException(nsme, service, interfaceImplementationRef, operation, parameterType, parameter);
        }
        catch (InvocationTargetException ite) {
            this.handleException(ite, service, interfaceImplementationRef, operation, parameterType, parameter);
        }
        catch (Throwable cause) {
            this.handleException(cause, service, interfaceImplementationRef, operation, parameterType, parameter);
        }
    }

    private void handleException(Throwable cause, String service, String interfaceImplementationRef, String operation, String paramType, Object param) {
        WorkItemHandlerRuntimeException wihRe;
        logger.debug("Handling exception {} inside service {} or {} and operation {} with param type {} and value {}", new Object[]{cause.getMessage(), service, operation, paramType, param});
        if (cause instanceof InvocationTargetException) {
            Throwable realCause = cause.getCause();
            wihRe = new WorkItemHandlerRuntimeException(realCause);
            wihRe.setStackTrace(realCause.getStackTrace());
        } else {
            wihRe = new WorkItemHandlerRuntimeException(cause);
            wihRe.setStackTrace(cause.getStackTrace());
        }
        wihRe.setInformation("Interface", service);
        wihRe.setInformation("InterfaceImplementationRef", interfaceImplementationRef);
        wihRe.setInformation("Operation", operation);
        wihRe.setInformation("ParameterType", paramType);
        wihRe.setInformation("Parameter", param);
        wihRe.setInformation("workItemHandlerType", this.getClass().getSimpleName());
        throw wihRe;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

