/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.ExecutionInterruptedException;
import org.jboss.threads.ExecutionTimedOutException;
import org.jboss.threads.ThreadCreationException;
import org.jboss.threads.management.BoundedThreadPoolExecutorMBean;

class ThreadFactoryExecutor
implements BlockingExecutor,
BoundedThreadPoolExecutorMBean {
    private final ThreadFactory factory;
    private final Semaphore limitSemaphore;
    private final DirectExecutor taskExecutor;
    private final Object lock = new Object();
    private int maxThreads;
    private int largestThreadCount;
    private int currentThreadCount;
    private final AtomicInteger rejected = new AtomicInteger();
    private volatile boolean blocking;

    ThreadFactoryExecutor(ThreadFactory factory, int maxThreads, boolean blocking, DirectExecutor taskExecutor) {
        this.factory = factory;
        this.maxThreads = maxThreads;
        this.blocking = blocking;
        this.taskExecutor = taskExecutor;
        this.limitSemaphore = new Semaphore(maxThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.maxThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxThreads(int maxThreads) {
        if (maxThreads < 0) {
            throw new IllegalArgumentException("Max threads must not be negative");
        }
        Object object = this.lock;
        synchronized (object) {
            int old = this.maxThreads;
            int diff = old - maxThreads;
            if (diff < 0) {
                this.limitSemaphore.release(-diff);
            } else if (diff > 0 && !this.limitSemaphore.tryAcquire(diff)) {
                throw new IllegalArgumentException("Cannot reduce maximum threads below current number of running threads");
            }
            this.maxThreads = maxThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable task) {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        try {
            Semaphore semaphore = this.limitSemaphore;
            if (this.blocking) {
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ExecutionInterruptedException();
                }
            } else if (!semaphore.tryAcquire()) {
                throw new RejectedExecutionException("Task limit reached");
            }
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                            Object var6_5 = null;
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                            throw throwable;
                        }
                    }
                });
                if (thread == null) {
                    throw new ThreadCreationException("No threads can be created");
                }
                thread.start();
                ok = true;
                Object var6_7 = null;
                if (!ok) {
                    semaphore.release();
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (!ok) {
                    semaphore.release();
                }
                throw throwable;
            }
        }
        catch (RejectedExecutionException e) {
            this.rejected.getAndIncrement();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBlocking(final Runnable task) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        try {
            Semaphore semaphore = this.limitSemaphore;
            semaphore.acquire();
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                            Object var6_5 = null;
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                            throw throwable;
                        }
                    }
                });
                if (thread == null) {
                    throw new ThreadCreationException("No threads can be created");
                }
                thread.start();
                ok = true;
                Object var6_6 = null;
                if (!ok) {
                    semaphore.release();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!ok) {
                    semaphore.release();
                }
                throw throwable;
            }
        }
        catch (RejectedExecutionException e) {
            this.rejected.getAndIncrement();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBlocking(final Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        try {
            Semaphore semaphore = this.limitSemaphore;
            if (!semaphore.tryAcquire(timeout, unit)) {
                throw new ExecutionTimedOutException();
            }
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                            Object var6_5 = null;
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                            throw throwable;
                        }
                    }
                });
                if (thread == null) {
                    throw new ThreadCreationException("No threads can be created");
                }
                thread.start();
                ok = true;
                Object var9_8 = null;
                if (!ok) {
                    semaphore.release();
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!ok) {
                    semaphore.release();
                }
                throw throwable;
            }
        }
        catch (RejectedExecutionException e) {
            this.rejected.getAndIncrement();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNonBlocking(final Runnable task) throws RejectedExecutionException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        try {
            Semaphore semaphore = this.limitSemaphore;
            if (!semaphore.tryAcquire()) {
                throw new RejectedExecutionException("Task limit reached");
            }
            boolean ok = false;
            try {
                Thread thread = this.factory.newThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Object object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                int t = ++ThreadFactoryExecutor.this.currentThreadCount;
                                if (t > ThreadFactoryExecutor.this.largestThreadCount) {
                                    ThreadFactoryExecutor.this.largestThreadCount = t;
                                }
                            }
                            ThreadFactoryExecutor.this.taskExecutor.execute(task);
                            object = ThreadFactoryExecutor.this.lock;
                            synchronized (object) {
                                ThreadFactoryExecutor.this.currentThreadCount--;
                            }
                            Object var6_5 = null;
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            ThreadFactoryExecutor.this.limitSemaphore.release();
                            throw throwable;
                        }
                    }
                });
                if (thread == null) {
                    throw new ThreadCreationException("No threads can be created");
                }
                thread.start();
                ok = true;
                Object var6_6 = null;
                if (!ok) {
                    semaphore.release();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!ok) {
                    semaphore.release();
                }
                throw throwable;
            }
        }
        catch (RejectedExecutionException e) {
            this.rejected.getAndIncrement();
            throw e;
        }
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestThreadCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.largestThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentThreadCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThreadCount;
        }
    }

    public int getRejectedCount() {
        return this.rejected.get();
    }

    public long getKeepAliveTime() {
        return 0L;
    }

    public void setKeepAliveTime(long milliseconds) {
        if (milliseconds != 0L) {
            throw new IllegalArgumentException("Keep-alive may only be set to 0ms");
        }
    }

    public String toString() {
        return String.format("%s (%s)", super.toString(), this.factory);
    }
}

