/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;

public final class Dependency {
    private static final Logger log = Logger.getLogger(Dependency.class);
    private static final AtomicIntegerFieldUpdater<Dependency> depUpdater = AtomicIntegerFieldUpdater.newUpdater(Dependency.class, "remainingDependencies");
    private volatile int remainingDependencies;
    private final Executor executor;
    private final Object lock = new Object();
    private Runner runner;
    private State state;
    private static final ThreadLocal<Dependency> CTH = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dependency(Executor executor, Runnable runnable, int initialDepCount) {
        this.executor = executor;
        Object object = this.lock;
        synchronized (object) {
            this.runner = new Runner(runnable);
            this.state = State.WAITING;
            this.remainingDependencies = initialDepCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDependent(Dependency task) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case RUNNING: {
                    this.runner.dependents.add(task);
                    return;
                }
                case FAILED: {
                    return;
                }
                case DONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        task.dependencyFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependencyFinished() {
        AtomicIntegerFieldUpdater<Dependency> updater = depUpdater;
        int res = updater.decrementAndGet(this);
        if (res == 0) {
            Runner runner = this.runner;
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.executor.execute(runner);
                    this.state = State.RUNNING;
                }
                catch (RejectedExecutionException e) {
                    log.errorf((Throwable)e, "Error submitting task %s to executor", (Object)runner.runnable);
                    this.state = State.FAILED;
                    runner.runnable = null;
                    runner.dependents = null;
                    this.runner = null;
                }
            }
        }
        if (res < 0) {
            updater.incrementAndGet(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dependencyFailed() {
        AtomicIntegerFieldUpdater<Dependency> updater = depUpdater;
        int res = updater.decrementAndGet(this);
        Object object = this.lock;
        synchronized (object) {
            this.state = State.FAILED;
            Runner runner = this.runner;
            runner.runnable = null;
            runner.dependents = null;
            this.runner = null;
        }
        if (res < 0) {
            updater.incrementAndGet(this);
        }
    }

    public static Dependency currentTask() {
        return CTH.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        WAITING,
        RUNNING,
        FAILED,
        DONE;

    }

    private class Runner
    implements Runnable {
        private List<Dependency> dependents = new ArrayList<Dependency>();
        private Runnable runnable;

        public Runner(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List<Dependency> tasks2;
            boolean ok = false;
            CTH.set(Dependency.this);
            try {
                this.runnable.run();
                ok = true;
                Object var3_2 = null;
                CTH.set(null);
            }
            catch (Throwable throwable) {
                List<Dependency> tasks2;
                Object var3_3 = null;
                CTH.set(null);
                Object object = Dependency.this.lock;
                synchronized (object) {
                    tasks2 = this.dependents;
                    this.dependents = null;
                    this.runnable = null;
                    Dependency.this.runner = null;
                    Dependency.this.state = ok ? State.DONE : State.FAILED;
                }
                if (ok) {
                    for (Dependency task : tasks2) {
                        task.dependencyFinished();
                    }
                } else {
                    for (Dependency task : tasks2) {
                        task.dependencyFailed();
                    }
                }
                throw throwable;
            }
            Object object = Dependency.this.lock;
            synchronized (object) {
                tasks2 = this.dependents;
                this.dependents = null;
                this.runnable = null;
                Dependency.this.runner = null;
                Dependency.this.state = ok ? State.DONE : State.FAILED;
            }
            if (ok) {
                for (Dependency task : tasks2) {
                    task.dependencyFinished();
                }
            } else {
                for (Dependency task : tasks2) {
                    task.dependencyFailed();
                }
            }
        }
    }
}

