/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.jboss.seam.util.IteratorEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpSession
implements HttpSession {
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean isInvalid;
    private ServletContext servletContext;
    private int maxInactiveInterval;

    public MockHttpSession(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public long getCreationTime() {
        return 0L;
    }

    public String getId() {
        return null;
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public void setMaxInactiveInterval(int max) {
        this.maxInactiveInterval = max;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String att) {
        return this.attributes.get(att);
    }

    public Object getValue(String att) {
        return this.getAttribute(att);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[0]);
    }

    public void setAttribute(String att, Object value) {
        if (value == null) {
            this.attributes.remove(att);
        } else {
            this.attributes.put(att, value);
        }
    }

    public void putValue(String att, Object value) {
        this.setAttribute(att, value);
    }

    public void removeAttribute(String att) {
        this.attributes.remove(att);
    }

    public void removeValue(String att) {
        this.removeAttribute(att);
    }

    public void invalidate() {
        this.attributes.clear();
        this.isInvalid = true;
    }

    public boolean isNew() {
        return false;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

