/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.spi.AsynchronousResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.util.Encode;

public abstract class BaseHttpRequest
implements HttpRequest {
    protected CountDownLatch latch;
    protected long suspendTimeout;
    protected SynchronousDispatcher dispatcher;
    protected boolean suspended;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    protected AbstractAsynchronousResponse asynchronousResponse;
    protected HttpResponse httpResponse;

    public BaseHttpRequest(SynchronousDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm((InputStream)this.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Request media type is not application/x-www-form-urlencoded");
        }
        return this.formParameters;
    }

    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    public AsynchronousResponse createAsynchronousResponse(long suspendTimeout) {
        this.suspended = true;
        this.latch = new CountDownLatch(1);
        this.suspendTimeout = suspendTimeout;
        this.asynchronousResponse = new AbstractAsynchronousResponse(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setResponse(Response response) {
                try {
                    this.setupResponse((ServerResponse)response);
                    BaseHttpRequest.this.dispatcher.asynchronousDelivery((HttpRequest)BaseHttpRequest.this, BaseHttpRequest.this.httpResponse, response);
                }
                finally {
                    BaseHttpRequest.this.latch.countDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFailure(Exception ex) {
                try {
                    BaseHttpRequest.this.dispatcher.asynchronousDelivery((HttpRequest)BaseHttpRequest.this, BaseHttpRequest.this.httpResponse, ex);
                }
                finally {
                    BaseHttpRequest.this.latch.countDown();
                }
            }
        };
        return this.asynchronousResponse;
    }

    public AsynchronousResponse getAsynchronousResponse() {
        return this.asynchronousResponse;
    }

    public boolean isInitial() {
        return true;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void initialRequestThreadFinished() {
        if (this.latch == null) {
            return;
        }
        try {
            this.latch.await(this.suspendTimeout + 100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

