/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.persistence;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.managed.api.ManagedObject;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.plugins.values.MetaValueFactoryBuilder;
import org.jboss.profileservice.persistence.AbstractValuePersistence;
import org.jboss.profileservice.persistence.AbstractValueRecreation;
import org.jboss.profileservice.persistence.DefaultManagedObjectPersistencePlugin;
import org.jboss.profileservice.persistence.ManagedObjectPersistencePlugin;
import org.jboss.profileservice.persistence.ManagedObjectRecreationHelper;
import org.jboss.profileservice.persistence.xml.PersistedManagedObject;

public class DelegatingPersistencePlugin
implements ManagedObjectPersistencePlugin {
    private Map<String, ManagedObjectPersistencePlugin> plugins = new ConcurrentHashMap<String, ManagedObjectPersistencePlugin>();
    private final ManagedObjectPersistencePlugin defaultPlugin;
    private final MetaValueFactory metaValueFactory = MetaValueFactoryBuilder.create();
    private final AbstractValuePersistence valuePersistence = new AbstractValuePersistence(this, this.metaValueFactory);
    private AbstractValueRecreation valueRecreation = new AbstractValueRecreation(this);

    public DelegatingPersistencePlugin(ManagedObjectRecreationHelper helper) {
        this.defaultPlugin = new DefaultManagedObjectPersistencePlugin(this.valuePersistence, this.valueRecreation, helper);
    }

    @Override
    public String getType() {
        return Object.class.getName();
    }

    @Override
    public AbstractValuePersistence getValuePersistence() {
        return this.valuePersistence;
    }

    @Override
    public PersistedManagedObject createPersistedManagedObject(ManagedObject mo) {
        if (mo == null) {
            throw new IllegalArgumentException("Null managed object.");
        }
        ManagedObjectPersistencePlugin plugin = this.getPlugin(mo);
        return plugin.createPersistedManagedObject(mo);
    }

    @Override
    public PersistedManagedObject createPersistedManagedObject(PersistedManagedObject persisted, ManagedObject mo) {
        if (persisted == null) {
            throw new IllegalArgumentException("Null persisted managed object.");
        }
        if (mo == null) {
            throw new IllegalArgumentException("Null managed object.");
        }
        ManagedObjectPersistencePlugin plugin = this.getPlugin(mo);
        return plugin.createPersistedManagedObject(persisted, mo);
    }

    @Override
    public AbstractValueRecreation getValueRecreation() {
        return this.valueRecreation;
    }

    @Override
    public ManagedObject createManagedObject(PersistedManagedObject persisted) {
        if (persisted == null) {
            throw new IllegalArgumentException("null persisted managed object");
        }
        ManagedObjectPersistencePlugin plugin = this.getPlugin(persisted);
        return plugin.createManagedObject(persisted);
    }

    @Override
    public ManagedObject updateManagedObject(PersistedManagedObject persisted, ManagedObject mo) {
        if (persisted == null) {
            throw new IllegalArgumentException("null persisted managed object");
        }
        if (mo == null) {
            throw new IllegalArgumentException("null managed object");
        }
        ManagedObjectPersistencePlugin plugin = this.getPlugin(persisted);
        return plugin.updateManagedObject(persisted, mo);
    }

    protected ManagedObjectPersistencePlugin getPlugin(ManagedObject mo) {
        String type = mo.getAttachmentName();
        if (type == null && mo.getAttachment() != null) {
            type = mo.getAttachment().getClass().getName();
        }
        return this.getPlugin(type);
    }

    protected ManagedObjectPersistencePlugin getPlugin(PersistedManagedObject persisted) {
        if (persisted == null) {
            throw new IllegalArgumentException("null persisted managed object");
        }
        String className = persisted.getTemplateName();
        if (className == null) {
            className = persisted.getClassName();
        }
        return this.getPlugin(className);
    }

    public ManagedObjectPersistencePlugin getPlugin(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type.");
        }
        ManagedObjectPersistencePlugin plugin = this.plugins.get(type);
        if (plugin == null) {
            plugin = this.defaultPlugin;
        }
        return plugin;
    }

    public void addPlugin(ManagedObjectPersistencePlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin.");
        }
        if (plugin.getType() == null) {
            throw new IllegalArgumentException("Null plugin type.");
        }
        this.plugins.put(plugin.getType(), plugin);
    }

    public void removePlugin(ManagedObjectPersistencePlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin.");
        }
        if (plugin.getType() == null) {
            throw new IllegalArgumentException("Null plugin type.");
        }
        this.plugins.remove(plugin.getType());
    }
}

