/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.persistence.repository;

import org.jboss.managed.api.ManagedComponent;
import org.jboss.profileservice.persistence.PersistenceFactory;
import org.jboss.profileservice.persistence.repository.metadata.AttachmentMetaData;
import org.jboss.profileservice.persistence.repository.metadata.RepositoryAttachmentMetaData;
import org.jboss.profileservice.persistence.xml.PersistenceRoot;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface PersistenceRepository
{
   
   /**
    * Get the persistence factory.
    * 
    * @return the persistence factory
    */
   PersistenceFactory getPersistenceFactory();
   
   /**
    * Load the repository attachment meta data
    * 
    * @param deploymentName the deployment name
    * @param simpleName the simple name
    * @return the persisted meta data or null if it does not exist
    * @throws Exception
    */
   RepositoryAttachmentMetaData loadMetaData(String deploymentName, String simpleName) throws Exception;

   /**
    * Load a attachment.
    * 
    * @param deploymentName
    * @param simpleName
    * @param attachment
    * @return
    * @throws Exception
    */
   PersistenceRoot loadAttachment(String deploymentName, String simpleName, AttachmentMetaData attachment) throws Exception;

   /**
    * Check whether persistence for a given {@code ManagedComponent}
    * is supported.
    * 
    * @param comp the managed component
    * @return true if persistence is supported, false otherwise
    */
   boolean isSupportPersistence(ManagedComponent comp);
   
   /**
    * Persist the managed component.
    * 
    * @param ctx the deployment context name
    * @param comp the managed componenbt
    * @throws Exception
    */
   void updateDeployment(String ctx, ManagedComponent comp) throws Exception;

   /**
    * Remove a component from the attachment.
    * 
    * @param ctx the deployment context name
    * @param comp the managed componenbt
    * @throws Exception
    */
   void removeComponent(String ctx, ManagedComponent comp) throws Exception;
   
}

