/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import java.security.AccessController;
import java.security.PrivilegedAction;

class PropertyAccess {
    PropertyAccess() {
    }

    public static String getProperty(String name) {
        return PropertyAccess.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        PropertyReadAction action = new PropertyReadAction(name, defaultValue);
        String property = AccessController.doPrivileged(action);
        return property;
    }

    public static String setProperty(String name, String value) {
        PropertyWriteAction action = new PropertyWriteAction(name, value);
        String property = AccessController.doPrivileged(action);
        return property;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyWriteAction
    implements PrivilegedAction<String> {
        private String name;
        private String value;

        PropertyWriteAction(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String run() {
            return System.setProperty(this.name, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyReadAction
    implements PrivilegedAction<String> {
        private String name;
        private String defaultValue;

        PropertyReadAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

