/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.plugins.dependency.SecurityActions;
import org.jboss.kernel.plugins.dispatch.InvokeDispatchHelper;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

public abstract class InstallsAwareAction
extends KernelControllerContextAction {
    protected abstract ControllerState getState();

    public void installAction(KernelControllerContext context) throws Throwable {
        this.installActionInternal(context);
        this.doInstalls(context);
        this.setKernelControllerContext(context);
    }

    protected void doInstalls(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        this.invokeInstalls(context, controller, configurator, metaData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeInstalls(KernelControllerContext context, KernelController controller, KernelConfigurator configurator, BeanMetaData metaData, boolean unget) throws Throwable {
        block9: {
            List<InstallMetaData> installs = metaData.getInstalls();
            if (installs != null && !installs.isEmpty()) {
                int index;
                try {
                    int size = installs.size();
                    for (index = 0; index < size; ++index) {
                        InstallMetaData install = installs.get(index);
                        if (!this.getState().equals((Object)install.getState())) continue;
                        KernelControllerContext target = context;
                        if (install.getBean() != null) {
                            target = controller.getContext(install.getBean(), install.getDependentState());
                        }
                        if (target instanceof InvokeDispatchContext) {
                            ClassLoader previous = SecurityActions.setContextClassLoader(context);
                            try {
                                InvokeDispatchHelper.invoke(configurator, (InvokeDispatchContext)target, install.getMethodName(), install.getParameters(), unget);
                                continue;
                            }
                            finally {
                                SecurityActions.resetContextClassLoader(previous);
                            }
                        }
                        throw new IllegalArgumentException("Cannot install, context " + target + " does not implement InvokeDispatchContext");
                    }
                }
                catch (Throwable t) {
                    if (unget) break block9;
                    this.considerUninstalls(context, index);
                    this.undoInstallAction(context);
                    throw t;
                }
            }
        }
    }

    protected void considerUninstalls(KernelControllerContext context, int index) {
        if (index > 0) {
            this.doUninstalls(context);
        }
    }

    protected void undoInstallAction(KernelControllerContext context) {
        this.uninstallActionInternal(context);
    }

    public void uninstallAction(KernelControllerContext context) {
        this.unsetKernelControllerContext(context);
        this.doUninstalls(context);
        this.uninstallActionInternal(context);
    }

    protected void doUninstalls(KernelControllerContext context) {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        List<InstallMetaData> uninstalls = beanMetaData.getUninstalls();
        int size = uninstalls != null ? uninstalls.size() : 0;
        this.doUninstalls(context, size - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUninstalls(KernelControllerContext context, int index) {
        if (index < 0) {
            return;
        }
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        try {
            this.invokeInstalls(context, controller, configurator, metaData, true);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        List<InstallMetaData> uninstalls = metaData.getUninstalls();
        if (uninstalls != null && !uninstalls.isEmpty()) {
            for (int i = index; i >= 0; --i) {
                InstallMetaData uninstall = uninstalls.get(i);
                if (!this.getState().equals((Object)uninstall.getState())) continue;
                KernelControllerContext target = context;
                if (uninstall.getBean() != null && (target = controller.getContext(uninstall.getBean(), uninstall.getDependentState())) == null) {
                    this.log.warn((Object)("Ignoring uninstall action on target in incorrect state " + uninstall.getBean()));
                    continue;
                }
                if (target instanceof InvokeDispatchContext) {
                    ClassLoader previous = null;
                    try {
                        previous = SecurityActions.setContextClassLoader(context);
                        try {
                            InvokeDispatchHelper.invoke(configurator, (InvokeDispatchContext)target, uninstall.getMethodName(), uninstall.getParameters(), false);
                            continue;
                        }
                        finally {
                            InvokeDispatchHelper.invoke(configurator, (InvokeDispatchContext)target, uninstall.getMethodName(), uninstall.getParameters(), true);
                        }
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Ignoring uninstall action on target " + uninstall), t);
                        continue;
                    }
                    finally {
                        if (previous != null) {
                            SecurityActions.resetContextClassLoader(previous);
                        }
                    }
                }
                this.log.warn((Object)("Cannot uninstall, context " + target + " does not implement InvokeDispatchContext for " + uninstall.getBean()));
            }
        }
    }
}

