/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.convert.impl;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.convert.ConverterGenerator;
import org.jboss.forge.addon.convert.exception.ConverterNotFoundException;
import org.jboss.forge.addon.convert.impl.ConstructorConverter;
import org.jboss.forge.addon.convert.impl.Converters;
import org.jboss.forge.addon.convert.impl.MethodConverter;
import org.jboss.forge.addon.convert.impl.StringToImportedInstanceConverter;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.services.Imported;

@Singleton
public class ConverterFactoryImpl
implements ConverterFactory {
    @Inject
    private AddonRegistry registry;

    public <S, T> Converter<S, T> getConverter(Class<S> source, Class<T> target) {
        Object result = null;
        Imported instances = this.registry.getServices(ConverterGenerator.class);
        for (ConverterGenerator generator : instances) {
            if (!generator.handles(source, target)) continue;
            result = generator.generateConverter(source, target);
            break;
        }
        if (result == null) {
            if (String.class.equals(source) && !this.registry.getServices(target).isUnsatisfied()) {
                result = new StringToImportedInstanceConverter<T>(target, this.registry);
            } else if (String.class.equals(target)) {
                result = Converters.TO_STRING;
            } else if (target.isAssignableFrom(source)) {
                result = Converters.NOOP;
            } else {
                try {
                    result = new MethodConverter<S, T>(source, target, null, target.getMethod("valueOf", source));
                }
                catch (NoSuchMethodException noValueOf) {
                    try {
                        result = new ConstructorConverter<S, T>(source, target, target.getConstructor(source));
                    }
                    catch (NoSuchMethodException noConstructor) {
                        throw new ConverterNotFoundException(source, target);
                    }
                }
            }
        }
        return result;
    }
}

