/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.helpers;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.MetaDataEntry;
import org.jboss.deployers.spi.structure.MetaDataType;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.vfs.spi.structure.CandidateAnnotationsCallback;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.CandidateStructureVisitorFactory;
import org.jboss.deployers.vfs.spi.structure.helpers.DefaultCandidateStructureVisitorFactory;
import org.jboss.deployers.vfs.spi.structure.helpers.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.util.collection.CollectionsFactory;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructureDeployer
implements StructureDeployer {
    protected static final Logger log = Logger.getLogger((String)"org.jboss.deployers.vfs.structure");
    private int relativeOrder = Integer.MAX_VALUE;
    private CandidateStructureVisitorFactory candidateStructureVisitorFactory = DefaultCandidateStructureVisitorFactory.INSTANCE;
    private Integer contextInfoOrder;
    private boolean supportsCandidateAnnotations;
    private Set<Class<? extends Annotation>> candidateAnnotations;

    public static String getRelativePath(StructureContext context, VirtualFile child) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        return AbstractStructureDeployer.getRelativePath(context.getParent(), child);
    }

    public static String getRelativePath(VirtualFile parent, VirtualFile child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        String childPath = child.getPathName();
        if (parent != null) {
            String parentPath = parent.getPathName();
            if (parentPath.length() == childPath.length()) {
                return "";
            }
            if (parentPath.length() < childPath.length()) {
                if (!parentPath.endsWith("/")) {
                    parentPath = parentPath + "/";
                }
                if (childPath.startsWith(parentPath)) {
                    return childPath.substring(parentPath.length());
                }
            }
        }
        if (childPath.endsWith("/")) {
            childPath = childPath.substring(0, childPath.length() - 1);
        }
        return childPath;
    }

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public void setRelativeOrder(int relativeOrder) {
        this.relativeOrder = relativeOrder;
    }

    public void setContextInfoOrder(Integer contextInfoOrder) {
        this.contextInfoOrder = contextInfoOrder;
    }

    public Set<Class<? extends Annotation>> getCandidateAnnotations() {
        return this.candidateAnnotations;
    }

    public void setCandidateAnnotations(Set<Class<? extends Annotation>> candidateAnnotations) {
        this.candidateAnnotations = candidateAnnotations;
    }

    public void addCandidateAnnotation(Class<? extends Annotation> annotationClass) {
        if (this.candidateAnnotations == null) {
            this.candidateAnnotations = new LinkedHashSet<Class<? extends Annotation>>();
        }
        this.candidateAnnotations.add(annotationClass);
    }

    @Override
    public boolean isSupportsCandidateAnnotations() {
        return this.supportsCandidateAnnotations;
    }

    public void setSupportsCandidateAnnotations(boolean supportsCandidateAnnotations) {
        this.supportsCandidateAnnotations = supportsCandidateAnnotations;
    }

    public CandidateStructureVisitorFactory getCandidateStructureVisitorFactory() {
        return this.candidateStructureVisitorFactory;
    }

    public void setCandidateStructureVisitorFactory(CandidateStructureVisitorFactory candidateStructureVisitorFactory) {
        if (candidateStructureVisitorFactory == null) {
            throw new IllegalArgumentException("Null candidateStructureVisitorFactory");
        }
        this.candidateStructureVisitorFactory = candidateStructureVisitorFactory;
    }

    protected void addClassPath(StructureContext structureContext, VirtualFile entry, boolean includeEntry, boolean includeRootManifestCP, ContextInfo context) {
        ArrayList<VirtualFile> paths;
        boolean trace;
        block5: {
            trace = log.isTraceEnabled();
            paths = new ArrayList<VirtualFile>();
            if (includeEntry) {
                paths.add(entry);
            }
            if (includeRootManifestCP && entry.isDirectory()) {
                try {
                    VFSUtils.addManifestLocations((VirtualFile)entry, paths);
                }
                catch (Exception e) {
                    if (!trace) break block5;
                    log.trace((Object)"Failed to add manifest locations", (Throwable)e);
                }
            }
        }
        VirtualFile root = structureContext.getRoot();
        for (VirtualFile vf : paths) {
            String entryPath = AbstractStructureDeployer.getRelativePath(root, vf);
            ClassPathEntry cpe = StructureMetaDataFactory.createClassPathEntry((String)entryPath);
            context.addClassPathEntry(cpe);
            if (!trace) continue;
            log.trace((Object)("Added classpath entry " + entryPath + " for " + vf.getName() + " from " + root));
        }
    }

    protected abstract AnnotationRepository createAnnotationRepository(VirtualFile var1);

    protected boolean checkCandidateAnnotations(StructureContext context, VirtualFile ... roots) {
        if (roots == null || roots.length == 0) {
            throw new IllegalArgumentException("Null or empty roots");
        }
        if (this.candidateAnnotations == null || this.candidateAnnotations.isEmpty()) {
            return true;
        }
        StructureContext parentContext = context.getParentContext();
        if (parentContext == null) {
            return true;
        }
        Set<CandidateAnnotationsCallback> callbacks = parentContext.getCallbacks(CandidateAnnotationsCallback.class);
        if (callbacks.isEmpty()) {
            return true;
        }
        boolean result = false;
        for (VirtualFile root : roots) {
            AnnotationRepository env = this.createAnnotationRepository(root);
            for (Class<? extends Annotation> annotationClass : this.candidateAnnotations) {
                if (!env.hasClassAnnotatedWith(annotationClass)) continue;
                result = true;
                for (CandidateAnnotationsCallback callback : callbacks) {
                    callback.executeCallback(root, context, env, annotationClass);
                }
            }
        }
        return result;
    }

    protected void addAllChildren(StructureContext context) throws Exception {
        this.addChildren(context, null);
    }

    protected void addChildren(StructureContext context, VisitorAttributes attributes) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        VirtualFile file = context.getFile();
        VirtualFileVisitor visitor = this.candidateStructureVisitorFactory.createVisitor(context, attributes);
        file.visit(visitor);
    }

    protected void addAllChildren(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers) throws Exception {
        this.addChildren(root, parent, metaData, deployers, null);
    }

    protected void addChildren(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers, VisitorAttributes attributes) throws Exception {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        StructureContext context = new StructureContext(root, null, parent, metaData, deployers, null);
        this.addChildren(context, attributes);
    }

    protected static boolean isLeaf(VirtualFile file) {
        return SecurityActions.isLeaf(file);
    }

    protected ContextInfo createContext(StructureContext context) {
        return this.createContext(context, (String)null);
    }

    protected ContextInfo createContext(StructureContext context, String metaDataPath) {
        ContextInfo result = this.applyMetadataPath(context, metaDataPath);
        this.applyStructure(context, result);
        return result;
    }

    protected ContextInfo applyMetadataPath(StructureContext context, String metaDataPath) {
        VirtualFile root;
        VirtualFile child;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (metaDataPath != null && !(child = (root = context.getFile()).getChild(metaDataPath)).exists()) {
            metaDataPath = null;
        }
        if (metaDataPath != null) {
            return StructureMetaDataFactory.createContextInfo((String)"", (String)metaDataPath, null);
        }
        return StructureMetaDataFactory.createContextInfo((String)"", null);
    }

    protected ContextInfo createContext(StructureContext context, String[] metaDataPaths) {
        ContextInfo result = this.applyMetadataPaths(context, metaDataPaths);
        this.applyStructure(context, result);
        return result;
    }

    private MetaDataEntry createMetaDataEntry(String path, MetaDataType type) {
        return StructureMetaDataFactory.createMetaDataEntry((String)path, (MetaDataType)type);
    }

    protected void addMetaDataPath(StructureContext context, ContextInfo info, String path, MetaDataType type) {
        VirtualFile root = context.getFile();
        if (root.getChild(path).exists()) {
            info.addMetaDataPath(this.createMetaDataEntry(path, type));
        }
    }

    protected ContextInfo applyMetadataPaths(StructureContext context, String[] metaDataPaths) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        VirtualFile root = context.getFile();
        List metaDataPath = CollectionsFactory.createLazyList();
        if (metaDataPaths != null && metaDataPaths.length > 0) {
            for (String path : metaDataPaths) {
                VirtualFile child = root.getChild(path);
                if (!child.exists()) continue;
                metaDataPath.add(path);
            }
        }
        if (metaDataPath.isEmpty()) {
            return StructureMetaDataFactory.createContextInfo((String)"", null);
        }
        return StructureMetaDataFactory.createContextInfo((String)"", (List)metaDataPath, null);
    }

    protected void applyStructure(StructureContext context, ContextInfo contextInfo) {
        boolean trace = log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        VirtualFile root = context.getRoot();
        this.applyContextInfo(context, contextInfo);
        context.addChild(contextInfo);
        if (trace) {
            log.trace((Object)("Added context " + context + " from " + root.getName()));
        }
    }

    protected void applyContextInfo(StructureContext context, ContextInfo result) {
        if (result != null && this.contextInfoOrder != null) {
            result.setRelativeOrder(this.contextInfoOrder.intValue());
        }
    }
}

