/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.threads.BoundedQueueThreadPoolAdd;
import org.jboss.as.threads.BoundedQueueThreadPoolReadAttributeHandler;
import org.jboss.as.threads.BoundedQueueThreadPoolRemove;
import org.jboss.as.threads.BoundedQueueThreadPoolWriteAttributeHandler;
import org.jboss.as.threads.Namespace;
import org.jboss.as.threads.QueuelessThreadPoolAdd;
import org.jboss.as.threads.QueuelessThreadPoolReadAttributeHandler;
import org.jboss.as.threads.QueuelessThreadPoolRemove;
import org.jboss.as.threads.QueuelessThreadPoolWriteAttributeHandler;
import org.jboss.as.threads.ScheduledThreadPoolAdd;
import org.jboss.as.threads.ScheduledThreadPoolReadAttributeHandler;
import org.jboss.as.threads.ScheduledThreadPoolRemove;
import org.jboss.as.threads.ScheduledThreadPoolWriteAttributeHandler;
import org.jboss.as.threads.ThreadFactoryAdd;
import org.jboss.as.threads.ThreadFactoryRemove;
import org.jboss.as.threads.ThreadFactoryWriteAttributeHandler;
import org.jboss.as.threads.ThreadsDescriptionUtil;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.as.threads.ThreadsSubsystemAdd;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.as.threads.UnboundedQueueThreadPoolAdd;
import org.jboss.as.threads.UnboundedQueueThreadPoolReadAttributeHandler;
import org.jboss.as.threads.UnboundedQueueThreadPoolRemove;
import org.jboss.as.threads.UnboundedQueueThreadPoolWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ThreadsExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.threads");
    public static String SUBSYSTEM_NAME = "threads";

    public void initialize(ExtensionContext context) {
        log.debugf("Initializing Threading Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem("threads");
        registration.registerXMLElementWriter((XMLElementWriter)ThreadsParser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel(ThreadsSubsystemProviders.SUBSYSTEM_PROVIDER);
        subsystem.registerOperationHandler("add", (OperationStepHandler)ThreadsSubsystemAdd.INSTANCE, (DescriptionProvider)ThreadsSubsystemAdd.INSTANCE, false);
        subsystem.registerOperationHandler("describe", (OperationStepHandler)ThreadsSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)ThreadsSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration threadFactories = subsystem.registerSubModel(PathElement.pathElement((String)"thread-factory"), ThreadsSubsystemProviders.THREAD_FACTORY_DESC);
        threadFactories.registerOperationHandler("add", (OperationStepHandler)ThreadFactoryAdd.INSTANCE, (DescriptionProvider)ThreadFactoryAdd.INSTANCE, false);
        threadFactories.registerOperationHandler("remove", (OperationStepHandler)ThreadFactoryRemove.INSTANCE, (DescriptionProvider)ThreadFactoryRemove.INSTANCE, false);
        ThreadFactoryWriteAttributeHandler.INSTANCE.registerAttributes(threadFactories);
        ManagementResourceRegistration boundedQueueThreadPools = subsystem.registerSubModel(PathElement.pathElement((String)"bounded-queue-thread-pool"), ThreadsSubsystemProviders.BOUNDED_QUEUE_THREAD_POOL_DESC);
        boundedQueueThreadPools.registerOperationHandler("add", (OperationStepHandler)BoundedQueueThreadPoolAdd.INSTANCE, (DescriptionProvider)BoundedQueueThreadPoolAdd.INSTANCE, false);
        boundedQueueThreadPools.registerOperationHandler("remove", (OperationStepHandler)BoundedQueueThreadPoolRemove.INSTANCE, (DescriptionProvider)BoundedQueueThreadPoolRemove.INSTANCE, false);
        BoundedQueueThreadPoolReadAttributeHandler.INSTANCE.registerAttributes(boundedQueueThreadPools);
        BoundedQueueThreadPoolWriteAttributeHandler.INSTANCE.registerAttributes(boundedQueueThreadPools);
        ManagementResourceRegistration unboundedQueueThreadPools = subsystem.registerSubModel(PathElement.pathElement((String)"unbounded-queue-thread-pool"), ThreadsSubsystemProviders.UNBOUNDED_QUEUE_THREAD_POOL_DESC);
        unboundedQueueThreadPools.registerOperationHandler("add", (OperationStepHandler)UnboundedQueueThreadPoolAdd.INSTANCE, (DescriptionProvider)UnboundedQueueThreadPoolAdd.INSTANCE, false);
        unboundedQueueThreadPools.registerOperationHandler("remove", (OperationStepHandler)UnboundedQueueThreadPoolRemove.INSTANCE, (DescriptionProvider)UnboundedQueueThreadPoolRemove.INSTANCE, false);
        UnboundedQueueThreadPoolReadAttributeHandler.INSTANCE.registerAttributes(unboundedQueueThreadPools);
        UnboundedQueueThreadPoolWriteAttributeHandler.INSTANCE.registerAttributes(unboundedQueueThreadPools);
        ManagementResourceRegistration queuelessThreadPools = subsystem.registerSubModel(PathElement.pathElement((String)"queueless-thread-pool"), ThreadsSubsystemProviders.QUEUELESS_THREAD_POOL_DESC);
        queuelessThreadPools.registerOperationHandler("add", (OperationStepHandler)QueuelessThreadPoolAdd.INSTANCE, (DescriptionProvider)QueuelessThreadPoolAdd.INSTANCE, false);
        queuelessThreadPools.registerOperationHandler("remove", (OperationStepHandler)QueuelessThreadPoolRemove.INSTANCE, (DescriptionProvider)QueuelessThreadPoolRemove.INSTANCE, false);
        QueuelessThreadPoolReadAttributeHandler.INSTANCE.registerAttributes(queuelessThreadPools);
        QueuelessThreadPoolWriteAttributeHandler.INSTANCE.registerAttributes(queuelessThreadPools);
        ManagementResourceRegistration scheduledThreadPools = subsystem.registerSubModel(PathElement.pathElement((String)"scheduled-thread-pool"), ThreadsSubsystemProviders.SCHEDULED_THREAD_POOL_DESC);
        scheduledThreadPools.registerOperationHandler("add", (OperationStepHandler)ScheduledThreadPoolAdd.INSTANCE, (DescriptionProvider)ScheduledThreadPoolAdd.INSTANCE, false);
        scheduledThreadPools.registerOperationHandler("remove", (OperationStepHandler)ScheduledThreadPoolRemove.INSTANCE, (DescriptionProvider)ScheduledThreadPoolRemove.INSTANCE, false);
        ScheduledThreadPoolReadAttributeHandler.INSTANCE.registerAttributes(scheduledThreadPools);
        ScheduledThreadPoolWriteAttributeHandler.INSTANCE.registerAttributes(scheduledThreadPools);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)ThreadsParser.INSTANCE);
    }

    private static class ThreadsSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final ThreadsSubsystemDescribeHandler INSTANCE = new ThreadsSubsystemDescribeHandler();

        private ThreadsSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = context.getResult();
            result.add(Util.getEmptyOperation((String)"add", (ModelNode)ThreadsDescriptionUtil.pathAddress(PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME))));
            ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
            this.addBoundedQueueThreadPools(result, model);
            this.addQueuelessThreadPools(result, model);
            this.addScheduledThreadPools(result, model);
            this.addThreadFactories(result, model);
            this.addUnboundedQueueThreadPools(result, model);
            context.completeStep();
        }

        private void addBoundedQueueThreadPools(ModelNode result, ModelNode model) {
            if (model.hasDefined("bounded-queue-thread-pool")) {
                ModelNode pools = model.get("bounded-queue-thread-pool");
                for (Property poolProp : pools.asPropertyList()) {
                    ThreadsDescriptionUtil.addBoundedQueueThreadPool(result, poolProp.getValue(), PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME), PathElement.pathElement((String)"bounded-queue-thread-pool", (String)poolProp.getName()));
                }
            }
        }

        private void addQueuelessThreadPools(ModelNode result, ModelNode model) {
            if (model.hasDefined("queueless-thread-pool")) {
                ModelNode pools = model.get("queueless-thread-pool");
                for (Property poolProp : pools.asPropertyList()) {
                    ThreadsDescriptionUtil.addQueuelessThreadPool(result, poolProp.getValue(), PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME), PathElement.pathElement((String)"queueless-thread-pool", (String)poolProp.getName()));
                }
            }
        }

        private void addThreadFactories(ModelNode result, ModelNode model) {
            if (model.hasDefined("thread-factory")) {
                ModelNode pools = model.get("thread-factory");
                for (Property poolProp : pools.asPropertyList()) {
                    ThreadsDescriptionUtil.addThreadFactory(result, poolProp.getValue(), PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME), PathElement.pathElement((String)"thread-factory", (String)poolProp.getName()));
                }
            }
        }

        private void addScheduledThreadPools(ModelNode result, ModelNode model) {
            if (model.hasDefined("scheduled-thread-pool")) {
                ModelNode pools = model.get("scheduled-thread-pool");
                for (Property poolProp : pools.asPropertyList()) {
                    ThreadsDescriptionUtil.addScheduledThreadPool(result, poolProp.getValue(), PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME), PathElement.pathElement((String)"scheduled-thread-pool", (String)poolProp.getName()));
                }
            }
        }

        private void addUnboundedQueueThreadPools(ModelNode result, ModelNode model) {
            if (model.hasDefined("unbounded-queue-thread-pool")) {
                ModelNode pools = model.get("unbounded-queue-thread-pool");
                for (Property poolProp : pools.asPropertyList()) {
                    ThreadsDescriptionUtil.addUnboundedQueueThreadPool(result, poolProp.getValue(), PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME), PathElement.pathElement((String)"unbounded-queue-thread-pool", (String)poolProp.getName()));
                }
            }
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }
}

