/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryAdd;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class ThreadFactoryWriteAttributeHandler
extends ThreadsWriteAttributeOperationHandler {
    public static final ThreadFactoryWriteAttributeHandler INSTANCE = new ThreadFactoryWriteAttributeHandler();

    private ThreadFactoryWriteAttributeHandler() {
        super(ThreadFactoryAdd.ATTRIBUTES, ThreadFactoryAdd.RW_ATTRIBUTES);
    }

    @Override
    protected ServiceController<?> getService(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ServiceName serviceName = ThreadsServices.threadFactoryName(name);
        ServiceController controller = context.getServiceRegistry(true).getService(serviceName);
        if (controller == null) {
            throw new OperationFailedException(new ModelNode().set("Service " + serviceName + " not found."));
        }
        return controller;
    }

    @Override
    protected void applyOperation(OperationContext context, ModelNode operation, String attributeName, ServiceController<?> service) {
        block6: {
            ThreadFactoryService tf = (ThreadFactoryService)service.getService();
            try {
                if ("group-name".equals(attributeName)) {
                    ModelNode value = PoolAttributeDefinitions.GROUP_NAME.resolveModelAttribute(context, operation);
                    tf.setThreadGroupName(value.isDefined() ? value.asString() : null);
                    break block6;
                }
                if ("priority".equals(attributeName)) {
                    ModelNode value = PoolAttributeDefinitions.PRIORITY.resolveModelAttribute(context, operation);
                    tf.setPriority(value.isDefined() ? value.asInt() : -1);
                    break block6;
                }
                if ("thread-name-pattern".equals(attributeName)) {
                    ModelNode value = PoolAttributeDefinitions.THREAD_NAME_PATTERN.resolveModelAttribute(context, operation);
                    tf.setNamePattern(value.isDefined() ? value.asString() : null);
                    break block6;
                }
                throw new IllegalArgumentException("Unexpected attribute '" + attributeName + "'");
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

