/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.test.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.aerogear.android.core.reflection.FieldNotFoundException;

public class UnitTestUtils {
    public static void setPrivateField(Object target, String fieldName, Object value) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        List<Field> fields = UnitTestUtils.getAllFields(new ArrayList<Field>(), target.getClass());
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            field.setAccessible(true);
            field.set(target, value);
            return;
        }
        throw new FieldNotFoundException(target.getClass(), fieldName);
    }

    public static Object getPrivateField(Object target, String fieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(target);
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        Collections.addAll(fields, type.getDeclaredFields());
        if (type.getSuperclass() != null) {
            fields = UnitTestUtils.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }
}

