/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.test.gcm;

import android.content.Context;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.http.HttpException;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushConfiguration;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar;
import org.jboss.aerogear.android.unifiedpush.gcm.UnifiedPushConfig;
import org.jboss.aerogear.android.unifiedpush.test.MainActivity;
import org.jboss.aerogear.android.unifiedpush.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.unifiedpush.test.util.UnitTestUtils;
import org.jboss.aerogear.android.unifiedpush.test.util.VoidCallback;
import org.json.JSONObject;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class AeroGearGCMPushRegistrarTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    private static final String TEST_SENDER_ID = "272275396485";
    private static final String TEST_SENDER_PASSWORD = "Password";
    private static final String TEST_SENDER_VARIANT = "Variant";
    private static final String TAG = AeroGearGCMPushRegistrarTest.class.getSimpleName();

    public AeroGearGCMPushRegistrarTest() {
        super(MainActivity.class);
    }

    public void testAsRegistrarFailsOnNullSenderId() throws URISyntaxException {
        try {
            AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().setPushServerURI(new URI("https://testuri"));
            config.asRegistrar();
        }
        catch (IllegalStateException ex) {
            AeroGearGCMPushRegistrarTest.assertEquals((String)"SenderIds can't be null or empty", (String)ex.getMessage());
            return;
        }
        AeroGearGCMPushRegistrarTest.fail();
    }

    public void testAsRegistrarFailsOnNullPushServerURI() {
        try {
            AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().addSenderId(TEST_SENDER_ID);
            config.asRegistrar();
        }
        catch (IllegalStateException ex) {
            AeroGearGCMPushRegistrarTest.assertEquals((String)"PushServerURI can't be null", (String)ex.getMessage());
            return;
        }
        AeroGearGCMPushRegistrarTest.fail();
    }

    public void testRegister() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().addSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        StubHttpProvider provider = new StubHttpProvider();
        UnitTestUtils.setPrivateField(registrar, "httpProviderProvider", provider);
        VoidCallback callback = new VoidCallback(latch);
        registrar.register((Context)super.getActivity(), (Callback)callback);
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            AeroGearGCMPushRegistrarTest.fail((String)"Latch wasn't called");
        }
        if (callback.exception != null) {
            Log.e((String)TAG, (String)callback.exception.getMessage(), (Throwable)callback.exception);
            AeroGearGCMPushRegistrarTest.fail((String)callback.exception.getMessage());
        }
        ArgumentCaptor postCaptore = ArgumentCaptor.forClass(String.class);
        ((HttpProvider)Mockito.verify((Object)provider.mock)).post((String)postCaptore.capture());
        JSONObject object = new JSONObject((String)postCaptore.getValue());
        AeroGearGCMPushRegistrarTest.assertEquals((Object)UnitTestUtils.getPrivateField(registrar, "deviceToken"), (Object)object.getString("deviceToken"));
    }

    public void testUnregister() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().addSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        StubHttpProvider provider = new StubHttpProvider();
        UnitTestUtils.setPrivateField(registrar, "httpProviderProvider", provider);
        StubGCMProvider gcmProvider = new StubGCMProvider();
        UnitTestUtils.setPrivateField(registrar, "gcmProvider", gcmProvider);
        VoidCallback callback = new VoidCallback(latch);
        AeroGearGCMPushRegistrar spy = (AeroGearGCMPushRegistrar)Mockito.spy((Object)registrar);
        ((AeroGearGCMPushRegistrar)Mockito.doReturn((Object)"tempId").when((Object)spy)).getRegistrationId((Context)Mockito.any());
        spy.register((Context)super.getActivity(), (Callback)callback);
        latch.await(1L, TimeUnit.SECONDS);
        latch = new CountDownLatch(1);
        callback = new VoidCallback(latch);
        spy.unregister((Context)super.getActivity(), (Callback)callback);
        latch.await(1L, TimeUnit.SECONDS);
        if (callback.exception != null) {
            Log.e((String)TAG, (String)callback.exception.getMessage(), (Throwable)callback.exception);
            AeroGearGCMPushRegistrarTest.fail((String)callback.exception.getMessage());
        }
        ((GoogleCloudMessaging)Mockito.verify((Object)gcmProvider.mock)).unregister();
        ((HttpProvider)Mockito.verify((Object)provider.mock)).delete(Mockito.matches((String)"tempId"));
        AeroGearGCMPushRegistrarTest.assertNull((Object)callback.exception);
        AeroGearGCMPushRegistrarTest.assertEquals((Object)"", (Object)UnitTestUtils.getPrivateField(registrar, "deviceToken"));
    }

    public void testRegisterExceptionsAreCaught() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().addSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        VoidCallback callback = new VoidCallback(latch);
        StubGCMProvider gcmProvider = new StubGCMProvider();
        UnitTestUtils.setPrivateField(registrar, "gcmProvider", gcmProvider);
        registrar.register((Context)this.getActivity(), (Callback)callback);
        latch.await(2L, TimeUnit.SECONDS);
        AeroGearGCMPushRegistrarTest.assertNotNull((Object)callback.exception);
        AeroGearGCMPushRegistrarTest.assertFalse((boolean)(callback.exception instanceof IOException));
    }

    public void testUnregisterExceptionsAreCaught() throws Exception {
        UnifiedPushConfig config = new UnifiedPushConfig().addSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = new AeroGearGCMPushRegistrar(config);
        CountDownLatch latch = new CountDownLatch(1);
        VoidCallback callback = new VoidCallback(latch);
        StubGCMProvider gcmProvider = new StubGCMProvider();
        UnitTestUtils.setPrivateField(registrar, "gcmProvider", gcmProvider);
        registrar.unregister((Context)this.getActivity(), (Callback)callback);
        latch.await(1L, TimeUnit.SECONDS);
        AeroGearGCMPushRegistrarTest.assertNotNull((Object)callback.exception);
        AeroGearGCMPushRegistrarTest.assertFalse((boolean)(callback.exception instanceof IOException));
    }

    public void testUnregisterTwice() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().addSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        StubHttpProvider provider = new StubHttpProvider();
        UnitTestUtils.setPrivateField(registrar, "httpProviderProvider", provider);
        StubGCMProvider gcmProvider = new StubGCMProvider();
        UnitTestUtils.setPrivateField(registrar, "gcmProvider", gcmProvider);
        VoidCallback callback = new VoidCallback(latch);
        AeroGearGCMPushRegistrar spy = (AeroGearGCMPushRegistrar)Mockito.spy((Object)registrar);
        spy.register((Context)super.getActivity(), (Callback)callback);
        latch.await(1L, TimeUnit.SECONDS);
        latch = new CountDownLatch(2);
        callback = new VoidCallback(latch);
        spy.unregister((Context)super.getActivity(), (Callback)callback);
        spy.unregister((Context)super.getActivity(), (Callback)callback);
        latch.await(4L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)callback.exception);
        Assert.assertTrue((boolean)(callback.exception instanceof IllegalStateException));
    }

    public void testRegistrationTokensAreNotCached() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().addSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        StubHttpProvider provider = new StubHttpProvider();
        UnitTestUtils.setPrivateField(registrar, "httpProviderProvider", provider);
        StubGCMProvider gcmProvider = new StubGCMProvider();
        UnitTestUtils.setPrivateField(registrar, "gcmProvider", gcmProvider);
        VoidCallback callback = new VoidCallback(latch);
        registrar.register((Context)super.getActivity(), (Callback)callback);
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)((MainActivity)super.getActivity()).getSharedPreferences(AeroGearGCMPushRegistrar.class.getSimpleName(), 0).getString("registration_id", null));
        latch = new CountDownLatch(1);
        callback = new VoidCallback(latch);
        registrar.unregister((Context)super.getActivity(), (Callback)callback);
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"", (String)((MainActivity)super.getActivity()).getSharedPreferences(AeroGearGCMPushRegistrar.class.getSimpleName(), 0).getString("registration_id", null));
    }

    public void testAeroGearGCMPushConfigurationWithoutVariantID() throws Exception {
        try {
            AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration();
            config.addSenderId(TEST_SENDER_ID).setPushServerURI(new URI("https://testuri")).setSenderIds(new String[]{TEST_SENDER_ID}).setSecret(TEST_SENDER_ID).asRegistrar();
        }
        catch (IllegalStateException ex) {
            AeroGearGCMPushRegistrarTest.assertEquals((String)"VariantID can't be null", (String)ex.getMessage());
            return;
        }
        AeroGearGCMPushRegistrarTest.fail();
    }

    public void testAeroGearGCMPushConfigurationWithoutSecret() throws Exception {
        try {
            AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration();
            config.addSenderId(TEST_SENDER_ID).setPushServerURI(new URI("https://testuri")).setSenderIds(new String[]{TEST_SENDER_ID}).setVariantID(TEST_SENDER_VARIANT).asRegistrar();
        }
        catch (IllegalStateException ex) {
            AeroGearGCMPushRegistrarTest.assertEquals((String)"Secret can't be null", (String)ex.getMessage());
            return;
        }
        AeroGearGCMPushRegistrarTest.fail();
    }

    private class StubGCMProvider
    implements Provider<GoogleCloudMessaging> {
        protected final GoogleCloudMessaging mock = (GoogleCloudMessaging)Mockito.mock(GoogleCloudMessaging.class);

        public GoogleCloudMessaging get(Object ... in) {
            return this.mock;
        }
    }

    private class BrokenStubHttpProvider
    implements Provider<HttpProvider> {
        protected final HttpProvider mock = (HttpProvider)Mockito.mock(HttpProvider.class);

        public BrokenStubHttpProvider() {
            byte[] bytes = new byte[]{1};
            ((HttpProvider)Mockito.doThrow((Throwable)new HttpException(bytes, 401)).when((Object)this.mock)).post((String)Mockito.any());
            ((HttpProvider)Mockito.doThrow((Throwable)new HttpException(bytes, 401)).when((Object)this.mock)).delete((String)Mockito.any());
        }

        public HttpProvider get(Object ... in) {
            return this.mock;
        }
    }

    private class StubHttpProvider
    implements Provider<HttpProvider> {
        protected final HttpProvider mock = (HttpProvider)Mockito.mock(HttpProvider.class);

        public StubHttpProvider() {
            byte[] bytes = new byte[]{1};
            ((HttpProvider)Mockito.doReturn((Object)new HeaderAndBody(bytes, new HashMap())).when((Object)this.mock)).post((String)Mockito.any());
            ((HttpProvider)Mockito.doReturn((Object)new HeaderAndBody(bytes, new HashMap())).when((Object)this.mock)).delete((String)Mockito.any());
        }

        public HttpProvider get(Object ... in) {
            return this.mock;
        }
    }
}

