/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.test.gcm;

import android.content.Context;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushJsonConfiguration;
import org.jboss.aerogear.android.unifiedpush.test.MainActivity;
import org.jboss.aerogear.android.unifiedpush.test.util.PatchedActivityInstrumentationTestCase;

public class AeroGearGCMPushJsonConfigurationTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    private static final URI pushServerURL = URI.create("https://localhost:8080/ag-push");
    private static final Set<String> senderIds = new HashSet<String>(Arrays.asList("123456"));
    private static final String variantID = "8abfae4eb02a6140c0a20798433180a063fd7006";
    private static final String secret = "5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8";

    public AeroGearGCMPushJsonConfigurationTest() {
        super(MainActivity.class);
    }

    public void testJsonConfigUsingDefaultFileName() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.loadConfigJson((Context)this.getActivity());
        Assert.assertEquals((Object)pushServerURL, (Object)config.getPushServerURI());
        Assert.assertEquals((String)senderIds.iterator().next(), (String)((String)config.getSenderIds().iterator().next()));
        Assert.assertEquals((String)variantID, (String)config.getVariantID());
        Assert.assertEquals((String)secret, (String)config.getSecret());
    }

    public void testJsonConfigUsingDifferentFileName() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setFileName("correct-config.json");
        config.loadConfigJson((Context)this.getActivity());
        Assert.assertEquals((Object)pushServerURL, (Object)config.getPushServerURI());
        Assert.assertEquals((String)senderIds.iterator().next(), (String)((String)config.getSenderIds().iterator().next()));
        Assert.assertEquals((String)variantID, (String)config.getVariantID());
        Assert.assertEquals((String)secret, (String)config.getSecret());
    }

    public void testJsonConfigUsingIncorrectFileFormat() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setFileName("wrong-format.json");
        try {
            config.loadConfigJson((Context)this.getActivity());
            AeroGearGCMPushJsonConfigurationTest.fail((String)"Somethings is wrong. File with incorrect format should throw an exception");
        }
        catch (RuntimeException e) {
            String errorMessage = "An error occurred while parsing the wrong-format.json. Please check the file format";
            Assert.assertEquals((String)errorMessage, (String)e.getMessage());
        }
        Assert.assertNull((Object)config.getPushServerURI());
        Assert.assertEquals((int)0, (int)config.getSenderIds().size());
        Assert.assertNull((Object)config.getVariantID());
        Assert.assertNull((Object)config.getSecret());
    }

    public void testJsonConfigUsingEmptyFile() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setFileName("empty-file.json");
        try {
            config.loadConfigJson((Context)this.getActivity());
            AeroGearGCMPushJsonConfigurationTest.fail((String)"Somethings is wrong. Empty file should throw an exception");
        }
        catch (RuntimeException e) {
            String errorMessage = "An error occurred while parsing the empty-file.json. Please check the file format";
            Assert.assertEquals((String)errorMessage, (String)e.getMessage());
        }
    }

    public void testJsonConfigUsingAbsentFile() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setFileName("blablabla.json");
        try {
            config.loadConfigJson((Context)this.getActivity());
            AeroGearGCMPushJsonConfigurationTest.fail((String)"Somethings is wrong. This file not exists and load should throw an exception");
        }
        catch (RuntimeException e) {
            String errorMessage = "An error occurred while parsing the blablabla.json. Please check if the file exists";
            Assert.assertEquals((String)errorMessage, (String)e.getMessage());
        }
    }
}

