/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.test.gcm;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.android.unifiedpush.MessageHandler;
import org.jboss.aerogear.android.unifiedpush.RegistrarManager;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMMessageReceiver;
import org.jboss.aerogear.android.unifiedpush.test.MainActivity;
import org.jboss.aerogear.android.unifiedpush.test.util.PatchedActivityInstrumentationTestCase;

public class AeroGearGCMMessageReceiverTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    public AeroGearGCMMessageReceiverTest() {
        super(MainActivity.class);
    }

    public void testConsumeMessageNoMetadata() throws InterruptedException {
        Context ctx = ((MainActivity)this.getActivity()).getApplicationContext();
        AeroGearGCMMessageReceiver receiver = new AeroGearGCMMessageReceiver();
        CountDownLatch latch = new CountDownLatch(1);
        TestMessageHandler handler = new TestMessageHandler(latch);
        RegistrarManager.registerMainThreadHandler((MessageHandler)handler);
        IntentFilter filter = new IntentFilter("com.google.android.c2dm.intent.RECEIVE");
        Intent myIntent = new Intent("com.google.android.c2dm.intent.RECEIVE");
        myIntent.putExtra("testKey", "testValue");
        ctx.registerReceiver((BroadcastReceiver)receiver, filter);
        ctx.sendBroadcast(myIntent);
        latch.await(1L, TimeUnit.SECONDS);
        AeroGearGCMMessageReceiverTest.assertEquals((Object)((Object)TestMessageHandler.Result.MESSAGE), (Object)((Object)handler.resultType));
        AeroGearGCMMessageReceiverTest.assertEquals((String)"testValue", (String)handler.result.getString("testKey"));
    }

    public void testConsumeMessageDelete() throws InterruptedException {
        Context ctx = ((MainActivity)this.getActivity()).getApplicationContext();
        AeroGearGCMMessageReceiver receiver = new AeroGearGCMMessageReceiver();
        CountDownLatch latch = new CountDownLatch(1);
        TestMessageHandler handler = new TestMessageHandler(latch);
        RegistrarManager.registerMainThreadHandler((MessageHandler)handler);
        IntentFilter filter = new IntentFilter("com.google.android.c2dm.intent.RECEIVE");
        Intent myIntent = new Intent("com.google.android.c2dm.intent.RECEIVE").putExtra("message_type", "deleted_messages");
        ctx.registerReceiver((BroadcastReceiver)receiver, filter);
        ctx.sendBroadcast(myIntent);
        latch.await(1L, TimeUnit.SECONDS);
        AeroGearGCMMessageReceiverTest.assertEquals((Object)((Object)TestMessageHandler.Result.DELETE), (Object)((Object)handler.resultType));
        AeroGearGCMMessageReceiverTest.assertEquals((String)myIntent.getExtras().getString("message_type"), (String)handler.result.getString("message_type"));
    }

    public void testConsumeMessageError() throws InterruptedException {
        Context ctx = ((MainActivity)this.getActivity()).getApplicationContext();
        AeroGearGCMMessageReceiver receiver = new AeroGearGCMMessageReceiver();
        CountDownLatch latch = new CountDownLatch(1);
        TestMessageHandler handler = new TestMessageHandler(latch);
        RegistrarManager.registerMainThreadHandler((MessageHandler)handler);
        IntentFilter filter = new IntentFilter("com.google.android.c2dm.intent.RECEIVE");
        Intent myIntent = new Intent("com.google.android.c2dm.intent.RECEIVE").putExtra("message_type", "send_error");
        ctx.registerReceiver((BroadcastReceiver)receiver, filter);
        ctx.sendBroadcast(myIntent);
        latch.await(1L, TimeUnit.SECONDS);
        AeroGearGCMMessageReceiverTest.assertEquals((Object)((Object)TestMessageHandler.Result.ERROR), (Object)((Object)handler.resultType));
        AeroGearGCMMessageReceiverTest.assertEquals(null, (Object)handler.result);
    }

    private static final class TestMessageHandler
    implements MessageHandler {
        final CountDownLatch latch;
        Bundle result;
        Result resultType;

        public TestMessageHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onDeleteMessage(Context context, Bundle message) {
            this.resultType = Result.DELETE;
            this.result = message;
            this.latch.countDown();
        }

        public void onMessage(Context context, Bundle message) {
            this.resultType = Result.MESSAGE;
            this.result = message;
            this.latch.countDown();
        }

        public void onError() {
            this.resultType = Result.ERROR;
            this.latch.countDown();
        }

        static enum Result {
            DELETE,
            MESSAGE,
            ERROR;

        }
    }
}

