/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.test;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.aerogear.android.core.ConfigurationProvider;
import org.jboss.aerogear.android.unifiedpush.PushConfiguration;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;
import org.jboss.aerogear.android.unifiedpush.RegistrarManager;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushConfiguration;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar;
import org.jboss.aerogear.android.unifiedpush.test.MainActivity;
import org.jboss.aerogear.android.unifiedpush.test.util.PatchedActivityInstrumentationTestCase;
import org.mockito.Mockito;

public class RegistrationsTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    private static final String PUSH = "push";

    public RegistrationsTest() {
        super(MainActivity.class);
    }

    public void testDefaultConfig() throws URISyntaxException {
        AeroGearGCMPushConfiguration config = ((AeroGearGCMPushConfiguration)RegistrarManager.config((String)PUSH, AeroGearGCMPushConfiguration.class)).setPushServerURI(new URI("http://testreg.com")).setSenderIds(new String[]{"TestID"}).setVariantID("VariantID").setSecret("secret");
        config.asRegistrar();
        PushRegistrar registrar = RegistrarManager.getRegistrar((String)PUSH);
        RegistrationsTest.assertNotNull((Object)registrar);
        RegistrationsTest.assertTrue((boolean)(registrar instanceof AeroGearGCMPushRegistrar));
    }

    public void testFailsOnUnsupportedType() {
        try {
            PushConfiguration config = RegistrarManager.config((String)PUSH, BrokenConfig.class);
            RegistrationsTest.fail();
        }
        catch (IllegalArgumentException ignore) {
            return;
        }
    }

    public void testCustomFactoryType() {
        RegistrarManager.registerConfigurationProvider(StubConfig.class, (ConfigurationProvider)new ConfigurationProvider<StubConfig>(){

            public StubConfig newConfiguration() {
                return new StubConfig();
            }
        });
        StubConfig config = (StubConfig)RegistrarManager.config((String)PUSH, StubConfig.class);
        config.asRegistrar();
        RegistrationsTest.assertNotNull((Object)RegistrarManager.getRegistrar((String)PUSH));
        RegistrationsTest.assertFalse((boolean)(RegistrarManager.getRegistrar((String)PUSH) instanceof AeroGearGCMPushRegistrar));
    }

    private static final class StubConfig
    extends PushConfiguration<StubConfig> {
        private StubConfig() {
        }

        protected PushRegistrar buildRegistrar() {
            return (PushRegistrar)Mockito.mock(PushRegistrar.class);
        }
    }

    private static final class BrokenConfig
    extends PushConfiguration<BrokenConfig> {
        private BrokenConfig() {
        }

        protected PushRegistrar buildRegistrar() {
            return (PushRegistrar)Mockito.mock(PushRegistrar.class);
        }
    }
}

