/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.utils;

public class Patterns {
    private Patterns() {
    }

    public static boolean matchPattern(String name, char[] pattern) {
        return Patterns.matchPattern(name.toCharArray(), pattern);
    }

    public static boolean matchPattern(char[] name, char[] pattern) {
        return Patterns.matchPattern(name, 0, name.length, pattern);
    }

    public static boolean matchPattern(char[] name, int offset, int len, char[] pattern) {
        int k;
        int i = offset;
        boolean wildcard = false;
        block4: for (k = 0; k < pattern.length; ++k) {
            char c = pattern[k];
            switch (c) {
                case '*': {
                    wildcard = true;
                    continue block4;
                }
                case '?': {
                    ++i;
                    continue block4;
                }
                default: {
                    if (wildcard) {
                        while (i < len && name[i++] != c) {
                        }
                        if (i == len) {
                            return k >= pattern.length - 1;
                        }
                        wildcard = false;
                        continue block4;
                    }
                    if (i >= len || name[i] != c) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        if (wildcard && k < pattern.length) {
            return false;
        }
        return wildcard || i == len;
    }
}

