/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.filters;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.filters.AbstractPatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestBundleCategoryPatternFilter
extends AbstractPatternFilter {
    public static final String MANIFEST_BUNDLE_CATEGORY = "Bundle-Category";
    public static final String MANIFEST_BUNDLE_CATEGORY_TOKEN = ",";

    public ManifestBundleCategoryPatternFilter(String pattern, AbstractNuxeoAssembler mojo) {
        super(pattern, mojo);
    }

    public ManifestBundleCategoryPatternFilter(char[] pattern, AbstractNuxeoAssembler mojo) {
        super(pattern, mojo);
    }

    protected List<String> getValuesToMatch(Artifact artifact) {
        ArrayList<String> valuesToMatch = new ArrayList<String>();
        File file = artifact.getFile();
        if (file == null) {
            if (artifact.isResolved()) {
                this.mojo.getLog().warn((CharSequence)("Artifact " + artifact + " doesn't contain a file"));
            } else if (!"provided".equals(artifact.getScope())) {
                this.mojo.getLog().warn((CharSequence)("Artifact " + artifact + " unresolved"));
            }
            return valuesToMatch;
        }
        if (file.getName().endsWith(".pom")) {
            return valuesToMatch;
        }
        try {
            JarFile jarFile = new JarFile(file, true);
            Manifest mf = jarFile.getManifest();
            if (mf != null) {
                String bundleCategories;
                Attributes attributes = mf.getMainAttributes();
                if (attributes != null && (bundleCategories = attributes.getValue(MANIFEST_BUNDLE_CATEGORY)) != null) {
                    StringTokenizer st = new StringTokenizer(bundleCategories, MANIFEST_BUNDLE_CATEGORY_TOKEN);
                    while (st.hasMoreTokens()) {
                        valuesToMatch.add(st.nextToken());
                    }
                }
            } else {
                this.mojo.getLog().warn((CharSequence)("Artifact " + artifact + " doesn't contain a manifest"));
            }
        }
        catch (IOException e) {
            this.mojo.getLog().error((CharSequence)("error while inspecting this jar manifest: " + artifact.getFile()), (Throwable)e);
        }
        return valuesToMatch;
    }

    @Override
    protected String getValueToMatch(Artifact artifact) {
        return null;
    }

    @Override
    public boolean include(Artifact artifact) {
        boolean include = this.matchPattern(this.getValuesToMatch(artifact));
        this.mojo.getLog().debug((CharSequence)((include ? "accepts " : "rejects ") + artifact));
        return include;
    }

    private boolean matchPattern(List<String> valuesToMatch) {
        for (String valueToMatch : valuesToMatch) {
            if (!ManifestBundleCategoryPatternFilter.matchPattern(valueToMatch, this.pattern)) continue;
            return true;
        }
        return false;
    }
}

