/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.InversionArtifactFilter;
import org.nuxeo.build.filters.OrArtifactFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndArtifactFilter
implements ArtifactFilter {
    Collection<ArtifactFilter> filters = new ArrayList<ArtifactFilter>();

    public boolean include(Artifact artifact) {
        boolean include = true;
        for (ArtifactFilter filter : this.filters) {
            if (filter.include(artifact)) continue;
            include = false;
            break;
        }
        return include;
    }

    public void add(ArtifactFilter filter) {
        this.filters.add(filter);
    }

    public Collection<ArtifactFilter> getFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    public OrArtifactFilter invert() {
        OrArtifactFilter or = new OrArtifactFilter();
        for (ArtifactFilter filter : this.filters) {
            or.add((ArtifactFilter)new InversionArtifactFilter(filter));
        }
        return or;
    }
}

