/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.embedded;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.assembler.ArtifactResolver;
import org.nuxeo.build.assembler.xml.ArtifactDescriptor;
import org.nuxeo.build.embedded.NuxeoAppBuilder;
import org.nuxeo.common.utils.StringUtils;

public class NuxeoAppBuilderMojo
extends AbstractMojo {
    protected MavenProject project;
    protected ArtifactRepository local;
    protected List<ArtifactRepository> remoteArtifactRepositories;
    protected ArtifactFactory factory;
    protected org.apache.maven.artifact.resolver.ArtifactResolver resolver;
    private File src;
    private File target;
    private String launcher;
    private boolean includeNestedJars;
    private boolean excludeLibs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!(this.isProfileActivated("embedded-standalone") || this.isProfileActivated("embedded-minimal") || this.isProfileActivated("embedded-osgi"))) {
            System.out.println("Skiping all-in-one task. Use -Pembedded-standalone or -Pembedded-minimal or -Pembedded-osgi to activate it!");
            return;
        }
        NuxeoAppBuilder builder = new NuxeoAppBuilder();
        String[] ar = StringUtils.split((String)this.launcher, (char)':', (boolean)false);
        if (ar.length != 3) {
            throw new MojoFailureException("Invalid launcher format. Must use a string like groupId:artifactId:version to specify the launcher");
        }
        ArtifactDescriptor ad = new ArtifactDescriptor();
        ad.setGroup(ar[0]);
        ad.setName(ar[1]);
        ad.setVersion(ar[2]);
        ArtifactResolver aresolver = new ArtifactResolver(this.project, this.local, this.remoteArtifactRepositories, this.resolver, this.factory);
        Artifact arti = aresolver.resolve(ad);
        File ljar = arti.getFile();
        builder.setCopyEmbeddedJars(this.includeNestedJars);
        builder.setExcludeLibs(this.excludeLibs);
        if (this.isProfileActivated("embedded-osgi")) {
            builder.setExcludeOsgi(true);
        }
        try {
            builder.process(this.src, this.target, ljar);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to build all in one JAR for nuxeo", (Exception)e);
        }
    }

    public boolean isProfileActivated(String id) {
        List profiles = this.project.getActiveProfiles();
        for (Profile p : profiles) {
            if (!p.getId().equals(id)) continue;
            return true;
        }
        return false;
    }
}

