/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler.xml;

import java.util.ArrayList;
import java.util.Arrays;
import org.nuxeo.common.utils.FilePathPattern;
import org.nuxeo.common.utils.Path;

public class FilePathPatterns {
    protected FilePathPattern[] patterns;

    public FilePathPattern[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String[] patterns) {
        this.patterns = new FilePathPattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            this.patterns[i] = new FilePathPattern(patterns[i]);
        }
    }

    public void setPatterns(FilePathPattern[] patterns) {
        this.patterns = patterns;
    }

    public boolean match(String text) {
        Path path = new Path(text);
        for (FilePathPattern pattern : this.patterns) {
            if (!pattern.match(path)) continue;
            return true;
        }
        return false;
    }

    public void addPatterns(String[] newPatterns) {
        ArrayList<FilePathPattern> newPatternsList = new ArrayList<FilePathPattern>();
        if (this.patterns != null) {
            newPatternsList.addAll(Arrays.asList(this.patterns));
        }
        for (String pattern : newPatterns) {
            newPatternsList.add(new FilePathPattern(pattern));
        }
        this.patterns = newPatternsList.toArray(new FilePathPattern[newPatternsList.size()]);
    }
}

