/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.assembler.ArtifactResolver;
import org.nuxeo.build.assembler.NuxeoAssembler;
import org.nuxeo.build.assembler.resource.ArtifactResourceSet;
import org.nuxeo.build.assembler.resource.ResourceSet;
import org.nuxeo.build.assembler.xml.ArtifactDescriptor;
import org.nuxeo.build.filters.OrArtifactFilter;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="artifactSet")
public class ArtifactSet
extends ArtifactResourceSet {
    @XContext(value="mojo")
    protected AbstractNuxeoAssembler mojo;
    @XNode(value="@id")
    protected String id;
    @XNode(value="includeDependencies")
    protected boolean includeDependencies = false;
    @XNode(value="excludeDependencies")
    protected boolean excludeDependencies = false;
    @XNode(value="@extends")
    private String extendedSetId;
    protected ArtifactResourceSet superSet;
    @XNodeList(value="import", type=String[].class, componentType=String.class)
    private String[] importedSets;
    @XNodeList(value="artifacts/artifact", type=ArrayList.class, componentType=ArtifactDescriptor.class)
    private List<ArtifactDescriptor> artifactDescriptors;
    @XNodeList(value="includes/artifact", type=ArrayList.class, componentType=ArtifactDescriptor.class)
    private List<ArtifactDescriptor> includes;
    @XNodeList(value="excludes/artifact", type=ArrayList.class, componentType=ArtifactDescriptor.class)
    private List<ArtifactDescriptor> excludes;
    @XNode(value="@profile")
    protected String profile;
    private ArtifactFilter includeFilter;
    private ArtifactFilter excludeFilter;
    protected Set<Artifact> artifacts;
    private Set<Artifact> resolvedArtifacts;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public List<ArtifactDescriptor> getArtifactDescriptors() {
        return this.artifactDescriptors;
    }

    public void setArtifactDescriptors(List<ArtifactDescriptor> artifacts) {
        this.artifactDescriptors = artifacts;
    }

    public void setMojo(AbstractNuxeoAssembler mojo) {
        this.mojo = mojo;
    }

    public NuxeoAssembler getMojo() {
        return this.mojo;
    }

    public String getExtendedSetId() {
        return this.extendedSetId;
    }

    public void setExtendedSetId(String extendedSetId) {
        this.extendedSetId = extendedSetId;
    }

    public ArtifactResourceSet getSuperSet() {
        return this.superSet;
    }

    public void setSuperSet(ArtifactResourceSet superSet) {
        this.superSet = superSet;
    }

    public String[] getExtendedSets() {
        return this.importedSets;
    }

    public void setExtendedSets(String[] extendedSets) {
        this.importedSets = extendedSets;
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public boolean getIncludeDependencies() {
        return this.includeDependencies;
    }

    public void setExcludeDependencies(boolean excludeDependencies) {
        this.excludeDependencies = excludeDependencies;
    }

    public boolean getExcludeDependencies() {
        return this.excludeDependencies;
    }

    public Set<Artifact> getResolvedArtifacts() {
        return this.resolvedArtifacts;
    }

    public ArtifactFilter getIncludeFilter() {
        if (this.includes == null || this.includes.isEmpty()) {
            return null;
        }
        if (this.includeFilter == null) {
            OrArtifactFilter filter = new OrArtifactFilter();
            for (ArtifactDescriptor artifactDescriptor : this.includes) {
                filter.add(artifactDescriptor.getFilter());
            }
            this.includeFilter = filter;
        }
        return this.includeFilter;
    }

    public ArtifactFilter getExcludeFilter() {
        if (this.excludes == null || this.excludes.isEmpty()) {
            return null;
        }
        if (this.excludeFilter == null) {
            OrArtifactFilter filter = new OrArtifactFilter();
            for (ArtifactDescriptor afd : this.excludes) {
                filter.add(afd.getFilter());
            }
            this.excludeFilter = filter;
        }
        return this.excludeFilter;
    }

    protected Set<Artifact> loadImportedSets() {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Map<String, ResourceSet> sets = this.mojo.getResourceSetMap();
        if (this.importedSets != null && this.importedSets.length > 0) {
            for (String setId : this.importedSets) {
                ResourceSet set = sets.get(setId);
                if (!(set instanceof ArtifactResourceSet)) {
                    this.mojo.getLog().warn((CharSequence)("Cannot extend set " + setId + ". Set not found or not compatible"));
                    continue;
                }
                ArtifactResourceSet arSet = (ArtifactResourceSet)set;
                Iterator<Artifact> it = arSet.artifactIterator();
                while (it.hasNext()) {
                    Artifact artifact = it.next();
                    result.add(artifact);
                }
            }
        }
        return result;
    }

    @Override
    public Set<Artifact> getArtifacts() {
        if (this.artifacts == null) {
            this.artifacts = this.loadImportedSets();
            this.resolveArtifacts(this.artifacts);
            if (this.superSet != null) {
                Set<Artifact> superSetArtifacts = this.superSet.getArtifacts();
                this.resolveArtifacts(superSetArtifacts);
                this.artifacts.addAll(superSetArtifacts);
            }
            if (this.mojo.getLog().isDebugEnabled()) {
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-webapp-core " + this.find("nuxeo-platform-webapp-core")));
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-audit-facade " + this.find("nuxeo-platform-audit-facade")));
                this.mojo.getLog().debug((CharSequence)"CHECK applyIncludeFilters");
            }
            this.artifacts = this.applyIncludeFilters();
            if (this.mojo.getLog().isDebugEnabled()) {
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-webapp-core " + this.find("nuxeo-platform-webapp-core")));
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-audit-facade " + this.find("nuxeo-platform-audit-facade")));
                this.mojo.getLog().debug((CharSequence)"CHECK applyExcludeFilters");
            }
            this.artifacts = this.applyExcludeFilters();
            if (this.mojo.getLog().isDebugEnabled()) {
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-webapp-core " + this.find("nuxeo-platform-webapp-core")));
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-audit-facade " + this.find("nuxeo-platform-audit-facade")));
                this.mojo.getLog().debug((CharSequence)"CHECK applyIncludeDependenciesFilter");
            }
            this.applyIncludeDependenciesFilter();
            if (this.mojo.getLog().isDebugEnabled()) {
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-webapp-core " + this.find("nuxeo-platform-webapp-core")));
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-audit-facade " + this.find("nuxeo-platform-audit-facade")));
                this.mojo.getLog().debug((CharSequence)"CHECK applyExcludeFilters");
            }
            this.resolveArtifacts(this.artifacts);
            this.artifacts = this.applyExcludeFilters();
            if (this.mojo.getLog().isDebugEnabled()) {
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-webapp-core " + this.find("nuxeo-platform-webapp-core")));
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-audit-facade " + this.find("nuxeo-platform-audit-facade")));
                this.mojo.getLog().debug((CharSequence)"CHECK applyExcludeDependenciesFilter");
            }
            this.applyExcludeDependenciesFilter();
            if (this.mojo.getLog().isDebugEnabled()) {
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-webapp-core " + this.find("nuxeo-platform-webapp-core")));
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-audit-facade " + this.find("nuxeo-platform-audit-facade")));
                this.mojo.getLog().debug((CharSequence)"CHECK resolveArtifacts");
            }
            this.collectResolvedArtifacts(this.artifacts);
            if (this.mojo.getLog().isDebugEnabled()) {
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-webapp-core " + this.find("nuxeo-platform-webapp-core")));
                this.mojo.getLog().debug((CharSequence)("CHECK nuxeo-platform-audit-facade " + this.find("nuxeo-platform-audit-facade")));
            }
        }
        return this.artifacts;
    }

    private boolean find(String artifactId) {
        for (Artifact artifact : this.artifacts) {
            if (!artifact.getArtifactId().equals(artifactId)) continue;
            this.mojo.getLog().debug((CharSequence)("found " + artifact.hashCode()));
            return true;
        }
        return false;
    }

    private void applyExcludeDependenciesFilter() {
        if (this.excludeDependencies) {
            HashSet<Artifact> result = new HashSet<Artifact>();
            for (Artifact artifact : this.artifacts) {
                Set<Artifact> deps = this.mojo.getArtifactDependencies(artifact);
                result.addAll(deps);
            }
            this.artifacts.removeAll(result);
        }
    }

    private void applyIncludeDependenciesFilter() {
        if (this.includeDependencies) {
            HashSet<Artifact> result = new HashSet<Artifact>();
            for (Artifact artifact : this.artifacts) {
                Set<Artifact> deps = this.mojo.getArtifactDependencies(artifact);
                if (deps == null) continue;
                if (this.mojo.getLog().isDebugEnabled()) {
                    this.mojo.getLog().debug((CharSequence)("add dependencies for " + artifact));
                    for (Artifact dep : deps) {
                        if (result.contains(dep)) continue;
                        this.mojo.getLog().debug((CharSequence)("   added " + dep));
                    }
                }
                result.addAll(deps);
            }
            this.artifacts.addAll(result);
        }
    }

    private Set<Artifact> applyExcludeFilters() {
        HashSet<Artifact> result = new HashSet<Artifact>();
        ArtifactFilter filter = this.getExcludeFilter();
        if (filter != null) {
            for (Artifact nextArtifact : this.artifacts) {
                if (!filter.include(nextArtifact)) {
                    result.add(nextArtifact);
                    continue;
                }
                this.mojo.getLog().debug((CharSequence)("excluded " + nextArtifact + " " + nextArtifact.hashCode() + " (exclude filters)"));
            }
            return result;
        }
        return this.artifacts;
    }

    private Set<Artifact> applyIncludeFilters() {
        HashSet<Artifact> result = new HashSet<Artifact>();
        ArtifactFilter filter = this.getIncludeFilter();
        if (filter != null) {
            for (Artifact artifact : this.artifacts) {
                if (!filter.include(artifact)) {
                    this.mojo.getLog().debug((CharSequence)("excluded " + artifact + " " + artifact.hashCode() + " (include filters)"));
                    continue;
                }
                result.add(artifact);
            }
            return result;
        }
        return this.artifacts;
    }

    private void resolveArtifacts(Set<Artifact> artifactsToResolve) {
        ArtifactResolver resolver = this.mojo.getArtifactResolver();
        for (Artifact artifact : artifactsToResolve) {
            if (artifact.isResolved()) continue;
            try {
                resolver.resolve(artifact);
            }
            catch (MojoExecutionException e) {
                this.mojo.getLog().warn((Throwable)e);
            }
        }
    }

    public void collectResolvedArtifacts(Set<Artifact> artifactSet) {
        ArtifactResolver resolver = this.mojo.getArtifactResolver();
        try {
            for (ArtifactDescriptor ad : this.artifactDescriptors) {
                Artifact artifact;
                if (ad.profile != null && !this.mojo.isProfileActivated(ad.profile)) continue;
                if (ad.version == null) {
                    this.tryFillVersion(ad);
                }
                if ((artifact = resolver.resolve(ad)) == null) continue;
                this.mojo.getLog().info((CharSequence)("add explicitely declared " + artifact));
                artifactSet.add(artifact);
            }
        }
        catch (MojoExecutionException e) {
            throw new Error(e);
        }
    }

    protected void tryFillVersion(ArtifactDescriptor ad) {
        if (ad.group == null || ad.name == null) {
            return;
        }
        Artifact artifact = null;
        Map map = this.mojo.getProject().getManagedVersionMap();
        String key = ad.group + ":" + ad.name;
        if (ad.type != null) {
            key = key + ":" + ad.type;
            artifact = (Artifact)map.get(key);
        } else {
            String k = key + ":jar";
            artifact = (Artifact)map.get(k);
            if (artifact == null && (artifact = (Artifact)map.get(key + ":ejb")) == null) {
                artifact = (Artifact)map.get(key + ":rar");
            }
        }
        if (artifact != null) {
            ad.version = artifact.getVersion();
            ad.type = artifact.getType();
        }
    }

    public String toString() {
        StringBuffer toStringBuffer = new StringBuffer();
        toStringBuffer.append("{" + this.getId() + ", extends: " + this.getExtendedSets() + "," + this.getExtendedSetId() + ", includeDependencies=" + this.getIncludeDependencies() + ", resolvedArtifacts=" + this.getResolvedArtifacts() + ", " + this.getArtifacts().size() + " artifacts=" + this.getArtifacts());
        return toStringBuffer.toString();
    }
}

