/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.assembler.Assembly;
import org.nuxeo.build.assembler.NuxeoAssembler;
import org.nuxeo.build.assembler.commands.Command;
import org.nuxeo.build.assembler.resource.ArtifactResourceSet;
import org.nuxeo.build.assembler.resource.ResourceSet;
import org.nuxeo.build.assembler.xml.ArtifactSet;
import org.nuxeo.build.assembler.xml.AssemblyBuilder;
import org.nuxeo.build.assembler.xml.AssemblyDescriptor;
import org.nuxeo.build.assembler.xml.FileSet;
import org.nuxeo.build.assembler.xml.Files;
import org.nuxeo.build.assembler.xml.ZipEntrySet;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.runtime.jboss.deployment.preprocessor.DeploymentPreprocessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyImpl
implements Assembly {
    private NuxeoAssembler mojo;
    private MavenProject project;
    private AssemblyDescriptor descriptor;
    private File targetDir;
    private Map<String, Artifact> artifactMap;
    private Map<String, Artifact> artifactIdMap;
    private Log log = AbstractNuxeoAssembler.getLogger();
    private static String FORMAT_SEPARATOR = ",";

    public AssemblyImpl(NuxeoAssembler assembler, AssemblyDescriptor descriptor) {
        this.mojo = assembler;
        this.project = assembler.getProject();
        this.descriptor = descriptor;
    }

    @Override
    public Map<String, Artifact> getArtifactMap() {
        if (this.artifactMap == null) {
            this.artifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)this.project.getArtifacts());
        }
        return this.artifactMap;
    }

    @Override
    public Map<String, Artifact> getArtifactMapById() {
        if (this.artifactIdMap == null) {
            this.artifactIdMap = ArtifactUtils.artifactMapByArtifactId((Collection)this.project.getArtifacts());
        }
        return this.artifactIdMap;
    }

    @Override
    public Artifact getArtifact(String key) {
        Artifact artifact = this.getArtifactMapById().get(key);
        if (artifact == null) {
            artifact = this.getArtifactMap().get(key);
        }
        return artifact;
    }

    @Override
    public AssemblyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void run(Map<Object, Object> context) throws Exception {
        List<ArtifactSet> artifactSets;
        List<ZipEntrySet> zipEntrySets;
        List<FileSet> fileSets;
        List<Files> files;
        HashMap<Object, Object> properties = this.descriptor.getProperties();
        if (properties != null) {
            this.mojo.getProject().getProperties().putAll((Map<?, ?>)properties);
        }
        if (context == null) {
            context = new HashMap<Object, Object>();
        }
        this.targetDir = new File(this.mojo.getBasedir(), this.mojo.getOutputDirectory());
        this.targetDir = new File(this.targetDir, this.mojo.getTargetFileName() + ".tmp");
        if (this.targetDir.isDirectory()) {
            FileUtils.emptyDirectory((File)this.targetDir);
        } else {
            this.targetDir.mkdirs();
        }
        Map<String, ResourceSet> setMap = this.mojo.getResourceSetMap();
        context.put("outputDirectory", this.targetDir);
        context.put("resourceSets", setMap);
        String[] includes = this.descriptor.getIncludes();
        if (includes != null && includes.length > 0) {
            AssemblyBuilder builder = (AssemblyBuilder)context.get("builder");
            File asFile = (File)context.get("assemblyFile");
            asFile = asFile.getParentFile();
            for (String inc : includes) {
                List<Command> cmds;
                List<Files> files2;
                List<FileSet> fileSets2;
                List<ArtifactSet> asets;
                File incFile = new File(asFile, inc);
                AssemblyImpl ass = (AssemblyImpl)builder.parse(incFile);
                AssemblyDescriptor ad = ass.getDescriptor();
                properties = ad.getProperties();
                if (properties != null) {
                    this.mojo.getProject().getProperties().putAll((Map<?, ?>)properties);
                }
                if ((asets = ad.getArtifactSets()) != null) {
                    this.descriptor.getArtifactSets().addAll(asets);
                }
                if ((fileSets2 = ad.getFileSets()) != null) {
                    this.descriptor.getFileSets().addAll(fileSets2);
                }
                if ((files2 = ad.getFiles()) != null) {
                    this.descriptor.getFiles().addAll(files2);
                }
                List<ZipEntrySet> zipsets = ad.getZipEntrySets();
                if (files2 != null) {
                    this.descriptor.getZipEntrySets().addAll(zipsets);
                }
                if ((cmds = ad.getCommands()) == null) continue;
                this.descriptor.getCommands().addAll(cmds);
            }
        }
        if ((files = this.descriptor.getFiles()) != null) {
            this.log.info((CharSequence)"Processing resource files");
            for (Files set : files) {
                String id = set.getId();
                this.log.info((CharSequence)("Processing set: " + id));
                if (id == null) continue;
                setMap.put(id, set);
            }
        }
        if ((fileSets = this.descriptor.getFileSets()) != null) {
            this.log.info((CharSequence)"Processing resource file sets");
            for (FileSet set : fileSets) {
                String profile = set.getProfile();
                if (profile != null && !this.mojo.isProfileActivated(profile)) {
                    this.log.info((CharSequence)("Ignoring set: " + set.getId() + ". requires profile: " + profile));
                    continue;
                }
                String id = set.getId();
                this.log.info((CharSequence)("Processing set: " + id + " [profile: " + profile + "]"));
                if (id == null) continue;
                setMap.put(id, set);
            }
        }
        if ((zipEntrySets = this.descriptor.getZipEntrySets()) != null) {
            this.log.info((CharSequence)"Processing zip entry sets");
            for (ZipEntrySet set : zipEntrySets) {
                String profile = set.getProfile();
                if (profile != null && !this.mojo.isProfileActivated(profile)) {
                    this.log.info((CharSequence)("Ignoring set: " + set.getId() + ". requires profile: " + profile));
                    continue;
                }
                String id = set.getId();
                this.log.info((CharSequence)("Processing set: " + id + " [profile: " + profile + "]"));
                if (id == null) continue;
                setMap.put(id, set);
            }
        }
        if ((artifactSets = this.descriptor.getArtifactSets()) != null) {
            this.log.info((CharSequence)"Processing artifact sets");
            for (ArtifactSet set : artifactSets) {
                String profile = set.getProfile();
                if (profile != null && !this.mojo.isProfileActivated(set.getProfile())) {
                    this.log.info((CharSequence)("Ignoring set: " + set.getId() + ". requires profile: " + profile));
                    continue;
                }
                String id = set.getId();
                this.log.info((CharSequence)("Processing set: " + id + " [profile: " + profile + "]"));
                if (id != null) {
                    setMap.put(id, set);
                } else {
                    String extendsSetId = set.getExtendedSetId();
                    if (extendsSetId != null) {
                        ResourceSet superSet = setMap.get(extendsSetId);
                        if (superSet instanceof ArtifactResourceSet) {
                            set.setSuperSet((ArtifactResourceSet)superSet);
                        } else if (superSet != null) {
                            this.log.warn((CharSequence)("Invalid super set in extends clause: " + extendsSetId + ". A super set must be an artifact set"));
                        } else {
                            this.log.warn((CharSequence)("Extended set not found: " + extendsSetId + ". Ignoring..."));
                        }
                        set.setId(extendsSetId);
                        setMap.put(extendsSetId, set);
                    }
                }
                this.log.debug((CharSequence)(id + ": " + set.getArtifacts()));
            }
        }
        this.log.info((CharSequence)"Processing servers sets...");
        this.log.info((CharSequence)"Running assemble commands");
        for (Command cmd : this.descriptor.getCommands()) {
            cmd.execute(this.project, context);
        }
        if (this.mojo.isRunPreprocessor()) {
            this.log.info((CharSequence)("Running preprocessor on " + this.targetDir));
            DeploymentPreprocessor processor = new DeploymentPreprocessor(this.targetDir);
            try {
                processor.init();
                processor.predeploy();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Preprocessing Failed", e);
            }
            this.log.info((CharSequence)"Preprocessing done.");
        }
        File targetFile = new File(this.mojo.getBasedir(), this.mojo.getOutputDirectory());
        targetFile = new File(targetFile, this.mojo.getTargetFileName());
        this.log.info((CharSequence)("Creating target file: " + targetFile));
        if (targetFile.isFile()) {
            targetFile.delete();
        } else if (targetFile.isDirectory()) {
            FileUtils.deleteTree((File)targetFile);
        }
        String prefix = this.mojo.getZipRoot();
        String formats = this.mojo.getFormat();
        for (String pack : formats.split(FORMAT_SEPARATOR)) {
            if ("zip".equals(pack)) {
                File targetFileZiped = new File(targetFile.getParentFile(), targetFile.getName() + ".zip");
                if (prefix != null) {
                    ZipUtils.zip((File[])this.targetDir.listFiles(), (File)targetFileZiped, (String)prefix);
                } else {
                    ZipUtils.zip((File[])this.targetDir.listFiles(), (File)targetFileZiped);
                }
                this.log.info((CharSequence)("Zipped target to: " + targetFileZiped));
                continue;
            }
            FileUtils.copyTree((File)this.targetDir, (File)targetFile);
            this.log.info((CharSequence)("Copied target to: " + targetFile));
        }
        FileUtils.deleteTree((File)this.targetDir);
        this.log.info((CharSequence)"Done.");
    }

    protected File getOutputDirectory(String outputDirectory) {
        File dir = this.targetDir;
        if (outputDirectory != null) {
            dir = new File(dir, outputDirectory);
            dir.mkdirs();
        }
        return dir;
    }
}

