/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.ImportTask;
import org.codehaus.plexus.util.StringUtils;

public class AntRunTask
extends ImportTask {
    private List<String> targets = new ArrayList<String>();
    private String file;
    private boolean optional;

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setTarget(String target) {
        if (target == null || target.length() == 0) {
            return;
        }
        for (String t : StringUtils.split((String)target, (String)",")) {
            this.targets.add(t);
        }
    }

    public void execute() throws BuildException {
        File f = new File(this.getProject().replaceProperties(this.file));
        if (!f.exists()) {
            String message = "Cannot find " + this.file + " imported from antrun";
            if (this.optional) {
                this.getProject().log(message, 3);
                return;
            }
            throw new BuildException(message);
        }
        try {
            Project project = this.getProject();
            project.getTargets().remove("");
            ProjectHelper.getProjectHelper().parse(project, (Object)f);
            Target t = (Target)project.getTargets().get("");
            if (t != null) {
                t.execute();
            }
            if (this.targets != null && !this.targets.isEmpty()) {
                for (String target : this.targets) {
                    t = (Target)project.getTargets().get(target);
                    if (t != null) {
                        t.execute();
                        continue;
                    }
                    project.log("Unknown target: " + target, 3);
                }
            } else if (project.getDefaultTarget() != null && (t = (Target)project.getTargets().get(project.getDefaultTarget())) != null) {
                t.execute();
            }
        }
        catch (BuildException ex) {
            throw ProjectHelper.addLocationToBuildException((BuildException)ex, (Location)this.getLocation());
        }
    }
}

