/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class VersionMojo
extends AbstractMojo {
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String version = this.project.getVersion();
        if (version.length() > 1) {
            String eclipseVersion = this.executeMojo(version);
            this.project.getProperties().setProperty("eclipseVersion", eclipseVersion);
            this.getLog().info((CharSequence)("eclipseVersion:" + eclipseVersion));
        }
    }

    public String executeMojo(String version) {
        String eclipseVersion;
        String trailingTag;
        String[] versionSplitted = version.split("^(\\d+\\.)+\\d*");
        String string = trailingTag = versionSplitted.length > 0 ? versionSplitted[versionSplitted.length - 1] : null;
        if (trailingTag != null) {
            int tagIdx = version.indexOf(trailingTag);
            eclipseVersion = version.substring(0, tagIdx);
            trailingTag = trailingTag.replace(".", "_");
        } else {
            eclipseVersion = version;
        }
        eclipseVersion = VersionMojo.format(eclipseVersion, trailingTag);
        if (trailingTag != null) {
            if (!eclipseVersion.endsWith(".") && !trailingTag.startsWith(".")) {
                eclipseVersion = eclipseVersion + ".";
            }
            eclipseVersion = eclipseVersion + trailingTag;
        }
        return eclipseVersion;
    }

    private static String format(String shortVersion, String trailingTag) {
        if (shortVersion.matches("^(\\d+\\.){3}.*")) {
            return shortVersion;
        }
        if (shortVersion.matches("^(\\d+\\.){2}.*")) {
            if (shortVersion.endsWith(".")) {
                return shortVersion + "0.";
            }
            if (trailingTag == null) {
                return shortVersion + ".0";
            }
            return shortVersion;
        }
        if (shortVersion.matches("^\\d+\\..*")) {
            if (shortVersion.endsWith(".")) {
                return shortVersion + "0.0.";
            }
            if (trailingTag == null) {
                return shortVersion + ".0.0";
            }
            return shortVersion + ".0";
        }
        return shortVersion;
    }
}

