/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    protected Map<String, Node> nodes;
    private Artifact artifact;
    private List<Node> children;

    public Node(Map<String, Node> nodes) {
        this(nodes, null);
    }

    public Node(Map<String, Node> nodes, Artifact artifact) {
        this.nodes = nodes;
        this.artifact = artifact;
        this.children = new ArrayList<Node>();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Collection<Node> getChildren() {
        return this.children;
    }

    public void add(Node node) {
        this.children.add(node);
    }

    public void clear() {
        this.children.clear();
    }

    public String getParentID() {
        List trail = this.artifact.getDependencyTrail();
        if (trail != null) {
            return (String)trail.get(trail.size() - 2);
        }
        return null;
    }

    public Node getParent() {
        String parentId = this.getParentID();
        return parentId == null ? null : this.nodes.get(parentId);
    }

    public String[] getDependencyTrail() {
        List trail = this.artifact.getDependencyTrail();
        if (trail == null) {
            return null;
        }
        String[] ar = new String[trail.size()];
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = (String)trail.get(i);
        }
        return ar;
    }

    public Node[] getParents() {
        List trail = this.artifact.getDependencyTrail();
        if (trail == null) {
            return null;
        }
        Node[] ar = new Node[trail.size()];
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = this.nodes.get(trail.get(i));
        }
        return ar;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append(super.toString());
        toString.append(" [" + this.artifact + ", " + this.getParents().length + " parents, " + this.getChildren().size() + " children");
        return toString.toString();
    }
}

