/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property;

import org.jboss.util.Classes;
import org.jboss.util.CoercionException;
import org.jboss.util.FieldInstance;
import org.jboss.util.NullArgumentException;
import org.jboss.util.Objects;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.property.BoundPropertyAdapter;
import org.jboss.util.property.PropertyEvent;
import org.jboss.util.property.PropertyException;
import org.jboss.util.property.PropertyMap;

public class FieldBoundPropertyListener
extends BoundPropertyAdapter {
    protected final String propertyName;
    protected final FieldInstance fieldInstance;

    public FieldBoundPropertyListener(Object instance, String fieldName, String propertyName) {
        if (propertyName == null) {
            throw new NullArgumentException("propertyName");
        }
        this.propertyName = propertyName;
        try {
            this.fieldInstance = new FieldInstance(instance, fieldName);
            try {
                this.fieldInstance.getField().setAccessible(true);
            }
            catch (SecurityException e) {
                ThrowableHandler.add(e);
            }
            Classes.forceLoad(this.fieldInstance.getField().getType());
        }
        catch (NoSuchFieldException e) {
            throw new PropertyException(e);
        }
    }

    public FieldBoundPropertyListener(Object instance, String fieldName) {
        this(instance, fieldName, fieldName);
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public String filterValue(String value) {
        return value;
    }

    protected void setFieldValue(String value) {
        try {
            value = this.filterValue(value);
            Class<?> type = this.fieldInstance.getField().getType();
            Object coerced = Objects.coerce(value, type);
            this.fieldInstance.set(coerced);
        }
        catch (IllegalAccessException e) {
            throw new PropertyException(e);
        }
        catch (CoercionException e) {
            throw new PropertyException(e);
        }
    }

    public void propertyAdded(PropertyEvent event) {
        this.setFieldValue(event.getPropertyValue());
    }

    public void propertyChanged(PropertyEvent event) {
        this.setFieldValue(event.getPropertyValue());
    }

    public void propertyBound(PropertyMap map) {
        if (map.containsProperty(this.propertyName)) {
            this.setFieldValue(map.getProperty(this.propertyName));
        }
    }
}

