/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.FeatureZNodeStatus$;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FeatureZNode$
implements scala.Serializable {
    public static FeatureZNode$ MODULE$;
    private final String VersionKey;
    private final String StatusKey;
    private final String FeaturesKey;
    private final String V1MinVersionKey;
    private final String V1MaxVersionKey;
    private final int V1;
    private final int V2;

    static {
        new FeatureZNode$();
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String StatusKey() {
        return this.StatusKey;
    }

    private String FeaturesKey() {
        return this.FeaturesKey;
    }

    private String V1MinVersionKey() {
        return this.V1MinVersionKey;
    }

    private String V1MaxVersionKey() {
        return this.V1MaxVersionKey;
    }

    public int V1() {
        return this.V1;
    }

    public int V2() {
        return this.V2;
    }

    public FeatureZNode apply(MetadataVersion metadataVersion, FeatureZNodeStatus status, Map<String, Object> features) {
        int version = metadataVersion.isAtLeast(MetadataVersion.IBP_3_3_IV0) ? this.V2() : this.V1();
        return new FeatureZNode(version, status, features);
    }

    public String path() {
        return "/feature";
    }

    public java.util.Map<String, java.util.Map<String, Short>> asJavaMap(Map<String, Map<String, Object>> scalaMap) {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scalaMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String featureName = (String)x0$1._1();
            Map versionInfo = (Map)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)versionInfo.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                String label = (String)x0$2._1();
                short version = BoxesRunTime.unboxToShort((Object)x0$2._2());
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)version);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom())).asJava());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public byte[] encode(FeatureZNode featureZNode) {
        java.util.Map<String, java.util.Map<String, Short>> features = featureZNode.version() == this.V1() ? this.asJavaMap((Map<String, Map<String, Object>>)((Map)featureZNode.features().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String feature = (String)x0$1._1();
            short version = BoxesRunTime.unboxToShort((Object)x0$1._2());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)feature), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.V1MaxVersionKey()), (Object)BoxesRunTime.boxToShort((short)version)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.V1MinVersionKey()), (Object)BoxesRunTime.boxToShort((short)version))})));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()))) : this.asJavaMap((Map<String, Map<String, Object>>)((Map)featureZNode.features().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String feature = (String)x0$2._1();
            short version = BoxesRunTime.unboxToShort((Object)x0$2._2());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)feature), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.V1MaxVersionKey()), (Object)BoxesRunTime.boxToShort((short)version))})));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())));
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)featureZNode.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.StatusKey()), (Object)BoxesRunTime.boxToInteger((int)featureZNode.status().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FeaturesKey()), features)}));
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(jsonMap).asJava());
    }

    public FeatureZNode decode(byte[] jsonBytes) {
        Option<FeatureZNodeStatus> status;
        int version;
        JsonObject featureInfo;
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            featureInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            version = BoxesRunTime.unboxToInt((Object)featureInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < this.V1() || version > this.V2()) {
                throw new IllegalArgumentException(new StringBuilder(46).append("Unsupported version: ").append(version).append(" of feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            Option statusInt = featureInfo.get(this.StatusKey()).flatMap((Function1 & Serializable & scala.Serializable)x$36 -> x$36.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeInt$.MODULE$)));
            if (statusInt.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Status can not be absent in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            status = FeatureZNodeStatus$.MODULE$.withNameOpt(BoxesRunTime.unboxToInt((Object)statusInt.get()));
            if (status.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Malformed status: ").append(statusInt).append(" found in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
        } else {
            if (either instanceof Left) {
                JsonProcessingException e = (JsonProcessingException)((Object)((Left)either).value());
                throw new IllegalArgumentException(new StringBuilder(37).append("Failed to parse feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), e);
            }
            throw new MatchError(either);
        }
        Map<String, Object> finalizedFeatures = this.decodeFeature(version, featureInfo, jsonBytes);
        FeatureZNode featureZNode = new FeatureZNode(version, (FeatureZNodeStatus)status.get(), finalizedFeatures);
        return featureZNode;
    }

    private Map<String, Object> decodeFeature(int version, JsonObject featureInfo, byte[] jsonBytes) {
        Option featuresMap = featureInfo.get(this.FeaturesKey()).flatMap((Function1 & Serializable & scala.Serializable)x$37 -> x$37.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$.MODULE$.decodeMap(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeInt$.MODULE$, Map$.MODULE$.canBuildFrom()), Map$.MODULE$.canBuildFrom()))));
        if (featuresMap.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Features map can not be absent in: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
        }
        return (Map)((TraversableLike)featuresMap.get()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int maxValue;
            String featureName;
            if (x0$1 != null) {
                featureName = (String)x0$1._1();
                Map versionInfo = (Map)x0$1._2();
                if (version == MODULE$.V1() && !versionInfo.contains((Object)MODULE$.V1MinVersionKey())) {
                    throw new IllegalArgumentException(new StringBuilder(13).append(MODULE$.V1MinVersionKey()).append(" absent in [").append(versionInfo).append("]").toString());
                }
                if (!versionInfo.contains((Object)MODULE$.V1MaxVersionKey())) {
                    throw new IllegalArgumentException(new StringBuilder(13).append(MODULE$.V1MaxVersionKey()).append(" absent in [").append(versionInfo).append("]").toString());
                }
                Option minValueOpt = versionInfo.get((Object)MODULE$.V1MinVersionKey());
                maxValue = BoxesRunTime.unboxToInt((Object)versionInfo.apply((Object)MODULE$.V1MaxVersionKey()));
                if (version == MODULE$.V1() && (BoxesRunTime.unboxToInt((Object)minValueOpt.get()) < 1 || maxValue < BoxesRunTime.unboxToInt((Object)minValueOpt.get()))) {
                    throw new IllegalArgumentException(new StringBuilder(99).append("Expected minValue >= 1, maxValue >= 1 and maxValue >= minValue, but received minValue: ").append(minValueOpt.get()).append(", maxValue: ").append(maxValue).toString());
                }
                if (maxValue < 1) {
                    throw new IllegalArgumentException(new StringBuilder(47).append("Expected maxValue >= 1, but received maxValue: ").append(maxValue).toString());
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)BoxesRunTime.boxToShort((short)((short)maxValue)));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public FeatureZNode apply(int version, FeatureZNodeStatus status, Map<String, Object> features) {
        return new FeatureZNode(version, status, features);
    }

    public Option<Tuple3<Object, FeatureZNodeStatus, Map<String, Object>>> unapply(FeatureZNode x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.version()), (Object)x$0.status(), x$0.features()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FeatureZNode$() {
        MODULE$ = this;
        this.VersionKey = "version";
        this.StatusKey = "status";
        this.FeaturesKey = "features";
        this.V1MinVersionKey = "min_version_level";
        this.V1MaxVersionKey = "max_version_level";
        this.V1 = 1;
        this.V2 = 2;
    }
}

