/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.utils.Logging;
import kafka.utils.Throttler$;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0011#\u0001\u001dB\u0001\u0002\u000f\u0001\u0003\u0002\u0004%\t!\u000f\u0005\t{\u0001\u0011\t\u0019!C\u0001}!AA\t\u0001B\u0001B\u0003&!\b\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011u\u0003!\u0011!Q\u0001\nIC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\u0006W\u0002!\t\u0001\u001c\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u0019q\b\u0001)A\u0005m\"Aq\u0010\u0001b\u0001\n\u0013\t\t\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\u0002\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\u0002C\u0004\u0002 \u0001\u0001\u000b\u0011\u0002&\t\u0013\u0005\u0005\u0002\u00011A\u0005\n\u0005u\u0001\"CA\u0012\u0001\u0001\u0007I\u0011BA\u0013\u0011\u001d\tI\u0003\u0001Q!\n)C\u0001\"a\u000b\u0001\u0001\u0004%I!\u000f\u0005\n\u0003[\u0001\u0001\u0019!C\u0005\u0003_Aq!a\r\u0001A\u0003&!\bC\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u001d9\u0011Q\n\u0012\t\u0002\u0005=cAB\u0011#\u0011\u0003\t\t\u0006\u0003\u0004l3\u0011\u0005\u00111\u000b\u0005\b\u0003+JB\u0011AA,\u0011%\t\u0019'GI\u0001\n\u0003\t)\u0007C\u0005\u0002|e\t\n\u0011\"\u0001\u0002~!I\u0011\u0011Q\r\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003\u000fK\u0012\u0013!C\u0001\u0003\u0007C\u0011\"!#\u001a#\u0003%\t!a#\u0003\u0013QC'o\u001c;uY\u0016\u0014(BA\u0012%\u0003\u0015)H/\u001b7t\u0015\u0005)\u0013!B6bM.\f7\u0001A\n\u0005\u0001!r#\u0007\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Aj\u0011AI\u0005\u0003c\t\u0012q\u0001T8hO&tw\r\u0005\u00024m5\tAG\u0003\u00026I\u00059Q.\u001a;sS\u000e\u001c\u0018BA\u001c5\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u0012I\u0016\u001c\u0018N]3e%\u0006$X\rU3s'\u0016\u001cW#\u0001\u001e\u0011\u0005%Z\u0014B\u0001\u001f+\u0005\u0019!u.\u001e2mK\u0006)B-Z:je\u0016$'+\u0019;f!\u0016\u00148+Z2`I\u0015\fHCA C!\tI\u0003)\u0003\u0002BU\t!QK\\5u\u0011\u001d\u0019%!!AA\u0002i\n1\u0001\u001f\u00132\u0003I!Wm]5sK\u0012\u0014\u0016\r^3QKJ\u001cVm\u0019\u0011)\u0005\r1\u0005CA\u0015H\u0013\tA%F\u0001\u0005w_2\fG/\u001b7f\u0003=\u0019\u0007.Z2l\u0013:$XM\u001d<bY6\u001b\bCA\u0015L\u0013\ta%F\u0001\u0003M_:<\u0017\u0001\u0004;ie>$H\u000f\\3E_^t\u0007CA\u0015P\u0013\t\u0001&FA\u0004C_>dW-\u00198\u0002\u00155,GO]5d\u001d\u0006lW\r\u0005\u0002T5:\u0011A\u000b\u0017\t\u0003+*j\u0011A\u0016\u0006\u0003/\u001a\na\u0001\u0010:p_Rt\u0014BA-+\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eS\u0013!B;oSR\u001c\u0018\u0001\u0002;j[\u0016\u0004\"\u0001Y5\u000e\u0003\u0005T!a\t2\u000b\u0005\r$\u0017AB2p[6|gN\u0003\u0002&K*\u0011amZ\u0001\u0007CB\f7\r[3\u000b\u0003!\f1a\u001c:h\u0013\tQ\u0017M\u0001\u0003US6,\u0017A\u0002\u001fj]&$h\bF\u0004n]>\u0004\u0018O]:\u0011\u0005=\u0002\u0001\"\u0002\u001d\n\u0001\u0004Q\u0004bB%\n!\u0003\u0005\rA\u0013\u0005\b\u001b&\u0001\n\u00111\u0001O\u0011\u001d\t\u0016\u0002%AA\u0002ICq!X\u0005\u0011\u0002\u0003\u0007!\u000bC\u0004_\u0013A\u0005\t\u0019A0\u0002\t1|7m[\u000b\u0002mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0005Y\u0006twMC\u0001|\u0003\u0011Q\u0017M^1\n\u0005uD(AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%A\u0003nKR,'/\u0006\u0002\u0002\u0004A!\u0011QAA\u000b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001B2pe\u0016T1!NA\u0007\u0015\u0011\ty!!\u0005\u0002\re\fW.\\3s\u0015\t\t\u0019\"A\u0002d_6LA!a\u0006\u0002\b\t)Q*\u001a;fe\u00061Q.\u001a;fe\u0002\nqb\u00195fG.Le\u000e^3sm\u0006dgj]\u000b\u0002\u0015\u0006\u00012\r[3dW&sG/\u001a:wC2t5\u000fI\u0001\u000ea\u0016\u0014\u0018n\u001c3Ti\u0006\u0014HOT:\u0002#A,'/[8e'R\f'\u000f\u001e(t?\u0012*\u0017\u000fF\u0002@\u0003OAqaQ\t\u0002\u0002\u0003\u0007!*\u0001\bqKJLw\u000eZ*uCJ$hj\u001d\u0011\u0002\u001b=\u00147/\u001a:wK\u0012\u001cvNR1s\u0003Ey'm]3sm\u0016$7k\u001c$be~#S-\u001d\u000b\u0004\u007f\u0005E\u0002bB\"\u0015\u0003\u0003\u0005\rAO\u0001\u000f_\n\u001cXM\u001d<fIN{g)\u0019:!\u00035i\u0017-\u001f2f)\"\u0014x\u000e\u001e;mKR\u0019q(!\u000f\t\r\u0005mb\u00031\u0001;\u0003!y'm]3sm\u0016$\u0017aF;qI\u0006$X\rR3tSJ,GMU1uKB+'oU3d)\ry\u0014\u0011\t\u0005\u0007\u0003\u0007:\u0002\u0019\u0001\u001e\u00021U\u0004H-\u0019;fI\u0012+7/\u001b:fIJ\u000bG/\u001a)feN+7\rK\u0002\u0001\u0003\u000f\u00022aLA%\u0013\r\tYE\t\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0017!\u0003+ie>$H\u000f\\3s!\ty\u0013d\u0005\u0002\u001aQQ\u0011\u0011qJ\u0001\u0005[\u0006Lg\u000eF\u0002@\u00033Bq!a\u0017\u001c\u0001\u0004\ti&\u0001\u0003be\u001e\u001c\b\u0003B\u0015\u0002`IK1!!\u0019+\u0005\u0015\t%O]1z\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\r\u0016\u0004\u0015\u0006%4FAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U$&\u0001\u0006b]:|G/\u0019;j_:LA!!\u001f\u0002p\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyHK\u0002O\u0003S\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAACU\r\u0011\u0016\u0011N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\tiIK\u0002`\u0003S\u0002")
public class Throttler
implements KafkaMetricsGroup {
    private volatile double desiredRatePerSec;
    private final boolean throttleDown;
    private final Time time;
    private final Object lock;
    private final Meter meter;
    private final long checkIntervalNs;
    private long periodStartNs;
    private double observedSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$6() {
        return Throttler$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return Throttler$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return Throttler$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return Throttler$.MODULE$.$lessinit$greater$default$3();
    }

    public static long $lessinit$greater$default$2() {
        return Throttler$.MODULE$.$lessinit$greater$default$2();
    }

    public static void main(String[] stringArray) {
        Throttler$.MODULE$.main(stringArray);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public double desiredRatePerSec() {
        return this.desiredRatePerSec;
    }

    public void desiredRatePerSec_$eq(double x$1) {
        this.desiredRatePerSec = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private Meter meter() {
        return this.meter;
    }

    private long checkIntervalNs() {
        return this.checkIntervalNs;
    }

    private long periodStartNs() {
        return this.periodStartNs;
    }

    private void periodStartNs_$eq(long x$1) {
        this.periodStartNs = x$1;
    }

    private double observedSoFar() {
        return this.observedSoFar;
    }

    private void observedSoFar_$eq(double x$1) {
        this.observedSoFar = x$1;
    }

    public void maybeThrottle(double observed) {
        long msPerSec = TimeUnit.SECONDS.toMillis(1L);
        long nsPerSec = TimeUnit.SECONDS.toNanos(1L);
        double currentDesiredRatePerSec = this.desiredRatePerSec();
        this.meter().mark((long)observed);
        Object object = this.lock();
        synchronized (object) {
            this.observedSoFar_$eq(this.observedSoFar() + observed);
            long elapsedNs = this.time.nanoseconds() - this.periodStartNs();
            if (elapsedNs > this.checkIntervalNs() && this.observedSoFar() > 0.0) {
                double rateInSecs = this.observedSoFar() * (double)nsPerSec / (double)elapsedNs;
                if (!(this.throttleDown ^ rateInSecs > currentDesiredRatePerSec)) {
                    double desiredRateMs = currentDesiredRatePerSec / (double)msPerSec;
                    long elapsedMs = TimeUnit.NANOSECONDS.toMillis(elapsedNs);
                    long sleepTime = package$.MODULE$.round(this.observedSoFar() / desiredRateMs - (double)elapsedMs);
                    if (sleepTime > 0L) {
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Natural rate is %f per second but desired rate is %f, sleeping for %d ms to compensate.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rateInSecs), BoxesRunTime.boxToDouble((double)currentDesiredRatePerSec), BoxesRunTime.boxToLong((long)sleepTime)})));
                        this.time.sleep(sleepTime);
                    }
                }
                this.periodStartNs_$eq(this.time.nanoseconds());
                this.observedSoFar_$eq(0.0);
            }
            return;
        }
    }

    public void updateDesiredRatePerSec(double updatedDesiredRatePerSec) {
        this.desiredRatePerSec_$eq(updatedDesiredRatePerSec);
    }

    public Throttler(double desiredRatePerSec, long checkIntervalMs, boolean throttleDown, String metricName, String units, Time time) {
        this.desiredRatePerSec = desiredRatePerSec;
        this.throttleDown = throttleDown;
        this.time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.lock = new Object();
        this.meter = this.newMeter(metricName, units, TimeUnit.SECONDS, this.newMeter$default$4());
        this.checkIntervalNs = TimeUnit.MILLISECONDS.toNanos(checkIntervalMs);
        this.periodStartNs = time.nanoseconds();
        this.observedSoFar = 0.0;
    }
}

