/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Logging;
import kafka.utils.NoOpScheduledFutureTask;
import kafka.utils.Scheduler;
import org.apache.kafka.common.utils.KafkaThread;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\u000f\u001e\u0001\tB\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00039\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u000fA\u0003\u0001\u0019!C\u0005#\"9A\f\u0001a\u0001\n\u0013i\u0006BB2\u0001A\u0003&!\u000bC\u0004i\u0001\t\u0007I\u0011B5\t\rA\u0004\u0001\u0015!\u0003k\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015\u0019\b\u0001\"\u0011s\u0011\u0015!\b\u0001\"\u0001v\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fA\u0001\"!\u0012\u0001\t\u0003y\u0012q\t\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBa!a\u0019\u0001\t\u0003\nt!CA7;\u0005\u0005\t\u0012AA8\r!aR$!A\t\u0002\u0005E\u0004BB%\u0018\t\u0003\t\u0019\bC\u0005\u0002v]\t\n\u0011\"\u0001\u0002x!I\u0011QR\f\u0012\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003';\u0012\u0013!C\u0001\u0003\u001f\u0013abS1gW\u0006\u001c6\r[3ek2,'O\u0003\u0002\u001f?\u0005)Q\u000f^5mg*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0019\u0013&\f\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)ZS\"A\u000f\n\u00051j\"!C*dQ\u0016$W\u000f\\3s!\tQc&\u0003\u00020;\t9Aj\\4hS:<\u0017a\u0002;ie\u0016\fGm]\u000b\u0002eA\u0011AeM\u0005\u0003i\u0015\u00121!\u00138u\u0003!!\bN]3bIN\u0004\u0013\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y+\u0005A\u0004CA\u001dA\u001d\tQd\b\u0005\u0002<K5\tAH\u0003\u0002>C\u00051AH]8pizJ!aP\u0013\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f\u0015\n\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u0003\u0019!\u0017-Z7p]B\u0011AER\u0005\u0003\u000f\u0016\u0012qAQ8pY\u0016\fg.\u0001\u0007ue\u0006\u001c7n\u0015;vG.Lu*\u0001\u0004=S:LGO\u0010\u000b\u0006\u00172kej\u0014\t\u0003U\u0001AQ\u0001M\u0004A\u0002IBqAN\u0004\u0011\u0002\u0003\u0007\u0001\bC\u0004E\u000fA\u0005\t\u0019A#\t\u000f!;\u0001\u0013!a\u0001\u000b\u0006AQ\r_3dkR|'/F\u0001S!\t\u0019&,D\u0001U\u0015\t)f+\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0016-\u0002\tU$\u0018\u000e\u001c\u0006\u00023\u0006!!.\u0019<b\u0013\tYFKA\u000eTG\",G-\u001e7fIRC'/Z1e!>|G.\u0012=fGV$xN]\u0001\rKb,7-\u001e;pe~#S-\u001d\u000b\u0003=\u0006\u0004\"\u0001J0\n\u0005\u0001,#\u0001B+oSRDqAY\u0005\u0002\u0002\u0003\u0007!+A\u0002yIE\n\u0011\"\u001a=fGV$xN\u001d\u0011)\u0005))\u0007C\u0001\u0013g\u0013\t9WE\u0001\u0005w_2\fG/\u001b7f\u0003E\u00198\r[3ek2,'\u000f\u00165sK\u0006$\u0017\nZ\u000b\u0002UB\u00111N\\\u0007\u0002Y*\u0011Q\u000eV\u0001\u0007CR|W.[2\n\u0005=d'!D!u_6L7-\u00138uK\u001e,'/\u0001\ntG\",G-\u001e7feRC'/Z1e\u0013\u0012\u0004\u0013aB:uCJ$X\u000f\u001d\u000b\u0002=\u0006A1\u000f[;uI><h.\u0001\u0007tG\",G-\u001e7f\u001f:\u001cW\rF\u0002_mbDQa^\bA\u0002a\nAA\\1nK\")\u0011p\u0004a\u0001u\u0006\u0019a-\u001e8\u0011\u0007\u0011Zh,\u0003\u0002}K\tIa)\u001e8di&|g\u000eM\u0001\u0016g\u000eDW\rZ;mK>s7-Z,ji\"$U\r\\1z)\u0019qv0!\u0001\u0002\f!)q\u000f\u0005a\u0001q!9\u00111\u0001\tA\u0002\u0005\u0015\u0011a\u00023fY\u0006LXj\u001d\t\u0004I\u0005\u001d\u0011bAA\u0005K\t!Aj\u001c8h\u0011\u0015I\b\u00031\u0001{\u0003!\u00198\r[3ek2,G\u0003DA\t\u0003_\t\t$a\r\u00028\u0005m\u0002\u0007BA\n\u0003;\u0001RaUA\u000b\u00033I1!a\u0006U\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007\u0003BA\u000e\u0003;a\u0001\u0001B\u0006\u0002 E\t\t\u0011!A\u0003\u0002\u0005\u0005\"aA0%eE!\u00111EA\u0015!\r!\u0013QE\u0005\u0004\u0003O)#a\u0002(pi\"Lgn\u001a\t\u0004I\u0005-\u0012bAA\u0017K\t\u0019\u0011I\\=\t\u000b]\f\u0002\u0019\u0001\u001d\t\u000be\f\u0002\u0019\u0001>\t\u0013\u0005U\u0012\u0003%AA\u0002\u0005\u0015\u0011!\u00023fY\u0006L\b\"CA\u001d#A\u0005\t\u0019AA\u0003\u0003\u0019\u0001XM]5pI\"I\u0011QH\t\u0011\u0002\u0003\u0007\u0011qH\u0001\u0005k:LG\u000fE\u0002T\u0003\u0003J1!a\u0011U\u0005!!\u0016.\\3V]&$\u0018a\u0003;bg.\u0014VO\u001c8j]\u001e$2!RA%\u0011\u001d\tYE\u0005a\u0001\u0003\u001b\nA\u0001^1tWB\"\u0011qJA*!\u0015\u0019\u0016QCA)!\u0011\tY\"a\u0015\u0005\u0019\u0005U\u0013\u0011JA\u0001\u0002\u0003\u0015\t!!\t\u0003\u0007}#3'\u0001\tsKNL'0\u001a+ie\u0016\fG\rU8pYR\u0019a,a\u0017\t\r\u0005u3\u00031\u00013\u0003\u001dqWm^*ju\u0016\f\u0011\"[:Ti\u0006\u0014H/\u001a3\u0016\u0003\u0015\u000bAa]5{K\"\u001a\u0001!a\u001a\u0011\u0007)\nI'C\u0002\u0002lu\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u00039Y\u0015MZ6b'\u000eDW\rZ;mKJ\u0004\"AK\f\u0014\u0005]\u0019CCAA8\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0010\u0016\u0004q\u0005m4FAA?!\u0011\ty(!#\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dU%\u0001\u0006b]:|G/\u0019;j_:LA!a#\u0002\u0002\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tJK\u0002F\u0003w\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class KafkaScheduler
implements Scheduler,
Logging {
    private final int threads;
    private final String threadNamePrefix;
    private final boolean daemon;
    private final boolean trackStuckIO;
    private volatile ScheduledThreadPoolExecutor executor;
    private final AtomicInteger schedulerThreadId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$4() {
        return KafkaScheduler$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return KafkaScheduler$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return KafkaScheduler$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public long schedule$default$3() {
        return Scheduler.schedule$default$3$(this);
    }

    @Override
    public long schedule$default$4() {
        return Scheduler.schedule$default$4$(this);
    }

    @Override
    public TimeUnit schedule$default$5() {
        return Scheduler.schedule$default$5$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int threads() {
        return this.threads;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    private void executor_$eq(ScheduledThreadPoolExecutor x$1) {
        this.executor = x$1;
    }

    private AtomicInteger schedulerThreadId() {
        return this.schedulerThreadId;
    }

    @Override
    public void startup() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing task scheduler.");
        synchronized (this) {
            if (this.isStarted()) {
                throw new IllegalStateException("This scheduler has already been started!");
            }
            this.executor_$eq(new ScheduledThreadPoolExecutor(this.threads()));
            this.executor().setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.executor().setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executor().setRemoveOnCancelPolicy(true);
            this.executor().setThreadFactory(runnable -> new KafkaThread(new StringBuilder(0).append(this.threadNamePrefix()).append(this.schedulerThreadId().getAndIncrement()).toString(), runnable, $this.daemon, $this.trackStuckIO));
            return;
        }
    }

    @Override
    public void shutdown() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down task scheduler.");
        ScheduledThreadPoolExecutor cachedExecutor = this.executor();
        if (cachedExecutor != null) {
            synchronized (this) {
                cachedExecutor.shutdown();
                this.executor_$eq(null);
            }
            cachedExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    public void scheduleOnce(String name, Function0<BoxedUnit> fun) {
        this.schedule(name, fun, 0L, -1L, TimeUnit.MILLISECONDS);
    }

    public void scheduleOnceWithDelay(String name, long delayMs, Function0<BoxedUnit> fun) {
        this.schedule(name, fun, delayMs, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> schedule(String name, Function0<BoxedUnit> fun, long delay, long period, TimeUnit unit) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Scheduling task %s with initial delay %d ms and period %d ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.convert(delay, unit)), BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.convert(period, unit))})));
        synchronized (this) {
            ScheduledFuture<BoxedUnit> scheduledFuture;
            if (this.isStarted()) {
                Runnable runnable = () -> {
                    try {
                        try {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning execution of scheduled task '%s'.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                            fun.apply$mcV$sp();
                        }
                        catch (Throwable t) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Uncaught exception in scheduled task '").append(name).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                        }
                    }
                    finally {
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Completed execution of scheduled task '%s'.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                    }
                };
                scheduledFuture = period >= 0L ? this.executor().scheduleAtFixedRate(runnable, delay, period, unit) : this.executor().schedule(runnable, delay, unit);
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Kafka scheduler is not running at the time task '%s' is scheduled. The task is ignored.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                scheduledFuture = new NoOpScheduledFutureTask();
            }
            NoOpScheduledFutureTask noOpScheduledFutureTask = scheduledFuture;
            return noOpScheduledFutureTask;
        }
    }

    public boolean taskRunning(ScheduledFuture<?> task) {
        return this.executor().getQueue().contains(task);
    }

    public void resizeThreadPool(int newSize) {
        this.executor().setCorePoolSize(newSize);
    }

    @Override
    public synchronized boolean isStarted() {
        return this.executor() != null;
    }

    @Override
    public int size() {
        ScheduledThreadPoolExecutor cachedExecutor = this.executor();
        if (cachedExecutor != null) {
            return cachedExecutor.getQueue().size();
        }
        return 0;
    }

    public KafkaScheduler(int threads, String threadNamePrefix, boolean daemon, boolean trackStuckIO) {
        this.threads = threads;
        this.threadNamePrefix = threadNamePrefix;
        this.daemon = daemon;
        this.trackStuckIO = trackStuckIO;
        Logging.$init$(this);
        this.executor = null;
        this.schedulerThreadId = new AtomicInteger(0);
    }
}

