/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTransactionMetadata;
import kafka.log.AbortedTxn;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LastRecord;
import kafka.log.LogSegment;
import kafka.log.LogSegmentReadAdapter;
import kafka.log.MergedLog$;
import kafka.log.OffsetMap;
import kafka.log.TierLogSegment;
import kafka.log.TransactionIndex;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.CompactStats;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreRetryPolicy;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogCompactionUtils$;
import kafka.tier.tasks.compaction.TierLogSegmentReadAdapter;
import kafka.tier.tasks.compaction.TierLogSegmentReadAdapter$;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\f\u0019\u0001\u0005B\u0011\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0017\t\u00115\u0002!\u0011!Q\u0001\n9B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!)\u0005A!A!\u0002\u00131\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011e\u0003!\u0011!Q\u0001\niC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003u\u0011\u00159\b\u0001\"\u0001y\u0011\u001d\ty\u0001\u0001C)\u0003#Aq!!\u000b\u0001\t\u0003\nY\u0003C\u0004\u0002J\u0001!I!a\u0013\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u0011q\r\u0001\u0005\n\u0005%\u0004\u0002CA]\u0001\u0011\u0005\u0001$a/\t\u000f\u0005U\b\u0001\"\u0011\u0002x\"9!1\u0002\u0001\u0005B\t5!a\u0003+jKJ\u001cE.Z1oKJT!!\u0007\u000e\u0002\u0015\r|W\u000e]1di&|gN\u0003\u0002\u001c9\u0005)A/Y:lg*\u0011QDH\u0001\u0005i&,'OC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015r\u0012a\u00017pO&\u0011q\u0005\n\u0002\b\u00072,\u0017M\\3s\u0003%ygMZ:fi6\u000b\u0007\u000f\u0005\u0002$U%\u00111\u0006\n\u0002\n\u001f\u001a47/\u001a;NCBL!\u0001\u000b\u0014\u0002\u0019%|')\u001e4gKJ\u001c\u0016N_3\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\u0007%sG/A\bnCbLuNQ;gM\u0016\u00148+\u001b>f\u0003M!W\u000f\u001d\"vM\u001a,'\u000fT8bI\u001a\u000b7\r^8s!\tys'\u0003\u00029a\t1Ai\\;cY\u0016\f\u0011\u0002\u001e5s_R$H.\u001a:\u0011\u0005mrT\"\u0001\u001f\u000b\u0005ur\u0012!B;uS2\u001c\u0018BA =\u0005%!\u0006N]8ui2,'/A\u000buS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8NKR\u0014\u0018nY:\u0011\u0005\t\u001bU\"\u0001\r\n\u0005\u0011C\"!\u0006+jKJ\u001cu.\u001c9bGRLwN\\'fiJL7m]\u0001\u0005i&lW\r\u0005\u0002H!6\t\u0001J\u0003\u0002>\u0013*\u0011!jS\u0001\u0007G>lWn\u001c8\u000b\u0005}a%BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001eL!!\u0015%\u0003\tQKW.Z\u0001\u0010i&,'o\u00142kK\u000e$8\u000b^8sKB\u0011AkV\u0007\u0002+*\u0011a\u000bH\u0001\u0006gR|'/Z\u0005\u00031V\u0013q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0012i&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014\bCA._\u001b\u0005a&BA/\u001d\u0003\u0015!x\u000e]5d\u0013\tyFLA\tUS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJ\f1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006\u00191\r\u001e=\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015d\u0012a\u00024fi\u000eDWM]\u0005\u0003O\u0012\u00141cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR\f\u0011b\u00195fG.$uN\\3\u0011\t=RG\u000e]\u0005\u0003WB\u0012\u0011BR;oGRLwN\\\u0019\u0011\u00055tW\"A%\n\u0005=L%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003_EL!A\u001d\u0019\u0003\tUs\u0017\u000e^\u0001\fe\u0016$(/\u001f)pY&\u001c\u0017\u0010\u0005\u0002Uk&\u0011a/\u0016\u0002\u001b)&,'o\u00142kK\u000e$8\u000b^8sKJ+GO]=Q_2L7-_\u0001\u0007y%t\u0017\u000e\u001e \u0015+eT8\u0010`?\u007f\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0002\u000eA\u0011!\t\u0001\u0005\u0006Q9\u0001\r!\u000b\u0005\u0006[9\u0001\rA\f\u0005\u0006i9\u0001\rA\f\u0005\u0006k9\u0001\rA\u000e\u0005\u0006s9\u0001\rA\u000f\u0005\u0006\u0001:\u0001\r!\u0011\u0005\u0006\u000b:\u0001\rA\u0012\u0005\u0006%:\u0001\ra\u0015\u0005\u00063:\u0001\rA\u0017\u0005\u0006A:\u0001\rA\f\u0005\u0006C:\u0001\rA\u0019\u0005\u0006Q:\u0001\r!\u001b\u0005\u0006g:\u0001\r\u0001^\u0001\u000bY><w-\u001a:OC6,WCAA\n!\u0011\t)\"a\t\u000f\t\u0005]\u0011q\u0004\t\u0004\u00033\u0001TBAA\u000e\u0015\r\ti\u0002I\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005\u0002'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\t9C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003C\u0001\u0014!B2mK\u0006tG\u0003BA\u0017\u0003\u007f\u0001raLA\u0018\u0003g\tI$C\u0002\u00022A\u0012a\u0001V;qY\u0016\u0014\u0004cA\u0018\u00026%\u0019\u0011q\u0007\u0019\u0003\t1{gn\u001a\t\u0004G\u0005m\u0012bAA\u001fI\ta1\t\\3b]\u0016\u00148\u000b^1ug\"9\u0011\u0011\t\tA\u0002\u0005\r\u0013!C2mK\u0006t\u0017M\u00197f!\r\u0019\u0013QI\u0005\u0004\u0003\u000f\"#aC\"mK\u0006t\u0007+\u0019:b[N\f1\u0002Z8US\u0016\u00148\t\\3b]R1\u0011QFA'\u0003#Bq!a\u0014\u0012\u0001\u0004\t\u0019%A\u0006dY\u0016\fg\u000eU1sC6\u001c\bbBA*#\u0001\u0007\u00111G\u0001\fGV\u0014(/\u001a8u)&lW-\u0001\fva\u0012\fG/\u001a3MCN$8\t\\3b]>3gm]3u)\u0019\t\u0019$!\u0017\u0002^!9\u00111\f\nA\u0002\u0005M\u0012A\u00049s_B|7/\u001a3PM\u001a\u001cX\r\u001e\u0005\b\u0003?\u0012\u0002\u0019AA1\u0003A\u0019w.\u001c9bGR\u001cu.\u001c9mKR,G\rE\u00020\u0003GJ1!!\u001a1\u0005\u001d\u0011un\u001c7fC:\f1d\u0019:fCR,\u0017I\u001c3Xe&$XmQ8n[&$\u0018I\u001c3To\u0006\u0004H#\u00059\u0002l\u0005M\u0014qPAB\u0003\u000f\u000bI)a(\u00026\"1Qe\u0005a\u0001\u0003[\u00022aIA8\u0013\r\t\t\b\n\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0004\u0002vM\u0001\r!a\u001e\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0003BA=\u0003wj\u0011\u0001H\u0005\u0004\u0003{b\"\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u0019\t\ti\u0005a\u0001]\u0005IA/[3s\u000bB|7\r\u001b\u0005\b\u0003\u000b\u001b\u0002\u0019AA\u001d\u0003\u0015\u0019H/\u0019;t\u0011\u001d\tyf\u0005a\u0001\u0003CBq!a#\u0014\u0001\u0004\ti)\u0001\bt_V\u00148-Z*fO6,g\u000e^:\u0011\r\u0005=\u0015QSAM\u001b\t\t\tJC\u0002\u0002\u0014B\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9*!%\u0003\u0011%#XM]1cY\u0016\u00042aIAN\u0013\r\ti\n\n\u0002\u000f)&,'\u000fT8h'\u0016<W.\u001a8u\u0011\u001d\t\tk\u0005a\u0001\u0003G\u000bA\u0003Z3ti&t\u0017\r^5p]>\u0013'.Z2u\u0013\u0012\u001c\bCBAH\u0003+\u000b)\u000b\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003_\u000bAA[1wC&!\u00111WAU\u0005\u0011)V+\u0013#\t\u000f\u0005]6\u00031\u0001\u00024\u0005yA.Y:u\u00072,\u0017M\\(gMN,G/A\u0007dY\u0016\fgnU3h[\u0016tGo\u001d\u000b\u0013\u0003{\u000b\t.a5\u0002^\u0006\u0005\u00181]As\u0003_\f\u0019\u0010E\u00040\u0003_\ty,a3\u0011\r\u0005\u0005\u0017qYAM\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006E\u0015aB7vi\u0006\u0014G.Z\u0005\u0005\u0003\u0013\f\u0019M\u0001\u0006MSN$()\u001e4gKJ\u00042aIAg\u0013\r\ty\r\n\u0002\u000b\u0019><7+Z4nK:$\bBB\u0013\u0015\u0001\u0004\ti\u0007C\u0004\u0002VR\u0001\r!a6\u0002\u0011M,w-\\3oiN\u0004b!!1\u0002Z\u0006e\u0015\u0002BAn\u0003\u0007\u0014Q!U;fk\u0016Da!a8\u0015\u0001\u0004I\u0013aA7ba\"9\u00111\u000b\u000bA\u0002\u0005M\u0002bBAC)\u0001\u0007\u0011\u0011\b\u0005\b\u0003O$\u0002\u0019AAu\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\r\u0019\u00131^\u0005\u0004\u0003[$#AG\"mK\u0006tW\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007bBAy)\u0001\u0007\u00111G\u0001\u0016Y\u0016<\u0017mY=EK2,G/\u001a%pe&TxN\\'t\u0011\u001d\t)\b\u0006a\u0001\u0003o\n1\u0002\\8h'\u0016<W.\u001a8ugRA\u0011\u0011 B\u0001\u0005\u0007\u00119\u0001\u0005\u0004\u0002\u0010\u0006U\u00151 \t\u0004G\u0005u\u0018bAA\u0000I\t)Bj\\4TK\u001elWM\u001c;SK\u0006$\u0017\tZ1qi\u0016\u0014\bBB\u0013\u0016\u0001\u0004\ti\u0007C\u0004\u0003\u0006U\u0001\r!a\r\u0002\t\u0019\u0014x.\u001c\u0005\b\u0005\u0013)\u0002\u0019AA\u001a\u0003\t!x.\u0001\u000ed_2dWm\u0019;BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7\u000f\u0006\u0005\u0003\u0010\t\u001d\"\u0011\u0006B\u0017!\u0019\u0011\tBa\u0007\u0003\"9!!1\u0003B\f\u001d\u0011\tIB!\u0006\n\u0003EJ1A!\u00071\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\b\u0003 \t!A*[:u\u0015\r\u0011I\u0002\r\t\u0004G\t\r\u0012b\u0001B\u0013I\tQ\u0011IY8si\u0016$G\u000b\u001f8\t\r\u00152\u0002\u0019AA7\u0011\u001d\u0011YC\u0006a\u0001\u0003g\tQa\u001d;beRDqAa\f\u0017\u0001\u0004\t\u0019$A\u0002f]\u0012\u0004")
public class TierCleaner
extends Cleaner {
    private final TierCompactionMetrics tierCompactionMetrics;
    private final Time time;
    private final TierObjectStore tierObjectStore;
    private final TierTopicAppender tierTopicAppender;
    private final int leaderEpoch;
    private final CancellationContext ctx;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final TierObjectStoreRetryPolicy retryPolicy;

    @Override
    public String loggerName() {
        return TierCleaner.class.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<Object, CleanerStats> clean(CleanParams cleanable) {
        void var3_3;
        void var5_4;
        this.checkDone.apply((Object)cleanable.log().topicPartition());
        Tuple2<Object, CleanerStats> tuple2 = this.doTierClean(cleanable, this.time.milliseconds());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        CleanerStats cleanerStats = (CleanerStats)tuple2._2();
        double bytesShrinkageRatio = 1.0 - (double)var5_4.bytesWritten() / (double)var5_4.bytesRead();
        cleanable.log().updateLastShrinkageRatio(bytesShrinkageRatio);
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)var3_3), (Object)var5_4);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, CleanerStats> doTierClean(CleanParams cleanParams, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Beginning cleaning of log ").append(cleanParams.log().name()).append(" with ").append(cleanParams).toString());
        Option option = cleanParams.log().localLogSegments(0L, cleanParams.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - Predef$.MODULE$.Long2long(cleanParams.log().config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        if (cleanParams.topicIdPartition().isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(72).append("CleanParams for tiered compactions must have a valid topic id partition ").append(cleanParams).toString());
        }
        AbstractLog log = cleanParams.log();
        TopicIdPartition topicIdPartition = (TopicIdPartition)cleanParams.topicIdPartition().get();
        CleanerStats stats = new CleanerStats(this.time, this.tierCompactionMetrics.cleanerMetrics());
        long firstDirtyOffset = cleanParams.firstDirtyOffset();
        long upperBoundOffset = cleanParams.firstUncleanableOffset();
        boolean isOffsetMapFull = this.buildOffsetMap(log, firstDirtyOffset, upperBoundOffset, super.offsetMap(), stats);
        if (super.offsetMap().latestOffset() == -1L) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map for %s has latest offset of -1, no offsets to compact")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)-1L), (Object)stats);
        }
        long endOffset = super.offsetMap().latestOffset() + 1L;
        stats.indexDone(isOffsetMapFull);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("CompactionTask for ").append(topicIdPartition).append(" endOffset: ").append(endOffset).append(" upperBoundOffset: ").append(upperBoundOffset).toString());
        Queue tieredSegments = (Queue)new Queue().$plus$plus$eq(log.tieredLogSegments(cleanParams.startOffset(), endOffset));
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)tieredSegments.lastOption().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.maxTimestamp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(l)})));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cleaning log tiered segments for cleaning ").append(tieredSegments.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.metadata(), Queue$.MODULE$.canBuildFrom())).append(" vs ").append(log.tieredLogSegments().toList()).toString());
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        while (tieredSegments.nonEmpty()) {
            void var23_17;
            void var22_16;
            Tuple2<ListBuffer<TierLogSegment>, LogSegment> tuple2 = this.cleanSegments(log, (Queue<TierLogSegment>)tieredSegments, super.offsetMap(), currentTime, stats, transactionMetadata, l, topicIdPartition);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            ListBuffer segmentsUsed = (ListBuffer)tuple2._1();
            LogSegment cleanedSegment = (LogSegment)tuple2._2();
            void segmentsUsed2 = var22_16;
            void cleanedSegment2 = var23_17;
            this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TierCleaner.$anonfun$doTierClean$9(topicIdPartition, (ListBuffer)segmentsUsed2, tieredSegments)));
            try {
                if (segmentsUsed2.isEmpty()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append(topicIdPartition).append(": cleanSegments cleaned no segment because some source segments are deleted. ").append("Continue to clean next source segment").toString());
                    continue;
                }
                if (cleanedSegment2.size() == 0) {
                    boolean compactCompleted = true;
                    long lastCleanOffset = this.updatedLastCleanOffset(((TierLogSegment)segmentsUsed2.last()).endOffset(), compactCompleted);
                    this.info((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TierCleaner.$anonfun$doTierClean$11(topicIdPartition, (ListBuffer)segmentsUsed2)));
                    this.createAndWriteCommitAndSwap(log, topicIdPartition, this.leaderEpoch, stats, compactCompleted, (Iterable<TierLogSegment>)segmentsUsed2, (Iterable<UUID>)Nil$.MODULE$, lastCleanOffset);
                    continue;
                }
                Option<ByteBuffer> producerStateOpt = TierLogCompactionUtils$.MODULE$.fetchProducerState(this.tierObjectStore, (TierLogSegment)segmentsUsed2.last(), this.ctx, this.retryPolicy);
                Option<ByteBuffer> epochStateOpt = TierLogCompactionUtils$.MODULE$.fetchEpochState(this.tierObjectStore, (TierLogSegment)segmentsUsed2.last(), this.ctx, this.retryPolicy);
                long nextOffset = ((TierLogSegment)segmentsUsed2.last()).endOffset() + 1L;
                List<AbortedTxn> completedAbortedTxns = cleanedSegment2.collectAbortedTxns(cleanedSegment2.baseOffset(), nextOffset).abortedTransactions();
                List ongoingAbortedTxns = (List)((TraversableOnce)((TraversableLike)transactionMetadata.ongoingAbortedTxns().values().filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TierCleaner.$anonfun$doTierClean$12(x$14)))).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.abortedTxn(), Iterable$.MODULE$.canBuildFrom())).toList().sortBy((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.lastOffset()), (Ordering)Ordering.Long$.MODULE$);
                Option<ByteBuffer> abortedTxns = MergedLog$.MODULE$.serializeAbortedTransactions((Seq<AbortedTxn>)((Seq)completedAbortedTxns.$plus$plus((GenTraversableOnce)ongoingAbortedTxns, List$.MODULE$.canBuildFrom())));
                TierObjectStore.OpaqueData opaqueData = (TierObjectStore.OpaqueData)Option$.MODULE$.apply((Object)this.tierObjectStore.prepPutSegment()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TierObjectStore.OpaqueData.ZEROED);
                TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, this.leaderEpoch, UUID.randomUUID(), cleanedSegment2.baseOffset(), cleanedSegment2.readNextOffset() - 1L, cleanedSegment2.largestTimestamp(), cleanedSegment2.getFirstBatchTimestamp(), cleanedSegment2.size(), epochStateOpt.isDefined(), abortedTxns.isDefined(), producerStateOpt.isDefined(), TierUploadType.Compaction, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), opaqueData);
                TierLogCompactionUtils$.MODULE$.writeUploadInitiateMarker(uploadInitiate, topicIdPartition, this.time, this.tierTopicAppender);
                TierObjectStore.ObjectMetadata objectStoreMetadata = new TierObjectStore.ObjectMetadata(topicIdPartition, uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), uploadInitiate.hasEpochState(), opaqueData);
                this.tierObjectStore.putInMemorySegment(objectStoreMetadata, cleanedSegment2.log().file(), cleanedSegment2.offsetIndex().file(), cleanedSegment2.timeIndex().file(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(producerStateOpt)), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(abortedTxns)), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(epochStateOpt)));
                boolean compactCompleted = tieredSegments.isEmpty();
                long lastCleanOffset = this.updatedLastCleanOffset(uploadInitiate.endOffset(), compactCompleted);
                this.createAndWriteCommitAndSwap(log, topicIdPartition, this.leaderEpoch, stats, compactCompleted, (Iterable<TierLogSegment>)segmentsUsed2, (Iterable<UUID>)new .colon.colon((Object)uploadInitiate.objectId(), (List)Nil$.MODULE$), lastCleanOffset);
            }
            finally {
                cleanedSegment2.deleteIfExists();
            }
        }
        stats.bufferUtilization_$eq(super.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    private long updatedLastCleanOffset(long proposedOffset, boolean compactCompleted) {
        if (proposedOffset >= super.offsetMap().latestOffset()) {
            return super.offsetMap().latestOffset();
        }
        if (compactCompleted) {
            return super.offsetMap().latestOffset();
        }
        return proposedOffset;
    }

    private void createAndWriteCommitAndSwap(AbstractLog log, TopicIdPartition topicIdPartition, int tierEpoch, CleanerStats stats, boolean compactCompleted, Iterable<TierLogSegment> sourceSegments, Iterable<UUID> destinationObjectIds, long lastCleanOffset) {
        java.util.Set sourceObjectIds = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)sourceSegments.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.metadata().objectId(), Iterable$.MODULE$.canBuildFrom())).toSet()).asJava();
        CompactStats compactStats = compactCompleted ? new CompactStats(stats.bytesRead(), stats.bytesWritten(), stats.mapBytesRead()) : CompactStats.EMPTY;
        TierCompactionCommitAndSwap commitAndSwap = new TierCompactionCommitAndSwap(topicIdPartition, tierEpoch, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), UUID.randomUUID(), sourceObjectIds, (java.util.Set<UUID>)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)destinationObjectIds.toSet()).asJava()), lastCleanOffset, compactStats);
        TierLogCompactionUtils$.MODULE$.writeCommitAndSwapMarker(commitAndSwap, topicIdPartition, this.time, this.tierTopicAppender);
    }

    public Tuple2<ListBuffer<TierLogSegment>, LogSegment> cleanSegments(AbstractLog log, Queue<TierLogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs, TopicIdPartition topicIdPartition) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Cleaning log ").append(log.name()).append(" cleanSegments tiered segments ").append(segments).toString());
        ListBuffer segmentsUsed = new ListBuffer();
        LogSegment cleanedSegment = MergedLog$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((TierLogSegment)segments.head()).baseOffset(), MergedLog$.MODULE$.TierCleanedFileSuffix());
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleanedSegment.txnIndex()));
        Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
        boolean cleanedSegmentDone = false;
        Integer targetSegmentSize = log.config().segmentSize();
        Integer minSegmentSize = log.config().confluentLogConfig().tierCleanerCompactSegmentMinBytes();
        int maxSegmentSize = Integer.MAX_VALUE;
        while (segments.nonEmpty() && !cleanedSegmentDone) {
            TierLogSegment currentSegment = (TierLogSegment)segments.head();
            cleanedSegmentDone = !TierLogCompactionUtils$.MODULE$.shouldCompactNextSourceSegmentIntoDestSegment(topicIdPartition, cleanedSegment, currentSegment, Predef$.MODULE$.Integer2int(targetSegmentSize), Predef$.MODULE$.Integer2int(minSegmentSize), maxSegmentSize);
            if (cleanedSegmentDone) continue;
            List<AbortedTxn> abortedTransactions = TierLogCompactionUtils$.MODULE$.fetchAbortedTransactions(this.tierObjectStore, currentSegment, this.ctx, this.retryPolicy);
            transactionMetadata.addAbortedTransactions(abortedTransactions);
            boolean retainLegacyDeletesAndTxnMarkers = currentSegment.maxTimestamp() > legacyDeleteHorizonMs;
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append(topicIdPartition).append(": cleaning ").append(currentSegment).append(" into ").append(cleanedSegment.baseOffset()).append(" ").append("with upper bound deleteHorizonMs=").append(legacyDeleteHorizonMs).append(", retainDeletesAndTxnMarkers=").append(retainLegacyDeletesAndTxnMarkers).append(".").toString());
                segments.dequeue();
                if (currentSegment.endOffset() < log.logStartOffset()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append(topicIdPartition).append(": end offset of segment ").append(currentSegment).append(" is smaller than log start offset ").append(log.logStartOffset()).append(". ").append("Discard current result and continue to clean next segments.").toString());
                    segmentsUsed.clear();
                    cleanedSegmentDone = true;
                    continue;
                }
                segmentsUsed.$plus$eq((Object)currentSegment);
                TierLogSegmentReadAdapter segmentAdapter = TierLogSegmentReadAdapter$.MODULE$.apply(currentSegment, this.tierObjectStore, this.ctx, this.retryPolicy);
                this.cleanInto(log.topicPartition(), segmentAdapter, cleanedSegment, map, retainLegacyDeletesAndTxnMarkers, Predef$.MODULE$.Long2long(log.config().deleteRetentionMs()), Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, lastOffsetOfActiveProducers, stats, currentTime);
            }
            catch (LogSegmentOffsetOverflowException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append(topicIdPartition).append(": LogSegmentOffsetOverflowException cause to abort, ").append(e.getCause()).toString());
                try {
                    try {
                        cleanedSegment.deleteIfExists();
                    }
                    catch (Exception deleteException) {
                        e.addSuppressed(deleteException);
                    }
                }
                catch (Throwable throwable) {
                    throw new TierLogCompactionFencedException(topicIdPartition, e.getCause());
                }
                throw new TierLogCompactionFencedException(topicIdPartition, e.getCause());
            }
        }
        cleanedSegment.onBecomeInactiveSegment();
        return new Tuple2((Object)segmentsUsed, (Object)cleanedSegment);
    }

    @Override
    public Iterable<LogSegmentReadAdapter> logSegments(AbstractLog log, long from, long to) {
        return log.tieredLogSegments(from, to).map((Function1 & Serializable & scala.Serializable)x$18 -> TierLogSegmentReadAdapter$.MODULE$.apply((TierLogSegment)x$18, $this.tierObjectStore, $this.ctx, $this.retryPolicy)).dropWhile((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TierCleaner.$anonfun$logSegments$2(from, x$19))).toList();
    }

    @Override
    public List<AbortedTxn> collectAbortedTransactions(AbstractLog log, long start, long end) {
        Iterator<TierLogSegment> tieredSegments = log.tieredLogSegments(start, end);
        HashSet abortedTxnSet = new HashSet();
        tieredSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            List<AbortedTxn> abortedTransactions = TierLogCompactionUtils$.MODULE$.fetchAbortedTransactions($this.tierObjectStore, (TierLogSegment)segment, $this.ctx, $this.retryPolicy);
            return (HashSet)abortedTxnSet.$plus$plus$eq(abortedTransactions);
        });
        return abortedTxnSet.toList();
    }

    public static final /* synthetic */ String $anonfun$doTierClean$9(TopicIdPartition topicIdPartition$6, ListBuffer segmentsUsed$1, Queue tieredSegments$1) {
        return new StringBuilder(55).append("Cleaning ").append(topicIdPartition$6).append(", after cleanSegments we have used ").append(segmentsUsed$1).append(" with ").append(tieredSegments$1).append(" left").toString();
    }

    public static final /* synthetic */ String $anonfun$doTierClean$11(TopicIdPartition topicIdPartition$6, ListBuffer segmentsUsed$1) {
        return new StringBuilder(87).append("Fully deleting all segments for ").append(topicIdPartition$6).append(" due to empty generated segment source source segments ").append(segmentsUsed$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$doTierClean$12(AbortedTransactionMetadata x$14) {
        return x$14.lastRetainedBatchOffset().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$logSegments$2(long from$1, TierLogSegmentReadAdapter x$19) {
        return x$19.endOffset() < from$1;
    }

    public TierCleaner(OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, TierCompactionMetrics tierCompactionMetrics, Time time, TierObjectStore tierObjectStore, TierTopicAppender tierTopicAppender, int leaderEpoch, CancellationContext ctx, Function1<TopicPartition, BoxedUnit> checkDone, TierObjectStoreRetryPolicy retryPolicy) {
        this.tierCompactionMetrics = tierCompactionMetrics;
        this.time = time;
        this.tierObjectStore = tierObjectStore;
        this.tierTopicAppender = tierTopicAppender;
        this.leaderEpoch = leaderEpoch;
        this.ctx = ctx;
        this.checkDone = checkDone;
        this.retryPolicy = retryPolicy;
        super(-1, offsetMap, ioBufferSize, maxIoBufferSize, dupBufferLoadFactor, throttler, time, checkDone, tierCompactionMetrics.cleanerMetrics());
        this.logIdent_$eq(new StringBuilder(14).append("TierCleaner ").append(this.id()).append(": ").toString());
    }
}

