/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Random;
import java.util.concurrent.CancellationException;
import kafka.cluster.Partition;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.ExtendedOffsetMap;
import kafka.log.SkimpyOffsetMap;
import kafka.log.SkimpyOffsetMap$;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.exceptions.TierLogCompactionFencedException$;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreLinearRetry;
import kafka.tier.tasks.CompactionTasksConfig;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.compaction.CompactionTask$;
import kafka.tier.tasks.compaction.TierCleaner;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r5e\u0001\u0002\"D\u00051C\u0001\"\u0017\u0001\u0003\u0006\u0004%\tE\u0017\u0005\tC\u0002\u0011\t\u0011)A\u00057\"A!\r\u0001BC\u0002\u0013\u00053\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003e\u0011!I\u0007A!a\u0001\n\u0003Q\u0007BCB\u001a\u0001\t\u0005\r\u0011\"\u0001\u00046!I1\u0011\b\u0001\u0003\u0002\u0003\u0006Ka\u001b\u0005\u000b\u0003{\u0003!Q1A\u0005\u0002\rm\u0002BCB\u001f\u0001\t\u0005\t\u0015!\u0003\u0002@\"9\u00111\u0001\u0001\u0005\u0002\r}\u0002bBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\n\u0007\u0013\u0002\u0001\u0019!C\u0001\u0007\u0017B\u0011ba\u0014\u0001\u0001\u0004%\ta!\u0015\t\u0011\rU\u0003\u0001)Q\u0005\u0007\u001bB\u0011ba\u0016\u0001\u0001\u0004%\ta!\u0017\t\u0013\ru\u0003\u00011A\u0005\u0002\r}\u0003\u0002CB2\u0001\u0001\u0006Kaa\u0017\t\u000f\r5\u0004\u0001\"\u0001\u0004p!9\u0011\u0011\f\u0001\u0005B\r]\u0004b\u0002B:\u0001\u0011\u0005#QO\u0004\u0006q\u000eC\t!\u001f\u0004\u0006\u0005\u000eC\tA\u001f\u0005\b\u0003\u00071B\u0011AA\u0003\u0011\u001d\t9A\u0006C)\u0003\u0013A\u0011\"a\u0007\u0017\u0005\u0004%\t!!\b\t\u0011\u0005\u0015b\u0003)A\u0005\u0003?A\u0011\"a\n\u0017\u0005\u0004%\t!!\b\t\u0011\u0005%b\u0003)A\u0005\u0003?A\u0011\"a\u000b\u0017\u0005\u0004%\t!!\f\t\u0011\u0005mb\u0003)A\u0005\u0003_1!\"!\u0010\u0017!\u0003\r\ncQA \u0011\u001d\t\te\bD\u0001\u0003;Aq!a\u0011 \r\u0003\t)\u0005C\u0004\u0002Z}1\t!a\u0017\u0007\r\u0005\rh\u0003QAs\u0011)\t\te\tBK\u0002\u0013\u0005\u0011Q\u0004\u0005\u000b\u0003g\u001c#\u0011#Q\u0001\n\u0005}\u0001BCA{G\tU\r\u0011\"\u0001\u0002x\"Q\u0011\u0011`\u0012\u0003\u0012\u0003\u0006I!a\u0012\t\u000f\u0005\r1\u0005\"\u0001\u0002|\"9\u00111I\u0012\u0005B\u0005\u0015\u0003bBA-G\u0011\u0005#1\u0001\u0005\b\u00057\u0019C\u0011\u0001B\u000f\u0011\u001d\u0011id\tC\u0005\u0005\u007fAqA!\u0015$\t\u0003\u0011\u0019\u0006C\u0004\u0003t\r\"\tE!\u001e\t\u0013\t]4%!A\u0005\u0002\te\u0004\"\u0003B@GE\u0005I\u0011\u0001BA\u0011%\u00119jII\u0001\n\u0003\u0011I\nC\u0005\u0003\u001e\u000e\n\t\u0011\"\u0011\u0003 \"I!qV\u0012\u0002\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0005c\u001b\u0013\u0011!C\u0001\u0005gC\u0011Ba0$\u0003\u0003%\tE!1\t\u0013\t=7%!A\u0005\u0002\tE\u0007\"\u0003BkG\u0005\u0005I\u0011\tBl\u0011%\u0011InIA\u0001\n\u0003\u0012YnB\u0005\u0003`Z\t\t\u0011#\u0001\u0003b\u001aI\u00111\u001d\f\u0002\u0002#\u0005!1\u001d\u0005\b\u0003\u0007QD\u0011\u0001By\u0011%\u0011\u0019HOA\u0001\n\u000b\u0012\u0019\u0010C\u0005\u0003vj\n\t\u0011\"!\u0003x\"I!Q \u001e\u0002\u0002\u0013\u0005%q \u0005\n\u0007\u001bQ\u0014\u0011!C\u0005\u0007\u001fAqaa\u0006\u0017\t\u0003\u0019I\u0002C\u0004\u0004*Y!Iaa\u000b\u0003\u001d\r{W\u000e]1di&|g\u000eV1tW*\u0011A)R\u0001\u000bG>l\u0007/Y2uS>t'B\u0001$H\u0003\u0015!\u0018m]6t\u0015\tA\u0015*\u0001\u0003uS\u0016\u0014(\"\u0001&\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!T*\u0011\u00079{\u0015+D\u0001F\u0013\t\u0001VI\u0001\u0005US\u0016\u0014H+Y:l!\t\u0011\u0006!D\u0001D!\t!v+D\u0001V\u0015\t1\u0016*A\u0003vi&d7/\u0003\u0002Y+\n9Aj\\4hS:<\u0017aA2uqV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_\u000f\u00069a-\u001a;dQ\u0016\u0014\u0018B\u00011^\u0005M\u0019\u0015M\\2fY2\fG/[8o\u0007>tG/\u001a=u\u0003\u0011\u0019G\u000f\u001f\u0011\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>tW#\u00013\u0011\u0005\u00154W\"A$\n\u0005\u001d<%\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003E!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0006gR\fG/Z\u000b\u0002WB\u0011An\b\b\u0003[Vq!A\\<\u000f\u0005=4hB\u00019v\u001d\t\tH/D\u0001s\u0015\t\u00198*\u0001\u0004=e>|GOP\u0005\u0002\u0015&\u0011\u0001*S\u0005\u0003\r\u001eK!\u0001R#\u0002\u001d\r{W\u000e]1di&|g\u000eV1tWB\u0011!KF\n\u0004-m\u001c\u0006C\u0001?\u0000\u001b\u0005i(\"\u0001@\u0002\u000bM\u001c\u0017\r\\1\n\u0007\u0005\u0005QP\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\f!\u0002\\8hO\u0016\u0014h*Y7f+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005Ua\u0002BA\b\u0003#\u0001\"!]?\n\u0007\u0005MQ0\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'i\u0018\u0001\u0006#fM\u0006,H\u000e^'bqJ+GO]=D_VtG/\u0006\u0002\u0002 A\u0019A0!\t\n\u0007\u0005\rRPA\u0002J]R\fQ\u0003R3gCVdG/T1y%\u0016$(/_\"pk:$\b%\u0001\rEK\u001a\fW\u000f\u001c;SKR\u0014\u00180\u00138uKJ4\u0018\r\\%o\u001bN\f\u0011\u0004R3gCVdGOU3uefLe\u000e^3sm\u0006d\u0017J\\'tA\u0005\u0011B)\u001a4bk2$(+\u001a;ssB{G.[2z+\t\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)dR\u0001\u0006gR|'/Z\u0005\u0005\u0003s\t\u0019D\u0001\u000eUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0019&tW-\u0019:SKR\u0014\u00180A\nEK\u001a\fW\u000f\u001c;SKR\u0014\u0018\u0010U8mS\u000eL\bEA\nD_6\u0004\u0018m\u0019;j_:$\u0016m]6Ti\u0006$Xm\u0005\u0002 w\u0006YA.Z1eKJ,\u0005o\\2i\u00031\u0019G.Z1oKJ\u001cF/\u0019;t)\t\t9\u0005E\u0003}\u0003\u0013\ni%C\u0002\u0002Lu\u0014aa\u00149uS>t\u0007\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0013*A\u0002m_\u001eLA!a\u0016\u0002R\ta1\t\\3b]\u0016\u00148\u000b^1ug\u0006QAO]1og&$\u0018n\u001c8\u0015)\u0005u\u0013\u0011PA>\u0003{\ni)!(\u0002(\u0006E\u00161XAc)\u0011\ty&a\u001c\u0011\r\u0005\u0005\u0014qMA6\u001b\t\t\u0019GC\u0002\u0002fu\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\tI'a\u0019\u0003\r\u0019+H/\u001e:f!\r\tigH\u0007\u0002-!9\u0011\u0011\u000f\u0012A\u0004\u0005M\u0014AA3d!\u0011\t\t'!\u001e\n\t\u0005]\u00141\r\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQ!\u0017\u0012A\u0002mCQA\u0019\u0012A\u0002\u0011Dq!a #\u0001\u0004\t\t)\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"J\u0003\u0019\u0019XM\u001d<fe&!\u00111RAC\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!a$#\u0001\u0004\t\t*A\tuS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJ\u0004B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0004\u0003/;\u0015!\u0002;pa&\u001c\u0017\u0002BAN\u0003+\u0013\u0011\u0003V5feR{\u0007/[2BaB,g\u000eZ3s\u0011\u001d\tyJ\ta\u0001\u0003C\u000bq\u0002^5fe>\u0013'.Z2u'R|'/\u001a\t\u0005\u0003c\t\u0019+\u0003\u0003\u0002&\u0006M\"a\u0004+jKJ|%M[3diN#xN]3\t\u000f\u0005%&\u00051\u0001\u0002,\u000611m\u001c8gS\u001e\u00042ATAW\u0013\r\ty+\u0012\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\"9\u00111\u0017\u0012A\u0002\u0005U\u0016!\u0003;ie>$H\u000f\\3s!\r!\u0016qW\u0005\u0004\u0003s+&!\u0003+ie>$H\u000f\\3s\u0011\u001d\tiL\ta\u0001\u0003\u007f\u000bQ\u0003^5fe\u000e{W\u000e]1di&|g.T3ue&\u001c7\u000fE\u0002S\u0003\u0003L1!a1D\u0005U!\u0016.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGNDq!a2#\u0001\u0004\tI-\u0001\u0003uS6,\u0007\u0003BAf\u0003;l!!!4\u000b\u0007Y\u000byM\u0003\u0003\u0002R\u0006M\u0017AB2p[6|gNC\u0002K\u0003+TA!a6\u0002Z\u00061\u0011\r]1dQ\u0016T!!a7\u0002\u0007=\u0014x-\u0003\u0003\u0002`\u00065'\u0001\u0002+j[\u0016L#aH\u0012\u0003\u0011\rcW-\u00198M_\u001e\u001c\u0002bI>\u0002l\u0005\u001d\u0018Q\u001e\t\u0004y\u0006%\u0018bAAv{\n9\u0001K]8ek\u000e$\bc\u0001?\u0002p&\u0019\u0011\u0011_?\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u00191,\u0017\rZ3s\u000bB|7\r\u001b\u0011\u0002\u00131\f7\u000f^*uCR\u001cXCAA$\u0003)a\u0017m\u001d;Ti\u0006$8\u000f\t\u000b\u0007\u0003{\fyP!\u0001\u0011\u0007\u000554\u0005C\u0004\u0002B!\u0002\r!a\b\t\u000f\u0005U\b\u00061\u0001\u0002HQ!\"Q\u0001B\u0005\u0005\u0017\u0011iAa\u0004\u0003\u0012\tM!Q\u0003B\f\u00053!B!a\u0018\u0003\b!9\u0011\u0011\u000f\u0016A\u0004\u0005M\u0004\"B-+\u0001\u0004Y\u0006\"\u00022+\u0001\u0004!\u0007bBA@U\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003\u001fS\u0003\u0019AAI\u0011\u001d\tyJ\u000ba\u0001\u0003CCq!!++\u0001\u0004\tY\u000bC\u0004\u00024*\u0002\r!!.\t\u000f\u0005u&\u00061\u0001\u0002@\"9\u0011q\u0019\u0016A\u0002\u0005%\u0017A\u00033p\u00072,\u0017M\u001c'pOR1\"q\u0004B\u0012\u0005K\u00119C!\u000b\u0003,\t5\"Q\u0007B\u001c\u0005s\u0011Y\u0004\u0006\u0003\u0002`\t\u0005\u0002bBA9W\u0001\u000f\u00111\u000f\u0005\u00063.\u0002\ra\u0017\u0005\b\u0003\u001f[\u0003\u0019AAI\u0011\u001d\t\te\u000ba\u0001\u0003?AQAY\u0016A\u0002\u0011Dq!a ,\u0001\u0004\t\t\tC\u0004\u0002*.\u0002\rAa\f\u0011\u00079\u0013\t$C\u0002\u00034\u0015\u0013QcQ8na\u0006\u001cG/[8o)\u0006\u001c8n]\"p]\u001aLw\rC\u0004\u0002 .\u0002\r!!)\t\u000f\u0005u6\u00061\u0001\u0002@\"9\u00111W\u0016A\u0002\u0005U\u0006bBAdW\u0001\u0007\u0011\u0011Z\u0001!g\"|W\u000f\u001c3E_\u0012+\u0018\r\\\"p[B\f7\r^5p]Z\u000bG.\u001b3bi&|g\u000e\u0006\u0004\u0003B\t\u001d#q\n\t\u0004y\n\r\u0013b\u0001B#{\n9!i\\8mK\u0006t\u0007bBA*Y\u0001\u0007!\u0011\n\t\u0005\u0003\u001f\u0012Y%\u0003\u0003\u0003N\u0005E#aC!cgR\u0014\u0018m\u0019;M_\u001eDq!!+-\u0001\u0004\u0011y#A\u0006sK\u000e|'\u000fZ*uCR\u001cH\u0003\u0004B+\u00057\u0012yF!\u0019\u0003l\t=\u0004c\u0001?\u0003X%\u0019!\u0011L?\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005;j\u0003\u0019AA\u0006\u0003\u0011!\u0018m]6\t\u000b\tl\u0003\u0019\u00013\t\u000f\t\rT\u00061\u0001\u0003f\u0005!aM]8n!\ra(qM\u0005\u0004\u0005Sj(\u0001\u0002'p]\u001eDqA!\u001c.\u0001\u0004\u0011)'\u0001\u0002u_\"9!\u0011O\u0017A\u0002\u00055\u0013!B:uCR\u001c\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0011\u0001B2paf$b!!@\u0003|\tu\u0004\"CA!_A\u0005\t\u0019AA\u0010\u0011%\t)p\fI\u0001\u0002\u0004\t9%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\r%\u0006BA\u0010\u0005\u000b[#Aa\"\u0011\t\t%%1S\u0007\u0003\u0005\u0017SAA!$\u0003\u0010\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005#k\u0018AC1o]>$\u0018\r^5p]&!!Q\u0013BF\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YJ\u000b\u0003\u0002H\t\u0015\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\"B!!1\u0015BW\u001b\t\u0011)K\u0003\u0003\u0003(\n%\u0016\u0001\u00027b]\u001eT!Aa+\u0002\t)\fg/Y\u0005\u0005\u0003/\u0011)+\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tU&1\u0018\t\u0004y\n]\u0016b\u0001B]{\n\u0019\u0011I\\=\t\u0013\tuF'!AA\u0002\u0005}\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003DB1!Q\u0019Bf\u0005kk!Aa2\u000b\u0007\t%W0\u0001\u0006d_2dWm\u0019;j_:LAA!4\u0003H\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\tEa5\t\u0013\tuf'!AA\u0002\tU\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005}\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0003B\tu\u0007\"\u0003B_q\u0005\u0005\t\u0019\u0001B[\u0003!\u0019E.Z1o\u0019><\u0007cAA7uM)!H!:\u0002nBQ!q\u001dBw\u0003?\t9%!@\u000e\u0005\t%(b\u0001Bv{\u00069!/\u001e8uS6,\u0017\u0002\u0002Bx\u0005S\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011\t\u000f\u0006\u0002\u0003\"\u0006)\u0011\r\u001d9msR1\u0011Q B}\u0005wDq!!\u0011>\u0001\u0004\ty\u0002C\u0004\u0002vv\u0002\r!a\u0012\u0002\u000fUt\u0017\r\u001d9msR!1\u0011AB\u0005!\u0015a\u0018\u0011JB\u0002!\u001da8QAA\u0010\u0003\u000fJ1aa\u0002~\u0005\u0019!V\u000f\u001d7fe!I11\u0002 \u0002\u0002\u0003\u0007\u0011Q`\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\u0005\u0011\t\t\r61C\u0005\u0005\u0007+\u0011)K\u0001\u0004PE*,7\r^\u0001\u0012O\u0016$H+[3s\u0019><Gk\\\"mK\u0006tG\u0003CB\u000e\u0007C\u0019\u0019c!\n\u0011\u0007I\u001bi\"C\u0002\u0004 \r\u0013a\u0002V5fe2{w\rV8DY\u0016\fg\u000eC\u0004\u0002T\u0001\u0003\rA!\u0013\t\u000f\u0005\u001d\u0007\t1\u0001\u0002J\"91q\u0005!A\u0002\t\u0015\u0014a\u00018po\u0006QA-\u001b:usJ\u000bgnZ3\u0015\r\r52qFB\u0019!\u001da8Q\u0001B3\u0005KBq!a\u0015B\u0001\u0004\u0011I\u0005C\u0004\u0004(\u0005\u0003\rA!\u001a\u0002\u0013M$\u0018\r^3`I\u0015\fH\u0003\u0002B+\u0007oA\u0001B!0\u0007\u0003\u0003\u0005\ra[\u0001\u0007gR\fG/\u001a\u0011\u0016\u0005\u0005}\u0016A\u0006;jKJ\u001cu.\u001c9bGRLwN\\'fiJL7m\u001d\u0011\u0015\u0013E\u001b\tea\u0011\u0004F\r\u001d\u0003\"B-\u000b\u0001\u0004Y\u0006\"\u00022\u000b\u0001\u0004!\u0007\"B5\u000b\u0001\u0004Y\u0007bBA_\u0015\u0001\u0007\u0011qX\u0001\u0010Y\u0006\u001cH\u000f\u0015:pG\u0016\u001c8/\u001a3NgV\u00111Q\n\t\u0006y\u0006%#QM\u0001\u0014Y\u0006\u001cH\u000f\u0015:pG\u0016\u001c8/\u001a3Ng~#S-\u001d\u000b\u0005\u0005+\u001a\u0019\u0006C\u0005\u0003>6\t\t\u00111\u0001\u0004N\u0005\u0001B.Y:u!J|7-Z:tK\u0012l5\u000fI\u0001\u000bY><Gk\\\"mK\u0006tWCAB.!\u0015a\u0018\u0011JB\u000e\u00039awn\u001a+p\u00072,\u0017M\\0%KF$BA!\u0016\u0004b!I!Q\u0018\t\u0002\u0002\u0003\u000711L\u0001\fY><Gk\\\"mK\u0006t\u0007\u0005K\u0002\u0012\u0007O\u00022\u0001`B5\u0013\r\u0019Y' \u0002\tm>d\u0017\r^5mK\u0006)R.Y=cKV\u0003H-\u0019;f\u0019><Gk\\\"mK\u0006tGCBB.\u0007c\u001a\u0019\bC\u0004\u0002\u0000I\u0001\r!!!\t\u000f\rU$\u00031\u0001\u0003f\u0005Ian\\<NS2d\u0017n\u001d\u000b\u000f\u0007s\u001ayh!!\u0004\u0004\u000e\u00155qQBE)\u0011\u0019Yh! \u0011\u000b\u0005\u0005\u0014qM)\t\u000f\u0005E4\u0003q\u0001\u0002t!9\u0011qY\nA\u0002\u0005%\u0007bBAH'\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003?\u001b\u0002\u0019AAQ\u0011\u001d\tyh\u0005a\u0001\u0003\u0003Cq!!+\u0014\u0001\u0004\tY\u000bC\u0004\u00024N\u0001\raa#\u0011\u000bq\fI%!.")
public final class CompactionTask
extends TierTask<CompactionTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private CompactionTaskState state;
    private final TierCompactionMetrics tierCompactionMetrics;
    private Option<Object> lastProcessedMs;
    private volatile Option<TierLogToClean> logToClean;

    public static TierLogToClean getTierLogToClean(AbstractLog abstractLog, Time time, long l) {
        return CompactionTask$.MODULE$.getTierLogToClean(abstractLog, time, l);
    }

    public static TierObjectStoreLinearRetry DefaultRetryPolicy() {
        return CompactionTask$.MODULE$.DefaultRetryPolicy();
    }

    public static int DefaultRetryIntervalInMs() {
        return CompactionTask$.MODULE$.DefaultRetryIntervalInMs();
    }

    public static int DefaultMaxRetryCount() {
        return CompactionTask$.MODULE$.DefaultMaxRetryCount();
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public CompactionTaskState state() {
        return this.state;
    }

    public void state_$eq(CompactionTaskState x$1) {
        this.state = x$1;
    }

    public TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public Option<Object> lastProcessedMs() {
        return this.lastProcessedMs;
    }

    public void lastProcessedMs_$eq(Option<Object> x$1) {
        this.lastProcessedMs = x$1;
    }

    public Option<TierLogToClean> logToClean() {
        return this.logToClean;
    }

    public void logToClean_$eq(Option<TierLogToClean> x$1) {
        this.logToClean = x$1;
    }

    public Option<TierLogToClean> maybeUpdateLogToClean(ReplicaManager replicaManager, long nowMillis) {
        Object object = this.state() instanceof CleanLog ? replicaManager.getLog(this.topicPartition()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isTierCompactable())) : None$.MODULE$;
        Option updatedNextLogToClean = object.flatMap((Function1 & Serializable & scala.Serializable)log -> {
            if (this.logToClean().isEmpty() || this.logToClean().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.stale(log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch())))) {
                return new Some((Object)CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, replicaManager.time(), nowMillis));
            }
            return this.logToClean();
        });
        this.logToClean_$eq((Option<TierLogToClean>)updatedNextLogToClean);
        return updatedNextLogToClean;
    }

    @Override
    public Future<CompactionTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, Option<Throttler> throttler, ExecutionContext ec) {
        long nowMs = time.hiResClockMs();
        return (this.ctx().isCancelled() ? Future$.MODULE$.successful((Object)this.state()) : this.state().transition(this.ctx(), this.topicIdPartition(), replicaManager, tierTopicAppender, tierObjectStore, config, (Throttler)throttler.get(), this.tierCompactionMetrics(), time, ec)).map((Function1 & Serializable & scala.Serializable)result -> {
            this.onSuccessfulTransition();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(CompactionTask.$anonfun$transition$2(this, result)));
            }
            this.lastProcessedMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)nowMs)));
            this.state_$eq((CompactionTaskState)result);
            return this;
        }, ec).recover((PartialFunction)new scala.Serializable(this, config, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactionTask $outer;
            private final TierTasksConfig config$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierMetadataRetriableException));
                    object = this.$outer;
                } else if (x1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierObjectStoreRetriableException));
                    object = this.$outer;
                } else if (x1 instanceof LogCleaningAbortedException) {
                    LogCleaningAbortedException logCleaningAbortedException = (LogCleaningAbortedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$1(this)), (Throwable)$anonfun$transition$3.$anonfun$applyOrElse$2(logCleaningAbortedException));
                    }
                    object = this.$outer;
                } else if (x1 instanceof TierLogCompactionFencedException) {
                    TierLogCompactionFencedException tierLogCompactionFencedException = (TierLogCompactionFencedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$3(this)), (Throwable)$anonfun$transition$3.$anonfun$applyOrElse$4(tierLogCompactionFencedException));
                    }
                    this.$outer.ctx().cancel();
                    object = this.$outer;
                } else if (x1 instanceof CancellationException) {
                    CancellationException cancellationException = (CancellationException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$5(this)), (Throwable)$anonfun$transition$3.$anonfun$applyOrElse$6(cancellationException));
                    }
                    this.$outer.ctx().cancel();
                    object = this.$outer;
                } else if (x1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$7(this)), (Throwable)$anonfun$transition$3.$anonfun$applyOrElse$8(notTierablePartitionException));
                    }
                    this.$outer.ctx().cancel();
                    object = this.$outer;
                } else if (x1 != null) {
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask error_this = compactionTask;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$9(this)), $anonfun$transition$3.$anonfun$applyOrElse$10(x1));
                    }
                    this.$outer.cancelAndSetErrorState(x1);
                    object = this.$outer;
                } else {
                    object = function1.apply(null);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = x1 instanceof TierMetadataRetriableException ? true : (x1 instanceof TierObjectStoreRetriableException ? true : (x1 instanceof LogCleaningAbortedException ? true : (x1 instanceof TierLogCompactionFencedException ? true : (x1 instanceof CancellationException ? true : (x1 instanceof NotTierablePartitionException ? true : x1 != null)))));
                return bl;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$transition$3 $this) {
                return new StringBuilder(35).append($this.$outer.topicIdPartition()).append(": compaction operation was aborted.").toString();
            }

            public static final /* synthetic */ LogCleaningAbortedException $anonfun$applyOrElse$2(LogCleaningAbortedException x4$1) {
                return x4$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$3($anonfun$transition$3 $this) {
                return new StringBuilder(40).append($this.$outer.topicIdPartition()).append(" was fenced, stopping compaction process").toString();
            }

            public static final /* synthetic */ TierLogCompactionFencedException $anonfun$applyOrElse$4(TierLogCompactionFencedException x5$1) {
                return x5$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$5($anonfun$transition$3 $this) {
                return new StringBuilder(64).append($this.$outer.topicIdPartition()).append(" was fenced by cancellation context, stopping compaction process").toString();
            }

            public static final /* synthetic */ CancellationException $anonfun$applyOrElse$6(CancellationException x6$1) {
                return x6$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$7($anonfun$transition$3 $this) {
                return new StringBuilder(47).append($this.$outer.topicIdPartition()).append(" is not tierable and cannot use tier compaction").toString();
            }

            public static final /* synthetic */ NotTierablePartitionException $anonfun$applyOrElse$8(NotTierablePartitionException x7$1) {
                return x7$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$9($anonfun$transition$3 $this) {
                return new StringBuilder(67).append($this.$outer.topicIdPartition()).append(": unhandled exception in CompactionTask. Moving task to error state").toString();
            }

            public static final /* synthetic */ Throwable $anonfun$applyOrElse$10(Throwable x8$1) {
                return x8$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.time$1 = time$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$2(kafka.common.LogCleaningAbortedException ), $anonfun$applyOrElse$3(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$4(kafka.tier.exceptions.TierLogCompactionFencedException ), $anonfun$applyOrElse$5(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$6(java.util.concurrent.CancellationException ), $anonfun$applyOrElse$7(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$8(kafka.tier.exceptions.NotTierablePartitionException ), $anonfun$applyOrElse$9(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$10(java.lang.Throwable )}, serializedLambda);
            }
        }, ec);
    }

    public String toString() {
        return new StringBuilder(36).append("CompactionTask(").append(this.topicIdPartition()).append(", state=").append(this.state().getClass().getName()).append(", cancelled=").append(this.ctx().isCancelled()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$transition$2(CompactionTask $this, CompactionTaskState result$1) {
        return new StringBuilder(23).append("Transitioned ").append($this.topicIdPartition()).append(" from ").append($this.state()).append(" to ").append(result$1).toString();
    }

    public CompactionTask(CancellationContext ctx, TopicIdPartition topicIdPartition, CompactionTaskState state, TierCompactionMetrics tierCompactionMetrics) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.state = state;
        this.tierCompactionMetrics = tierCompactionMetrics;
        super(tierCompactionMetrics.retryRateOpt());
        this.lastProcessedMs = None$.MODULE$;
        this.logToClean = None$.MODULE$;
    }

    public static class CleanLog
    implements CompactionTaskState,
    Product,
    scala.Serializable {
        private final int leaderEpoch;
        private final Option<CleanerStats> lastStats;

        @Override
        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public Option<CleanerStats> lastStats() {
            return this.lastStats;
        }

        @Override
        public Option<CleanerStats> cleanerStats() {
            return this.lastStats();
        }

        @Override
        public Future<CompactionTaskState> transition(CancellationContext ctx, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, TierTasksConfig config, Throttler throttler, TierCompactionMetrics tierCompactionMetrics, Time time, ExecutionContext ec) {
            CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
            if (compactionTask$ == null) {
                throw null;
            }
            CompactionTask$ info_this = compactionTask$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(info_this.msgWithLogIdent(CleanLog.$anonfun$transition$4(topicIdPartition)));
            }
            if (config.compactionTaskConfig().isEmpty()) {
                throw new IllegalArgumentException("Compaction task config was unexpectedly empty");
            }
            return this.doCleanLog(ctx, tierTopicAppender, this.leaderEpoch(), topicIdPartition, replicaManager, (CompactionTasksConfig)config.compactionTaskConfig().get(), tierObjectStore, tierCompactionMetrics, throttler, time, ec).map((Function1 & Serializable & scala.Serializable)state -> {
                CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                if (compactionTask$ == null) {
                    throw null;
                }
                CompactionTask$ info_this = compactionTask$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(CleanLog.$anonfun$transition$6(topicIdPartition)));
                }
                return state;
            }, ec);
        }

        public Future<CompactionTaskState> doCleanLog(CancellationContext ctx, TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, CompactionTasksConfig config, TierObjectStore tierObjectStore, TierCompactionMetrics tierCompactionMetrics, Throttler throttler, Time time, ExecutionContext ec) {
            return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
                if (either instanceof Left) {
                    Errors error = (Errors)((Left)either).value();
                    throw new TierLogCompactionFencedException(topicIdPartition, (Throwable)error.exception());
                }
                if (!(either instanceof Right)) {
                    throw new MatchError(either);
                }
                Partition partition = (Partition)((Right)either).value();
                CompactionTaskState compactionTaskState = (CompactionTaskState)partition.log().map((Function1 & Serializable & scala.Serializable)log -> {
                    int tierEpoch = log.tierPartitionState().tierEpoch();
                    if (tierEpoch > leaderEpoch) {
                        throw new TierLogCompactionFencedException(topicIdPartition, TierLogCompactionFencedException$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (tierEpoch < leaderEpoch) {
                        throw new TierMetadataRetriableException(new StringBuilder(45).append("Leadership not established for ").append(topicIdPartition).append(". Backing off.").toString());
                    }
                    if (partition.isUncleanLeader()) {
                        throw new TierMetadataRetriableException(new StringBuilder(49).append(topicIdPartition).append(" undergoing unclean leader recovery. Backing off.").toString());
                    }
                    if (log.isTierMetadataStateRecovering()) {
                        throw new TierMetadataRetriableException(new StringBuilder(48).append(topicIdPartition).append(" undergoing tier metadata recovery. Backing off.").toString());
                    }
                    if (log.isFrozenLogStartOffsetState()) {
                        throw new TierMetadataRetriableException(new StringBuilder(46).append(topicIdPartition).append(" undergoing tiered data recovery. Backing off.").toString());
                    }
                    Some stats = this.lastStats();
                    if (!log.isTierCompactable()) {
                        CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                        if (compactionTask$ == null) {
                            throw null;
                        }
                        CompactionTask$ warn_this = compactionTask$;
                        if (warn_this.logger().underlying().isWarnEnabled()) {
                            warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$3(topicIdPartition)));
                        }
                    } else {
                        void var33_39;
                        void var31_38;
                        Tuple2<Object, CleanerStats> tuple2;
                        if (log.tieredLogSegments().isEmpty()) {
                            CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                            if (compactionTask$ == null) {
                                throw null;
                            }
                            CompactionTask$ warn_this = compactionTask$;
                            if (warn_this.logger().underlying().isWarnEnabled()) {
                                warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$4(topicIdPartition)));
                            }
                            throw new TierMetadataRetriableException(new StringBuilder(60).append("Log for ").append(topicIdPartition).append(" has no eligible tiered segments for tier compaction").toString());
                        }
                        SkimpyOffsetMap offsetMap = new SkimpyOffsetMap(config.skimpyOffsetMapMemory(), SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
                        TierLogToClean cleanable = CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, time, time.milliseconds());
                        Function1 & Serializable & scala.Serializable checkDone = (Function1 & Serializable & scala.Serializable)x$3 -> {
                            CleanLog.$anonfun$doCleanLog$5(ctx, x$3);
                            return BoxedUnit.UNIT;
                        };
                        TierObjectStoreLinearRetry retryPolicy = CompactionTask$.MODULE$.DefaultRetryPolicy();
                        TierCleaner cleaner = new TierCleaner(offsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, tierCompactionMetrics, time, tierObjectStore, tierTopicAppender, leaderEpoch, ctx, (Function1<TopicPartition, BoxedUnit>)checkDone, retryPolicy);
                        Option<Object> lockedOffset = log.lockOffsetFromDeletion();
                        if (lockedOffset.isEmpty()) {
                            CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                            if (compactionTask$ == null) {
                                throw null;
                            }
                            CompactionTask$ warn_this = compactionTask$;
                            if (warn_this.logger().underlying().isWarnEnabled()) {
                                warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$6(topicIdPartition)));
                            }
                            throw new LogCleaningAbortedException();
                        }
                        cleanable.firstCleanableOffset_$eq(BoxesRunTime.unboxToLong((Object)lockedOffset.get()));
                        try {
                            long tierEndOffset = log.tierPartitionState().endOffset();
                            if (this.shouldDoDualCompactionValidation((AbstractLog)log, config) && cleanable.firstCleanableOffset() >= log.localLogStartOffset() && cleanable.firstCleanableOffset() <= tierEndOffset && log.tierableLogSegments().isEmpty()) {
                                void var28_30;
                                CleanerStats stats2;
                                CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                                if (compactionTask$ == null) {
                                    throw null;
                                }
                                CompactionTask$ info_this = compactionTask$;
                                if (info_this.logger().underlying().isInfoEnabled()) {
                                    info_this.logger().underlying().info(info_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$7(topicIdPartition, cleanable, tierEndOffset)));
                                }
                                SkimpyOffsetMap localOffsetMap = new SkimpyOffsetMap(config.skimpyOffsetMapMemory(), SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
                                ExtendedOffsetMap baseOffsetMap = new ExtendedOffsetMap(localOffsetMap);
                                Cleaner localCleaner = new Cleaner(-1, localOffsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, time, (Function1<TopicPartition, BoxedUnit>)checkDone, tierCompactionMetrics.cleanerMetrics());
                                Tuple2 tuple22 = CleanLog.liftedTree1$1(localCleaner, log, cleanable, tierEndOffset, baseOffsetMap, stats2 = new CleanerStats(time, tierCompactionMetrics.cleanerMetrics()), localOffsetMap);
                                if (tuple22 == null) {
                                    throw new MatchError(null);
                                }
                                boolean offsetMapSuccess = tuple22._1$mcZ$sp();
                                String failReason = (String)tuple22._2();
                                if (var28_30 == false) {
                                    CompactionTask$ compactionTask$2 = CompactionTask$.MODULE$;
                                    if (compactionTask$2 == null) {
                                        throw null;
                                    }
                                    CompactionTask$ warn_this = compactionTask$2;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        void var29_31;
                                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$8(log, (String)var29_31)));
                                    }
                                    stats2.validationAborted();
                                } else if (log.tierPartitionState().endOffset() != tierEndOffset) {
                                    CompactionTask$ compactionTask$3 = CompactionTask$.MODULE$;
                                    if (compactionTask$3 == null) {
                                        throw null;
                                    }
                                    CompactionTask$ warn_this = compactionTask$3;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$9(log, tierEndOffset)));
                                    }
                                    stats2.validationAborted();
                                } else if (!cleaner.validateLog((AbstractLog)log, cleanable.firstCleanableOffset(), tierEndOffset + 1L, baseOffsetMap, stats2)) {
                                    CompactionTask$ compactionTask$4 = CompactionTask$.MODULE$;
                                    if (compactionTask$4 == null) {
                                        throw null;
                                    }
                                    CompactionTask$ warn_this = compactionTask$4;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$10(log)));
                                    }
                                    stats2.validationFailed();
                                } else {
                                    CompactionTask$ compactionTask$5 = CompactionTask$.MODULE$;
                                    if (compactionTask$5 == null) {
                                        throw null;
                                    }
                                    CompactionTask$ info_this2 = compactionTask$5;
                                    if (info_this2.logger().underlying().isInfoEnabled()) {
                                        info_this2.logger().underlying().info(info_this2.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$11(topicIdPartition)));
                                    }
                                    stats2.validationPassed();
                                }
                            }
                            tuple2 = cleaner.clean(cleanable);
                        }
                        finally {
                            log.unlockOffsetFromDeletion(cleanable.firstCleanableOffset());
                        }
                        Tuple2<Object, CleanerStats> tuple23 = tuple2;
                        if (tuple23 == null) {
                            throw new MatchError(null);
                        }
                        long nextDirtyOffset = tuple23._1$mcJ$sp();
                        CleanerStats cleanerStats = (CleanerStats)tuple23._2();
                        if (var31_38 != -1L) {
                            this.recordStats(this.toString(), topicIdPartition, cleanable.firstDirtyOffset(), (long)var31_38, (CleanerStats)var33_39);
                        }
                        stats = new Some((Object)var33_39);
                    }
                    return new CleanLog(leaderEpoch, (Option<CleanerStats>)stats);
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this);
                return compactionTaskState;
            }, ec);
        }

        private boolean shouldDoDualCompactionValidation(AbstractLog log, CompactionTasksConfig config) {
            return Predef$.MODULE$.Boolean2boolean(log.config().confluentLogConfig().tierCleanerDualCompaction()) && config.dualCompactionValidationPercent() > 0 && log.tierPartitionState().totalSize() <= config.dualCompactionValidationMaxBytes() && new Random().nextInt(100) < config.dualCompactionValidationPercent();
        }

        public void recordStats(String task, TopicIdPartition topicIdPartition, long from, long to, CleanerStats stats) {
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("Tier Compaction Task: %s cleaned log %s (dirty section = [%d, %d))%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task, topicIdPartition.toString(), BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanLog.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanLog.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanLog.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
            if (compactionTask$ == null) {
                throw null;
            }
            CompactionTask$ info_this = compactionTask$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(info_this.msgWithLogIdent(message));
            }
            if (stats.invalidMessagesRead() > 0L) {
                CompactionTask$ compactionTask$2 = CompactionTask$.MODULE$;
                if (compactionTask$2 == null) {
                    throw null;
                }
                CompactionTask$ warn_this = compactionTask$2;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$recordStats$2(stats)));
                    return;
                }
            }
        }

        public String toString() {
            return new StringBuilder(22).append("CleanLog(leaderEpoch=").append(this.leaderEpoch()).append(")").toString();
        }

        public CleanLog copy(int leaderEpoch, Option<CleanerStats> lastStats) {
            return new CleanLog(leaderEpoch, lastStats);
        }

        public int copy$default$1() {
            return this.leaderEpoch();
        }

        public Option<CleanerStats> copy$default$2() {
            return this.lastStats();
        }

        public String productPrefix() {
            return "CleanLog";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.leaderEpoch());
                }
                case 1: {
                    return this.lastStats();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CleanLog;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.leaderEpoch()), (int)Statics.anyHash(this.lastStats())), (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof CleanLog)) return false;
            boolean bl = true;
            if (!bl) return false;
            CleanLog cleanLog = (CleanLog)x$1;
            if (this.leaderEpoch() != cleanLog.leaderEpoch()) return false;
            Option<CleanerStats> option = this.lastStats();
            Option<CleanerStats> option2 = cleanLog.lastStats();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!cleanLog.canEqual(this)) return false;
            return true;
        }

        public static final /* synthetic */ String $anonfun$transition$4(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(33).append("Starting tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$transition$6(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(34).append("Completed tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$3(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(80).append("Log for ").append(topicIdPartition$2).append(" is not tier compact enabled, but is attempting to clean tiered segments").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$4(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(96).append("Log for ").append(topicIdPartition$2).append(" was scheduled in tier CompactionTask but has no eligible tiered segments for compaction").toString();
        }

        public static final /* synthetic */ void $anonfun$doCleanLog$5(CancellationContext ctx$1, TopicPartition x$3) {
            if (ctx$1.isCancelled()) {
                throw new CancellationException("Operation cancelled");
            }
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$6(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(99).append("Log for ").append(topicIdPartition$2).append(" is still locked by previous compaction round. Abort current operation and will be retried.").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$7(TopicIdPartition topicIdPartition$2, TierLogToClean cleanable$1, long tierEndOffset$1) {
            return new StringBuilder(73).append("Starting dual compaction validation for ").append(topicIdPartition$2).append(" for offset range [").append(cleanable$1.firstCleanableOffset()).append(", end offset=").append(tierEndOffset$1).append("]").toString();
        }

        private static final /* synthetic */ Tuple2 liftedTree1$1(Cleaner localCleaner$1, AbstractLog log$2, TierLogToClean cleanable$1, long tierEndOffset$1, ExtendedOffsetMap baseOffsetMap$1, CleanerStats stats$1, SkimpyOffsetMap localOffsetMap$1) {
            Tuple2 tuple2;
            try {
                if (!localCleaner$1.buildOffsetMap(log$2, cleanable$1.firstCleanableOffset(), tierEndOffset$1 + 1L, baseOffsetMap$1, stats$1)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
                }
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(96).append("offset map is too small for storing all keys in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append("Offset map memory: ").append(localOffsetMap$1.memory()).append(", slots: ").append(localOffsetMap$1.slots()).append(".").toString());
            }
            catch (Throwable e) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(84).append("exception encountered when building offset map for local data in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append(e).toString());
            }
            return tuple2;
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$8(AbstractLog log$2, String failReason$1) {
            return new StringBuilder(39).append("Abort dual compaction validation for ").append(log$2).append(". ").append(failReason$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$9(AbstractLog log$2, long tierEndOffset$1) {
            return new StringBuilder(110).append("Abort dual compaction validation for ").append(log$2).append(" because tierEndOffset changed. old tierEndOffset: ").append(tierEndOffset$1).append(", new tierEndOffset: ").append(log$2.tierPartitionState().endOffset()).append(".").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$10(AbstractLog log$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(log$2).append(" failed").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$11(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(topicIdPartition$2).append(" passed").toString();
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public static final /* synthetic */ String $anonfun$recordStats$2(CleanerStats stats$2) {
            return new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats$2.invalidMessagesRead())}));
        }

        public CleanLog(int leaderEpoch, Option<CleanerStats> lastStats) {
            this.leaderEpoch = leaderEpoch;
            this.lastStats = lastStats;
            Product.$init$((Product)this);
        }
    }

    public static interface CompactionTaskState {
        public int leaderEpoch();

        public Option<CleanerStats> cleanerStats();

        public Future<CompactionTaskState> transition(CancellationContext var1, TopicIdPartition var2, ReplicaManager var3, TierTopicAppender var4, TierObjectStore var5, TierTasksConfig var6, Throttler var7, TierCompactionMetrics var8, Time var9, ExecutionContext var10);
    }
}

