/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AeadConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.CleartextDataKey;
import kafka.tier.store.encryption.EncryptionKeyManager;
import kafka.tier.store.encryption.KeyContext;
import kafka.tier.store.encryption.KeySha;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function3;

public class MockInMemoryTierObjectStore
implements TierObjectStore,
AutoCloseable {
    public static UploadedObject deleteMarker = new UploadedObject(new HashMap(), null, null, new VersionInformation("delete-marker"), System.currentTimeMillis());
    public volatile boolean throwExceptionOnSegmentFetch = false;
    public volatile boolean throwExceptionOnTransactionFetch = false;
    public Function3<String, TierObjectStore.ObjectStoreMetadata, TierObjectStore.FileType, Boolean> throwOnCondition = null;
    private static final ConcurrentHashMap<String, ConcurrentLinkedDeque<UploadedObject>> KEY_TO_BLOB = new ConcurrentHashMap();
    private static final Aead MASTER_KEY;
    private static Map<String, String> wellKnownKeyPathMetadata;
    private final ConcurrentHashMap<TierObjectStore.FileType, Integer> objectCounts = new ConcurrentHashMap();
    private final MockInMemoryTierObjectStoreConfig config;
    private final String keyPrefix;
    private final EncryptionKeyManager encryptionKeyManager;

    public MockInMemoryTierObjectStore(Time time, MockInMemoryTierObjectStoreConfig config) {
        this(time, null, config);
    }

    public MockInMemoryTierObjectStore(Time time, Metrics metrics, MockInMemoryTierObjectStoreConfig config) {
        this.config = config;
        this.keyPrefix = config.prefix;
        this.encryptionKeyManager = new EncryptionKeyManager(time, metrics, MASTER_KEY, Duration.ofSeconds(1L));
        this.encryptionKeyManager.bindHook(new EncryptionKeyManager.WellKnownKeypathHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeWellKnownPathMetadata(Map<String, String> metadata) {
                Aead aead = MASTER_KEY;
                synchronized (aead) {
                    wellKnownKeyPathMetadata = metadata;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, String> fetchWellKnownPathMetadata() {
                Aead aead = MASTER_KEY;
                synchronized (aead) {
                    return wellKnownKeyPathMetadata;
                }
            }
        });
    }

    public List<String> getStoredKeys() {
        return this.getStored().keySet().stream().filter(k -> k.startsWith(this.keyPrefix)).collect(Collectors.toList());
    }

    public ConcurrentHashMap<TierObjectStore.FileType, Integer> getObjectCounts() {
        return this.objectCounts;
    }

    private boolean shouldThrow(String method, TierObjectStore.ObjectStoreMetadata metadata, TierObjectStore.FileType objectFileType) {
        return this.throwOnCondition != null && (Boolean)this.throwOnCondition.apply((Object)method, (Object)metadata, (Object)objectFileType) != false || this.throwExceptionOnSegmentFetch && objectFileType == TierObjectStore.FileType.SEGMENT || this.throwExceptionOnTransactionFetch && objectFileType == TierObjectStore.FileType.TRANSACTION_INDEX;
    }

    public ConcurrentHashMap<String, byte[]> getStored() {
        ConcurrentHashMap<String, byte[]> returnMap = new ConcurrentHashMap<String, byte[]>();
        for (Map.Entry<String, ConcurrentLinkedDeque<UploadedObject>> entry : KEY_TO_BLOB.entrySet()) {
            if (entry.getValue().isEmpty() || entry.getValue().getFirst() == deleteMarker) continue;
            returnMap.put(entry.getKey(), entry.getValue().getFirst().data);
        }
        return returnMap;
    }

    private String generateVersion() {
        byte[] array = new byte[1024];
        new Random().nextBytes(array);
        return new String(array, Charset.forName("UTF-8"));
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return TierObjectStore.Backend.Mock;
    }

    @Override
    public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
        HashMap<String, List<VersionInformation>> blobKeysToVersions = new HashMap<String, List<VersionInformation>>();
        for (Map.Entry<String, ConcurrentLinkedDeque<UploadedObject>> entry : KEY_TO_BLOB.entrySet()) {
            String blobKey = entry.getKey();
            if (!blobKey.startsWith(keyPrefix)) continue;
            ConcurrentLinkedDeque<UploadedObject> uploadedObjects = entry.getValue();
            LinkedList versionInformation = new LinkedList();
            if (getVersionInfo) {
                uploadedObjects.forEach(blobWithMetadata -> versionInformation.add(blobWithMetadata.versionInfo));
                blobKeysToVersions.put(blobKey, versionInformation);
                continue;
            }
            if (uploadedObjects.getFirst().getVersionId().equals("delete-marker")) continue;
            blobKeysToVersions.put(blobKey, versionInformation);
        }
        return blobKeysToVersions;
    }

    @Override
    public TierObjectStoreResponse getObject(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType objectFileType, Integer byteOffset, Integer byteOffsetEnd) throws TierObjectStoreRetriableException {
        if (this.shouldThrow("getObject", objectMetadata, objectFileType)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        String key = this.keyPath(objectMetadata, objectFileType);
        ConcurrentLinkedDeque<UploadedObject> uploadedObjectLinkedList = KEY_TO_BLOB.get(key);
        if (uploadedObjectLinkedList == null || uploadedObjectLinkedList.isEmpty() || uploadedObjectLinkedList.getFirst() == deleteMarker) {
            throw new TierObjectStoreRetriableException(String.format("Key not found: %s", key));
        }
        byte[] blob = uploadedObjectLinkedList.getFirst().data;
        UploadedObject uploadedObject = uploadedObjectLinkedList.getFirst();
        if (objectFileType.equals((Object)TierObjectStore.FileType.SEGMENT)) {
            if (!objectMetadata.opaqueData().equals(TierObjectStore.OpaqueData.ZEROED)) {
                KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
                KeyContext keyContext = this.encryptionKeyManager.keyContext(keySha);
                if (keyContext == null) {
                    KeySha registeredKeySha = this.encryptionKeyManager.registerKeyFromObjectMetadata(uploadedObject.metadata);
                    if (!registeredKeySha.equals(keySha)) {
                        throw new IllegalStateException("key sha does not match");
                    }
                    keyContext = this.encryptionKeyManager.keyContext(registeredKeySha);
                }
                if (!keyContext.cleartextDataKey.equals(uploadedObject.cleartextDataKey)) {
                    throw new IllegalStateException("decryption failed, decrypted data keys do not match");
                }
            } else if (uploadedObject.encrypted()) {
                throw new IllegalStateException("tried to download an encrypted segment without OpaqueData");
            }
        }
        int start = byteOffset == null ? 0 : byteOffset;
        int end = byteOffsetEnd == null ? blob.length : Math.min(byteOffsetEnd, blob.length);
        int byteBufferSize = end - start;
        ByteBuffer buf = ByteBuffer.allocate(byteBufferSize);
        buf.put(blob, start, byteBufferSize);
        buf.flip();
        return new MockInMemoryTierObjectStoreResponse((InputStream)new ByteBufferInputStream(buf));
    }

    @Override
    public TierObjectStore.OpaqueData prepPutSegment() throws TierObjectStoreRetriableException {
        KeySha activeKeySha = this.encryptionKeyManager.activeKeySha();
        if (activeKeySha != null) {
            return TierObjectStore.OpaqueData.fromByteArray(activeKeySha.toRawBytes());
        }
        return TierObjectStore.OpaqueData.ZEROED;
    }

    @Override
    public void close() {
    }

    private void incrementObjectCount(TierObjectStore.FileType fileType) {
        this.objectCounts.compute(fileType, (key, integer) -> integer == null ? 1 : integer + 1);
    }

    @Override
    public void putInMemorySegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<ByteBuffer> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws IOException {
        String segmentKeyPath = this.keyPath(objectMetadata, TierObjectStore.FileType.SEGMENT);
        this.writeSegmentFile(segmentKeyPath, segmentData, objectMetadata.opaqueData());
        if (this.shouldThrow("putSegmentCompacted", objectMetadata, TierObjectStore.FileType.SEGMENT)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        this.incrementObjectCount(TierObjectStore.FileType.SEGMENT);
        this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.OFFSET_INDEX), offsetIndexData);
        this.incrementObjectCount(TierObjectStore.FileType.OFFSET_INDEX);
        this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.TIMESTAMP_INDEX), timestampIndexData);
        this.incrementObjectCount(TierObjectStore.FileType.TIMESTAMP_INDEX);
        producerStateSnapshotData.ifPresent(data -> {
            this.writeBufToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.PRODUCER_STATE), (ByteBuffer)data);
            this.incrementObjectCount(TierObjectStore.FileType.PRODUCER_STATE);
        });
        transactionIndexData.ifPresent(data -> {
            this.writeBufToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.TRANSACTION_INDEX), (ByteBuffer)data);
            this.incrementObjectCount(TierObjectStore.FileType.TRANSACTION_INDEX);
        });
        if (epochState.isPresent()) {
            this.writeBufToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.EPOCH_STATE), epochState.get());
            this.incrementObjectCount(TierObjectStore.FileType.EPOCH_STATE);
        }
    }

    @Override
    public void putSegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws IOException {
        String segmentKeyPath = this.keyPath(objectMetadata, TierObjectStore.FileType.SEGMENT);
        this.writeSegmentFile(segmentKeyPath, segmentData, objectMetadata.opaqueData());
        this.incrementObjectCount(TierObjectStore.FileType.SEGMENT);
        this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.OFFSET_INDEX), offsetIndexData);
        this.incrementObjectCount(TierObjectStore.FileType.OFFSET_INDEX);
        this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.TIMESTAMP_INDEX), timestampIndexData);
        this.incrementObjectCount(TierObjectStore.FileType.TIMESTAMP_INDEX);
        producerStateSnapshotData.ifPresent(data -> {
            this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.PRODUCER_STATE), (File)data);
            this.incrementObjectCount(TierObjectStore.FileType.PRODUCER_STATE);
        });
        transactionIndexData.ifPresent(data -> {
            this.writeBufToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.TRANSACTION_INDEX), (ByteBuffer)data);
            this.incrementObjectCount(TierObjectStore.FileType.TRANSACTION_INDEX);
        });
        if (epochState.isPresent()) {
            this.writeBufToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.EPOCH_STATE), epochState.get());
            this.incrementObjectCount(TierObjectStore.FileType.EPOCH_STATE);
        }
    }

    @Override
    public void putObject(TierObjectStore.ObjectStoreMetadata objectMetadata, File file, TierObjectStore.FileType fileType) {
        if (this.shouldThrow("putObject", objectMetadata, fileType)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        String key = this.keyPath(objectMetadata, fileType);
        this.writeFileToArray(key, file);
    }

    @Override
    public void restoreObjectByCopy(TierObjectStore.ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        Optional<UploadedObject> toBeRestoredOpt;
        if (KEY_TO_BLOB.containsKey(key) && (toBeRestoredOpt = KEY_TO_BLOB.get(key).stream().filter(obj -> obj.getVersionId() == lastLiveVersion.getVersionId()).findFirst()).isPresent()) {
            UploadedObject toBeRestored = toBeRestoredOpt.get();
            KEY_TO_BLOB.get(key).addFirst(new UploadedObject(toBeRestored.metadata, toBeRestored.cleartextDataKey, toBeRestored.data, new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
        }
    }

    @Override
    public void putBuf(String key, Map<String, String> metadata, ByteBuffer buf) {
        this.writeBufToArray(key, buf);
    }

    @Override
    public void deleteSegment(TierObjectStore.ObjectMetadata objectMetadata) {
        for (TierObjectStore.FileType type : TierObjectStore.FileType.values()) {
            if (!KEY_TO_BLOB.containsKey(this.keyPath(objectMetadata, type))) continue;
            KEY_TO_BLOB.get(this.keyPath(objectMetadata, type)).addFirst(deleteMarker);
        }
    }

    @Override
    public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
        for (TierObjectStore.KeyAndVersion k : keys) {
            if (!KEY_TO_BLOB.containsKey(k.key())) continue;
            if (k.versionId() == null) {
                KEY_TO_BLOB.get(k.key()).removeIf(element -> element.getVersionId() == null);
                KEY_TO_BLOB.get(k.key()).addFirst(deleteMarker);
                continue;
            }
            KEY_TO_BLOB.get(k.key()).removeIf(element -> element.versionInfo.getVersionId().equals(k.versionId()));
            if (KEY_TO_BLOB.get(k.key()).size() != 1 || KEY_TO_BLOB.get(k.key()).getFirst() != deleteMarker) continue;
            KEY_TO_BLOB.remove(k.key());
        }
    }

    @Override
    public TierObjectAttribute objectExists(TierObjectStore.ObjectMetadata objectMetadata, TierObjectStore.FileType type) {
        TierObjectAttribute result = new TierObjectAttribute(false);
        if (KEY_TO_BLOB.containsKey(this.keyPath(objectMetadata, type)) && KEY_TO_BLOB.get(this.keyPath(objectMetadata, type)).getFirst() != deleteMarker) {
            result.exist = true;
            result.size = MockInMemoryTierObjectStore.KEY_TO_BLOB.get((Object)this.keyPath((TierObjectStore.ObjectStoreMetadata)objectMetadata, (TierObjectStore.FileType)type)).getFirst().data.length;
        }
        return result;
    }

    @Override
    public BucketHealthResult checkBucketHealth() {
        return BucketHealthResult.HEALTHY;
    }

    public void clearForClusterId() {
        this.getStoredKeys().forEach(KEY_TO_BLOB::remove);
    }

    private String keyPath(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType fileType) {
        return objectMetadata.toPath(this.keyPrefix, fileType);
    }

    private void writeSegmentFile(String filePath, File file, TierObjectStore.OpaqueData opaqueData) {
        ByteBuffer buf;
        try (FileChannel sourceChan = FileChannel.open(file.toPath(), new OpenOption[0]);){
            buf = ByteBuffer.allocate((int)sourceChan.size());
            sourceChan.read(buf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ConcurrentLinkedDeque<UploadedObject> up = new ConcurrentLinkedDeque<UploadedObject>();
        if (!opaqueData.equals(TierObjectStore.OpaqueData.ZEROED)) {
            KeySha keySha = KeySha.fromRawBytes(opaqueData.intoByteArray());
            KeyContext keyContext = this.encryptionKeyManager.keyContext(keySha);
            if (keyContext == null) {
                throw new TierObjectStoreFatalException(String.format("no key context on upload for '%s'", keySha));
            }
            up.add(new UploadedObject(keyContext.metadata, keyContext.cleartextDataKey, buf.array(), new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
            KEY_TO_BLOB.put(filePath, up);
        } else {
            up.add(new UploadedObject(new HashMap(), null, buf.array(), new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
            KEY_TO_BLOB.put(filePath, up);
        }
    }

    private void addBuffertoObjectStore(String filePath, byte[] buf) {
        if (KEY_TO_BLOB.containsKey(filePath)) {
            KEY_TO_BLOB.get(filePath).addFirst(new UploadedObject(new HashMap(), null, buf, new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
        } else {
            ConcurrentLinkedDeque<UploadedObject> uploadedObjects = new ConcurrentLinkedDeque<UploadedObject>();
            uploadedObjects.addFirst(new UploadedObject(new HashMap(), null, buf, new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
            KEY_TO_BLOB.put(filePath, uploadedObjects);
        }
    }

    private void writeFileToArray(String filePath, File file) {
        try (FileChannel sourceChan = FileChannel.open(file.toPath(), new OpenOption[0]);){
            ByteBuffer buf = ByteBuffer.allocate((int)sourceChan.size());
            sourceChan.read(buf);
            this.addBuffertoObjectStore(filePath, buf.array());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeBufToArray(String filePath, ByteBuffer buf) {
        try {
            ByteBufferInputStream inputStream = new ByteBufferInputStream(buf);
            byte[] bs = new byte[buf.limit()];
            Utils.readFully((InputStream)inputStream, (byte[])bs, (boolean)false);
            this.addBuffertoObjectStore(filePath, bs);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    static {
        wellKnownKeyPathMetadata = null;
        try {
            AeadConfig.register();
            KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
            KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
            MASTER_KEY = (Aead)keySetHandle.getPrimitive(Aead.class);
        }
        catch (GeneralSecurityException e) {
            throw new TierObjectStoreFatalException("failed to initialize Tink", e);
        }
    }

    public static class UploadedObject {
        final HashMap<String, String> metadata;
        final CleartextDataKey cleartextDataKey;
        final byte[] data;
        VersionInformation versionInfo;
        long timestamp;

        private UploadedObject(HashMap<String, String> metadata, CleartextDataKey cleartextDataKey, byte[] data, VersionInformation versionInfo, long timestamp) {
            this.metadata = metadata;
            this.cleartextDataKey = cleartextDataKey;
            this.data = data;
            this.versionInfo = versionInfo;
            this.timestamp = timestamp;
        }

        public String getVersionId() {
            return this.versionInfo.getVersionId();
        }

        boolean encrypted() {
            return this.cleartextDataKey != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UploadedObject that = (UploadedObject)o;
            return this.timestamp == that.timestamp && Objects.equals(this.cleartextDataKey, that.cleartextDataKey) && Arrays.equals(this.data, that.data) && this.versionInfo.versionId == that.versionInfo.versionId;
        }

        public int hashCode() {
            int result = Objects.hash(this.cleartextDataKey, this.versionInfo, this.timestamp);
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }

    private static class MockInMemoryTierObjectStoreResponse
    implements TierObjectStoreResponse {
        private final InputStream inputStream;

        MockInMemoryTierObjectStoreResponse(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

