/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.serdes.TierPartitionStateEntry;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.AbstractIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTierPartitionIterator
extends AbstractIterator<TierObjectMetadata> {
    private static final Logger log = LoggerFactory.getLogger(FileTierPartitionIterator.class);
    private static final int ENTRY_LENGTH_SIZE = 2;
    private final ByteBuffer lengthBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
    private final TopicIdPartition topicIdPartition;
    private long position;
    private long endPosition;
    private CheckedFileIO channel;
    private ByteBuffer sharedEntryBuffer = null;
    private boolean useSharedEntryBuffer;

    public FileTierPartitionIterator(TopicIdPartition topicIdPartition, CheckedFileIO channel, long startPosition) throws IOException {
        this(topicIdPartition, channel, startPosition, true);
    }

    public FileTierPartitionIterator(TopicIdPartition topicIdPartition, CheckedFileIO channel, long startPosition, boolean useSharedEntryBuffer) throws IOException {
        this.topicIdPartition = topicIdPartition;
        this.channel = channel;
        this.position = startPosition;
        this.endPosition = channel.size();
        this.useSharedEntryBuffer = useSharedEntryBuffer;
    }

    protected TierObjectMetadata makeNext() {
        if (this.position >= this.endPosition) {
            return (TierObjectMetadata)this.allDone();
        }
        long currentPosition = this.position;
        try {
            this.lengthBuffer.clear();
            this.channel.read(this.lengthBuffer, currentPosition);
            if (this.lengthBuffer.hasRemaining()) {
                return (TierObjectMetadata)this.allDone();
            }
            this.lengthBuffer.flip();
            short length = this.lengthBuffer.getShort();
            if ((currentPosition += (long)this.lengthBuffer.limit()) + (long)length > this.endPosition) {
                return (TierObjectMetadata)this.allDone();
            }
            ByteBuffer entryBuffer = this.getEntryBuffer(length);
            this.channel.read(entryBuffer, currentPosition);
            if (entryBuffer.hasRemaining()) {
                return (TierObjectMetadata)this.allDone();
            }
            entryBuffer.flip();
            this.position = currentPosition += (long)entryBuffer.limit();
            return new TierObjectMetadata(this.topicIdPartition, TierPartitionStateEntry.getRootAsTierPartitionStateEntry(entryBuffer));
        }
        catch (IOException e) {
            throw new KafkaStorageException("Encountered error during iteration at byte offset " + currentPosition, (Throwable)e);
        }
    }

    public long position() {
        return this.position;
    }

    private ByteBuffer getEntryBuffer(short length) {
        if (this.useSharedEntryBuffer) {
            if (this.sharedEntryBuffer == null || length > this.sharedEntryBuffer.capacity()) {
                if (this.sharedEntryBuffer != null) {
                    log.debug("Resizing tier partition state iterator buffer from " + this.sharedEntryBuffer.capacity() + " to " + length);
                }
                this.sharedEntryBuffer = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
            }
            this.sharedEntryBuffer.clear();
            this.sharedEntryBuffer.limit(length);
            return this.sharedEntryBuffer;
        }
        return ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
    }
}

