/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.serdes.MetadataSnapshotComplete;
import kafka.tier.state.OffsetAndEpoch;

public class TierMetadataSnapshotComplete
extends AbstractTierMetadata {
    public static final byte VERSION_V1 = 1;
    public static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 64;
    private final TopicIdPartition topicIdPartition;
    protected final MetadataSnapshotComplete metadata;

    public TierMetadataSnapshotComplete(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, OffsetAndEpoch stateOffset) {
        FlatBufferBuilder builder = new FlatBufferBuilder(TierMetadataSnapshotComplete.initialBufferSize()).forceDefaults(false);
        int entryId = TierMetadataSnapshotComplete.buildMetadataSnapshotComplete(builder, tierEpoch, objectId, stateOffset);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = MetadataSnapshotComplete.getRootAsMetadataSnapshotComplete(builder.dataBuffer());
    }

    public TierMetadataSnapshotComplete(TopicIdPartition topicIdPartition, MetadataSnapshotComplete metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    static int buildMetadataSnapshotComplete(FlatBufferBuilder builder, int tierEpoch, UUID objectId, OffsetAndEpoch stateOffset) {
        MetadataSnapshotComplete.startMetadataSnapshotComplete(builder);
        MetadataSnapshotComplete.addVersion(builder, (byte)1);
        MetadataSnapshotComplete.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        MetadataSnapshotComplete.addObjectId(builder, objectIdOffset);
        int offsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffset.offset(), stateOffset.epoch().orElse(-1));
        MetadataSnapshotComplete.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        return MetadataSnapshotComplete.endMetadataSnapshotComplete(builder);
    }

    public static int initialBufferSize() {
        return 64;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.MetadataSnapshotComplete;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        kafka.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public String toString() {
        return "MetadataSnapshotComplete(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", messageIdBase64=" + this.messageIdAsBase64() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ", )";
    }
}

