/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigAdminManager$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MetadataPublisher;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageListener;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t-x!B\u0016-\u0011\u0003\u0019d!B\u001b-\u0011\u00031\u0004\"B\"\u0002\t\u0003!\u0005\"B#\u0002\t\u00031\u0005\"\u00027\u0002\t\u0003ig!B\u001b-\u0001\u0005\u0005\u0002\"CA\u0015\u000b\t\u0005\t\u0015!\u0003X\u0011)\tY#\u0002B\u0001B\u0003%\u0011Q\u0006\u0005\u000b\u0003k)!\u0011!Q\u0001\n\u0005]\u0002BCA\u001f\u000b\t\u0005\t\u0015!\u0003\u0002@!Q\u0011QI\u0003\u0003\u0002\u0003\u0006I!a\u0012\t\u0015\u00055SA!A!\u0002\u0013\ty\u0005\u0003\u0006\u0002`\u0015\u0011\t\u0011)A\u0005\u0003CB!\"!\u001c\u0006\u0005\u0003\u0005\u000b\u0011BA8\u0011)\t)(\u0002B\u0001B\u0003%\u0011q\u000f\u0005\u000b\u0003\u0007+!Q1A\u0005\n\u0005\u0015\u0005BCAL\u000b\t\u0005\t\u0015!\u0003\u0002\b\"Q\u0011\u0011T\u0003\u0003\u0002\u0003\u0006I!a'\t\u0015\u0005\u001dVA!A!\u0002\u0013\tY\n\u0003\u0006\u0002*\u0016\u0011\t\u0011)A\u0005\u0003WC!\"a3\u0006\u0005\u0003\u0005\u000b\u0011BAg\u0011)\tY.\u0002B\u0001B\u0003%\u0011Q\u001c\u0005\u000b\u0003W,!\u0011!Q\u0001\n\u00055\bBB\"\u0006\t\u0003\tY\u0010\u0003\u0005\u007f\u000b\t\u0007I\u0011\u0001B\u0010\u0011\u001d\u0011\t#\u0002Q\u0001\n}D\u0011Ba\t\u0006\u0001\u0004%\tA!\n\t\u0013\t5R\u00011A\u0005\u0002\t=\u0002\u0002\u0003B\u001e\u000b\u0001\u0006KAa\n\t\u0013\tuR\u00011A\u0005\u0002\t}\u0002\"\u0003B,\u000b\u0001\u0007I\u0011\u0001B-\u0011!\u0011i&\u0002Q!\n\t\u0005\u0003\"\u0003B0\u000b\t\u0007I\u0011\u0001B1\u0011!\u0011Y(\u0002Q\u0001\n\t\r\u0004b\u0002B?\u000b\u0011\u0005#q\u0010\u0005\b\u0005\u000b+A\u0011\tBD\u0011\u001d\u0011y)\u0002C\u0001\u0005#CqAa(\u0006\t\u0003\u0012\t\u000bC\u0004\u00034\u0016!\tE!.\t\u000f\tmV\u0001\"\u0001\u0003>\"9!q[\u0003\u0005\n\te\u0007b\u0002Bq\u000b\u0011%!1\u001d\u0005\b\u0005K,A\u0011\u0002Bt\u0003]\u0011%o\\6fe6+G/\u00193bi\u0006\u0004VO\u00197jg\",'O\u0003\u0002.]\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u00020a\u000511/\u001a:wKJT\u0011!M\u0001\u0006W\u000647.Y\u0002\u0001!\t!\u0014!D\u0001-\u0005]\u0011%o\\6fe6+G/\u00193bi\u0006\u0004VO\u00197jg\",'oE\u0002\u0002ou\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0007C\u0001 B\u001b\u0005y$B\u0001!1\u0003\u0015)H/\u001b7t\u0013\t\u0011uHA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0019\u0014!D4fiR{\u0007/[2EK2$\u0018\r\u0006\u0003H+\n<\u0007c\u0001\u001dI\u0015&\u0011\u0011*\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005-\u001bV\"\u0001'\u000b\u00055s\u0015!B5nC\u001e,'BA\u0019P\u0015\t\u0001\u0016+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0006\u0019qN]4\n\u0005Qc%A\u0003+pa&\u001cG)\u001a7uC\")ak\u0001a\u0001/\u0006IAo\u001c9jG:\u000bW.\u001a\t\u00031~s!!W/\u0011\u0005iKT\"A.\u000b\u0005q\u0013\u0014A\u0002\u001fs_>$h(\u0003\u0002_s\u00051\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tq\u0016\bC\u0003d\u0007\u0001\u0007A-\u0001\u0005oK^LU.Y4f!\tYU-\u0003\u0002g\u0019\niQ*\u001a;bI\u0006$\u0018-S7bO\u0016DQ\u0001[\u0002A\u0002%\fQ\u0001Z3mi\u0006\u0004\"a\u00136\n\u0005-d%!D'fi\u0006$\u0017\r^1EK2$\u0018-A\ngS:$7\u000b\u001e:bsB\u000b'\u000f^5uS>t7\u000f\u0006\u0004o{\u0006\u0015\u0011q\u0002\t\u0004_R<hB\u00019s\u001d\tQ\u0016/C\u0001;\u0013\t\u0019\u0018(A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(\u0001C%uKJ\f'\r\\3\u000b\u0005ML\u0004C\u0001=|\u001b\u0005I(B\u0001>O\u0003\u0019\u0019w.\\7p]&\u0011A0\u001f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015qH\u00011\u0001\u0000\u0003!\u0011'o\\6fe&#\u0007c\u0001\u001d\u0002\u0002%\u0019\u00111A\u001d\u0003\u0007%sG\u000fC\u0004\u0002\b\u0011\u0001\r!!\u0003\u0002\u001d9,w\u000fV8qS\u000e\u001c\u0018*\\1hKB\u00191*a\u0003\n\u0007\u00055AJA\u0006U_BL7m]%nC\u001e,\u0007bBA\t\t\u0001\u0007\u00111C\u0001\u0005Y><7\u000f\u0005\u0003pi\u0006U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m\u0001'A\u0002m_\u001eLA!a\b\u0002\u001a\tY\u0011IY:ue\u0006\u001cG\u000fT8h'\u0015)q'a\t>!\r!\u0014QE\u0005\u0004\u0003Oa#!E'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5fe\u0006I1\r\\;ti\u0016\u0014\u0018\nZ\u0001\u0005G>tg\r\u0005\u0003\u00020\u0005ER\"\u0001\u0018\n\u0007\u0005MbFA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!D7fi\u0006$\u0017\r^1DC\u000eDW\rE\u00025\u0003sI1!a\u000f-\u0005IY%+\u00194u\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u00151|w-T1oC\u001e,'\u000f\u0005\u0003\u0002\u0018\u0005\u0005\u0013\u0002BA\"\u00033\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004B!a\f\u0002J%\u0019\u00111\n\u0018\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u00159'o\\;q\u0015\r\tI\u0006M\u0001\fG>|'\u000fZ5oCR|'/\u0003\u0003\u0002^\u0005M#\u0001E$s_V\u00048i\\8sI&t\u0017\r^8s\u00039!\bP\\\"p_J$\u0017N\\1u_J\u0004B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0005\u0003O\n9&A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BA6\u0003K\u0012a\u0003\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u0001\u001bG2LWM\u001c;Rk>$\u0018-T3uC\u0012\fG/Y'b]\u0006<WM\u001d\t\u0004i\u0005E\u0014bAA:Y\tQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006)B-\u001f8b[&\u001c7i\u001c8gS\u001eD\u0015M\u001c3mKJ\u001c\bC\u0002-\u0002z]\u000bi(C\u0002\u0002|\u0005\u00141!T1q!\u0011\ty#a \n\u0007\u0005\u0005eFA\u0007D_:4\u0017n\u001a%b]\u0012dWM]\u0001\f?\u0006,H\u000f[8sSj,'/\u0006\u0002\u0002\bB!\u0001\bSAE!\u0011\tY)a%\u000e\u0005\u00055%\u0002BAH\u0003#\u000b!\"Y;uQ>\u0014\u0018N_3s\u0015\tyc*\u0003\u0003\u0002\u0016\u00065%AC!vi\"|'/\u001b>fe\u0006aq,Y;uQ>\u0014\u0018N_3sA\u0005\tb-\u0019;bY\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0011\t\u0005u\u00151U\u0007\u0003\u0003?SA!!)\u0002\u0012\u0006)a-Y;mi&!\u0011QUAP\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003yiW\r^1eCR\f\u0007+\u001e2mSND\u0017N\\4GCVdG\u000fS1oI2,'/\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b\u0003\u0002\u001dI\u0003[\u0003B!a,\u0002F:!\u0011\u0011WA`\u001d\u0011\t\u0019,a/\u000f\t\u0005U\u0016\u0011\u0018\b\u00045\u0006]\u0016\"A\u0019\n\u0005=\u0002\u0014bAA_]\u0005!A.\u001b8l\u0013\u0011\t\t-a1\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/\u001f\u0006\u0004\u0003{s\u0013\u0002BAd\u0003\u0013\u00141\u0002T5oW6\u000bg.Y4fe*!\u0011\u0011YAb\u0003E!\u0018.\u001a:fI\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0005q!\u000by\r\u0005\u0003\u0002R\u0006]WBAAj\u0015\r\t)\u000eM\u0001\u0005i&,'/\u0003\u0003\u0002Z\u0006M'\u0001\t+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\f!FY1dWV\u0004xJ\u00196fGRd\u0015NZ3ds\u000edW-T1oC\u001e,'oQ8pe\u0012Lg.\u0019;pe>\u0003H\u000f\u0005\u00039\u0011\u0006}\u0007\u0003BAq\u0003Ol!!a9\u000b\t\u0005\u0015\u00181[\u0001\u0016E\u0006\u001c7.\u001e9pE*,7\r\u001e7jM\u0016\u001c\u0017p\u00197f\u0013\u0011\tI/a9\u0003O\t\u000b7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK6\u000bg.Y4fe\u000e{wN\u001d3j]\u0006$xN]\u0001\u0014cV|G/Y\"p_J$\u0017N\\1u_J|\u0005\u000f\u001e\t\u0005q!\u000by\u000f\u0005\u0003\u0002r\u0006]XBAAz\u0015\u0011\t)0a\u0016\u0002\u000bE,x\u000e^1\n\t\u0005e\u00181\u001f\u0002\u0011#V|G/Y\"p_J$\u0017N\\1u_J$\"%!@\u0002\u0000\n\u0005!1\u0001B\u0003\u0005\u000f\u0011IAa\u0003\u0003\u000e\t=!\u0011\u0003B\n\u0005+\u00119B!\u0007\u0003\u001c\tu\u0001C\u0001\u001b\u0006\u0011\u0019\tIc\u0006a\u0001/\"9\u00111F\fA\u0002\u00055\u0002bBA\u001b/\u0001\u0007\u0011q\u0007\u0005\b\u0003{9\u0002\u0019AA \u0011\u001d\t)e\u0006a\u0001\u0003\u000fBq!!\u0014\u0018\u0001\u0004\ty\u0005C\u0004\u0002`]\u0001\r!!\u0019\t\u000f\u00055t\u00031\u0001\u0002p!9\u0011QO\fA\u0002\u0005]\u0004bBAB/\u0001\u0007\u0011q\u0011\u0005\b\u00033;\u0002\u0019AAN\u0011\u001d\t9k\u0006a\u0001\u00037Cq!!+\u0018\u0001\u0004\tY\u000bC\u0004\u0002L^\u0001\r!!4\t\u000f\u0005mw\u00031\u0001\u0002^\"9\u00111^\fA\u0002\u00055X#A@\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013!D0gSJ\u001cH\u000fU;cY&\u001c\b.\u0006\u0002\u0003(A\u0019\u0001H!\u000b\n\u0007\t-\u0012HA\u0004C_>dW-\u00198\u0002#}3\u0017N]:u!V\u0014G.[:i?\u0012*\u0017\u000f\u0006\u0003\u00032\t]\u0002c\u0001\u001d\u00034%\u0019!QG\u001d\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005sY\u0012\u0011!a\u0001\u0005O\t1\u0001\u001f\u00132\u00039yf-\u001b:tiB+(\r\\5tQ\u0002\na#\\3uC\u0012\fG/Y%nC\u001e,G*[:uK:,'o]\u000b\u0003\u0005\u0003\u0002bAa\u0011\u0003N\tESB\u0001B#\u0015\u0011\u00119E!\u0013\u0002\u000f5,H/\u00192mK*\u0019!1J\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003P\t\u0015#A\u0003'jgR\u0014UO\u001a4feB\u00191Ja\u0015\n\u0007\tUCJA\u000bNKR\fG-\u0019;b\u00136\fw-\u001a'jgR,g.\u001a:\u000255,G/\u00193bi\u0006LU.Y4f\u0019&\u001cH/\u001a8feN|F%Z9\u0015\t\tE\"1\f\u0005\n\u0005sq\u0012\u0011!a\u0001\u0005\u0003\nq#\\3uC\u0012\fG/Y%nC\u001e,G*[:uK:,'o\u001d\u0011\u0002+A,(\r\\5tQ\u0016$wJ\u001a4tKR\fEo\\7jGV\u0011!1\r\t\u0005\u0005K\u00129(\u0004\u0002\u0003h)!!\u0011\u000eB6\u0003\u0019\tGo\\7jG*!!Q\u000eB8\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005c\u0012\u0019(\u0001\u0003vi&d'B\u0001B;\u0003\u0011Q\u0017M^1\n\t\te$q\r\u0002\u000b\u0003R|W.[2M_:<\u0017A\u00069vE2L7\u000f[3e\u001f\u001a47/\u001a;Bi>l\u0017n\u0019\u0011\u0002\u000fA,(\r\\5tQR1!\u0011\u0007BA\u0005\u0007CQ\u0001\u001b\u0012A\u0002%DQa\u0019\u0012A\u0002\u0011\fq\u0002];cY&\u001c\b.\u001a3PM\u001a\u001cX\r^\u000b\u0003\u0005\u0013\u00032\u0001\u000fBF\u0013\r\u0011i)\u000f\u0002\u0005\u0019>tw-A\u0013sK2|\u0017\rZ+qI\u0006$X\r\u001a$jY\u0016\u001cx+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0005.\u00198hKR!!\u0011\u0007BJ\u0011\u001d\u0011)\n\na\u0001\u0005/\u000bQ\u0001\u001d:paN\u0004BA!'\u0003\u001c6\u0011!qN\u0005\u0005\u0005;\u0013yG\u0001\u0006Qe>\u0004XM\u001d;jKN\f1\u0003];cY&\u001c\b\u000eT3bI\u0016\u00148\t[1oO\u0016$BA!\r\u0003$\"9!QU\u0013A\u0002\t\u001d\u0016A\u00027fC\u0012,'\u000f\u0005\u0003\u0003*\n=VB\u0001BV\u0015\r\u0011iKT\u0001\u0005e\u00064G/\u0003\u0003\u00032\n-&A\u0004'fC\u0012,'/\u00118e\u000bB|7\r[\u0001\te\u0016<\u0017n\u001d;feR!!\u0011\u0007B\\\u0011\u001d\u0011IL\na\u0001\u0005#\n\u0001\u0002\\5ti\u0016tWM]\u0001\u0012kB$\u0017\r^3D_>\u0014H-\u001b8bi>\u0014H\u0003\u0004B\u0019\u0005\u007f\u0013\tMa1\u0003F\n=\u0007\"B'(\u0001\u0004!\u0007\"\u00025(\u0001\u0004I\u0007\"\u0002,(\u0001\u00049\u0006b\u0002BdO\u0001\u0007!\u0011Z\u0001\tK2,7\r^5p]B9\u0001Ha3\u0000\u007f\nE\u0012b\u0001Bgs\tIa)\u001e8di&|gN\r\u0005\b\u0005#<\u0003\u0019\u0001Bj\u0003-\u0011Xm]5h]\u0006$\u0018n\u001c8\u0011\u0011a\u0012Ym Bk\u0005c\u00012\u0001\u000f%\u0000\u0003\u0019qw\u000e^5gsR1!\u0011\u0007Bn\u0005;DQ\u0001\u001b\u0015A\u0002%DaAa8)\u0001\u0004!\u0017A\u00049vE2L7\u000f[3e\u00136\fw-Z\u0001\u0013S:LG/[1mSj,W*\u00198bO\u0016\u00148\u000f\u0006\u0002\u00032\u0005\u0001c-\u001b8jg\"Le.\u001b;jC2L'0\u001b8h%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s)\u0011\u0011\tD!;\t\u000b\rT\u0003\u0019\u00013")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final String clusterId;
    private final KafkaConfig conf;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ClientQuotaMetadataManager clientQuotaMetadataManager;
    private final Map<String, ConfigHandler> dynamicConfigHandlers;
    private final Option<Authorizer> _authorizer;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final Option<ClusterLinkFactory.LinkManager> clusterLinkManager;
    private final Option<TierDeletedPartitionsCoordinator> tieredCoordinator;
    private final Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt;
    private final Option<QuotaCoordinator> quotaCoordinatorOpt;
    private final int brokerId;
    private boolean _firstPublish;
    private ListBuffer<MetadataImageListener> metadataImageListeners;
    private final AtomicLong publishedOffsetAtomic;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<TopicPartition> findStrayPartitions(int n, TopicsImage topicsImage, Iterable<AbstractLog> iterable) {
        return BrokerMetadataPublisher$.MODULE$.findStrayPartitions(n, topicsImage, iterable);
    }

    public static Option<TopicDelta> getTopicDelta(String string, MetadataImage metadataImage, MetadataDelta metadataDelta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(string, metadataImage, metadataDelta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Option<Authorizer> _authorizer() {
        return this._authorizer;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public ListBuffer<MetadataImageListener> metadataImageListeners() {
        return this.metadataImageListeners;
    }

    public void metadataImageListeners_$eq(ListBuffer<MetadataImageListener> x$1) {
        this.metadataImageListeners = x$1;
    }

    public AtomicLong publishedOffsetAtomic() {
        return this.publishedOffsetAtomic;
    }

    @Override
    public void publish(MetadataDelta delta, MetadataImage newImage) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? new StringBuilder(28).append("initial MetadataDelta up to ").append(highestOffsetAndEpoch.offset).toString() : new StringBuilder(20).append("MetadataDelta up to ").append(highestOffsetAndEpoch.offset).toString();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                }
                this.metadataCache.setImage(newImage);
                if (delta.topicsDelta() != null && !delta.topicsDelta().changedTopics().isEmpty()) {
                    try {
                        this.clientQuotaMetadataManager.quotaManagers().clientQuotaCallback().foreach((Function1 & Serializable & scala.Serializable)quotaCallback -> BoxesRunTime.boxToBoolean((boolean)quotaCallback.updateClusterMetadata(this.metadataCache.getClusterMetadata(this.clusterId, this.conf.interBrokerListenerName()))));
                    }
                    catch (Throwable t) {
                        this.metadataPublishingFaultHandler.handleFault(new StringBuilder(67).append("Error updating ").append("client quota metadata manager with local changes in ").append(deltaName).toString(), t);
                    }
                }
                String metadataVersionLogMsg = new StringBuilder(17).append("metadata.version ").append(newImage.features().metadataVersion()).toString();
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                    this.initializeManagers();
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable & scala.Serializable)featuresDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$5(this, highestOffsetAndEpoch, featuresDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(31).append("Error applying topics ").append("delta in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> $this.groupCoordinator.onElection(offsetTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)offsetTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(53).append("Error updating txn ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.tieredCoordinator.foreach((Function1 & Serializable & scala.Serializable)tieredCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, x$1) -> tieredCoord.handleImmigration(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, x$2) -> {
                                tieredCoord.handleEmigration(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(64).append("Error updating ").append("tiered storage coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.quotaCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)quotaCoordinator -> {
                            this.updateCoordinator(newImage, delta, "_confluent-quotas", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> quotaCoordinator.onElection(quotaTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> {
                                quotaCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)quotaTopicPartitionId), (Option<Object>)coordinatorEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating ").append("quota coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.backupObjectLifecycleManagerCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)backupObjectLifecycleManagerCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, x$3) -> backupObjectLifecycleManagerCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, x$4) -> {
                                backupObjectLifecycleManagerCoord.onResignation(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(81).append("Error updating ").append("backup object lifecycle manager coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.clusterLinkManager.foreach((Function1 & Serializable & scala.Serializable)manager -> {
                            this.updateCoordinator(newImage, delta, "_confluent-link-metadata", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, leaderEpoch) -> manager.onMetadataPartitionLeaderElection(partitionId, leaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, leaderEpoch) -> {
                                manager.onMetadataPartitionLeaderResignation(BoxesRunTime.unboxToInt((Object)partitionId), (Option<Object>)leaderEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(58).append("Error updating ").append("cluster link manager with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.handleDeletedPartitions((Seq<TopicPartition>)deletedTopicPartitions, RequestLocal$.MODULE$.NoCaching());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(60).append("Error updating group ").append("coordinator with deleted partitions in ").append(deltaName).toString(), t);
                    }
                    return runtimeException;
                });
                Option$.MODULE$.apply((Object)delta.configsDelta()).foreach((Function1 & Serializable & scala.Serializable)configsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$27(this, newImage, deltaName, configsDelta);
                    return BoxedUnit.UNIT;
                });
                try {
                    Option$.MODULE$.apply((Object)delta.clientQuotasDelta()).foreach((Function1 & Serializable & scala.Serializable)clientQuotasDelta -> {
                        this.clientQuotaMetadataManager.update(clientQuotasDelta);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault(new StringBuilder(32).append("Error updating client ").append("quotas in ").append(deltaName).toString(), t);
                }
                Option$.MODULE$.apply((Object)delta.aclsDelta()).foreach((Function1 & Serializable & scala.Serializable)aclsDelta -> {
                    BoxedUnit boxedUnit;
                    Authorizer authorizer;
                    Option<Authorizer> option = this._authorizer();
                    if (option instanceof Some && (authorizer = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
                        Object object;
                        ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer;
                        if (aclsDelta.isSnapshotDelta()) {
                            try {
                                clusterMetadataAuthorizer.loadSnapshot(newImage.acls().acls());
                                object = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                object = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(37).append("Error loading ").append("authorizer snapshot in ").append(deltaName).toString(), t);
                            }
                        } else {
                            try {
                                aclsDelta.changes().entrySet().forEach(e -> {
                                    if (((Optional)e.getValue()).isPresent()) {
                                        clusterMetadataAuthorizer.addAcl((Uuid)e.getKey(), (ConfluentStandardAcl)((Optional)e.getValue()).get());
                                        return;
                                    }
                                    clusterMetadataAuthorizer.removeAcl((Uuid)e.getKey());
                                });
                                object = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                object = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(36).append("Error loading ").append("authorizer changes in ").append(deltaName).toString(), t);
                            }
                        }
                        boxedUnit = object;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                });
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager(newImage);
                }
                this.notify(delta, newImage);
                this.publishedOffsetAtomic().set(newImage.highestOffsetAndEpoch().offset);
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault(new StringBuilder(57).append("Uncaught exception while ").append("publishing broker metadata from ").append(deltaName).toString(), t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
        }
    }

    @Override
    public long publishedOffset() {
        return this.publishedOffsetAtomic().get();
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    @Override
    public void publishLeaderChange(LeaderAndEpoch leader) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Publishing new leader [").append(leader).append("]").toString());
        this.metadataImageListeners().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.onLeaderUpdate(leader);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void register(MetadataImageListener listener) {
        this.metadataImageListeners_$eq((ListBuffer<MetadataImageListener>)this.metadataImageListeners().$plus$eq((Object)listener));
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
            if (topicsDelta.topicWasDeleted(topicName)) {
                topicsDelta.image().getTopic(topicName).partitions().entrySet().forEach(entry -> {
                    if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                        resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                    }
                });
            }
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable & scala.Serializable)topicDelta -> {
            LocalReplicaChanges $anonfun$updateCoordinator$3_changes = topicDelta.localChanges(this.brokerId());
            $anonfun$updateCoordinator$3_changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
            $anonfun$updateCoordinator$3_changes.leaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
            $anonfun$updateCoordinator$3_changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
            return BoxedUnit.UNIT;
        });
    }

    private void notify(MetadataDelta delta, MetadataImage publishedImage) {
        this.metadataImageListeners().foreach((Function1 & Serializable & scala.Serializable)publisher -> {
            BrokerMetadataPublisher.$anonfun$notify$1(this, delta, publishedImage, publisher);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers() {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics((Option<String>)None$.MODULE$));
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.clusterLinkManager.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.startup();
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ClusterLinkManager", t);
        }
        try {
            this.groupCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.offsetsTopicPartitions()))), this.groupCoordinator.startup$default$2());
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
        }
        try {
            this.quotaCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("_confluent-quotas").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.confluentConfig().quotasTopicPartitions()))));
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting QuotaCoordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager(MetadataImage newImage) {
        try {
            Iterable<TopicPartition> strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(this.brokerId(), newImage.topics(), this.logManager.allLogs());
            if (strayPartitions.nonEmpty()) {
                this.replicaManager.deleteStrayReplicas(strayPartitions);
            }
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error deleting stray partitions during startup", t);
        }
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$publish$5(BrokerMetadataPublisher $this, OffsetAndEpoch highestOffsetAndEpoch$1, FeaturesDelta featuresDelta) {
        featuresDelta.metadataVersionChange().ifPresent(metadataVersion -> $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Updating metadata.version to ").append(metadataVersion).append(" at offset ").append(highestOffsetAndEpoch$1).append(".").toString()));
    }

    public static final /* synthetic */ void $anonfun$publish$27(BrokerMetadataPublisher $this, MetadataImage newImage$1, String deltaName$1, ConfigurationsDelta configsDelta) {
        configsDelta.changes().keySet().forEach(resource -> {
            block18: {
                ConfigResource.Type type;
                Properties props;
                block15: {
                    block17: {
                        String string;
                        String string2;
                        block16: {
                            props = newImage$1.configs().configProperties(resource);
                            type = resource.type();
                            if (ConfigResource.Type.TOPIC.equals(type)) {
                                try {
                                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Updating topic ").append(resource.name()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                                    ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Topic())).processConfigChanges(resource.name(), props);
                                    return;
                                }
                                catch (Throwable t) {
                                    $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(50).append("Error updating topic ").append(resource.name()).append(" with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                                    return;
                                }
                            }
                            if (!ConfigResource.Type.BROKER.equals(type)) break block15;
                            if (resource.name().isEmpty()) {
                                try {
                                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Updating cluster configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                                    ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Broker())).processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
                                    return;
                                }
                                catch (Throwable t) {
                                    $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(51).append("Error updating ").append("cluster with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                                    return;
                                }
                            }
                            string2 = resource.name();
                            string = Integer.toString($this.brokerId());
                            if (string2 != null) break block16;
                            if (string != null) {
                                return;
                            }
                            break block17;
                        }
                        if (!string2.equals(string)) break block18;
                    }
                    try {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updating broker ").append($this.brokerId()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                        ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Broker())).processConfigChanges(resource.name(), props);
                        $this.reloadUpdatedFilesWithoutConfigChange(props);
                        return;
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(50).append("Error updating ").append("broker with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                        return;
                    }
                }
                if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
                    try {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Updating cluster link with id ").append(resource.name()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                        ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.ClusterLink())).processConfigChanges(resource.name(), props);
                        return;
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(75).append("Error updating ").append("cluster link configuration for ").append(resource).append(" with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" in ").append(deltaName$1).toString(), t);
                        return;
                    }
                }
            }
        });
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                    resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                }
            });
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$notify$1(BrokerMetadataPublisher $this, MetadataDelta delta$3, MetadataImage publishedImage$1, MetadataImageListener publisher) {
        try {
            publisher.onMetadataImageUpdate(delta$3, publishedImage$1);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Encountered error (%s) publishing to the subscriber %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getCause(), publisher.getClass().toString()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(String clusterId, KafkaConfig conf, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ClientQuotaMetadataManager clientQuotaMetadataManager, Map<String, ConfigHandler> dynamicConfigHandlers, Option<Authorizer> _authorizer, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler, Option<ClusterLinkFactory.LinkManager> clusterLinkManager, Option<TierDeletedPartitionsCoordinator> tieredCoordinator, Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt, Option<QuotaCoordinator> quotaCoordinatorOpt) {
        this.clusterId = clusterId;
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.clientQuotaMetadataManager = clientQuotaMetadataManager;
        this.dynamicConfigHandlers = dynamicConfigHandlers;
        this._authorizer = _authorizer;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.clusterLinkManager = clusterLinkManager;
        this.tieredCoordinator = tieredCoordinator;
        this.backupObjectLifecycleManagerCoordinatorOpt = backupObjectLifecycleManagerCoordinatorOpt;
        this.quotaCoordinatorOpt = quotaCoordinatorOpt;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
        this.metadataImageListeners = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.publishedOffsetAtomic = new AtomicLong(-1L);
    }
}

