/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.EpochUpdateState;
import kafka.server.link.FetchState;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$NoSourceRecords$;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.replica.ReplicaStatus;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg!B\u000f\u001f\u0001y!\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011A\u0017\t\u0011Q\u0002!\u0011!Q\u0001\n9B\u0001\"\u000e\u0001\u0003\u0002\u0004%\tA\u000e\u0005\tw\u0001\u0011\t\u0019!C\u0001y!A!\t\u0001B\u0001B\u0003&q\u0007C\u0003H\u0001\u0011\u0005\u0001\nC\u0004M\u0001\u0001\u0007I\u0011A'\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\"1!\u000e\u0001Q!\n9Cqa\u001b\u0001C\u0002\u0013\u0005A\u000e\u0003\u0004z\u0001\u0001\u0006I!\u001c\u0005\bu\u0002\u0001\r\u0011\"\u0001|\u0011%\t)\u0001\u0001a\u0001\n\u0003\t9\u0001C\u0004\u0002\f\u0001\u0001\u000b\u0015\u0002?\t\u0011\u0005=\u0001\u00011A\u0005\u0002mD\u0011\"!\u0005\u0001\u0001\u0004%\t!a\u0005\t\u000f\u0005]\u0001\u0001)Q\u0005y\"I\u00111\u0004\u0001A\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0003O\u0001\u0001\u0019!C\u0001\u0003SA\u0001\"!\f\u0001A\u0003&\u0011q\u0004\u0005\n\u0003c\u0001\u0001\u0019!C\u0001\u0003gA\u0011\"!\u0010\u0001\u0001\u0004%\t!a\u0010\t\u0011\u0005\r\u0003\u0001)Q\u0005\u0003kAq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0002\u0012!\u0006\u0014H/\u001b;j_:\fe\u000eZ*uCR,'BA\u0010!\u0003\u0011a\u0017N\\6\u000b\u0005\u0005\u0012\u0013AB:feZ,'OC\u0001$\u0003\u0015Y\u0017MZ6b'\t\u0001Q\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VMZ\u0001\na\u0006\u0014H/\u001b;j_:\u001c\u0001!F\u0001/!\ty#'D\u00011\u0015\t\t$%A\u0004dYV\u001cH/\u001a:\n\u0005M\u0002$!\u0003)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u0015Y\u0006\u001cH/\u00129pG\",\u0006\u000fZ1uKN#\u0018\r^3\u0016\u0003]\u0002\"\u0001O\u001d\u000e\u0003yI!A\u000f\u0010\u0003!\u0015\u0003xn\u00195Va\u0012\fG/Z*uCR,\u0017\u0001\u00077bgR,\u0005o\\2i+B$\u0017\r^3Ti\u0006$Xm\u0018\u0013fcR\u0011Q\b\u0011\t\u0003MyJ!aP\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0012\t\t\u00111\u00018\u0003\rAH%M\u0001\u0016Y\u0006\u001cH/\u00129pG\",\u0006\u000fZ1uKN#\u0018\r^3!Q\t)A\t\u0005\u0002'\u000b&\u0011ai\n\u0002\tm>d\u0017\r^5mK\u00061A(\u001b8jiz\"2!\u0013&L!\tA\u0004\u0001C\u0003,\r\u0001\u0007a\u0006C\u00036\r\u0001\u0007q'\u0001\u000bt_V\u00148-\u001a'fC\u0012,'/\u00118e\u000bB|7\r[\u000b\u0002\u001dB\u0011q\n\u001a\b\u0003!\u0006t!!\u00150\u000f\u0005IcfBA*Z\u001d\t!v+D\u0001V\u0015\t1F&\u0001\u0004=e>|GOP\u0005\u00021\u0006\u0019qN]4\n\u0005i[\u0016AB1qC\u000eDWMC\u0001Y\u0013\t\u0019SL\u0003\u0002[7&\u0011q\fY\u0001\bG2LWM\u001c;t\u0015\t\u0019S,\u0003\u0002cG\u0006AQ*\u001a;bI\u0006$\u0018M\u0003\u0002`A&\u0011QM\u001a\u0002\u000f\u0019\u0016\fG-\u001a:B]\u0012,\u0005o\\2i\u0015\t\u00117-\u0001\rt_V\u00148-\u001a'fC\u0012,'/\u00118e\u000bB|7\r[0%KF$\"!P5\t\u000f\u0005C\u0011\u0011!a\u0001\u001d\u0006)2o\\;sG\u0016dU-\u00193fe\u0006sG-\u00129pG\"\u0004\u0013A\u00044bS2,(/Z*uCJ$Xj]\u000b\u0002[B\u0011an^\u0007\u0002_*\u0011\u0001/]\u0001\u0007CR|W.[2\u000b\u0005I\u001c\u0018AC2p]\u000e,(O]3oi*\u0011A/^\u0001\u0005kRLGNC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a|'AC!u_6L7\rT8oO\u0006ya-Y5mkJ,7\u000b^1si6\u001b\b%A\bmCN$h)Y5mkJ,G+\u001f9f+\u0005a\bc\u0001\u0014~\u007f&\u0011ap\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007a\n\t!C\u0002\u0002\u0004y\u0011\u0011#T5se>\u0014h)Y5mkJ,G+\u001f9f\u0003Ma\u0017m\u001d;GC&dWO]3UsB,w\fJ3r)\ri\u0014\u0011\u0002\u0005\b\u00036\t\t\u00111\u0001}\u0003Aa\u0017m\u001d;GC&dWO]3UsB,\u0007\u0005\u000b\u0002\u000f\t\u0006q\u0011\r]5GC&dWO]3UsB,\u0017AE1qS\u001a\u000b\u0017\u000e\\;sKRK\b/Z0%KF$2!PA\u000b\u0011\u001d\t\u0005#!AA\u0002q\fq\"\u00199j\r\u0006LG.\u001e:f)f\u0004X\r\t\u0015\u0003#\u0011\u000b!BZ3uG\"\u001cF/\u0019;f+\t\ty\u0002\u0005\u0003'{\u0006\u0005\u0002c\u0001\u001d\u0002$%\u0019\u0011Q\u0005\u0010\u0003\u0015\u0019+Go\u00195Ti\u0006$X-\u0001\bgKR\u001c\u0007n\u0015;bi\u0016|F%Z9\u0015\u0007u\nY\u0003\u0003\u0005B'\u0005\u0005\t\u0019AA\u0010\u0003-1W\r^2i'R\fG/\u001a\u0011)\u0005Q!\u0015!\u00044fi\u000eDWM\u001d+ie\u0016\fG-\u0006\u0002\u00026A!a%`A\u001c!\rA\u0014\u0011H\u0005\u0004\u0003wq\"\u0001G\"mkN$XM\u001d'j].4U\r^2iKJ$\u0006N]3bI\u0006\tb-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012|F%Z9\u0015\u0007u\n\t\u0005\u0003\u0005B-\u0005\u0005\t\u0019AA\u001b\u000391W\r^2iKJ$\u0006N]3bI\u0002B#a\u0006#\u0002!U\u0004H-\u0019;f\u000bB|7\r[*uCR,G\u0003BA&\u0003#\u00022AJA'\u0013\r\tye\n\u0002\b\u0005>|G.Z1o\u0011\u0019\t\u0019\u0006\u0007a\u0001\u001d\u0006qA.Z1eKJ\fe\u000eZ#q_\u000eD\u0017!D8o\u0019&t7NR1jYV\u0014X\r\u0006\u0005\u0002Z\u0005\u0015\u0014\u0011NA7!\u001d1\u00131LA0\u0003\u0017J1!!\u0018(\u0005\u0019!V\u000f\u001d7feA\u0019a%!\u0019\n\u0007\u0005\rtE\u0001\u0003M_:<\u0007BBA43\u0001\u0007q0A\u0006gC&dWO]3UsB,\u0007bBA63\u0001\u0007\u0011qL\u0001\u0004]><\bbBA83\u0001\u0007\u0011\u0011O\u0001\u000fe\u0016$(/\u001f+j[\u0016|W\u000f^'t!\r1\u00131O\u0005\u0004\u0003k:#aA%oi\u0006\t\"/Z:fi\u0016\u0003xn\u00195Va\u0012\fG/Z:\u0015\u0003u\n\u0001c\u00197fCJd\u0015N\\6GC&dWO]3\u0015\t\u0005-\u0013q\u0010\u0005\b\u0003\u0003[\u0002\u0019AA&\u00035A\u0017m\u001d(foJ+7m\u001c:eg\u0006YQ.\u001b:s_J\u001cF/\u0019;f)\u0019\t9)a(\u00022B!\u0011\u0011RAM\u001d\u0011\tY)!&\u000e\u0005\u00055%\u0002BAH\u0003#\u000bqA]3qY&\u001c\u0017MC\u0002\u0002\u0014\u0002\faaY8n[>t\u0017\u0002BAL\u0003\u001b\u000bQBU3qY&\u001c\u0017m\u0015;biV\u001c\u0018\u0002BAN\u0003;\u0013!\"T5se>\u0014\u0018J\u001c4p\u0015\u0011\t9*!$\t\u000f\u0005\u0005F\u00041\u0001\u0002$\u0006)\u0002/\u001a:tSN$XM\u001c;NSJ\u0014xN]*uCR,\u0007\u0003BAS\u0003WsA!!#\u0002(&!\u0011\u0011VAO\u0003)i\u0015N\u001d:pe&sgm\\\u0005\u0005\u0003[\u000byKA\u0003Ti\u0006$XM\u0003\u0003\u0002*\u0006u\u0005bBAZ9\u0001\u0007\u0011QW\u0001\u0016CZ\f\u0017\u000e\\1cS2LG/_#yG\u0016\u0004H/[8o!\u00111S0a.\u0011\t\u0005e\u0016qX\u0007\u0003\u0003wSA!!0\u0002\u0012\u00061QM\u001d:peNLA!!1\u0002<\na\u0011\t]5Fq\u000e,\u0007\u000f^5p]\u0002")
public class PartitionAndState {
    private final Partition partition;
    private volatile EpochUpdateState lastEpochUpdateState;
    private Metadata.LeaderAndEpoch sourceLeaderAndEpoch;
    private final AtomicLong failureStartMs;
    private volatile Option<MirrorFailureType> lastFailureType;
    private volatile Option<MirrorFailureType> apiFailureType;
    private volatile Option<FetchState> fetchState;
    private volatile Option<ClusterLinkFetcherThread> fetcherThread;

    public Partition partition() {
        return this.partition;
    }

    public EpochUpdateState lastEpochUpdateState() {
        return this.lastEpochUpdateState;
    }

    public void lastEpochUpdateState_$eq(EpochUpdateState x$1) {
        this.lastEpochUpdateState = x$1;
    }

    public Metadata.LeaderAndEpoch sourceLeaderAndEpoch() {
        return this.sourceLeaderAndEpoch;
    }

    public void sourceLeaderAndEpoch_$eq(Metadata.LeaderAndEpoch x$1) {
        this.sourceLeaderAndEpoch = x$1;
    }

    public AtomicLong failureStartMs() {
        return this.failureStartMs;
    }

    public Option<MirrorFailureType> lastFailureType() {
        return this.lastFailureType;
    }

    public void lastFailureType_$eq(Option<MirrorFailureType> x$1) {
        this.lastFailureType = x$1;
    }

    public Option<MirrorFailureType> apiFailureType() {
        return this.apiFailureType;
    }

    public void apiFailureType_$eq(Option<MirrorFailureType> x$1) {
        this.apiFailureType = x$1;
    }

    public Option<FetchState> fetchState() {
        return this.fetchState;
    }

    public void fetchState_$eq(Option<FetchState> x$1) {
        this.fetchState = x$1;
    }

    public Option<ClusterLinkFetcherThread> fetcherThread() {
        return this.fetcherThread;
    }

    public void fetcherThread_$eq(Option<ClusterLinkFetcherThread> x$1) {
        this.fetcherThread = x$1;
    }

    public boolean updateEpochState(Metadata.LeaderAndEpoch leaderAndEpoch) {
        BooleanRef updated = BooleanRef.create((boolean)false);
        leaderAndEpoch.epoch.ifPresent(currentEpoch -> {
            Option<Object> option;
            EpochUpdateState epochUpdateState = this.lastEpochUpdateState();
            if (epochUpdateState != null) {
                Option<Object> option2 = epochUpdateState.sourceEpoch();
                int lastEmptyUpdates = epochUpdateState.numEmptyEpochUpdates();
                if (option2 instanceof Some) {
                    int lastEpoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    if (Predef$.MODULE$.Integer2int(currentEpoch) <= lastEpoch) return;
                    this.lastEpochUpdateState_$eq(new EpochUpdateState((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(currentEpoch))), lastEmptyUpdates + 1));
                    updated$1.elem = true;
                    return;
                }
            }
            if (epochUpdateState == null || !None$.MODULE$.equals(option = epochUpdateState.sourceEpoch())) throw new MatchError((Object)epochUpdateState);
            this.lastEpochUpdateState_$eq(new EpochUpdateState((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(currentEpoch))), 1));
            updated$1.elem = true;
        });
        return updated.elem;
    }

    public Tuple2<Object, Object> onLinkFailure(MirrorFailureType failureType, long now, int retryTimeoutMs) {
        boolean apiFailureTypeChanged;
        long remainingRetryMs;
        Option<MirrorFailureType> lastFailureType = this.lastFailureType();
        this.lastFailureType_$eq((Option<MirrorFailureType>)new Some((Object)failureType));
        if (failureType.persistFailure() && !lastFailureType.exists((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.persistFailure()))) {
            this.failureStartMs().set(now);
        } else {
            this.failureStartMs().compareAndSet(0L, now);
        }
        long l = remainingRetryMs = failureType.retriable() ? this.failureStartMs().get() + (long)retryTimeoutMs - now : 0L;
        boolean bl = remainingRetryMs <= 0L || !failureType.retriable() ? !this.apiFailureType().contains((Object)failureType) : (apiFailureTypeChanged = false);
        if (apiFailureTypeChanged) {
            this.apiFailureType_$eq((Option<MirrorFailureType>)new Some((Object)failureType));
        }
        return new Tuple2.mcJZ.sp(remainingRetryMs, apiFailureTypeChanged);
    }

    public void resetEpochUpdates() {
        this.lastEpochUpdateState_$eq(new EpochUpdateState(this.lastEpochUpdateState().sourceEpoch(), 0));
    }

    public boolean clearLinkFailure(boolean hasNewRecords) {
        if (hasNewRecords && this.lastEpochUpdateState().numEmptyEpochUpdates() > 0) {
            this.resetEpochUpdates();
        }
        this.apiFailureType_$eq((Option<MirrorFailureType>)None$.MODULE$);
        this.lastFailureType_$eq((Option<MirrorFailureType>)None$.MODULE$);
        return this.failureStartMs().getAndSet(0L) != 0L;
    }

    public ReplicaStatus.MirrorInfo mirrorState(ReplicaStatus.MirrorInfo.State persistentMirrorState, Option<ApiException> availabilityException) {
        ReplicaStatus.MirrorInfo.State state;
        None$ none$;
        Option<MirrorFailureType> option = this.apiFailureType();
        if (option instanceof Some) {
            none$ = this.apiFailureType();
        } else if (None$.MODULE$.equals(option)) {
            none$ = this.lastEpochUpdateState().numEmptyEpochUpdates() > MirrorFailureType$NoSourceRecords$.MODULE$.ConsecutiveEpochChangeLowerThreshold() ? new Some((Object)MirrorFailureType$NoSourceRecords$.MODULE$) : None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Option<FetchState> currentFetchState = this.fetchState();
        if (ReplicaStatus.MirrorInfo.State.ACTIVE.equals(persistentMirrorState)) {
            ReplicaStatus.MirrorInfo.State state2;
            ReplicaStatus.MirrorInfo.State state3;
            Option option2 = none$.map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.replicaStatusState());
            boolean bl = option2 instanceof Some && ReplicaStatus.MirrorInfo.State.ACTIVE.equals(state3 = (ReplicaStatus.MirrorInfo.State)((Some)option2).value()) ? true : None$.MODULE$.equals(option2);
            if (bl) {
                ReplicaStatus.MirrorInfo.State state4;
                if (availabilityException instanceof Some) {
                    ApiException e = (ApiException)((Object)((Some)availabilityException).value());
                    state4 = (ReplicaStatus.MirrorInfo.State)MirrorFailureType$.MODULE$.failureType(e).map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.replicaStatusState()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ReplicaStatus.MirrorInfo.State.ACTIVE);
                } else {
                    state4 = ReplicaStatus.MirrorInfo.State.ACTIVE;
                }
                state2 = state4;
            } else if (option2 instanceof Some) {
                state2 = (ReplicaStatus.MirrorInfo.State)((Some)option2).value();
            } else {
                throw new MatchError((Object)option2);
            }
            state = state2;
        } else {
            state = persistentMirrorState;
        }
        return new ReplicaStatus.MirrorInfo(state, BoxesRunTime.unboxToLong((Object)currentFetchState.map((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToLong((long)x$34.lastFetchTimeMs())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), BoxesRunTime.unboxToLong((Object)currentFetchState.map((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToLong((long)x$35.lastFetchHighWatermark())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
    }

    public PartitionAndState(Partition partition, EpochUpdateState lastEpochUpdateState) {
        this.partition = partition;
        this.lastEpochUpdateState = lastEpochUpdateState;
        this.sourceLeaderAndEpoch = Metadata.LeaderAndEpoch.noLeaderOrEpoch();
        this.failureStartMs = new AtomicLong();
        this.lastFailureType = None$.MODULE$;
        this.apiFailureType = None$.MODULE$;
        this.fetchState = None$.MODULE$;
        this.fetcherThread = None$.MODULE$;
    }
}

