/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.utils.CoreUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0016-\u0001MB\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005}!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0011!Y\u0005A!b\u0001\n\u0003a\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"A1\u000e\u0001BC\u0002\u0013\u0005A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003n\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001dQ\bA1A\u0005\nmDq!!\u0002\u0001A\u0003%A\u0010C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u00111\u0004\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\u001e\u0001\u0001\r\u0011\"\u0003\u0002 !I\u0011q\u0005\u0001A\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003k\u0001\u0001\u0015)\u0003\u0002\"!I\u0011q\u0007\u0001A\u0002\u0013%\u0011\u0011\b\u0005\n\u0003\u0003\u0002\u0001\u0019!C\u0005\u0003\u0007B\u0001\"a\u0012\u0001A\u0003&\u00111\b\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003?A\u0011\"a\u0013\u0001\u0001\u0004%I!!\u0014\t\u0011\u0005E\u0003\u0001)Q\u0005\u0003CA\u0011\"a\u0015\u0001\u0005\u0004%I!!\u0016\t\u000f\u0005]\u0003\u0001)A\u00053\"9\u0011\u0011\f\u0001\u0005R\u0005m\u0003bBA/\u0001\u0011%\u0011q\f\u0005\b\u0003\u0003\u0003A\u0011BAB\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!&\u0001\t\u0013\t9\nC\u0004\u0002B\u0002!I!a1\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\b\u0002CA}\u0001\u0011\u0005A&a?\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0013\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0005O\u0001A\u0011\u0001B\u0015\u0011!\u0011y\u0003\u0001C\u0001Y\u0005}\u0001b\u0002B\u0019\u0001\u0011\u0005\u0011\u0011\b\u0002\u0014\u00072,8\u000f^3s\u0019&t7nU=oG\u0006\u001bGn\u001d\u0006\u0003[9\nA\u0001\\5oW*\u0011q\u0006M\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003E\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001iA\u0011Q'\u000f\b\u0003m]j\u0011\u0001L\u0005\u0003q1\nAc\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018B\u0001\u001e<\u00051\u0001VM]5pI&\u001cG+Y:l\u0015\tAD&A\u0007dY&,g\u000e^'b]\u0006<WM]\u000b\u0002}A\u0011agP\u0005\u0003\u00012\u0012\u0001d\u00117vgR,'\u000fT5oW\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u00039\u0019G.[3oi6\u000bg.Y4fe\u0002\n\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\u0011q\tM\u0001\u0003u.L!!\u0013$\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ,\u0012!\u0014\t\u0003m9K!a\u0014\u0017\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002!5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u00053fgR\fE-\\5o\r\u0006\u001cGo\u001c:z+\u0005\u0019\u0006c\u0001+X36\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVKA\u0005Gk:\u001cG/[8oaA\u0011!\fZ\u0007\u00027*\u0011A,X\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003=~\u000bqa\u00197jK:$8O\u0003\u00022A*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0013\t)7L\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002#\u0011,7\u000f^!e[&tg)Y2u_JL\b%A\u0004nKR\u0014\u0018nY:\u0011\u0005YJ\u0017B\u00016-\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u00027\u0005\u001cGNQ5oI&twMR5mi\u0016\u0014HK]1og\u001a|'/\\3s+\u0005i\u0007C\u0001\u001co\u0013\tyGFA\u000eBG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feR\u0013\u0018M\\:g_JlWM]\u0001\u001dC\u000ed')\u001b8eS:<g)\u001b7uKJ$&/\u00198tM>\u0014X.\u001a:!\u0003\u0019a\u0014N\\5u}Q91\u000f^;wobL\bC\u0001\u001c\u0001\u0011\u0015aD\u00021\u0001?\u0011\u0015\u0011E\u00021\u0001E\u0011\u0015YE\u00021\u0001N\u0011\u0015\tF\u00021\u0001T\u0011\u00159G\u00021\u0001i\u0011\u0015YG\u00021\u0001n\u0003\u0019a\u0017N\\6JIV\tA\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f~\u000baaY8n[>t\u0017bAA\u0002}\n!Q+^5e\u0003\u001da\u0017N\\6JI\u0002\nA\"Y2m\u0019&t7.\u00133TKR,\"!a\u0003\u0011\u000b\u00055\u0011q\u0003?\u000e\u0005\u0005=!\u0002BA\t\u0003'\tA!\u001e;jY*\u0011\u0011QC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001a\u0005=!aA*fi\u0006i\u0011m\u00197MS:\\\u0017\nZ*fi\u0002\n\u0001\u0003^1tWN|U\u000f^:uC:$\u0017N\\4\u0016\u0005\u0005\u0005\u0002c\u0001+\u0002$%\u0019\u0011QE+\u0003\u0007%sG/\u0001\u000buCN\\7oT;ugR\fg\u000eZ5oO~#S-\u001d\u000b\u0005\u0003W\t\t\u0004E\u0002U\u0003[I1!a\fV\u0005\u0011)f.\u001b;\t\u0013\u0005M\"#!AA\u0002\u0005\u0005\u0012a\u0001=%c\u0005\tB/Y:lg>+Ho\u001d;b]\u0012Lgn\u001a\u0011\u0002\u0017%t\u0017\u000e^5bY&TX\rZ\u000b\u0003\u0003w\u00012\u0001VA\u001f\u0013\r\ty$\u0016\u0002\b\u0005>|G.Z1o\u0003=Ig.\u001b;jC2L'0\u001a3`I\u0015\fH\u0003BA\u0016\u0003\u000bB\u0011\"a\r\u0016\u0003\u0003\u0005\r!a\u000f\u0002\u0019%t\u0017\u000e^5bY&TX\r\u001a\u0011\u0002;9,XnU3dkJLG/\u001f#jg\u0006\u0014G.\u001a3Fq\u000e,\u0007\u000f^5p]N\f\u0011E\\;n'\u0016\u001cWO]5us\u0012K7/\u00192mK\u0012,\u0005pY3qi&|gn]0%KF$B!a\u000b\u0002P!I\u00111\u0007\r\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\u001f]Vl7+Z2ve&$\u0018\u0010R5tC\ndW\rZ#yG\u0016\u0004H/[8og\u0002\n\u0011\u0002Z3ti\u0006#W.\u001b8\u0016\u0003e\u000b!\u0002Z3ti\u0006#W.\u001b8!\u0003\r\u0011XO\u001c\u000b\u0003\u0003w\t!\"\u001b8ji&\fG.\u001b>f)\u0011\tY#!\u0019\t\u000f\u0005\rT\u00041\u0001\u0002f\u0005i\u0011m\u00197GS2$XM\u001d'jgR\u0004b!a\u001a\u0002r\u0005UTBAA5\u0015\u0011\tY'!\u001c\u0002\u000f5,H/\u00192mK*\u0019\u0011qN+\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002t\u0005%$A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tYH`\u0001\u0004C\u000ed\u0017\u0002BA@\u0003s\u0012\u0001#Q2m\u0005&tG-\u001b8h\r&dG/\u001a:\u0002\u00151Lgn\u001b$jYR,'\u000f\u0006\u0003\u0002v\u0005\u0015\u0005bBAD=\u0001\u0007\u0011QO\u0001\nC\u000edg)\u001b7uKJ\fq\u0001\\5oW\u0006\u001bG\u000e\u0006\u0003\u0002\u000e\u0006M\u0005\u0003BA<\u0003\u001fKA!!%\u0002z\tQ\u0011i\u00197CS:$\u0017N\\4\t\u000f\u0005mt\u00041\u0001\u0002\u000e\u0006I2-\u001e:sK:$H)Z:u\u0003\u000ed7oV5uQ2Kgn[%e)\u0019\tI*!,\u0002@B1\u00111TAU\u0003\u001bsA!!(\u0002&B\u0019\u0011qT+\u000e\u0005\u0005\u0005&bAARe\u00051AH]8pizJ1!a*V\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011DAV\u0015\r\t9+\u0016\u0005\b\u0003_\u0003\u0003\u0019AAY\u0003\u0011\tW\u000f\u001e5\u0011\t\u0005M\u00161X\u0007\u0003\u0003kSA!a.\u0002:\u0006Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005=z\u0016\u0002BA_\u0003k\u0013!\"Q;uQ>\u0014\u0018N_3s\u0011\u001d\t\u0019\u0007\ta\u0001\u0003K\n!\u0003[1oI2,G)Z:de&\u0014W-Q2mgR1\u00111HAc\u0003\u001bDq!a\u0019\"\u0001\u0004\t9\r\u0005\u0004\u0002h\u0005%\u0017QO\u0005\u0005\u0003\u0017\fIG\u0001\u0006MSN$()\u001e4gKJDq!a4\"\u0001\u0004\t\t.\u0001\u0006gkR,(/\u001a'jgR\u0004b!a\u001a\u0002J\u0006M\u0007#B?\u0002V\u0006e\u0017bAAl}\nY1*\u00194lC\u001a+H/\u001e:f!\u0019\ti!a7\u0002\u000e&!\u0011Q\\A\b\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\u000bkB$\u0017\r^3BG2\u001cHCBA\u001e\u0003G\f)\u000fC\u0004\u0002d\t\u0002\r!a2\t\u000f\u0005\u001d(\u00051\u0001\u0002\u001a\u0006Q1o\\;sG\u0016\f5\r\\:\u0002#\u0011,G.\u001a;f)\",g.\u00113e\u0003\u000ed7\u000f\u0006\u0005\u0002,\u00055\u0018\u0011_A{\u0011\u001d\tyo\ta\u0001\u00033\u000bA\"Y2mgR{7I]3bi\u0016Dq!a=$\u0001\u0004\tI*\u0001\u0007bG2\u001cHk\u001c#fY\u0016$X\rC\u0004\u0002x\u000e\u0002\r!a\u000f\u0002#U\u0004H-\u0019;f\u0013:LG/[1mSj,G-A\u000biC:$G.Z!dY\u0012+G.\u001a;f%\u0016\u001cX\u000f\u001c;\u0015\r\u0005m\u0012Q B\u0004\u0011\u001d\ty\u0010\na\u0001\u0005\u0003\t\u0001\u0003Z3mKR,\u0017i\u00197t%\u0016\u001cX\u000f\u001c;\u0011\u0007i\u0013\u0019!C\u0002\u0003\u0006m\u0013\u0001\u0003R3mKR,\u0017i\u00197t%\u0016\u001cX\u000f\u001c;\t\u000f\t%A\u00051\u0001\u0003\f\u0005\u00112M]3bi\u0016\f5\r\\:DC2d'-Y2l!\u0011!v+a\u000b\u0002\u0015\r\u0014X-\u0019;f\u0003\u000ed7\u000f\u0006\u0004\u0002,\tE!1\u0003\u0005\b\u0003_,\u0003\u0019AAM\u0011\u001d\t90\na\u0001\u0003w\tQ\u0003[1oI2,\u0017i\u00197De\u0016\fG/\u001a*fgVdG\u000f\u0006\u0004\u0002<\te!1\u0005\u0005\b\u000571\u0003\u0019\u0001B\u000f\u0003A\u0019'/Z1uK\u0006\u001bGn\u001d*fgVdG\u000fE\u0002[\u0005?I1A!\t\\\u0005A\u0019%/Z1uK\u0006\u001bGn\u001d*fgVdG\u000fC\u0004\u0002x\u001a\u0002\r!a\u000f\u0002/\r,(O]3oiR\u000b7o[:PkR\u001cH/\u00198eS:<\u0017!\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8h?R!\u00111\u0006B\u0016\u0011\u001d\u0011i\u0003\u000ba\u0001\u0003C\t\u0011\u0001^\u0001%GV\u0014(/\u001a8u\u001dVl7+Z2ve&$\u0018\u0010R5tC\ndW\rZ#yG\u0016\u0004H/[8og\u0006i\u0011n]%oSRL\u0017\r\\5{K\u0012\u0004")
public class ClusterLinkSyncAcls
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkClientManager clientManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetadataManager metadataManager;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private final AclBindingFilterTransformer aclBindingFilterTransformer;
    private final Uuid linkId;
    private final Set<Uuid> aclLinkIdSet;
    private int tasksOutstanding;
    private boolean initialized;
    private int numSecurityDisabledExceptions;
    private final ConfluentAdmin destAdmin;

    public ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    public AclBindingFilterTransformer aclBindingFilterTransformer() {
        return this.aclBindingFilterTransformer;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Set<Uuid> aclLinkIdSet() {
        return this.aclLinkIdSet;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private int numSecurityDisabledExceptions() {
        return this.numSecurityDisabledExceptions;
    }

    private void numSecurityDisabledExceptions_$eq(int x$1) {
        this.numSecurityDisabledExceptions = x$1;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    @Override
    public boolean run() {
        if (this.metadataManager().isLinkCoordinator(this.clientManager().linkData().linkName(), this.metadataManager().isLinkCoordinator$default$2())) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Number of outstanding tasks was not 0 at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            AclFiltersJson aclFilterJson = (AclFiltersJson)this.clientManager().currentConfig().aclFilters().get();
            ListBuffer<AclBindingFilter> aclFilterList = AclJson$.MODULE$.toAclBindingFilters(aclFilterJson);
            if (!this.initialized()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Not initialized for ").append(this.linkId()).append(". Starting initialization process.").toString());
                this.initialize((Buffer<AclBindingFilter>)aclFilterList);
                if (!this.initialized()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Still not initialized for ").append(this.linkId()).append(".").toString());
                    if (this.tasksOutstanding() == 0) {
                        throw new IllegalStateException(new StringBuilder(64).append("Task is not initialized for ").append(this.linkId()).append(" but there are no outstanding tasks.").toString());
                    }
                    return false;
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Now initialized for ").append(this.linkId()).append(".").toString());
            }
            ListBuffer describeAclsFutureList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            aclFilterList.foreach((Function1 & Serializable & scala.Serializable)aclFilter -> {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to retrieve ACLs from source cluster");
                return describeAclsFutureList.$plus$eq((Object)this.clientManager().getAdmin().describeAcls(aclFilter));
            });
            if (describeAclsFutureList.nonEmpty()) {
                ListBuffer futureList = (ListBuffer)describeAclsFutureList.map((Function1 & Serializable & scala.Serializable)result -> result.values(), ListBuffer$.MODULE$.canBuildFrom());
                KafkaFuture future = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futureList.toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
                this.scheduleWhenComplete(future, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleDescribeAcls(aclFilterList, (ListBuffer<KafkaFuture<Collection<AclBinding>>>)futureList));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            }
        }
        return this.tasksOutstanding() == 0;
    }

    private void initialize(Buffer<AclBindingFilter> aclFilterList) {
        if (this.clientManager().getAuthorizer().isDefined()) {
            Authorizer auth = (Authorizer)this.clientManager().getAuthorizer().get();
            scala.collection.immutable.Set<AclBinding> linkAcls = this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)((Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{AclBindingFilter.ANY}))));
            scala.collection.immutable.Set<AclBinding> matchingAcls = this.currentDestAclsWithLinkId(auth, aclFilterList);
            scala.collection.immutable.Set notMatchingLinkAclsToDelete = (scala.collection.immutable.Set)linkAcls.diff(matchingAcls);
            scala.collection.immutable.Set localAclsToCreate = (scala.collection.immutable.Set)notMatchingLinkAclsToDelete.map((Function1 & Serializable & scala.Serializable)acl -> {
                AccessControlEntry ace = acl.entry();
                AccessControlEntry linkAce = new AccessControlEntry(ace.principal(), ace.host(), ace.operation(), ace.permissionType());
                return new AclBinding(acl.pattern(), linkAce);
            }, Set$.MODULE$.canBuildFrom());
            this.deleteThenAddAcls((scala.collection.immutable.Set<AclBinding>)localAclsToCreate, (scala.collection.immutable.Set<AclBinding>)notMatchingLinkAclsToDelete, true);
        }
    }

    private AclBindingFilter linkFilter(AclBindingFilter aclFilter) {
        AccessControlEntryFilter ace = aclFilter.entryFilter();
        AccessControlEntryFilter linkFilter = new AccessControlEntryFilter(ace.principal(), ace.host(), ace.operation(), ace.permissionType(), this.aclLinkIdSet());
        return new AclBindingFilter(aclFilter.patternFilter(), linkFilter);
    }

    private AclBinding linkAcl(AclBinding acl) {
        Collection collection = acl.entry().clusterLinkIds();
        Set<Uuid> set = this.aclLinkIdSet();
        if (!(collection != null ? !((Object)collection).equals(set) : set != null)) {
            return acl;
        }
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, this.aclLinkIdSet());
    }

    private scala.collection.immutable.Set<AclBinding> currentDestAclsWithLinkId(Authorizer auth, Buffer<AclBindingFilter> aclFilterList) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)aclFilterList.map((Function1 & Serializable & scala.Serializable)aclFilter -> this.linkFilter((AclBindingFilter)aclFilter), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)filter -> {
            AclBindingFilter transformedFilter = this.aclBindingFilterTransformer().transform((AclBindingFilter)filter);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Transformed filter from ").append(filter).append(" to ").append(transformedFilter).toString());
            return (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(auth.acls(transformedFilter)).asScala();
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)acl -> this.linkAcl((AclBinding)acl), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    private boolean handleDescribeAcls(ListBuffer<AclBindingFilter> aclFilterList, ListBuffer<KafkaFuture<Collection<AclBinding>>> futureList) {
        Object object = new Object();
        try {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            scala.collection.immutable.Set sourceAcls = ((TraversableForwarder)futureList.flatMap((Function1 & Serializable & scala.Serializable)future -> {
                try {
                    return (Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)future.get()).asScala()).map((Function1 & Serializable & scala.Serializable)acl -> this.linkAcl((AclBinding)acl), scala.collection.Iterable$.MODULE$.canBuildFrom());
                }
                catch (ExecutionException e) {
                    $this.metrics.describeAclsFromSourceFailedSensor().record();
                    Throwable throwable = e.getCause();
                    if (throwable instanceof SecurityDisabledException) {
                        if (this.numSecurityDisabledExceptions() == 0) {
                            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(182).append("Unable to retrieve ACLs on source cluster because no authorizer is configured on the ").append("source cluster. Please configure authorizer to proceed with ACL migration. Encountered exception ").append(e).toString());
                        } else {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(182).append("Unable to retrieve ACLs on source cluster because no authorizer is configured on the ").append("source cluster. Please configure authorizer to proceed with ACL migration. Encountered exception ").append(e).toString());
                        }
                        this.numSecurityDisabledExceptions_$eq(this.numSecurityDisabledExceptions() + 1);
                        throw new NonLocalReturnControl.mcZ.sp(object, true);
                    }
                    if (throwable instanceof AuthorizationException) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(151).append("Unable to retrieve ACLs on source cluster due to authorization failure. ").append("Please enable DESCRIBE ACLs on the source cluster to proceed with ACL migration").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else if (throwable != null) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to retrieve ACLs on source cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else {
                        throw new MatchError(null);
                    }
                    this.numSecurityDisabledExceptions_$eq(0);
                    throw e;
                }
                catch (Throwable e) {
                    $this.metrics.describeAclsFromSourceFailedSensor().record();
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to retrieve ACLs on source cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    this.numSecurityDisabledExceptions_$eq(0);
                    throw e;
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).toSet();
            return this.updateAcls(aclFilterList, (scala.collection.immutable.Set<AclBinding>)sourceAcls);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean updateAcls(ListBuffer<AclBindingFilter> aclFilterList, scala.collection.immutable.Set<AclBinding> sourceAcls) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Result of describeAcls on source cluster for ").append(this.linkId()).append(": ").append(sourceAcls).toString());
        this.clientManager().getAuthorizer().foreach((Function1 & Serializable & scala.Serializable)auth -> {
            ClusterLinkSyncAcls.$anonfun$updateAcls$2(this, aclFilterList, sourceAcls, auth);
            return BoxedUnit.UNIT;
        });
        this.numSecurityDisabledExceptions_$eq(0);
        return this.tasksOutstanding() == 0;
    }

    private void deleteThenAddAcls(scala.collection.immutable.Set<AclBinding> aclsToCreate, scala.collection.immutable.Set<AclBinding> aclsToDelete, boolean updateInitialized) {
        JFunction0.mcV.sp & Serializable & scala.Serializable createAclsCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createAcls(aclsToCreate, updateInitialized);
        if (aclsToDelete.nonEmpty()) {
            try {
                List deleteAclsFilterList = ((TraversableOnce)aclsToDelete.map((Function1 & Serializable & scala.Serializable)acl -> acl.toFilter(), Set$.MODULE$.canBuildFrom())).toList();
                DeleteAclsResult deleteAclsResult = this.destAdmin().deleteAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)deleteAclsFilterList).asJava());
                scala.collection.mutable.Iterable deleteAclsResultFutures = (scala.collection.mutable.Iterable)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAclsResult.values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (KafkaFuture)x$1._2(), Iterable$.MODULE$.canBuildFrom());
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ClusterLinkSyncAcls.$anonfun$deleteThenAddAcls$4(this, deleteAclsResult, (Function0)createAclsCallback)));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                return;
            }
            catch (Throwable e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to delete ACLs on destination cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.metrics.aclsDeleteFailedSensor().record((double)aclsToDelete.size());
                return;
            }
        }
        this.createAcls(aclsToCreate, updateInitialized);
    }

    public boolean handleAclDeleteResult(DeleteAclsResult deleteAclsResult, Function0<BoxedUnit> createAclsCallback) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        BooleanRef err = BooleanRef.create((boolean)false);
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAclsResult.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkSyncAcls.$anonfun$handleAclDeleteResult$1(this, err, x0$1);
            return BoxedUnit.UNIT;
        });
        if (err.elem) {
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(new StringBuilder(42).append("Failed to delete ACLs but there are still ").append(this.tasksOutstanding()).toString());
            }
            return true;
        }
        createAclsCallback.apply$mcV$sp();
        return this.tasksOutstanding() == 0;
    }

    private void createAcls(scala.collection.immutable.Set<AclBinding> aclsToCreate, boolean updateInitialized) {
        if (aclsToCreate.nonEmpty()) {
            try {
                List aclsToCreateList = aclsToCreate.toList();
                CreateAclsResult createAclResult = this.destAdmin().createAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)aclsToCreateList).asJava());
                Map values = createAclResult.values();
                scala.collection.mutable.Iterable createAclsResultFutures = (scala.collection.mutable.Iterable)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(values).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (KafkaFuture)x$2._2(), Iterable$.MODULE$.canBuildFrom());
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleAclCreateResult(createAclResult, updateInitialized));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                return;
            }
            catch (Throwable e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to create ACLs on destination cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.metrics.aclsAddFailedSensor().record((double)aclsToCreate.size());
                return;
            }
        }
        if (updateInitialized) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Updating initialized to true for ").append(this.linkId()).toString());
            this.initialized_$eq(true);
        }
    }

    private boolean handleAclCreateResult(CreateAclsResult createAclsResult, boolean updateInitialized) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        BooleanRef err = BooleanRef.create((boolean)false);
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAclsResult.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkSyncAcls.$anonfun$handleAclCreateResult$1(this, err, x0$1);
            return BoxedUnit.UNIT;
        });
        if (err.elem) {
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(new StringBuilder(42).append("Failed to create ACLs but there are still ").append(this.tasksOutstanding()).toString());
            }
            return true;
        }
        if (updateInitialized) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Updating initialized to true for ").append(this.linkId()).toString());
            this.initialized_$eq(true);
        }
        return this.tasksOutstanding() == 0;
    }

    public int currentTasksOutstanding() {
        return this.tasksOutstanding();
    }

    public void tasksOutstanding_(int t) {
        this.tasksOutstanding_$eq(t);
    }

    public int currentNumSecurityDisabledExceptions() {
        return this.numSecurityDisabledExceptions();
    }

    public boolean isInitialized() {
        return this.initialized();
    }

    public static final /* synthetic */ void $anonfun$updateAcls$2(ClusterLinkSyncAcls $this, ListBuffer aclFilterList$2, scala.collection.immutable.Set sourceAcls$1, Authorizer auth) {
        scala.collection.immutable.Set<AclBinding> currentDestAcls = $this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)aclFilterList$2);
        scala.collection.immutable.Set deletedAcls = (scala.collection.immutable.Set)currentDestAcls.diff((GenSet)sourceAcls$1);
        scala.collection.immutable.Set addedAcls = (scala.collection.immutable.Set)sourceAcls$1.diff(currentDestAcls);
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Removing following ACLs on destination cluster: ").append(deletedAcls).toString());
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Adding following ACLs on destination cluster: ").append(addedAcls).toString());
        $this.deleteThenAddAcls((scala.collection.immutable.Set<AclBinding>)addedAcls, (scala.collection.immutable.Set<AclBinding>)deletedAcls, false);
    }

    public static final /* synthetic */ boolean $anonfun$deleteThenAddAcls$4(ClusterLinkSyncAcls $this, DeleteAclsResult deleteAclsResult$1, Function0 createAclsCallback$1) {
        return $this.handleAclDeleteResult(deleteAclsResult$1, (Function0<BoxedUnit>)createAclsCallback$1);
    }

    public static final /* synthetic */ void $anonfun$handleAclDeleteResult$2(ClusterLinkSyncAcls $this, BooleanRef err$1, DeleteAclsResult.FilterResult aclBindingDeleteResult) {
        if (aclBindingDeleteResult.exception() != null) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Encountered the following exception while trying to delete ACL: ").append((Object)aclBindingDeleteResult.exception()).toString());
            $this.metrics.aclsDeleteFailedSensor().record();
            err$1.elem = true;
            return;
        }
        $this.metrics.aclsDeletedSensor().record();
    }

    public static final /* synthetic */ void $anonfun$handleAclDeleteResult$1(ClusterLinkSyncAcls $this, BooleanRef err$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            try {
                java.util.List filters = ((DeleteAclsResult.FilterResults)((KafkaFuture)x0$1._2()).get()).values();
                ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(filters).asScala()).foreach((Function1 & Serializable & scala.Serializable)aclBindingDeleteResult -> {
                    ClusterLinkSyncAcls.$anonfun$handleAclDeleteResult$2($this, err$1, aclBindingDeleteResult);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (Throwable e) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to delete ACL", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                $this.metrics.aclsDeleteFailedSensor().record();
                err$1.elem = true;
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$handleAclCreateResult$1(ClusterLinkSyncAcls $this, BooleanRef err$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            try {
                ((KafkaFuture)x0$1._2()).get();
                $this.metrics.aclsAddedSensor().record();
                return;
            }
            catch (Throwable e) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to create ACL", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                $this.metrics.aclsAddFailedSensor().record();
                err$2.elem = true;
                return;
            }
        }
        throw new MatchError(null);
    }

    public ClusterLinkSyncAcls(ClusterLinkClientManager clientManager, ClusterLinkData linkData, ClusterLinkMetadataManager metadataManager, Function0<ConfluentAdmin> destAdminFactory, ClusterLinkMetrics metrics, AclBindingFilterTransformer aclBindingFilterTransformer) {
        this.clientManager = clientManager;
        this.linkData = linkData;
        this.metadataManager = metadataManager;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        this.aclBindingFilterTransformer = aclBindingFilterTransformer;
        super(clientManager.scheduler(), "ClusterLinkSyncAcls", Predef$.MODULE$.Integer2int(clientManager.currentConfig().aclSyncMs()));
        this.linkId = CoreUtils$.MODULE$.toKafkaUUID(linkData.linkId());
        this.aclLinkIdSet = Collections.singleton(this.linkId());
        this.tasksOutstanding = 0;
        this.initialized = false;
        this.numSecurityDisabledExceptions = 0;
        this.destAdmin = (ConfluentAdmin)destAdminFactory.apply();
    }
}

