/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.controller.KafkaController;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.KafkaConfig;
import kafka.server.MetadataSupport;
import kafka.server.RaftSupport;
import kafka.server.ReplicaManager;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public final class ClusterLinkMetadataManager$ {
    public static ClusterLinkMetadataManager$ MODULE$;

    static {
        new ClusterLinkMetadataManager$();
    }

    public ClusterLinkMetadataManager createClusterLinkMetadataManager(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, MetadataSupport metadataSupport, Option<BrokerToControllerChannelManager> controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo, ReplicaManager replicaManager) {
        ClusterLinkMetadataManager clusterLinkMetadataManager;
        if (metadataSupport instanceof ZkSupport) {
            ZkSupport zkSupport = (ZkSupport)metadataSupport;
            KafkaController controller = zkSupport.controller();
            KafkaZkClient zkClient = zkSupport.zkClient();
            ZkMetadataCache metadataCache = zkSupport.metadataCache();
            clusterLinkMetadataManager = new ClusterLinkMetadataManagerWithZkSupport(brokerConfig, scheduler, metadataCache, controller, zkClient, localAdminFactory, replicaManager);
        } else if (metadataSupport instanceof RaftSupport) {
            KRaftMetadataCache metadataCache = ((RaftSupport)metadataSupport).metadataCache();
            if (!(controllerChannelManager instanceof Some)) {
                if (None$.MODULE$.equals(controllerChannelManager)) {
                    throw new IllegalStateException("BrokerToControllerChannelManager is not provided to ClusterLinkManager in KRaft mode");
                }
                throw new MatchError(controllerChannelManager);
            }
            BrokerToControllerChannelManager channelManager = (BrokerToControllerChannelManager)((Some)controllerChannelManager).value();
            ClusterLinkMetadataManagerWithKRaftSupport clusterLinkMetadataManagerWithKRaftSupport = new ClusterLinkMetadataManagerWithKRaftSupport(brokerConfig, scheduler, metadataCache, channelManager, localAdminFactory, serverInfo);
            clusterLinkMetadataManager = clusterLinkMetadataManagerWithKRaftSupport;
        } else {
            throw new MatchError((Object)metadataSupport);
        }
        return clusterLinkMetadataManager;
    }

    private ClusterLinkMetadataManager$() {
        MODULE$ = this;
    }
}

