/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.server.BrokerBlockingSender;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagMetrics;
import kafka.server.KafkaConfig;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread$;
import kafka.server.link.ClusterLinkFetcherThread$AdjustmentType$;
import kafka.server.link.ClusterLinkFetcherThread$MinPartitionLagOrder$;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderEndPoint$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.FetchState;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$IllegalState$;
import kafka.server.link.MirrorFailureType$SourceTopicDeleted$;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011-u!\u00020`\u0011\u00031g!\u00025`\u0011\u0003I\u0007\"\u00029\u0002\t\u0003\t\b\"\u0002:\u0002\t\u0003\u0019xaBB\u0010\u0003!\u00051\u0011\u0005\u0004\b\u0007K\t\u0001\u0012AB\u0014\u0011\u0019\u0001X\u0001\"\u0001\u00040\u001511QE\u0003\u0001\u0007cA\u0011b!\u000f\u0006\u0005\u0004%\taa\u000f\t\u0011\ruR\u0001)A\u0005\u0007cA\u0011ba\u0010\u0006\u0005\u0004%\taa\u000f\t\u0011\r\u0005S\u0001)A\u0005\u0007cA\u0011ba\u0011\u0006\u0005\u0004%\taa\u000f\t\u0011\r\u0015S\u0001)A\u0005\u0007c1aa!1\u0002\u0001\u000e\r\u0007B\u0003Bd\u001d\tU\r\u0011\"\u0001\u0004R\"Q11\u001b\b\u0003\u0012\u0003\u0006IA!\u0007\t\u0015\r}cB!f\u0001\n\u0003\u0019)\u000e\u0003\u0006\u0004X:\u0011\t\u0012)A\u0005\u0005CAa\u0001\u001d\b\u0005\u0002\re\u0007\"CBq\u001d\u0005\u0005I\u0011ABr\u0011%\u0019IODI\u0001\n\u0003\u0019Y\u000fC\u0005\u0005\u00029\t\n\u0011\"\u0001\u0005\u0004!IAq\u0001\b\u0002\u0002\u0013\u0005\u0013Q\u001e\u0005\n\t\u0013q\u0011\u0011!C\u0001\t\u0017A\u0011\u0002\"\u0004\u000f\u0003\u0003%\t\u0001b\u0004\t\u0013\u0011ma\"!A\u0005B\u0011u\u0001\"\u0003C\u0013\u001d\u0005\u0005I\u0011\u0001C\u0014\u0011%!YCDA\u0001\n\u0003\"i\u0003C\u0005\u000509\t\t\u0011\"\u0011\u00052!IA1\u0007\b\u0002\u0002\u0013\u0005CQG\u0004\n\ts\t\u0011\u0011!E\u0001\tw1\u0011b!1\u0002\u0003\u0003E\t\u0001\"\u0010\t\rA\u0004C\u0011\u0001C&\u0011%!y\u0003IA\u0001\n\u000b\"\t\u0004\u0003\u0005sA\u0005\u0005I\u0011\u0011C'\u0011%!\u0019\u0006IA\u0001\n\u0003#)\u0006C\u0005\u0005`\u0001\n\t\u0011\"\u0003\u0005b\u001d9A\u0011N\u0001\t\u0002\u0011-da\u0002C7\u0003!\u0005Aq\u000e\u0005\u0007a\u001e\"\t\u0001b\u001e\t\u000f\u0011et\u0005\"\u0001\u0005|!IAqL\u0014\u0002\u0002\u0013%A\u0011\r\u0005\n\t\u000b\u000b\u0011\u0013!C\u0001\t\u000f3A\u0001[0\u0001k\"A!\u0010\fB\u0001B\u0003%1\u0010\u0003\u0006\u0002\u000e1\u0012\t\u0011)A\u0005\u0003\u001fAA\"!\u0006-\u0005\u0003\u0005\u000b\u0011BA\f\u0003;A!\"a\t-\u0005\u0003\u0005\u000b\u0011BA\u0013\u0011)\tY\u0003\fB\u0001B\u0003%\u0011Q\u0006\u0005\u000b\u0003ga#\u0011!Q\u0001\n\u0005U\u0002BCA\u001eY\t\u0005\t\u0015!\u0003\u0002>!Q\u00111\t\u0017\u0003\u0002\u0003\u0006I!!\u0012\t\u0015\u0005-CF!A!\u0002\u0013\ti\u0005\u0003\u0006\u0002T1\u0012\t\u0011)A\u0005\u0003+B!\"a\u0017-\u0005\u0003\u0005\u000b\u0011BA/\u0011)\t\u0019\u0007\fB\u0001B\u0003%\u0011Q\r\u0005\u000b\u0003\u007fb#\u0011!Q\u0001\n\u0005\u0005\u0005bCAGY\t\u0015\r\u0011\"\u0001`\u0003\u001fC!\"a&-\u0005\u0003\u0005\u000b\u0011BAI\u0011)\tI\n\fB\u0001B\u0003%\u00111\u0014\u0005\u000b\u0003Oc#\u0011!Q\u0001\n\u0005%\u0006B\u00029-\t\u0003\tY\u000bC\u0005\u0002N2\u0012\r\u0011\"\u0003\u0002P\"A\u0011\u0011\u001d\u0017!\u0002\u0013\t\t\u000eC\u0005\u0002d2\u0012\r\u0011\"\u0003\u0002P\"A\u0011Q\u001d\u0017!\u0002\u0013\t\t\u000eC\u0005\u0002h2\u0012\r\u0011\"\u0003\u0002P\"A\u0011\u0011\u001e\u0017!\u0002\u0013\t\t\u000eC\u0005\u0002l2\u0012\r\u0011\"\u0003\u0002n\"A\u00111\u001f\u0017!\u0002\u0013\ty\u000fC\u0005\u0002v2\u0012\r\u0011\"\u0003\u0002x\"A!1\u0001\u0017!\u0002\u0013\tI\u0010C\u0005\u0003\u00061\u0012\r\u0011\"\u0003\u0003\b!A!q\u0005\u0017!\u0002\u0013\u0011I\u0001C\u0004\u0003*1\"\tEa\u000b\t\u0013\tMBF1A\u0005B\tU\u0002\u0002\u0003B\u001fY\u0001\u0006IAa\u000e\t\u000f\t}B\u0006\"\u0015\u0003B!9!1\u000b\u0017\u0005R\tU\u0003b\u0002B/Y\u0011E#q\f\u0005\b\u0005sbC\u0011\tB>\u0011!\u0011I\t\fC)?\n-\u0005b\u0002BOY\u0011\u0005#q\u0014\u0005\b\u0005\u0003dC\u0011\tBb\u0011!\u00119\u000f\fC\u0001?\n%\bb\u0002BwY\u0011\u0005#q\u001e\u0005\b\u0007\u0007aC\u0011AB\u0003\u0011\u001d\u0019i\u0005\fC\t\u0007\u001fB\u0001b!\u0016-\t\u0003y&1\u0006\u0005\b\u0007/bC\u0011IB-\u0011\u001d\u0019\t\u0007\fC!\u0007GBqaa\u001b-\t\u0013\u0019i\u0007\u0003\u0005\u0004\n2\"\taXBF\u0003a\u0019E.^:uKJd\u0015N\\6GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0006\u0003A\u0006\fA\u0001\\5oW*\u0011!mY\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0011\fQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002h\u00035\tqL\u0001\rDYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001c\"!\u00016\u0011\u0005-tW\"\u00017\u000b\u00035\fQa]2bY\u0006L!a\u001c7\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta-A\u0003baBd\u0017\u0010F\u0010u\u0007'\u001b)ja&\u0004\u001a\u000em5QTBP\u0007S\u001b\u0019l!.\u00048\u000ee61XB_\u0007\u007f\u0003\"a\u001a\u0017\u0014\u000512\bCA<y\u001b\u0005\t\u0017BA=b\u0005Q\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bI\u0006!a.Y7f!\ra\u0018q\u0001\b\u0004{\u0006\r\u0001C\u0001@m\u001b\u0005y(bAA\u0001K\u00061AH]8pizJ1!!\u0002m\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u00017\u0002\u0013\u0019,Go\u00195fe&#\u0007cA6\u0002\u0012%\u0019\u00111\u00037\u0003\u0007%sG/\u0001\u0004mK\u0006$WM\u001d\t\u0004O\u0006e\u0011bAA\u000e?\nI2\t\\;ti\u0016\u0014H*\u001b8l\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0013\u0011\t)\"a\b\n\u0007\u0005\u0005\u0012MA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0007]\f9#C\u0002\u0002*\u0005\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0011\u0007\u001d\fy#C\u0002\u00022}\u0013\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003M\u0019G.^:uKJd\u0015N\\6NKR\fG-\u0019;b!\r9\u0017qG\u0005\u0004\u0003sy&aE\"mkN$XM\u001d'j].lU\r^1eCR\f\u0017A\u00044fi\u000eDWM]'b]\u0006<WM\u001d\t\u0004O\u0006}\u0012bAA!?\nI2\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fE\u0002x\u0003\u000fJ1!!\u0013b\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\u0006sKBd\u0017nY1NOJ\u00042a^A(\u0013\r\t\t&\u0019\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\r9\u0018qK\u0005\u0004\u00033\n'\u0001\u0004*fa2L7-Y)v_R\f\u0017AE2mkN$XM\u001d'j].lU\r\u001e:jGN\u00042aZA0\u0013\r\t\tg\u0018\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0003uS6,\u0007\u0003BA4\u0003wj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0006kRLGn\u001d\u0006\u0005\u0003_\n\t(\u0001\u0004d_6lwN\u001c\u0006\u0004I\u0006M$\u0002BA;\u0003o\na!\u00199bG\",'BAA=\u0003\ry'oZ\u0005\u0005\u0003{\nIG\u0001\u0003US6,\u0017\u0001\u00053z]\u0006l\u0017n\u0019$fi\u000eD7+\u001b>f!\u0015Y\u00171QAD\u0013\r\t)\t\u001c\u0002\n\rVt7\r^5p]B\u00022aZAE\u0013\r\tYi\u0018\u0002\u0012\r\u0016$8\r\u001b*fgB|gn]3TSj,\u0017!E2mkN$XM\u001d'j].\u001cE.[3oiV\u0011\u0011\u0011\u0013\t\u0004O\u0006M\u0015bAAK?\nA2\t\\;ti\u0016\u0014H*\u001b8l\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0002%\rdWo\u001d;fe2Kgn[\"mS\u0016tG\u000fI\u0001\u000eY><7i\u001c8uKb$x\n\u001d;\u0011\u000b-\fi*!)\n\u0007\u0005}EN\u0001\u0004PaRLwN\u001c\t\u0005\u0003O\n\u0019+\u0003\u0003\u0002&\u0006%$A\u0003'pO\u000e{g\u000e^3yi\u00061A/\u001a8b]R\u0004Ba[AOwR\tC/!,\u00020\u0006E\u00161WA[\u0003o\u000bI,a/\u0002>\u0006}\u0016\u0011YAb\u0003\u000b\f9-!3\u0002L\")!P\u0010a\u0001w\"9\u0011Q\u0002 A\u0002\u0005=\u0001bBA\u000b}\u0001\u0007\u0011q\u0003\u0005\b\u0003Gq\u0004\u0019AA\u0013\u0011\u001d\tYC\u0010a\u0001\u0003[Aq!a\r?\u0001\u0004\t)\u0004C\u0004\u0002<y\u0002\r!!\u0010\t\u000f\u0005\rc\b1\u0001\u0002F!9\u00111\n A\u0002\u00055\u0003bBA*}\u0001\u0007\u0011Q\u000b\u0005\b\u00037r\u0004\u0019AA/\u0011\u001d\t\u0019G\u0010a\u0001\u0003KBq!a ?\u0001\u0004\t\t\tC\u0004\u0002\u000ez\u0002\r!!%\t\u0013\u0005ee\b%AA\u0002\u0005m\u0005bBAT}\u0001\u0007\u0011\u0011V\u0001\u0017Y&t7NR3uG\",'O\u00127po\u000e{g\u000e\u001e:pYV\u0011\u0011\u0011\u001b\t\u0005\u0003'\fi.\u0004\u0002\u0002V*!\u0011q[Am\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0017\u0001\u00026bm\u0006LA!a8\u0002V\n9\u0011J\u001c;fO\u0016\u0014\u0018a\u00067j].4U\r^2iKJ4En\\<D_:$(o\u001c7!\u0003}a\u0017N\\6GKR\u001c\u0007.\u001a:NCbd\u0015mZ4j]\u001e\u0004\u0016M\u001d;ji&|gn]\u0001!Y&t7NR3uG\",'/T1y\u0019\u0006<w-\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\b%A\u000fmS:\\g)\u001a;dQ\u0016\u0014H*Y4hS:<\u0007+\u0019:uSRLwN\\'t\u0003ya\u0017N\\6GKR\u001c\u0007.\u001a:MC\u001e<\u0017N\\4QCJ$\u0018\u000e^5p]6\u001b\b%\u0001\nv]B\u0014XMZ5yK\u0012d\u0015N\\6OC6,WCAAx!\u0011\t\u0019.!=\n\t\u0005%\u0011Q[\u0001\u0014k:\u0004(/\u001a4jq\u0016$G*\u001b8l\u001d\u0006lW\rI\u0001\b[\u0016$(/[2t+\t\tI\u0010\u0005\u0003\u0002|\u0006}XBAA\u007f\u0015\u0011\t)0!\u001c\n\t\t\u0005\u0011Q \u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013a\u00079beRLG/[8o\u0019\u0006\u001cHoQ1vO\"$X\u000b\u001d+j[\u0016l5/\u0006\u0002\u0003\nAA!1\u0002B\u000b\u00053\u0011\t#\u0004\u0002\u0003\u000e)!!q\u0002B\t\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005'\tI.\u0001\u0003vi&d\u0017\u0002\u0002B\f\u0005\u001b\u0011\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\u0011YB!\b\u000e\u0005\u00055\u0014\u0002\u0002B\u0010\u0003[\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002l\u0005GI1A!\nm\u0005\u0011auN\\4\u00029A\f'\u000f^5uS>tG*Y:u\u0007\u0006,x\r\u001b;VaRKW.Z'tA\u00051Am\\,pe.$\"A!\f\u0011\u0007-\u0014y#C\u0002\u000321\u0014A!\u00168ji\u0006y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\t]\u0002cA6\u0003:%\u0019!1\b7\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0013n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3!\u00039ygn\u00144gg\u0016$H+[3sK\u0012$bAa\u000e\u0003D\t\u001d\u0003b\u0002B#\u001d\u0002\u0007!\u0011D\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\u0011IE\u0014a\u0001\u0005\u0017\nAB]3rk\u0016\u001cH/\u00129pG\"\u0004bA!\u0014\u0003P\u0005EWB\u0001B\t\u0013\u0011\u0011\tF!\u0005\u0003\u0011=\u0003H/[8oC2\f\u0011c\u001c8QCJ$\u0018\u000e^5p]\u001a+gnY3e)\u0019\u00119Da\u0016\u0003\\!9!\u0011L(A\u0002\te\u0011A\u0001;q\u0011\u001d\u0011Ie\u0014a\u0001\u0005\u0017\n\u0001\u0004[1oI2,\u0007+\u0019:uSRLwN\\#yG\u0016\u0004H/[8o)\u0019\u00119D!\u0019\u0003d!9!\u0011\f)A\u0002\te\u0001b\u0002B3!\u0002\u0007!qM\u0001\u0002KB!!\u0011\u000eB:\u001d\u0011\u0011YGa\u001c\u000f\u0007y\u0014i'C\u0001n\u0013\r\u0011\t\b\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Ha\u001e\u0003\u0013\u0015C8-\u001a9uS>t'b\u0001B9Y\u0006AAO];oG\u0006$X\r\u0006\u0004\u0003.\tu$q\u0010\u0005\b\u00053\n\u0006\u0019\u0001B\r\u0011\u001d\u0011\t)\u0015a\u0001\u0005\u0007\u000bQc\u001c4gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002x\u0005\u000bK1Aa\"b\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq&\u001e9eCR,g)\u001a;dQ>3gm]3u\u0003:$W*Y=cK6\u000b'o\u001b+sk:\u001c\u0017\r^5p]\u000e{W\u000e\u001d7fi\u0016$BA!\f\u0003\u000e\"9!q\u0012*A\u0002\tE\u0015\u0001\u00044fi\u000eDwJ\u001a4tKR\u001c\b\u0003\u0003BJ\u00053\u0013IBa!\u000e\u0005\tU%b\u0001BLY\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm%Q\u0013\u0002\u0004\u001b\u0006\u0004\u0018\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0003\"\n=&\u0011\u0017B[!\u0015Y\u0017Q\u0014BR!\u0011\u0011)Ka+\u000e\u0005\t\u001d&b\u0001BUG\u0006\u0019An\\4\n\t\t5&q\u0015\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\te3\u000b1\u0001\u0003\u001a!9!1W*A\u0002\t\u0005\u0012a\u00034fi\u000eDwJ\u001a4tKRDqAa.T\u0001\u0004\u0011I,A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0005w\u0013i,D\u0001-\u0013\u0011\u0011y,a\b\u0003\u0013\u0019+Go\u00195ECR\f\u0017!I;qI\u0006$X\rS5hQ^\u000bG/\u001a:nCJ\\\u0017I\u001c3Ti\u0006\u0014Ho\u00144gg\u0016$HC\u0003B\u0011\u0005\u000b\u0014)N!8\u0003b\"9!q\u0019+A\u0002\t%\u0017!\u00039beRLG/[8o!\u0011\u0011YM!5\u000e\u0005\t5'b\u0001BhG\u000691\r\\;ti\u0016\u0014\u0018\u0002\u0002Bj\u0005\u001b\u0014\u0011\u0002U1si&$\u0018n\u001c8\t\u000f\t%F\u000b1\u0001\u0003XB!!Q\u0015Bm\u0013\u0011\u0011YNa*\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u0005?$\u0006\u0019\u0001B\u0011\u0003e\u0019x.\u001e:dK2+\u0017\rZ3s\u0011&<\u0007nV1uKJl\u0017M]6\t\u000f\t\rH\u000b1\u0001\u0003f\u0006Q2o\\;sG\u0016dU-\u00193fe2{wm\u0015;beR|eMZ:fiB)1.!(\u0003\"\u0005AR.Y=cK:{G/\u001b4z%\u0016\fG-\u001f$pe\u001a+Go\u00195\u0015\t\t5\"1\u001e\u0005\b\u0005\u000f,\u0006\u0019\u0001Be\u0003A\u0011X-\\8wKB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003r\ne\b\u0003\u0003BJ\u00053\u0013IBa=\u0011\u0007]\u0014)0C\u0002\u0003x\u0006\u00141\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016DqAa?W\u0001\u0004\u0011i0A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\u0011\u0019Ja@\u0003\u001a%!1\u0011\u0001BK\u0005\r\u0019V\r^\u0001 C\u0012TWo\u001d;MC\u001e<\u0017N\\4QCJ$\u0018\u000e^5p]N\u0014V-];je\u0016$G\u0003BB\u0004\u0007\u0013\u0002ra[B\u0005\u0007\u001b\u00199%C\u0002\u0004\f1\u0014a\u0001V;qY\u0016\u0014\u0004cAB\b\u000f9\u00191\u0011\u0003\u0003\u000f\u0007\rM\u0001A\u0004\u0003\u0004\u0016\rua\u0002BB\f\u00077q1A`B\r\u0013\u0005!\u0017B\u00012d\u0013\t\u0001\u0017-\u0001\bBI*,8\u000f^7f]R$\u0016\u0010]3\u0011\u0007\r\rR!D\u0001\u0002\u00059\tEM[;ti6,g\u000e\u001e+za\u0016\u001c2!BB\u0015!\rY71F\u0005\u0004\u0007[a'aC#ok6,'/\u0019;j_:$\"a!\t\u0011\t\rM2QG\u0007\u0002\u000b%!1qGB\u0016\u0005\u00151\u0016\r\\;f\u00031qu.\u00113kkN$X.\u001a8u+\t\u0019\t$A\u0007O_\u0006#'.^:u[\u0016tG\u000fI\u0001\t\u0013:\u001c'/Z1tK\u0006I\u0011J\\2sK\u0006\u001cX\rI\u0001\t\t\u0016\u001c'/Z1tK\u0006IA)Z2sK\u0006\u001cX\r\t\t\u0006W\u0006u%Q \u0005\b\u0007\u0017:\u0006\u0019\u0001B\u0011\u0003\u0015qwn^'t\u0003e\u0019G.Z1s!\u0006\u0014H/\u001b;j_:d\u0015N\\6GC&dWO]3\u0015\r\t52\u0011KB*\u0011\u001d\u0011I\u0006\u0017a\u0001\u00053AqAa-Y\u0001\u0004\u0011\t#\u0001\fva\u0012\fG/\u001a#z]\u0006l\u0017n\u0019$fi\u000eD7+\u001b>f\u0003U)\b\u000fZ1uK\u001a+Go\u00195fe2\u000bwm\u0015;biN$bA!\f\u0004\\\ru\u0003b\u0002B-5\u0002\u0007!\u0011\u0004\u0005\b\u0007?R\u0006\u0019\u0001B\u0011\u0003\ra\u0017mZ\u0001\u0016kB$\u0017\r^3GKR\u001c\u0007.\u001a:CsR,'+\u0019;f)\u0019\u0011ic!\u001a\u0004h!9!\u0011L.A\u0002\te\u0001bBB57\u0002\u0007!\u0011E\u0001\u0006Ef$Xm]\u0001\u0017O\u0016$xJ]\"sK\u0006$X\rV8qS\u000e\u001cVM\\:peRQ1qNB;\u0007s\u001aYh!\"\u0011\t\u0005m8\u0011O\u0005\u0005\u0007g\niP\u0001\u0004TK:\u001cxN\u001d\u0005\u0007\u0007ob\u0006\u0019A>\u0002\u000bQ|\u0007/[2\t\u000bid\u0006\u0019A>\t\u000f\ruD\f1\u0001\u0004\u0000\u0005!1\u000f^1u!\u0011\tYp!!\n\t\r\r\u0015Q \u0002\u000f\u001b\u0016\f7/\u001e:bE2,7\u000b^1u\u0011\u0019\u00199\t\u0018a\u0001w\u0006YA-Z:de&\u0004H/[8o\u0003})\b\u000fZ1uKB\u000b'\u000f^5uS>tG*Y:u\u0007\u0006,x\r\u001b;VaRKW.\u001a\u000b\u0007\u0005[\u0019iia$\t\u000f\teS\f1\u0001\u0003\u001a!91\u0011S/A\u0002\t\u0005\u0012AD2bk\u001eDG/\u00169US6,Wj\u001d\u0005\u0006u\u000e\u0001\ra\u001f\u0005\b\u0003\u001b\u0019\u0001\u0019AA\b\u0011\u001d\t\u0019c\u0001a\u0001\u0003KAq!a\u000b\u0004\u0001\u0004\ti\u0003C\u0004\u00024\r\u0001\r!!\u000e\t\u000f\u0005m2\u00011\u0001\u0002>!91\u0011U\u0002A\u0002\r\r\u0016!\u00063fgR\u001cuN\u001c8fGRLwN\\'b]\u0006<WM\u001d\t\u0004O\u000e\u0015\u0016bABT?\n\u00013\t\\;ti\u0016\u0014H*\u001b8l\t\u0016\u001cHoQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0011\u001d\u0019Yk\u0001a\u0001\u0007[\u000bAb]8ve\u000e,'I]8lKJ\u0004BAa3\u00040&!1\u0011\u0017Bg\u00059\u0011%o\\6fe\u0016sG\rU8j]RDq!a\u0011\u0004\u0001\u0004\t)\u0005C\u0004\u0002L\r\u0001\r!!\u0014\t\u000f\u0005M3\u00011\u0001\u0002V!9\u00111L\u0002A\u0002\u0005u\u0003bBA2\u0007\u0001\u0007\u0011Q\r\u0005\b\u0003O\u001b\u0001\u0019AAU\u0011\u001d\tyh\u0001a\u0001\u0003\u0003\u0013q\u0002U1si&$\u0018n\u001c8B]\u0012d\u0015mZ\n\u0007\u001d)\u001c)ma3\u0011\u0007-\u001c9-C\u0002\u0004J2\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002l\u0007\u001bL1aa4m\u00051\u0019VM]5bY&T\u0018M\u00197f+\t\u0011I\"\u0001\u0006qCJ$\u0018\u000e^5p]\u0002*\"A!\t\u0002\t1\fw\r\t\u000b\u0007\u00077\u001cina8\u0011\u0007\r\rb\u0002C\u0004\u0003HN\u0001\rA!\u0007\t\u000f\r}3\u00031\u0001\u0003\"\u0005!1m\u001c9z)\u0019\u0019Yn!:\u0004h\"I!q\u0019\u000b\u0011\u0002\u0003\u0007!\u0011\u0004\u0005\n\u0007?\"\u0002\u0013!a\u0001\u0005C\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004n*\"!\u0011DBxW\t\u0019\t\u0010\u0005\u0003\u0004t\u000euXBAB{\u0015\u0011\u00199p!?\u0002\u0013Ut7\r[3dW\u0016$'bAB~Y\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r}8Q\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\t\u000bQCA!\t\u0004p\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0004\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!A\u0011\u0003C\f!\rYG1C\u0005\u0004\t+a'aA!os\"IA\u0011D\r\u0002\u0002\u0003\u0007\u0011qB\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0011}\u0001C\u0002BJ\tC!\t\"\u0003\u0003\u0005$\tU%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u000e\u0005*!IA\u0011D\u000e\u0002\u0002\u0003\u0007A\u0011C\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qB\u0001\ti>\u001cFO]5oOR\u0011\u0011q^\u0001\u0007KF,\u0018\r\\:\u0015\t\t]Bq\u0007\u0005\n\t3q\u0012\u0011!a\u0001\t#\tq\u0002U1si&$\u0018n\u001c8B]\u0012d\u0015m\u001a\t\u0004\u0007G\u00013#\u0002\u0011\u0005@\r-\u0007C\u0003C!\t\u000f\u0012IB!\t\u0004\\6\u0011A1\t\u0006\u0004\t\u000bb\u0017a\u0002:v]RLW.Z\u0005\u0005\t\u0013\"\u0019EA\tBEN$(/Y2u\rVt7\r^5p]J\"\"\u0001b\u000f\u0015\r\rmGq\nC)\u0011\u001d\u00119m\ta\u0001\u00053Aqaa\u0018$\u0001\u0004\u0011\t#A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0011]C1\f\t\u0006W\u0006uE\u0011\f\t\bW\u000e%!\u0011\u0004B\u0011\u0011%!i\u0006JA\u0001\u0002\u0004\u0019Y.A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011A1\r\t\u0005\u0003'$)'\u0003\u0003\u0005h\u0005U'AB(cU\u0016\u001cG/\u0001\u000bNS:\u0004\u0016M\u001d;ji&|g\u000eT1h\u001fJ$WM\u001d\t\u0004\u0007G9#\u0001F'j]B\u000b'\u000f^5uS>tG*Y4Pe\u0012,'oE\u0003(\tG\"\t\b\u0005\u0004\u0003j\u0011M41\\\u0005\u0005\tk\u00129H\u0001\u0005Pe\u0012,'/\u001b8h)\t!Y'A\u0004d_6\u0004\u0018M]3\u0015\r\u0005=AQ\u0010CA\u0011\u001d!y(\u000ba\u0001\u00077\f\u0011\u0001\u001f\u0005\b\t\u0007K\u0003\u0019ABn\u0003\u0005I\u0018\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'N\u000b\u0003\t\u0013SC!a'\u0004p\u0002")
public class ClusterLinkFetcherThread
extends ReplicaFetcherThread {
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final ClusterLinkFetcherManager fetcherManager;
    private final ReplicaManager replicaMgr;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final Time time;
    private final Function0<FetchResponseSize> dynamicFetchSize;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final Option<String> tenant;
    private final Integer linkFetcherFlowControl;
    private final Integer linkFetcherMaxLaggingPartitions;
    private final Integer linkFetcherLaggingPartitionMs;
    private final String unprefixedLinkName;
    private final Metrics metrics;
    private final ConcurrentHashMap<TopicPartition, Object> partitionLastCaughtUpTimeMs;
    private final boolean isOffsetForLeaderEpochSupported;

    public static Option<LogContext> $lessinit$greater$default$15() {
        return ClusterLinkFetcherThread$.MODULE$.$lessinit$greater$default$15();
    }

    public static ClusterLinkFetcherThread apply(String string, int n, KafkaConfig kafkaConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager clusterLinkFetcherManager, ClusterLinkDestConnectionManager clusterLinkDestConnectionManager, BrokerEndPoint brokerEndPoint, FailedPartitions failedPartitions, ReplicaManager replicaManager, ReplicaQuota replicaQuota, ClusterLinkMetrics clusterLinkMetrics, Time time, Option<String> option, Function0<FetchResponseSize> function0) {
        if (ClusterLinkFetcherThread$.MODULE$ == null) {
            throw null;
        }
        int apply_brokerId = kafkaConfig.brokerId();
        LogContext apply_logContext = new LogContext(new StringBuilder(68).append("[ClusterLinkFetcher brokerId=").append(apply_brokerId).append(" ").append("fetcherId=").append(n).append("] source(link=").append(clusterLinkMetadata.linkName()).append(", leaderId=").append(brokerEndPoint.id()).append(")] ").toString(), clusterLinkDestConnectionManager.maxLogLevel());
        ClusterLinkNetworkClient apply_clusterLinkClient = new ClusterLinkNetworkClient(kafkaConfig, clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)new ManualMetadataUpdater()), clusterLinkMetrics.metrics(), (Map<String, String>)ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()).$plus$plus((GenTraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(brokerEndPoint.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(n))}))), time, new StringBuilder(22).append("link-").append(clusterLinkMetadata.linkName()).append("-broker-").append(apply_brokerId).append("-fetcher-").append(n).toString(), "fetcher", apply_logContext);
        clusterLinkDestConnectionManager.enableClusterLink(apply_clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
        BrokerBlockingSender apply_blockingSender = new BrokerBlockingSender(brokerEndPoint, kafkaConfig, Predef$.MODULE$.Integer2int(clusterLinkConfig.replicaSocketTimeoutMs()), time, n, apply_clusterLinkClient.networkClient(), (Option<Reconfigurable>)None$.MODULE$);
        ClusterLinkLeaderEndPoint apply_leader = ClusterLinkLeaderEndPoint$.MODULE$.apply(apply_logContext, time, apply_blockingSender, kafkaConfig, clusterLinkConfig, replicaManager, replicaQuota, clusterLinkMetrics);
        return new ClusterLinkFetcherThread(string, n, apply_leader, kafkaConfig, clusterLinkConfig, clusterLinkMetadata, clusterLinkFetcherManager, failedPartitions, replicaManager, replicaQuota, clusterLinkMetrics, time, function0, apply_clusterLinkClient, (Option<LogContext>)new Some((Object)apply_logContext), option);
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private Integer linkFetcherFlowControl() {
        return this.linkFetcherFlowControl;
    }

    private Integer linkFetcherMaxLaggingPartitions() {
        return this.linkFetcherMaxLaggingPartitions;
    }

    private Integer linkFetcherLaggingPartitionMs() {
        return this.linkFetcherLaggingPartitionMs;
    }

    private String unprefixedLinkName() {
        return this.unprefixedLinkName;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ConcurrentHashMap<TopicPartition, Object> partitionLastCaughtUpTimeMs() {
        return this.partitionLastCaughtUpTimeMs;
    }

    @Override
    public void doWork() {
        this.updateDynamicFetchSize();
        super.doWork();
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean onOffsetTiered(TopicPartition topicPartition, Optional<Integer> requestEpoch) {
        this.fetcherManager.onPartitionLinkFailure(topicPartition, MirrorFailureType$IllegalState$.MODULE$, new StringBuilder(36).append("Unexpected tiered offset for ").append(topicPartition).append(" epoch ").append(requestEpoch).toString(), this.fetcherManager.onPartitionLinkFailure$default$4());
        return false;
    }

    @Override
    public boolean onPartitionFenced(TopicPartition tp, Optional<Integer> requestEpoch) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("onPartitionFenced ").append(tp).append(" : request metadata ").toString());
        this.clusterLinkMetadata.requestUpdate();
        return super.onPartitionFenced(tp, requestEpoch);
    }

    @Override
    public boolean handlePartitionException(TopicPartition tp, Exception e) {
        Option<MirrorFailureType> failure2 = MirrorFailureType$.MODULE$.failureType(e);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Handle mirror partition failure ").append(failure2).append(" for partition ").append(tp).append(" due to exception ").append(e).toString());
        if (failure2.exists((Function1 & Serializable & scala.Serializable)failure -> BoxesRunTime.boxToBoolean((boolean)this.fetcherManager.onPartitionLinkFailure(tp, failure, e.getMessage(), false)))) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Request metadata update because of errors for partition ").append(tp).toString());
            this.clusterLinkMetadata.requestUpdate();
        }
        return true;
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        AbstractLog log = partition.localLogOrException();
        if (log.logEndOffset() > offsetTruncationState.offset() && partition.getLinkedLeaderEpoch().contains((Object)BoxesRunTime.boxToInteger((int)0))) {
            String errorMessage = new StringBuilder(164).append("Failing mirror due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(" ").append("with source leader epoch 0 when destination leader leo is ").append(log.logEndOffset()).append(". ").append("Source topic may have been deleted and recreated.").toString();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
            this.fetcherManager.onPartitionLinkFailure(tp, MirrorFailureType$SourceTopicDeleted$.MODULE$, errorMessage, false);
            this.markPartitionFailed(tp);
            return;
        }
        super.truncate(tp, offsetTruncationState);
    }

    @Override
    public void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        super.updateFetchOffsetAndMaybeMarkTruncationComplete(fetchOffsets);
        fetchOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkFetcherThread.$anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition tp, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        this.fetcherManager.updatePartitionFetchState(tp, new FetchState(((ClusterLinkLeaderEndPoint)super.leader()).lastFetchTimeMs(), partitionData.highWatermark()));
        this.clearPartitionLinkFailure(tp, fetchOffset);
        return super.processPartitionData(tp, fetchOffset, partitionData);
    }

    @Override
    public long updateHighWatermarkAndStartOffset(Partition partition, AbstractLog log, long sourceLeaderHighWatermark, Option<Object> sourceLeaderLogStartOffset) {
        partition.maybeIncrementLinkLeaderHW(log);
        sourceLeaderLogStartOffset.foreach((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)sourceStartOffset -> {
            long destStartOffset = package$.MODULE$.min(log.highWatermark(), sourceStartOffset);
            return log.maybeIncrementLogStartOffset(destStartOffset, LeaderOffsetIncremented$.MODULE$);
        });
        return log.highWatermark();
    }

    public void maybeNotifyReadyForFetch(Partition partition) {
        if (ClusterLinkLeaderEndPoint$.MODULE$.isReadyForFetchForPartition(partition, this.clusterLinkMetrics, this.linkFetcherFlowControl(), false)) {
            this.notifyReadyForFetch();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        void var2_2;
        Map<TopicPartition, PartitionFetchState> removedPartitions = super.removePartitions(topicPartitions);
        removedPartitions.foreach((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToLong((long)ClusterLinkFetcherThread.$anonfun$removePartitions$1(this, p)));
        return var2_2;
    }

    public Tuple2<Enumeration.Value, Option<Set<TopicPartition>>> adjustLaggingPartitionsRequired(long nowMs) {
        IntRef numLaggingPartitions = IntRef.create((int)0);
        this.partitionLastCaughtUpTimeMs().forEach((x$2, caughtUpTimeMs) -> ClusterLinkFetcherThread.$anonfun$adjustLaggingPartitionsRequired$1(this, nowMs, numLaggingPartitions, x$2, BoxesRunTime.unboxToLong((Object)caughtUpTimeMs)));
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)numLaggingPartitions.elem), (Object)this.linkFetcherMaxLaggingPartitions())) {
            return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.NoAdjustment(), (Object)None$.MODULE$);
        }
        if (numLaggingPartitions.elem < Predef$.MODULE$.Integer2int(this.linkFetcherMaxLaggingPartitions())) {
            return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.Increase(), (Object)None$.MODULE$);
        }
        int numPartitionsToRemove = numLaggingPartitions.elem - Predef$.MODULE$.Integer2int(this.linkFetcherMaxLaggingPartitions());
        PriorityQueue minHeap = (PriorityQueue)PriorityQueue$.MODULE$.empty((Ordering)ClusterLinkFetcherThread$MinPartitionLagOrder$.MODULE$);
        this.partitionLastCaughtUpTimeMs().forEach((topicPartition, caughtUpTimeMs) -> ClusterLinkFetcherThread.$anonfun$adjustLaggingPartitionsRequired$2(this, nowMs, minHeap, numPartitionsToRemove, topicPartition, BoxesRunTime.unboxToLong((Object)caughtUpTimeMs)));
        return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.Decrease(), (Object)new Some((Object)((TraversableOnce)minHeap.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.partition(), Iterable$.MODULE$.canBuildFrom())).toSet()));
    }

    public void clearPartitionLinkFailure(TopicPartition tp, long fetchOffset) {
        this.fetcherManager.clearPartitionLinkFailure(tp, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("New data fetched from ").append(tp).append(" offset ").append(fetchOffset).toString(), true);
    }

    public void updateDynamicFetchSize() {
        FetchResponseSize dynamicSize = (FetchResponseSize)this.dynamicFetchSize.apply();
        ((ClusterLinkLeaderEndPoint)super.leader()).fetchSize_$eq(Predef$.MODULE$.int2Integer(dynamicSize.perPartitionSize()));
        ((ClusterLinkLeaderEndPoint)super.leader()).updateFetchResponseSize(dynamicSize.responseSize());
    }

    @Override
    public void updateFetcherLagStats(TopicPartition tp, long lag) {
        super.updateFetcherLagStats(tp, lag);
        long topicLag = this.fetcherManager.getTopicLag(tp.topic());
        if (topicLag >= 0L) {
            Sensor sensor = this.getOrCreateTopicSensor(tp.topic(), "mirror-topic-lag", (MeasurableStat)new Value(), "Mirror topic lag");
            long nowMs = this.time.milliseconds();
            sensor.record((double)topicLag, nowMs);
            if (topicLag == 0L) {
                this.partitionLastCaughtUpTimeMs().put(tp, BoxesRunTime.boxToLong((long)nowMs));
                return;
            }
        }
    }

    @Override
    public void updateFetcherByteRate(TopicPartition tp, long bytes) {
        super.updateFetcherByteRate(tp, bytes);
        this.getOrCreateTopicSensor(tp.topic(), "mirror-topic-byte-total", (MeasurableStat)new CumulativeSum(), "Mirror topic throughput").record((double)bytes);
    }

    private Sensor getOrCreateTopicSensor(String topic, String name, MeasurableStat stat, String description) {
        String unprefixedTopic = (String)this.tenant.map((Function1 & Serializable & scala.Serializable)t -> topic.substring(t.length() + 1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> topic);
        String sensorName = new StringBuilder(3).append(name).append("-").append(this.tenant).append("-").append(this.unprefixedLinkName()).append("-").append(unprefixedTopic).toString();
        Sensor sensor = this.metrics().sensor(sensorName, this.metrics().config(), TimeUnit.MINUTES.toSeconds(5L), new Sensor[0]);
        scala.collection.immutable.Map tags = ((TraversableOnce)new .colon.colon((Object)this.tenant.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), t)), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)this.unprefixedLinkName())), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)unprefixedTopic)), (List)Nil$.MODULE$))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
        MetricName metricName = new MetricName(name, "cluster-link-metrics", description, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava());
        sensor.add(metricName, stat);
        return sensor;
    }

    public void updatePartitionLastCaughtUpTime(TopicPartition tp, long caughtUpTimeMs) {
        this.partitionLastCaughtUpTimeMs().put(tp, BoxesRunTime.boxToLong((long)caughtUpTimeMs));
    }

    public static final /* synthetic */ void $anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(ClusterLinkFetcherThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            if (((OffsetTruncationState)x0$1._2()).truncationCompleted()) {
                $this.fetcherManager.partition(tp).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.linkedLeaderOffsetsPending(false);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ long $anonfun$removePartitions$1(ClusterLinkFetcherThread $this, Tuple2 p) {
        return BoxesRunTime.unboxToLong((Object)$this.partitionLastCaughtUpTimeMs().remove(p._1()));
    }

    public static final /* synthetic */ void $anonfun$adjustLaggingPartitionsRequired$1(ClusterLinkFetcherThread $this, long nowMs$1, IntRef numLaggingPartitions$1, TopicPartition x$2, long caughtUpTimeMs) {
        if (nowMs$1 - caughtUpTimeMs > (long)Predef$.MODULE$.Integer2int($this.linkFetcherLaggingPartitionMs())) {
            ++numLaggingPartitions$1.elem;
        }
    }

    public static final /* synthetic */ void $anonfun$adjustLaggingPartitionsRequired$2(ClusterLinkFetcherThread $this, long nowMs$1, PriorityQueue minHeap$1, int numPartitionsToRemove$1, TopicPartition topicPartition, long caughtUpTimeMs) {
        FetcherLagMetrics lagStats;
        if (nowMs$1 - caughtUpTimeMs > (long)Predef$.MODULE$.Integer2int($this.linkFetcherLaggingPartitionMs()) && (lagStats = $this.fetcherLagStats().stats().get(topicPartition)) != null && lagStats.lag() > 0L) {
            if (minHeap$1.size() >= numPartitionsToRemove$1) {
                if (((PartitionAndLag)minHeap$1.head()).lag() < lagStats.lag()) {
                    minHeap$1.dequeue();
                    minHeap$1.$plus$eq((Object)new PartitionAndLag(topicPartition, lagStats.lag()));
                    return;
                }
            } else {
                minHeap$1.$plus$eq((Object)new PartitionAndLag(topicPartition, lagStats.lag()));
                return;
            }
        }
    }

    public ClusterLinkFetcherThread(String name, int fetcherId, ClusterLinkLeaderEndPoint leader, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, Function0<FetchResponseSize> dynamicFetchSize, ClusterLinkNetworkClient clusterLinkClient, Option<LogContext> logContextOpt, Option<String> tenant) {
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.fetcherManager = fetcherManager;
        this.replicaMgr = replicaMgr;
        this.clusterLinkMetrics = clusterLinkMetrics;
        this.time = time;
        this.dynamicFetchSize = dynamicFetchSize;
        this.clusterLinkClient = clusterLinkClient;
        this.tenant = tenant;
        super(name, fetcherId, leader, brokerConfig, failedPartitions, replicaMgr, quota, logContextOpt, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)clusterLinkConfig.replicaFetchBackoffMs().longValue())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)clusterLinkConfig.replicaFetchBackoffMaxMs().longValue())), (Function0<MetadataVersion>)new scala.Serializable(brokerConfig){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig brokerConfig$1;

            public final MetadataVersion apply() {
                return this.brokerConfig$1.interBrokerProtocolVersion();
            }
            {
                this.brokerConfig$1 = brokerConfig$1;
            }
        });
        this.linkFetcherFlowControl = clusterLinkConfig.linkFetcherFlowControl();
        this.linkFetcherMaxLaggingPartitions = clusterLinkConfig.linkFetcherMaxLaggingPartitions();
        this.linkFetcherLaggingPartitionMs = clusterLinkConfig.linkFetcherLaggingPartitionMs();
        this.unprefixedLinkName = (String)tenant.map((Function1 & Serializable & scala.Serializable)t -> $this.clusterLinkMetadata.linkName().substring(t.length() + 1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.clusterLinkMetadata.linkName());
        this.metrics = clusterLinkMetrics.metrics();
        this.partitionLastCaughtUpTimeMs = new ConcurrentHashMap();
        this.isOffsetForLeaderEpochSupported = true;
    }

    public static class PartitionAndLag
    implements Product,
    scala.Serializable {
        private final TopicPartition partition;
        private final long lag;

        public TopicPartition partition() {
            return this.partition;
        }

        public long lag() {
            return this.lag;
        }

        public PartitionAndLag copy(TopicPartition partition, long lag) {
            return new PartitionAndLag(partition, lag);
        }

        public TopicPartition copy$default$1() {
            return this.partition();
        }

        public long copy$default$2() {
            return this.lag();
        }

        public String productPrefix() {
            return "PartitionAndLag";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partition();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.lag());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartitionAndLag;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.partition())), (int)Statics.longHash((long)this.lag())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof PartitionAndLag)) return false;
            boolean bl = true;
            if (!bl) return false;
            PartitionAndLag partitionAndLag = (PartitionAndLag)x$1;
            TopicPartition topicPartition = this.partition();
            TopicPartition topicPartition2 = partitionAndLag.partition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (this.lag() != partitionAndLag.lag()) return false;
            if (!partitionAndLag.canEqual(this)) return false;
            return true;
        }

        public PartitionAndLag(TopicPartition partition, long lag) {
            this.partition = partition;
            this.lag = lag;
            Product.$init$((Product)this);
        }
    }
}

