/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig$;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkMode;
import kafka.server.link.LinkMode$;
import kafka.server.link.LinkMode$Destination$;
import kafka.server.link.LinkMode$Source$;
import kafka.server.link.TopicConfigSyncIncludeValidator$;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.SetLike;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ClusterLinkConfig$ {
    public static ClusterLinkConfig$ MODULE$;
    private final String LinkModeProp;
    private final String LinkModeDoc;
    private final String ConnectionModeProp;
    private final String ConnectionModeDoc;
    private final String LocalPrefix;
    private final String LocalListenerNameProp;
    private final String LocalListenerNameDoc;
    private final String ReverseConnectionSetupTimeoutMsProp;
    private final String ReverseConnectionSetupTimeoutMsDoc;
    private final String NumClusterLinkFetchersProp;
    private final String NumClusterLinkFetchersDoc;
    private final String RetryTimeoutMsProp;
    private final String RetryTimeoutMsDoc;
    private final String ClusterLinkPausedProp;
    private final String ClusterLinkPausedDoc;
    private final String ClusterLinkPrefixProp;
    private final String ClusterLinkPrefixDoc;
    private final String ConsumerOffsetSyncEnableProp;
    private final String ConsumerOffsetSyncEnableDoc;
    private final String ConsumerGroupPrefixEnableProp;
    private final String ConsumerGroupPrefixEnableDoc;
    private final String ConsumerOffsetSyncMsProp;
    private final String ConsumerOffsetSyncMsDoc;
    private final String ConsumerOffsetGroupFiltersProp;
    private final String ConsumerOffsetGroupFiltersDoc;
    private final String AclSyncEnableProp;
    private final String AclSyncEnableDoc;
    private final String AclFiltersProp;
    private final String AclFiltersDoc;
    private final String AclSyncMsProp;
    private final String AclSyncMsDoc;
    private final String TopicConfigSyncIncludeProp;
    private final String TopicConfigFilterDoc;
    private final String TopicConfigSyncMsProp;
    private final String TopicConfigSyncMsDoc;
    private final String AutoMirroringEnableProp;
    private final String AutoMirroringEnableDoc;
    private final String TopicFiltersProp;
    private final String TopicFiltersDoc;
    private final String AvailabilityCheckMsProp;
    private final String AvailabilityCheckMsDoc;
    private final String AvailabilityCheckConsecutiveFailureThresholdProp;
    private final String AvailabilityCheckConsecutiveFailureThresholdDoc;
    private final String LinkFetcherFlowControlProp;
    private final String LinkFetcherFlowControlDoc;
    private final String LinkFetcherMaxLaggingPartitionsProp;
    private final String LinkFetcherMaxLaggingPartitionsDoc;
    private final String LinkFetcherLaggingPartitionMsProp;
    private final String LinkFetcherLaggingPartitionMsDoc;
    private final String LinkFetcherEnforceMaxLaggingPartitionMsProp;
    private final String LinkFetcherEnforceMaxLaggingPartitionMsDoc;
    private final String ReplicaSocketReceiveBufferBytesDoc;
    private final Set<String> ReplicationProps;
    private final Set<String> PeriodicTaskProps;
    private final Set<String> NonReconfigurableProps;
    private final ConfigDef configDef;

    static {
        new ClusterLinkConfig$();
    }

    public String LinkModeProp() {
        return this.LinkModeProp;
    }

    public String LinkModeDoc() {
        return this.LinkModeDoc;
    }

    public String ConnectionModeProp() {
        return this.ConnectionModeProp;
    }

    public String ConnectionModeDoc() {
        return this.ConnectionModeDoc;
    }

    public String LocalPrefix() {
        return this.LocalPrefix;
    }

    public String LocalListenerNameProp() {
        return this.LocalListenerNameProp;
    }

    public String LocalListenerNameDoc() {
        return this.LocalListenerNameDoc;
    }

    public String ReverseConnectionSetupTimeoutMsProp() {
        return this.ReverseConnectionSetupTimeoutMsProp;
    }

    public String ReverseConnectionSetupTimeoutMsDoc() {
        return this.ReverseConnectionSetupTimeoutMsDoc;
    }

    public String NumClusterLinkFetchersProp() {
        return this.NumClusterLinkFetchersProp;
    }

    public String NumClusterLinkFetchersDoc() {
        return this.NumClusterLinkFetchersDoc;
    }

    public String RetryTimeoutMsProp() {
        return this.RetryTimeoutMsProp;
    }

    public String RetryTimeoutMsDoc() {
        return this.RetryTimeoutMsDoc;
    }

    public String ClusterLinkPausedProp() {
        return this.ClusterLinkPausedProp;
    }

    public String ClusterLinkPausedDoc() {
        return this.ClusterLinkPausedDoc;
    }

    public String ClusterLinkPrefixProp() {
        return this.ClusterLinkPrefixProp;
    }

    public String ClusterLinkPrefixDoc() {
        return this.ClusterLinkPrefixDoc;
    }

    public String ConsumerOffsetSyncEnableProp() {
        return this.ConsumerOffsetSyncEnableProp;
    }

    public String ConsumerOffsetSyncEnableDoc() {
        return this.ConsumerOffsetSyncEnableDoc;
    }

    public String ConsumerGroupPrefixEnableProp() {
        return this.ConsumerGroupPrefixEnableProp;
    }

    public String ConsumerGroupPrefixEnableDoc() {
        return this.ConsumerGroupPrefixEnableDoc;
    }

    public String ConsumerOffsetSyncMsProp() {
        return this.ConsumerOffsetSyncMsProp;
    }

    public String ConsumerOffsetSyncMsDoc() {
        return this.ConsumerOffsetSyncMsDoc;
    }

    public String ConsumerOffsetGroupFiltersProp() {
        return this.ConsumerOffsetGroupFiltersProp;
    }

    public String ConsumerOffsetGroupFiltersDoc() {
        return this.ConsumerOffsetGroupFiltersDoc;
    }

    public String AclSyncEnableProp() {
        return this.AclSyncEnableProp;
    }

    public String AclSyncEnableDoc() {
        return this.AclSyncEnableDoc;
    }

    public String AclFiltersProp() {
        return this.AclFiltersProp;
    }

    public String AclFiltersDoc() {
        return this.AclFiltersDoc;
    }

    public String AclSyncMsProp() {
        return this.AclSyncMsProp;
    }

    public String AclSyncMsDoc() {
        return this.AclSyncMsDoc;
    }

    public String TopicConfigSyncIncludeProp() {
        return this.TopicConfigSyncIncludeProp;
    }

    public String TopicConfigFilterDoc() {
        return this.TopicConfigFilterDoc;
    }

    public String TopicConfigSyncMsProp() {
        return this.TopicConfigSyncMsProp;
    }

    public String TopicConfigSyncMsDoc() {
        return this.TopicConfigSyncMsDoc;
    }

    public String AutoMirroringEnableProp() {
        return this.AutoMirroringEnableProp;
    }

    public String AutoMirroringEnableDoc() {
        return this.AutoMirroringEnableDoc;
    }

    public String TopicFiltersProp() {
        return this.TopicFiltersProp;
    }

    public String TopicFiltersDoc() {
        return this.TopicFiltersDoc;
    }

    public String AvailabilityCheckMsProp() {
        return this.AvailabilityCheckMsProp;
    }

    public String AvailabilityCheckMsDoc() {
        return this.AvailabilityCheckMsDoc;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdProp() {
        return this.AvailabilityCheckConsecutiveFailureThresholdProp;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdDoc() {
        return this.AvailabilityCheckConsecutiveFailureThresholdDoc;
    }

    public String LinkFetcherFlowControlProp() {
        return this.LinkFetcherFlowControlProp;
    }

    public String LinkFetcherFlowControlDoc() {
        return this.LinkFetcherFlowControlDoc;
    }

    public String LinkFetcherMaxLaggingPartitionsProp() {
        return this.LinkFetcherMaxLaggingPartitionsProp;
    }

    public String LinkFetcherMaxLaggingPartitionsDoc() {
        return this.LinkFetcherMaxLaggingPartitionsDoc;
    }

    public String LinkFetcherLaggingPartitionMsProp() {
        return this.LinkFetcherLaggingPartitionMsProp;
    }

    public String LinkFetcherLaggingPartitionMsDoc() {
        return this.LinkFetcherLaggingPartitionMsDoc;
    }

    public String LinkFetcherEnforceMaxLaggingPartitionMsProp() {
        return this.LinkFetcherEnforceMaxLaggingPartitionMsProp;
    }

    public String LinkFetcherEnforceMaxLaggingPartitionMsDoc() {
        return this.LinkFetcherEnforceMaxLaggingPartitionMsDoc;
    }

    public String ReplicaSocketReceiveBufferBytesDoc() {
        return this.ReplicaSocketReceiveBufferBytesDoc;
    }

    public Set<String> ReplicationProps() {
        return this.ReplicationProps;
    }

    public Set<String> PeriodicTaskProps() {
        return this.PeriodicTaskProps;
    }

    public Set<String> NonReconfigurableProps() {
        return this.NonReconfigurableProps;
    }

    public boolean needsConnectionResetOnUpdate(String configName) {
        return !this.configKeys().contains((Object)configName) || configName.startsWith(this.LocalPrefix()) || configName.equals("security.protocol") || configName.startsWith("ssl.") || configName.startsWith("sasl.");
    }

    public void main(String[] args) {
        Predef$.MODULE$.println((Object)this.configDef().toHtml());
    }

    public ConfigDef configDef() {
        return this.configDef;
    }

    private ConfigDef createClusterLinkConfigDef() {
        ConfigDef configDef = new ConfigDef().define(this.LinkModeProp(), ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])((TraversableOnce)LinkMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$6 -> ((LinkMode)x$6).name(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, this.LinkModeDoc()).define(this.ConnectionModeProp(), ConfigDef.Type.STRING, null, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])((TraversableOnce)((SeqLike)ConnectionMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$7 -> ((ConnectionMode)x$7).name(), Seq$.MODULE$.canBuildFrom())).$colon$plus(null, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, this.ConnectionModeDoc()).define(this.LocalListenerNameProp(), ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, this.LocalListenerNameDoc()).define(this.ReverseConnectionSetupTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReverseConnectionSetupTimeoutMs()), (ConfigDef.Validator)ConfigDef.Range.between((Number)Predef$.MODULE$.int2Integer(1000), (Number)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE)), ConfigDef.Importance.LOW, this.ReverseConnectionSetupTimeoutMsDoc()).define(this.NumClusterLinkFetchersProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.NumClusterLinkFetchers()), ConfigDef.Importance.LOW, this.NumClusterLinkFetchersDoc()).define(this.ClusterLinkPausedProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.ClusterLinkPausedDoc()).define(this.ClusterLinkPrefixProp(), ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, this.ClusterLinkPrefixDoc()).define(this.ConsumerOffsetSyncEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.ConsumerOffsetSyncEnableDoc()).define(this.ConsumerGroupPrefixEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfigDefaults$.MODULE$.ConsumerGroupPrefixEnableDefault()), ConfigDef.Importance.LOW, this.ConsumerGroupPrefixEnableDoc()).define(this.ConsumerOffsetSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.OffsetSyncMsDefault()), ConfigDef.Importance.LOW, this.ConsumerOffsetSyncMsDoc()).define(this.ConsumerOffsetGroupFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)ClusterLinkFilterJson$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, this.ConsumerOffsetGroupFiltersDoc()).define(this.RetryTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.RetryTimeoutMs()), ConfigDef.Importance.MEDIUM, this.RetryTimeoutMsDoc()).define(this.AclSyncEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.AclSyncEnableDoc()).define(this.AclFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)AclJson$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, this.AclFiltersDoc()).define(this.AclSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AclSyncMsDefault()), ConfigDef.Importance.LOW, this.AclSyncMsDoc()).define(this.TopicConfigSyncIncludeProp(), ConfigDef.Type.LIST, ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault(), (ConfigDef.Validator)TopicConfigSyncIncludeValidator$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, this.TopicFiltersDoc()).define(this.TopicConfigSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncMsDefault()), ConfigDef.Importance.LOW, this.TopicConfigSyncMsDoc()).define(this.AutoMirroringEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.AutoMirroringEnableDoc()).define(this.TopicFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)ClusterLinkFilterJson$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, this.TopicFiltersDoc()).define(this.AvailabilityCheckMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckMsDefault()), ConfigDef.Importance.LOW, this.AvailabilityCheckMsDoc()).define(this.AvailabilityCheckConsecutiveFailureThresholdProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdDefault()), ConfigDef.Importance.LOW, this.AvailabilityCheckConsecutiveFailureThresholdProp()).define("bootstrap.servers", ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("client.dns.lookup", ConfigDef.Type.STRING, (Object)ClientDnsLookup.USE_ALL_DNS_IPS.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()}), ConfigDef.Importance.MEDIUM, "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).define(KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.ReplicaSocketTimeoutMs()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsDoc()).define(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.RequestTimeoutMs()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.RequestTimeoutMsDoc()).define(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.ConnectionsMaxIdleMs()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ConnectionsMaxIdleMsDoc()).define(KafkaConfig$.MODULE$.ConnectionSetupTimeoutMsProp(), ConfigDef.Type.LONG, (Object)Defaults$.MODULE$.ConnectionSetupTimeoutMs(), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ConnectionSetupTimeoutMsDoc()).define(KafkaConfig$.MODULE$.ConnectionSetupTimeoutMaxMsProp(), ConfigDef.Type.LONG, (Object)Defaults$.MODULE$.ConnectionSetupTimeoutMaxMs(), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ConnectionSetupTimeoutMaxMsDoc()).define(KafkaConfig$.MODULE$.ReplicaSocketReceiveBufferBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaSocketReceiveBufferBytes()), ConfigDef.Importance.LOW, this.ReplicaSocketReceiveBufferBytesDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchMaxBytes()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchMaxBytesDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.ReplicaFetchWaitMaxMs()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.ReplicaFetchBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchBackoffMsDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchBackoffMaxMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.ReplicaFetchBackoffMaxMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, KafkaConfig$.MODULE$.ReplicaFetchBackoffMaxMsDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.ReplicaFetchMinBytes()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchMinBytesDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchResponseMaxBytes()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc()).define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.RetryBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios.").define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker.").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMaxMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.").define("metadata.max.age.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.MetadataMaxAgeMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").define(this.LinkFetcherMaxLaggingPartitionsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherMaxLaggingPartitions()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(-1)), ConfigDef.Importance.LOW, this.LinkFetcherMaxLaggingPartitionsDoc()).define(this.LinkFetcherLaggingPartitionMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherLaggingPartitionMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherLaggingPartitionMsDoc()).define(this.LinkFetcherEnforceMaxLaggingPartitionMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherEnforceMaxLaggingPartitionMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherEnforceMaxLaggingPartitionMsDoc()).defineInternal(this.LinkFetcherFlowControlProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherFlowControl()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(-2)), ConfigDef.Importance.LOW, this.LinkFetcherFlowControlDoc()).withClientSslSupport().withClientSaslSupport();
        return this.addLocalClientSecurityConfigs(configDef);
    }

    private ConfigDef addLocalClientSecurityConfigs(ConfigDef configDef) {
        String localDoc = new StringBuilder(133).append("This security configuration with '").append(this.LocalPrefix()).append("' prefix is applied to clients connecting ").append("locally to the source cluster of a source initiated link.").toString();
        ObjectRef newConfigDef = ObjectRef.create((Object)configDef.define(new StringBuilder(17).append(this.LocalPrefix()).append("security.protocol").toString(), ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, new StringBuilder(0).append(CommonClientConfigs.SECURITY_PROTOCOL_DOC).append(localDoc).toString()));
        new ConfigDef().withClientSslSupport().withClientSaslSupport().configKeys().forEach((name, key) -> {
            newConfigDef$1.elem = ((ConfigDef)newConfigDef$1.elem).define(new StringBuilder(0).append(MODULE$.LocalPrefix()).append((String)name).toString(), key.type, key.defaultValue, key.validator, key.importance, new StringBuilder(1).append(key.documentation).append(" ").append(localDoc).toString(), key.group, key.orderInGroup, key.width, key.displayName, key.dependents, key.recommender);
        });
        return (ConfigDef)newConfigDef.elem;
    }

    public Seq<String> configNames() {
        return (Seq)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.configDef().names()).asScala()).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public scala.collection.immutable.Map<String, ConfigDef.ConfigKey> configKeys() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.configDef().configKeys()).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<ConfigDef.Type> configType(String name) {
        return Option$.MODULE$.apply(this.configDef().configKeys().get(name)).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.type);
    }

    public ConfigDef configDefCopy() {
        return new ConfigDef(this.configDef());
    }

    /*
     * Unable to fully structure code
     */
    public ClusterLinkConfig create(Map<?, ?> props, boolean validate) {
        try {
            linkMode = (LinkMode)Option$.MODULE$.apply(props.get(this.LinkModeProp())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$create$1(java.lang.Object ), (Ljava/lang/Object;)Lkafka/server/link/LinkMode;)()).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$create$2(), ()Lkafka/server/link/LinkMode$Destination$;)());
            v0 = props.containsKey(this.ConnectionModeProp()) != false ? ConnectionMode$.MODULE$.fromString(props.get(this.ConnectionModeProp()).toString()) : this.defaultConnectionMode(linkMode);
            var5_4 = ConnectionMode$Inbound$.MODULE$;
            if (v0 != null ? v0.equals(var5_4) == false : var5_4 != null) ** GOTO lbl-1000
            v1 = linkMode;
            var6_5 = LinkMode$Destination$.MODULE$;
            if (!(v1 != null ? v1.equals(var6_5) == false : var6_5 != null)) {
                newProps = new Properties();
                props.forEach((BiConsumer<Object, Object>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, $anonfun$create$3(java.util.Properties java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)((Properties)newProps));
                newProps.setProperty("bootstrap.servers", "localhost:0");
                v2 = newProps;
            } else lbl-1000:
            // 2 sources

            {
                v2 = props;
            }
            configProps = v2;
            return new ClusterLinkConfig(configProps, validate);
        }
        catch (InvalidConfigurationException v3) {
            throw v3;
        }
        catch (ConfigException e) {
            throw new InvalidConfigurationException(new StringBuilder(30).append("Invalid cluster link configs: ").append((Object)e).toString());
        }
        catch (Exception e) {
            throw new InvalidConfigurationException(new StringBuilder(30).append("Invalid cluster link configs: ").append(e).toString(), (Throwable)e);
        }
    }

    public boolean create$default$2() {
        return true;
    }

    public void kafka$server$link$ClusterLinkConfig$$validateClusterLinkPrefix(String clusterLinkPrefix) {
        int maxLength = 12;
        if (clusterLinkPrefix.length() > maxLength) {
            throw new InvalidConfigurationException(new StringBuilder(57).append("Cluster link prefix exceeds maximum size of '").append(maxLength).append("' characters").toString());
        }
        if (!Topic.containsValidPattern((String)clusterLinkPrefix)) {
            throw new InvalidConfigurationException(new StringBuilder(67).append("Cluster link prefix '").append(clusterLinkPrefix).append("' is illegal, valid characters: [a-zA-Z0-9._-]").toString());
        }
    }

    public ConnectionMode defaultConnectionMode(LinkMode linkMode) {
        LinkMode linkMode2 = linkMode;
        LinkMode$Destination$ linkMode$Destination$ = LinkMode$Destination$.MODULE$;
        if (!(linkMode2 != null ? !linkMode2.equals(linkMode$Destination$) : linkMode$Destination$ != null)) {
            return ConnectionMode$Outbound$.MODULE$;
        }
        return ConnectionMode$Inbound$.MODULE$;
    }

    public static final /* synthetic */ LinkMode $anonfun$create$1(Object m) {
        return LinkMode$.MODULE$.fromString(m.toString());
    }

    public static final /* synthetic */ LinkMode$Destination$ $anonfun$create$2() {
        return LinkMode$Destination$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$create$3(Properties newProps$1, Object k, Object v) {
        newProps$1.setProperty(k.toString(), v.toString());
    }

    private ClusterLinkConfig$() {
        MODULE$ = this;
        this.LinkModeProp = "link.mode";
        this.LinkModeDoc = new StringBuilder(121).append("Mode that indicates if this cluster is configured to be the source or destination of the cluster link.").append(" Valid values are ").append(LinkMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$4 -> ((LinkMode)x$4).name(), Seq$.MODULE$.canBuildFrom())).append(".").toString();
        this.ConnectionModeProp = "connection.mode";
        this.ConnectionModeDoc = new StringBuilder(490).append("Connection mode that indicates if outbound connections are established by this cluster for").append(" the cluster link. Valid values are ").append(ConnectionMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$5 -> ((ConnectionMode)x$5).name(), Seq$.MODULE$.canBuildFrom())).append(". By default, destination cluster creates").append(" outbound connections and source cluster accepts inbound connections. Connection and security configuration should be").append(" provided for the cluster that establishes outbound connections. Security configuration to establish local connections").append(" should also be provided with prefix 'local.' for source clusters with connection mode ").append(ConnectionMode$Outbound$.MODULE$.name()).append(".").toString();
        this.LocalPrefix = "local.";
        this.LocalListenerNameProp = "local.listener.name";
        this.LocalListenerNameDoc = new StringBuilder(383).append("Name of the local listener on the source cluster used for local cluster link connection requests.").append(" Cluster link connections are added to this listener if '").append(this.LinkModeProp()).append("=").append(LinkMode$Source$.MODULE$.name()).append("' and '").append(this.ConnectionModeProp()).append("=").append(ConnectionMode$Outbound$.MODULE$.name()).append("'.").append(" Security configuration options for creating local connections on this listener should be configured with the prefix '").append(this.LocalPrefix()).append("'.").append(" By default, the listener on which the source link was created will be used as the local listener.").toString();
        this.ReverseConnectionSetupTimeoutMsProp = "reverse.connection.setup.timeout.ms";
        this.ReverseConnectionSetupTimeoutMsDoc = "Timeout in milliseconds to wait for response of reverse connection requests for source initiated links. This limits the amount of time before a retry when brokers fail or are restarted.";
        this.NumClusterLinkFetchersProp = "num.cluster.link.fetchers";
        this.NumClusterLinkFetchersDoc = "Number of fetcher threads used to replicate messages from source brokers in cluster links.";
        this.RetryTimeoutMsProp = "cluster.link.retry.timeout.ms";
        this.RetryTimeoutMsDoc = "The number of milliseconds after which failures are no longer retried and partitions are marked as failed. If the source topic is deleted and recreated within this timeout, the link may contain records from the old as well as the new topic.";
        this.ClusterLinkPausedProp = "cluster.link.paused";
        this.ClusterLinkPausedDoc = "Whether all activity over the cluster link is paused.";
        this.ClusterLinkPrefixProp = "cluster.link.prefix";
        this.ClusterLinkPrefixDoc = new StringBuilder(212).append("The prefix value that will be applied to the name of the resources created by the cluster link. Some examples are mirror topic name and consumer group id.").append(" Topics that begin with '_confluent' will not be mirrored.").toString();
        this.ConsumerOffsetSyncEnableProp = "consumer.offset.sync.enable";
        this.ConsumerOffsetSyncEnableDoc = "Whether or not to migrate consumer offsets from the source cluster.";
        this.ConsumerGroupPrefixEnableProp = "consumer.group.prefix.enable";
        this.ConsumerGroupPrefixEnableDoc = "Whether to apply the cluster link prefix to consumer groups.";
        this.ConsumerOffsetSyncMsProp = "consumer.offset.sync.ms";
        this.ConsumerOffsetSyncMsDoc = "How often to sync consumer offsets.";
        this.ConsumerOffsetGroupFiltersProp = "consumer.offset.group.filters";
        this.ConsumerOffsetGroupFiltersDoc = "JSON to denote the list of consumer groups to be migrated.";
        this.AclSyncEnableProp = "acl.sync.enable";
        this.AclSyncEnableDoc = "Whether or not to migrate ACLs";
        this.AclFiltersProp = "acl.filters";
        this.AclFiltersDoc = "JSON to denote the list of ACLs to be migrated.";
        this.AclSyncMsProp = "acl.sync.ms";
        this.AclSyncMsDoc = "How often to refresh the ACLs.";
        this.TopicConfigSyncIncludeProp = "topic.config.sync.include";
        this.TopicConfigFilterDoc = "The list of topic configs to sync";
        this.TopicConfigSyncMsProp = "topic.config.sync.ms";
        this.TopicConfigSyncMsDoc = "How often to refresh the topic configs.";
        this.AutoMirroringEnableProp = "auto.create.mirror.topics.enable";
        this.AutoMirroringEnableDoc = "Whether or not to automatically create mirror topics";
        this.TopicFiltersProp = "auto.create.mirror.topics.filters";
        this.TopicFiltersDoc = "JSON to denote the list of source topics to automatically create mirror topics from";
        this.AvailabilityCheckMsProp = "availability.check.ms";
        this.AvailabilityCheckMsDoc = "How often to send a request to source cluster to check source cluster availability.";
        this.AvailabilityCheckConsecutiveFailureThresholdProp = "availability.check.consecutive.failure.threshold";
        this.AvailabilityCheckConsecutiveFailureThresholdDoc = "The upper-bound of the consecutive failures beyond which the availability checker will report the link as unavailable.";
        this.LinkFetcherFlowControlProp = "link.fetcher.flow.control";
        this.LinkFetcherFlowControlDoc = "The flow control approach used by cluster linking fetcher";
        this.LinkFetcherMaxLaggingPartitionsProp = "link.fetcher.max.lagging.partitions";
        this.LinkFetcherMaxLaggingPartitionsDoc = "Maximum number of lagging partitions. The limit is enforced periodically by the fetcher. If set to -1, the limit is not enforced.";
        this.LinkFetcherLaggingPartitionMsProp = "link.fetcher.lagging.partition.ms";
        this.LinkFetcherLaggingPartitionMsDoc = "When a partition last caught up time is more than this time, the partition is considered a lagging partition.";
        this.LinkFetcherEnforceMaxLaggingPartitionMsProp = "link.fetcher.enforce.max.lagging.partitions.ms";
        this.LinkFetcherEnforceMaxLaggingPartitionMsDoc = "The periodic interval where link fetcher will enforce the limit on number of lagging partitions.";
        this.ReplicaSocketReceiveBufferBytesDoc = "The socket receive buffer size for cluster linking connections. The receive buffer size will be limited by a defined maximum value. If set to -1, the kernel will auto tune the receive buffer size up to a defined maximum value.";
        this.ReplicationProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.NumClusterLinkFetchersProp(), this.RetryTimeoutMsProp(), this.LinkFetcherFlowControlProp(), this.LinkFetcherMaxLaggingPartitionsProp(), this.LinkFetcherLaggingPartitionMsProp(), KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), KafkaConfig$.MODULE$.ReplicaSocketReceiveBufferBytesProp(), KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), KafkaConfig$.MODULE$.ReplicaFetchBackoffMaxMsProp(), KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesProp()}));
        this.PeriodicTaskProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ConsumerOffsetSyncEnableProp(), this.ConsumerOffsetSyncMsProp(), this.ConsumerOffsetGroupFiltersProp(), this.AclSyncEnableProp(), this.AclFiltersProp(), this.AclSyncMsProp(), this.TopicConfigSyncIncludeProp(), this.TopicConfigSyncMsProp(), this.AutoMirroringEnableProp(), this.TopicFiltersProp(), this.AvailabilityCheckMsProp(), this.AvailabilityCheckConsecutiveFailureThresholdProp(), this.LinkFetcherEnforceMaxLaggingPartitionMsProp()}));
        this.NonReconfigurableProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.LinkModeProp(), this.ConnectionModeProp(), this.ClusterLinkPrefixProp(), this.ConsumerGroupPrefixEnableProp()}));
        this.configDef = this.createClusterLinkConfigDef();
    }
}

