/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kafka.server.LogDirFailureChannel;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.server.common.CheckpointFile;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0007\u000f\u0001UA\u0001\"\b\u0001\u0003\u0006\u0004%\tA\b\u0005\tO\u0001\u0011\t\u0011)A\u0005?!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000be\u0003A\u0011\u0001.\t\u000f\t\u0004!\u0019!C\u0005G\"1q\r\u0001Q\u0001\n\u0011DQ\u0001\u001b\u0001\u0005\u0002%DQ\u0001\u001f\u0001\u0005\u0002eDq!a\u0001\u0001\t\u0003\t)A\u0001\u0011DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3XSRDg)Y5mkJ,\u0007*\u00198eY\u0016\u0014(BA\b\u0011\u0003-\u0019\u0007.Z2la>Lg\u000e^:\u000b\u0005E\u0011\u0012AB:feZ,'OC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"AF \u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-\u0001\u0003gS2,W#A\u0010\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013AA5p\u0015\u0005!\u0013\u0001\u00026bm\u0006L!AJ\u0011\u0003\t\u0019KG.Z\u0001\u0006M&dW\rI\u0001\bm\u0016\u00148/[8o!\tA\"&\u0003\u0002,3\t\u0019\u0011J\u001c;\u0002\u0013\u0019|'/\\1ui\u0016\u0014\bc\u0001\u0018;{9\u0011q\u0006O\u0007\u0002a)\u0011\u0011GM\u0001\u0007G>lWn\u001c8\u000b\u0005E\u0019$BA\n5\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\n\u0005e\u0002\u0014AD\"iK\u000e\\\u0007o\\5oi\u001aKG.Z\u0005\u0003wq\u0012a\"\u00128uef4uN]7biR,'O\u0003\u0002:aA\u0011ah\u0010\u0007\u0001\t\u0015\u0001\u0005A1\u0001B\u0005\u0005!\u0016C\u0001\"F!\tA2)\u0003\u0002E3\t9aj\u001c;iS:<\u0007C\u0001\rG\u0013\t9\u0015DA\u0002B]f\fA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007C\u0001&L\u001b\u0005\u0001\u0012B\u0001'\u0011\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u00061An\\4ESJ\u0004\"a\u0014,\u000f\u0005A#\u0006CA)\u001a\u001b\u0005\u0011&BA*\u0015\u0003\u0019a$o\\8u}%\u0011Q+G\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V3\u00051A(\u001b8jiz\"baW/_?\u0002\f\u0007c\u0001/\u0001{5\ta\u0002C\u0003\u001e\u000f\u0001\u0007q\u0004C\u0003)\u000f\u0001\u0007\u0011\u0006C\u0003-\u000f\u0001\u0007Q\u0006C\u0003I\u000f\u0001\u0007\u0011\nC\u0003N\u000f\u0001\u0007a*\u0001\bdQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\u0016\u0003\u0011\u00042aL3>\u0013\t1\u0007G\u0001\bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\u0002\u001f\rDWmY6q_&tGOR5mK\u0002\nQa\u001e:ji\u0016$\"A[7\u0011\u0005aY\u0017B\u00017\u001a\u0005\u0011)f.\u001b;\t\u000b9T\u0001\u0019A8\u0002\u000f\u0015tGO]5fgB\u0019\u0001/^\u001f\u000f\u0005E\u001chBA)s\u0013\u0005Q\u0012B\u0001;\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\u0011%#XM]1cY\u0016T!\u0001^\r\u0002!]\u0014\u0018\u000e^3U_\nKH/Z!se\u0006LHc\u0001>\u0002\u0002A\u0019\u0001d_?\n\u0005qL\"!B!se\u0006L\bC\u0001\r\u007f\u0013\ty\u0018D\u0001\u0003CsR,\u0007\"\u00028\f\u0001\u0004y\u0017\u0001\u0002:fC\u0012$\"!a\u0002\u0011\u000b\u0005%\u0011qB\u001f\u000e\u0005\u0005-!bAA\u00073\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00111\u0002\u0002\u0004'\u0016\f\b")
public class CheckpointFileWithFailureHandler<T> {
    private final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String logDir;
    private final CheckpointFile<T> checkpointFile;

    public File file() {
        return this.file;
    }

    private CheckpointFile<T> checkpointFile() {
        return this.checkpointFile;
    }

    public void write(Iterable<T> entries) {
        try {
            this.checkpointFile().write((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(entries.toSeq()).asJava());
            return;
        }
        catch (IOException e) {
            String msg = new StringBuilder(39).append("Error while writing to checkpoint file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public byte[] writeToByteArray(Iterable<T> entries) {
        try {
            return this.checkpointFile().writeToByteArray((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(entries.toSeq()).asJava());
        }
        catch (IOException e) {
            String msg = "Error while writing to byte array";
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public Seq<T> read() {
        try {
            return (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(this.checkpointFile().read()).asScala();
        }
        catch (IOException e) {
            String msg = new StringBuilder(36).append("Error while reading checkpoint file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public CheckpointFileWithFailureHandler(File file, int version, CheckpointFile.EntryFormatter<T> formatter, LogDirFailureChannel logDirFailureChannel, String logDir) {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        this.logDir = logDir;
        this.checkpointFile = new CheckpointFile(file, version, formatter);
    }
}

