/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import io.confluent.kafka.availability.FileChannelWrapper;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.server.StorageProbe$;
import kafka.server.StorageProbe$LogDirMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005g\u0001\u0002 @\u0001\u0011C\u0001\u0002\u0018\u0001\u0003\u0006\u0004%I!\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005=\"A1\r\u0001BC\u0002\u0013%A\r\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003f\u0011!\u0011\bA!b\u0001\n\u0013\u0019\b\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u000bm\u0004A\u0011\u0001?\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0001\u0002CA\u0007\u0001\u0001\u0006I!a\u0002\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0005\t\u0013\u0005m\u0001A1A\u0005\n\u0005E\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0005\t\u0013\u0005}\u0001A1A\u0005\n\u0005\u0005\u0002\u0002CA\u001c\u0001\u0001\u0006I!a\t\t\u0017\u0005e\u0002\u00011AA\u0002\u0013%\u00111\b\u0005\f\u0003\u0007\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0005C\u0006\u0002R\u0001\u0001\r\u0011!Q!\n\u0005u\u0002\u0002C*\u0001\u0001\u0004%I!a\u0015\t\u0013\t%\u0003\u00011A\u0005\n\t-\u0003\u0002\u0003B(\u0001\u0001\u0006K!!\u0016\t\u0013\tE\u0003A1A\u0005\n\u0005\u0015\u0001\u0002\u0003B*\u0001\u0001\u0006I!a\u0002\t\u000f\tU\u0003\u0001\"\u0001\u0003X!9!\u0011\f\u0001\u0005\u0002\t]\u0003b\u0002B.\u0001\u0011\u0005!Q\f\u0005\b\u0005W\u0002A\u0011\u0001B7\u0011\u001d\u0011)\b\u0001C\u0001\u0005/2a!!\u001d\u0001\u0001\u0006M\u0004BCAD;\tU\r\u0011\"\u0001\u0002\n\"Q\u0011\u0011T\u000f\u0003\u0012\u0003\u0006I!a#\t\u0015\u0005mUD!f\u0001\n\u0003\ti\n\u0003\u0006\u0002&v\u0011\t\u0012)A\u0005\u0003?C!\"a*\u001e\u0005+\u0007I\u0011AAU\u0011)\t\t-\bB\tB\u0003%\u00111\u0016\u0005\u000b\u0003\u0007l\"Q3A\u0005\u0002\u0005\u0015\u0007BCAj;\tE\t\u0015!\u0003\u0002H\"110\bC\u0001\u0003+D\u0011\"a8\u001e\u0003\u0003%\t!!9\t\u0013\u0005-X$%A\u0005\u0002\u00055\b\"\u0003B\u0002;E\u0005I\u0011\u0001B\u0003\u0011%\u0011I!HI\u0001\n\u0003\u0011Y\u0001C\u0005\u0003\u0010u\t\n\u0011\"\u0001\u0003\u0012!I!QC\u000f\u0002\u0002\u0013\u0005\u0013\u0011\u0003\u0005\n\u0005/i\u0012\u0011!C\u0001\u0003\u000bA\u0011B!\u0007\u001e\u0003\u0003%\tAa\u0007\t\u0013\t\u0015R$!A\u0005B\t\u001d\u0002\"\u0003B\u001b;\u0005\u0005I\u0011\u0001B\u001c\u0011%\u0011Y$HA\u0001\n\u0003\u0012i\u0004C\u0005\u0003@u\t\t\u0011\"\u0011\u0003B!I!1I\u000f\u0002\u0002\u0013\u0005#QI\u0004\n\u0005\u007f\u0002\u0011\u0011!E\u0001\u0005\u00033\u0011\"!\u001d\u0001\u0003\u0003E\tAa!\t\rm,D\u0011\u0001BI\u0011%\u0011y$NA\u0001\n\u000b\u0012\t\u0005C\u0005\u0003\u0014V\n\t\u0011\"!\u0003\u0016\"I!qT\u001b\u0002\u0002\u0013\u0005%\u0011U\u0004\n\u0005g{\u0014\u0011!E\u0001\u0005k3\u0001BP \u0002\u0002#\u0005!q\u0017\u0005\u0007wn\"\tA!/\t\u0013\tm6(%A\u0005\u0002\tu&\u0001D*u_J\fw-\u001a)s_\n,'B\u0001!B\u0003\u0019\u0019XM\u001d<fe*\t!)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u0001)U\n\u0015,\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015\u0001\u00027b]\u001eT\u0011AS\u0001\u0005U\u00064\u0018-\u0003\u0002M\u000f\n1qJ\u00196fGR\u0004\"A\u0012(\n\u0005=;%\u0001\u0003*v]:\f'\r\\3\u0011\u0005E#V\"\u0001*\u000b\u0005M\u000b\u0015aB7fiJL7m]\u0005\u0003+J\u0013\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q!\t9&,D\u0001Y\u0015\tI\u0016)A\u0003vi&d7/\u0003\u0002\\1\n9Aj\\4hS:<\u0017AB2p]\u001aLw-F\u0001_!\ty\u0006-D\u0001@\u0013\t\twHA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0005i&lW-F\u0001f!\t1w.D\u0001h\u0015\tI\u0006N\u0003\u0002jU\u000611m\\7n_:T!AQ6\u000b\u00051l\u0017AB1qC\u000eDWMC\u0001o\u0003\ry'oZ\u0005\u0003a\u001e\u0014A\u0001V5nK\u0006)A/[7fA\u0005Y1\u000f^1siRC'/Z1e+\u0005!\bCA;y\u001b\u00051(\"A<\u0002\u000bM\u001c\u0017\r\\1\n\u0005e4(a\u0002\"p_2,\u0017M\\\u0001\rgR\f'\u000f\u001e+ie\u0016\fG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000butx0!\u0001\u0011\u0005}\u0003\u0001\"\u0002/\b\u0001\u0004q\u0006\"B2\b\u0001\u0004)\u0007b\u0002:\b!\u0003\u0005\r\u0001^\u0001\bm\u0016\u00148/[8o+\t\t9\u0001E\u0002v\u0003\u0013I1!a\u0003w\u0005\rIe\u000e^\u0001\tm\u0016\u00148/[8oA\u0005\tB.\u0019;f]\u000eLX*\u001a;sS\u000et\u0015-\\3\u0016\u0005\u0005M\u0001c\u0001$\u0002\u0016%\u0019\u0011qC$\u0003\rM#(/\u001b8h\u0003Ia\u0017\r^3oGflU\r\u001e:jG:\u000bW.\u001a\u0011\u0002-\r,(O]3oi^\u0013\u0018\u000e^3NKR\u0014\u0018n\u0019(b[\u0016\fqcY;se\u0016tGo\u0016:ji\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u0019MDW\u000f\u001e3po:4E.Y4\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003gi!!a\n\u000b\t\u0005%\u00121F\u0001\u0007CR|W.[2\u000b\t\u00055\u0012qF\u0001\u000bG>t7-\u001e:sK:$(bAA\u0019\u0013\u0006!Q\u000f^5m\u0013\u0011\t)$a\n\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u00035\u0019\b.\u001e;e_^tg\t\\1hA\u00051A\u000f\u001b:fC\u0012,\"!!\u0010\u0011\u0007\u0019\fy$C\u0002\u0002B\u001d\u00141bS1gW\u0006$\u0006N]3bI\u0006QA\u000f\u001b:fC\u0012|F%Z9\u0015\t\u0005\u001d\u0013Q\n\t\u0004k\u0006%\u0013bAA&m\n!QK\\5u\u0011%\ty%EA\u0001\u0002\u0004\ti$A\u0002yIE\nq\u0001\u001e5sK\u0006$\u0007%\u0006\u0002\u0002VA1\u0011qKA4\u0003[rA!!\u0017\u0002d9!\u00111LA1\u001b\t\tiFC\u0002\u0002`\r\u000ba\u0001\u0010:p_Rt\u0014\"A<\n\u0007\u0005\u0015d/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00141\u000e\u0002\u0005\u0019&\u001cHOC\u0002\u0002fY\u00042!a\u001c\u001e\u001b\u0005\u0001!!\u0004'pO\u0012K'/T3ue&\u001c7oE\u0004\u001e\u0003k\nY(!!\u0011\u0007U\f9(C\u0002\u0002zY\u0014a!\u00118z%\u00164\u0007cA;\u0002~%\u0019\u0011q\u0010<\u0003\u000fA\u0013x\u000eZ;diB\u0019Q/a!\n\u0007\u0005\u0015eO\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003oC6,WCAAF!\u0011\ti)!&\u000f\t\u0005=\u0015\u0011\u0013\t\u0004\u000372\u0018bAAJm\u00061\u0001K]3eK\u001aLA!a\u0006\u0002\u0018*\u0019\u00111\u0013<\u0002\u000b9\fW.\u001a\u0011\u0002+\r,(O]3oi^\u0013\u0018\u000e^3Ti\u0006\u0014H/\u001a3NgV\u0011\u0011q\u0014\t\u0005\u0003K\t\t+\u0003\u0003\u0002$\u0006\u001d\"AC!u_6L7\rT8oO\u000612-\u001e:sK:$xK]5uKN#\u0018M\u001d;fI6\u001b\b%A\u0005iSN$xn\u001a:b[V\u0011\u00111\u0016\t\u0005\u0003[\u000bi,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003\u0011\u0019wN]3\u000b\u0007M\u000b)L\u0003\u0003\u00028\u0006e\u0016AB=b[6,'O\u0003\u0002\u0002<\u0006\u00191m\\7\n\t\u0005}\u0016q\u0016\u0002\n\u0011&\u001cHo\\4sC6\f!\u0002[5ti><'/Y7!\u0003%AW-\u0019:uE\u0016\fG/\u0006\u0002\u0002HB1\u0011QVAe\u0003\u001bLA!a3\u00020\n)q)Y;hKB\u0019Q/a4\n\u0007\u0005EgO\u0001\u0003M_:<\u0017A\u00035fCJ$(-Z1uAQQ\u0011QNAl\u00033\fY.!8\t\u000f\u0005\u001de\u00051\u0001\u0002\f\"9\u00111\u0014\u0014A\u0002\u0005}\u0005bBATM\u0001\u0007\u00111\u0016\u0005\b\u0003\u00074\u0003\u0019AAd\u0003\u0011\u0019w\u000e]=\u0015\u0015\u00055\u00141]As\u0003O\fI\u000fC\u0005\u0002\b\u001e\u0002\n\u00111\u0001\u0002\f\"I\u00111T\u0014\u0011\u0002\u0003\u0007\u0011q\u0014\u0005\n\u0003O;\u0003\u0013!a\u0001\u0003WC\u0011\"a1(!\u0003\u0005\r!a2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u001e\u0016\u0005\u0003\u0017\u000b\tp\u000b\u0002\u0002tB!\u0011Q_A\u0000\u001b\t\t9P\u0003\u0003\u0002z\u0006m\u0018!C;oG\",7m[3e\u0015\r\tiP^\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0001\u0003o\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0002+\t\u0005}\u0015\u0011_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iA\u000b\u0003\u0002,\u0006E\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005'QC!a2\u0002r\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u001e\t\r\u0002cA;\u0003 %\u0019!\u0011\u0005<\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002P9\n\t\u00111\u0001\u0002\b\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003*A1!1\u0006B\u0019\u0005;i!A!\f\u000b\u0007\t=b/\u0001\u0006d_2dWm\u0019;j_:LAAa\r\u0003.\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r!(\u0011\b\u0005\n\u0003\u001f\u0002\u0014\u0011!a\u0001\u0005;\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u000f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\ta!Z9vC2\u001cHc\u0001;\u0003H!I\u0011qJ\u001a\u0002\u0002\u0003\u0007!QD\u0001\f[\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002H\t5\u0003\"CA()\u0005\u0005\t\u0019AA+\u0003!iW\r\u001e:jGN\u0004\u0013\u0001G<sSR,G+[7f/\u0006\u0014h\u000e\u00165sKNDw\u000e\u001c3Ng\u0006IrO]5uKRKW.Z,be:$\u0006N]3tQ>dG-T:!\u0003\u001d\u0019H/\u0019:ukB$\"!a\u0012\u0002\u0011MDW\u000f\u001e3po:\fq\u0001]1zY>\fG\r\u0006\u0002\u0003`A!!\u0011\rB4\u001b\t\u0011\u0019GC\u0002\u0003f%\u000b1A\\5p\u0013\u0011\u0011IGa\u0019\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0003qe>\u0014W\r\u0006\u0002\u0003pAA\u0011Q\u0012B9\u0003\u0017\u000bi-\u0003\u0003\u0003t\u0005]%aA'ba\u0006\u0019!/\u001e8)\u0007q\u0011I\bE\u0002G\u0005wJ1A! H\u0005!ye/\u001a:sS\u0012,\u0017!\u0004'pO\u0012K'/T3ue&\u001c7\u000fE\u0002\u0002pU\u001aR!\u000eBC\u0003\u0003\u0003bBa\"\u0003\u000e\u0006-\u0015qTAV\u0003\u000f\fi'\u0004\u0002\u0003\n*\u0019!1\u0012<\u0002\u000fI,h\u000e^5nK&!!q\u0012BE\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0005\u0003\u000bQ!\u00199qYf$\"\"!\u001c\u0003\u0018\ne%1\u0014BO\u0011\u001d\t9\t\u000fa\u0001\u0003\u0017Cq!a'9\u0001\u0004\ty\nC\u0004\u0002(b\u0002\r!a+\t\u000f\u0005\r\u0007\b1\u0001\u0002H\u00069QO\\1qa2LH\u0003\u0002BR\u0005_\u0003R!\u001eBS\u0005SK1Aa*w\u0005\u0019y\u0005\u000f^5p]BYQOa+\u0002\f\u0006}\u00151VAd\u0013\r\u0011iK\u001e\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\tE\u0016(!AA\u0002\u00055\u0014a\u0001=%a\u0005a1\u000b^8sC\u001e,\u0007K]8cKB\u0011qlO\n\u0004w\u0005UDC\u0001B[\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0018\u0016\u0004i\u0006E\b")
public class StorageProbe
implements Runnable,
KafkaMetricsGroup {
    private volatile StorageProbe$LogDirMetrics$ LogDirMetrics$module;
    private final KafkaConfig config;
    private final Time time;
    private final boolean startThread;
    private final int version;
    private final String latencyMetricName;
    private final String currentWriteMetricName;
    private final AtomicBoolean shutdownFlag;
    private KafkaThread thread;
    private List<LogDirMetrics> metrics;
    private final int writeTimeWarnThresholdMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return StorageProbe$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public StorageProbe$LogDirMetrics$ LogDirMetrics() {
        if (this.LogDirMetrics$module == null) {
            this.LogDirMetrics$lzycompute$1();
        }
        return this.LogDirMetrics$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private Time time() {
        return this.time;
    }

    private boolean startThread() {
        return this.startThread;
    }

    private int version() {
        return this.version;
    }

    private String latencyMetricName() {
        return this.latencyMetricName;
    }

    private String currentWriteMetricName() {
        return this.currentWriteMetricName;
    }

    private AtomicBoolean shutdownFlag() {
        return this.shutdownFlag;
    }

    private KafkaThread thread() {
        return this.thread;
    }

    private void thread_$eq(KafkaThread x$1) {
        this.thread = x$1;
    }

    private List<LogDirMetrics> metrics() {
        return this.metrics;
    }

    private void metrics_$eq(List<LogDirMetrics> x$1) {
        this.metrics = x$1;
    }

    private int writeTimeWarnThresholdMs() {
        return this.writeTimeWarnThresholdMs;
    }

    public void startup() {
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()) > 0L) {
            this.metrics_$eq((List<LogDirMetrics>)((TraversableOnce)this.config().logDirs().map((Function1 & Serializable & scala.Serializable)logDir -> {
                scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), logDir)}));
                AtomicLong currentWriteTimeStartedMs = new AtomicLong(-1L);
                return new LogDirMetrics(this, (String)logDir, currentWriteTimeStartedMs, this.newHistogram(this.latencyMetricName(), true, (Map<String, String>)tags), this.newGauge(this.currentWriteMetricName(), new Gauge<Object>(this, currentWriteTimeStartedMs){
                    private final /* synthetic */ StorageProbe $outer;
                    private final AtomicLong currentWriteTimeStartedMs$1;

                    public final long value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$2(this.currentWriteTimeStartedMs$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.currentWriteTimeStartedMs$1 = currentWriteTimeStartedMs$1;
                    }
                }, (Map<String, String>)tags));
            }, Seq$.MODULE$.canBuildFrom())).toList());
            String nonDaemon_name = "StorageProbe";
            this.thread_$eq(new KafkaThread(nonDaemon_name, (Runnable)this, false));
            if (this.startThread()) {
                this.thread().start();
                return;
            }
        }
    }

    public void shutdown() {
        this.shutdownFlag().set(true);
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()) > 0L) {
            this.metrics().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                StorageProbe.$anonfun$shutdown$1(this, logDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public ByteBuffer payload() {
        return ByteBuffer.wrap(new StringBuilder(1).append(this.version()).append(",").append(this.time().milliseconds()).toString().getBytes(StandardCharsets.UTF_8));
    }

    public scala.collection.immutable.Map<String, Object> probe() {
        return ((TraversableOnce)this.metrics().map((Function1 & Serializable & scala.Serializable)logDir -> {
            try {
                Tuple2 tuple2;
                Path path = Paths.get(logDir.name(), "storage.probe");
                ByteBuffer payloadBytes = this.payload();
                logDir.currentWriteStartedMs().set(this.time().hiResClockMs());
                FileChannel fc = FileChannelWrapper.open((Path)path, (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE});
                try {
                    FileChannelWrapper.truncate((FileChannel)fc, (long)0L);
                    long startMs = this.time().hiResClockMs();
                    FileChannelWrapper.write((FileChannel)fc, (ByteBuffer)payloadBytes);
                    FileChannelWrapper.force((FileChannel)fc, (boolean)true);
                    long tookMs = this.time().hiResClockMs() - startMs;
                    if (tookMs >= (long)this.writeTimeWarnThresholdMs()) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("slow storage probe write detected (>=").append(this.writeTimeWarnThresholdMs()).append("ms). Flush took ").append(tookMs).append("ms").toString());
                    }
                    logDir.histogram().update(tookMs);
                    tuple2 = new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)tookMs));
                }
                finally {
                    logDir.currentWriteStartedMs().set(-1L);
                    FileChannelWrapper.close((FileChannel)fc);
                }
                return tuple2;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Failed writing storage probe data to logdir ").append(logDir.name()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                return new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public void run() {
        ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.BACKGROUND_THREAD);
        do {
            ThreadCountersManager.wrapIO(() -> this.probe());
            Thread.sleep(Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()));
        } while (!this.shutdownFlag().get());
    }

    private final void LogDirMetrics$lzycompute$1() {
        synchronized (this) {
            if (this.LogDirMetrics$module == null) {
                this.LogDirMetrics$module = new StorageProbe$LogDirMetrics$(this);
            }
            return;
        }
    }

    public final /* synthetic */ long kafka$server$StorageProbe$$$anonfun$startup$2(AtomicLong currentWriteTimeStartedMs$1) {
        long startedMs = currentWriteTimeStartedMs$1.get();
        if (startedMs == -1L) {
            return 0L;
        }
        return this.time().hiResClockMs() - startedMs;
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(StorageProbe $this, LogDirMetrics logDir) {
        scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), (Object)logDir.name())}));
        $this.removeMetric($this.latencyMetricName(), (Map<String, String>)tags);
        $this.removeMetric($this.currentWriteMetricName(), (Map<String, String>)tags);
    }

    public StorageProbe(KafkaConfig config, Time time, boolean startThread) {
        this.config = config;
        this.time = time;
        this.startThread = startThread;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.version = 0;
        this.latencyMetricName = "StorageProbeLatencyMs";
        this.currentWriteMetricName = "CurrentWriteDurationMs";
        this.shutdownFlag = new AtomicBoolean(false);
        this.metrics = Nil$.MODULE$;
        this.writeTimeWarnThresholdMs = 5000;
    }

    public class LogDirMetrics
    implements Product,
    scala.Serializable {
        private final String name;
        private final AtomicLong currentWriteStartedMs;
        private final Histogram histogram;
        private final Gauge<Object> heartbeat;
        public final /* synthetic */ StorageProbe $outer;

        public String name() {
            return this.name;
        }

        public AtomicLong currentWriteStartedMs() {
            return this.currentWriteStartedMs;
        }

        public Histogram histogram() {
            return this.histogram;
        }

        public Gauge<Object> heartbeat() {
            return this.heartbeat;
        }

        public LogDirMetrics copy(String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat) {
            return new LogDirMetrics(this.kafka$server$StorageProbe$LogDirMetrics$$$outer(), name, currentWriteStartedMs, histogram, heartbeat);
        }

        public String copy$default$1() {
            return this.name();
        }

        public AtomicLong copy$default$2() {
            return this.currentWriteStartedMs();
        }

        public Histogram copy$default$3() {
            return this.histogram();
        }

        public Gauge<Object> copy$default$4() {
            return this.heartbeat();
        }

        public String productPrefix() {
            return "LogDirMetrics";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.currentWriteStartedMs();
                }
                case 2: {
                    return this.histogram();
                }
                case 3: {
                    return this.heartbeat();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogDirMetrics;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof LogDirMetrics)) return false;
            if (((LogDirMetrics)x$1).kafka$server$StorageProbe$LogDirMetrics$$$outer() != this.kafka$server$StorageProbe$LogDirMetrics$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            LogDirMetrics logDirMetrics = (LogDirMetrics)x$1;
            String string = this.name();
            String string2 = logDirMetrics.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!BoxesRunTime.equalsNumNum((Number)this.currentWriteStartedMs(), (Number)logDirMetrics.currentWriteStartedMs())) return false;
            Histogram histogram = this.histogram();
            Histogram histogram2 = logDirMetrics.histogram();
            if (histogram == null) {
                if (histogram2 != null) {
                    return false;
                }
            } else if (!histogram.equals(histogram2)) return false;
            Gauge<Object> gauge = this.heartbeat();
            Gauge<Object> gauge2 = logDirMetrics.heartbeat();
            if (gauge == null) {
                if (gauge2 != null) {
                    return false;
                }
            } else if (!gauge.equals(gauge2)) return false;
            if (!logDirMetrics.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ StorageProbe kafka$server$StorageProbe$LogDirMetrics$$$outer() {
            return this.$outer;
        }

        public LogDirMetrics(StorageProbe $outer, String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat) {
            this.name = name;
            this.currentWriteStartedMs = currentWriteStartedMs;
            this.histogram = histogram;
            this.heartbeat = heartbeat;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

