/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.metrics.LinuxCpuMetricsCollector;
import kafka.metrics.LinuxDiskMetricsCollector;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.server.KafkaConfig;
import kafka.utils.ProcessUtils;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Option;
import scala.Predef$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;

public final class Server$ {
    public static Server$ MODULE$;
    private final String MetricsPrefix;
    private final String ClusterIdLabel;
    private final String BrokerIdLabel;
    private final String NodeIdLabel;

    static {
        new Server$();
    }

    public String MetricsPrefix() {
        return this.MetricsPrefix;
    }

    public String ClusterIdLabel() {
        return this.ClusterIdLabel;
    }

    public String BrokerIdLabel() {
        return this.BrokerIdLabel;
    }

    public String NodeIdLabel() {
        return this.NodeIdLabel;
    }

    public Metrics initializeMetrics(KafkaConfig config, Time time, String clusterId) {
        KafkaMetricsContext metricsContext = this.createKafkaMetricsContext(config, clusterId);
        return this.buildMetrics(config, time, metricsContext);
    }

    public void maybeRegisterLinuxMetrics(KafkaConfig config, Time time, Logger logger) {
        new LinuxIoMetricsCollector("/proc", time, logger).maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        new LinuxCpuMetricsCollector("/proc", time, (Option<Object>)OptionConverters.RichOptionalLong$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalLong(ProcessUtils.PID)), logger).maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        if (Predef$.MODULE$.Boolean2boolean(config.confluentConfig().confluentInternalMetricsEnable())) {
            new LinuxDiskMetricsCollector(config, "/proc", time, logger).maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        }
    }

    private Metrics buildMetrics(KafkaConfig config, Time time, KafkaMetricsContext metricsContext) {
        List<MetricsReporter> defaultReporters = this.initializeDefaultReporters(config);
        MetricConfig metricConfig = this.buildMetricsConfig(config);
        return new Metrics(metricConfig, defaultReporters, time, true, (MetricsContext)metricsContext);
    }

    public MetricConfig buildMetricsConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(Predef$.MODULE$.Integer2int(kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(Predef$.MODULE$.Long2long(kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public KafkaMetricsContext createKafkaMetricsContext(KafkaConfig config, String clusterId) {
        HashMap<String, Object> contextLabels = new HashMap<String, Object>();
        contextLabels.put(this.ClusterIdLabel(), clusterId);
        if (config.usesSelfManagedQuorum()) {
            contextLabels.put(this.NodeIdLabel(), Integer.toString(config.nodeId()));
        } else {
            contextLabels.put(this.BrokerIdLabel(), Integer.toString(config.brokerId()));
        }
        contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
        contextLabels.put("resource.type", "kafka");
        contextLabels.put("resource.version", AppInfoParser.getVersion());
        contextLabels.put("resource.commit.id", AppInfoParser.getCommitId());
        return new KafkaMetricsContext(this.MetricsPrefix(), contextLabels);
    }

    /*
     * WARNING - void declaration
     */
    private List<MetricsReporter> initializeDefaultReporters(KafkaConfig config) {
        void var3_3;
        JmxReporter jmxReporter = new JmxReporter();
        jmxReporter.configure(config.originals());
        ArrayList<JmxReporter> reporters = new ArrayList<JmxReporter>();
        reporters.add(jmxReporter);
        return var3_3;
    }

    private Server$() {
        MODULE$ = this;
        this.MetricsPrefix = "kafka.server";
        this.ClusterIdLabel = "kafka.cluster.id";
        this.BrokerIdLabel = "kafka.broker.id";
        this.NodeIdLabel = "kafka.node.id";
    }
}

